/*! elementor - v3.19.0 - 26-02-2024 */
/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "../node_modules/@reduxjs/toolkit/dist/redux-toolkit.esm.js":
/*!******************************************************************!*\
  !*** ../node_modules/@reduxjs/toolkit/dist/redux-toolkit.esm.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   EnhancerArray: () => (/* binding */ EnhancerArray),
/* harmony export */   MiddlewareArray: () => (/* binding */ MiddlewareArray),
/* harmony export */   SHOULD_AUTOBATCH: () => (/* binding */ SHOULD_AUTOBATCH),
/* harmony export */   TaskAbortError: () => (/* binding */ TaskAbortError),
/* harmony export */   __DO_NOT_USE__ActionTypes: () => (/* reexport safe */ redux__WEBPACK_IMPORTED_MODULE_0__.__DO_NOT_USE__ActionTypes),
/* harmony export */   addListener: () => (/* binding */ addListener),
/* harmony export */   applyMiddleware: () => (/* reexport safe */ redux__WEBPACK_IMPORTED_MODULE_0__.applyMiddleware),
/* harmony export */   autoBatchEnhancer: () => (/* binding */ autoBatchEnhancer),
/* harmony export */   bindActionCreators: () => (/* reexport safe */ redux__WEBPACK_IMPORTED_MODULE_0__.bindActionCreators),
/* harmony export */   clearAllListeners: () => (/* binding */ clearAllListeners),
/* harmony export */   combineReducers: () => (/* reexport safe */ redux__WEBPACK_IMPORTED_MODULE_0__.combineReducers),
/* harmony export */   compose: () => (/* reexport safe */ redux__WEBPACK_IMPORTED_MODULE_0__.compose),
/* harmony export */   configureStore: () => (/* binding */ configureStore),
/* harmony export */   createAction: () => (/* binding */ createAction),
/* harmony export */   createActionCreatorInvariantMiddleware: () => (/* binding */ createActionCreatorInvariantMiddleware),
/* harmony export */   createAsyncThunk: () => (/* binding */ createAsyncThunk),
/* harmony export */   createDraftSafeSelector: () => (/* binding */ createDraftSafeSelector),
/* harmony export */   createEntityAdapter: () => (/* binding */ createEntityAdapter),
/* harmony export */   createImmutableStateInvariantMiddleware: () => (/* binding */ createImmutableStateInvariantMiddleware),
/* harmony export */   createListenerMiddleware: () => (/* binding */ createListenerMiddleware),
/* harmony export */   createNextState: () => (/* reexport safe */ immer__WEBPACK_IMPORTED_MODULE_2__["default"]),
/* harmony export */   createReducer: () => (/* binding */ createReducer),
/* harmony export */   createSelector: () => (/* reexport safe */ reselect__WEBPACK_IMPORTED_MODULE_1__.createSelector),
/* harmony export */   createSerializableStateInvariantMiddleware: () => (/* binding */ createSerializableStateInvariantMiddleware),
/* harmony export */   createSlice: () => (/* binding */ createSlice),
/* harmony export */   createStore: () => (/* reexport safe */ redux__WEBPACK_IMPORTED_MODULE_0__.createStore),
/* harmony export */   current: () => (/* reexport safe */ immer__WEBPACK_IMPORTED_MODULE_2__.current),
/* harmony export */   findNonSerializableValue: () => (/* binding */ findNonSerializableValue),
/* harmony export */   freeze: () => (/* reexport safe */ immer__WEBPACK_IMPORTED_MODULE_2__.freeze),
/* harmony export */   getDefaultMiddleware: () => (/* binding */ getDefaultMiddleware),
/* harmony export */   getType: () => (/* binding */ getType),
/* harmony export */   isAction: () => (/* binding */ isAction),
/* harmony export */   isActionCreator: () => (/* binding */ isActionCreator),
/* harmony export */   isAllOf: () => (/* binding */ isAllOf),
/* harmony export */   isAnyOf: () => (/* binding */ isAnyOf),
/* harmony export */   isAsyncThunkAction: () => (/* binding */ isAsyncThunkAction),
/* harmony export */   isDraft: () => (/* reexport safe */ immer__WEBPACK_IMPORTED_MODULE_2__.isDraft),
/* harmony export */   isFluxStandardAction: () => (/* binding */ isFSA),
/* harmony export */   isFulfilled: () => (/* binding */ isFulfilled),
/* harmony export */   isImmutableDefault: () => (/* binding */ isImmutableDefault),
/* harmony export */   isPending: () => (/* binding */ isPending),
/* harmony export */   isPlain: () => (/* binding */ isPlain),
/* harmony export */   isPlainObject: () => (/* binding */ isPlainObject),
/* harmony export */   isRejected: () => (/* binding */ isRejected),
/* harmony export */   isRejectedWithValue: () => (/* binding */ isRejectedWithValue),
/* harmony export */   legacy_createStore: () => (/* reexport safe */ redux__WEBPACK_IMPORTED_MODULE_0__.legacy_createStore),
/* harmony export */   miniSerializeError: () => (/* binding */ miniSerializeError),
/* harmony export */   nanoid: () => (/* binding */ nanoid),
/* harmony export */   original: () => (/* reexport safe */ immer__WEBPACK_IMPORTED_MODULE_2__.original),
/* harmony export */   prepareAutoBatched: () => (/* binding */ prepareAutoBatched),
/* harmony export */   removeListener: () => (/* binding */ removeListener),
/* harmony export */   unwrapResult: () => (/* binding */ unwrapResult)
/* harmony export */ });
/* harmony import */ var immer__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! immer */ "../node_modules/@reduxjs/toolkit/node_modules/immer/dist/immer.esm.mjs");
/* harmony import */ var redux__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! redux */ "../node_modules/redux/es/redux.js");
/* harmony import */ var reselect__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! reselect */ "../node_modules/reselect/es/index.js");
/* harmony import */ var redux_thunk__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! redux-thunk */ "../node_modules/redux-thunk/es/index.js");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __generator = (undefined && undefined.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __spreadArray = (undefined && undefined.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = function (obj, key, value) { return key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value: value }) : obj[key] = value; };
var __spreadValues = function (a, b) {
    for (var prop in b || (b = {}))
        if (__hasOwnProp.call(b, prop))
            __defNormalProp(a, prop, b[prop]);
    if (__getOwnPropSymbols)
        for (var _i = 0, _c = __getOwnPropSymbols(b); _i < _c.length; _i++) {
            var prop = _c[_i];
            if (__propIsEnum.call(b, prop))
                __defNormalProp(a, prop, b[prop]);
        }
    return a;
};
var __spreadProps = function (a, b) { return __defProps(a, __getOwnPropDescs(b)); };
var __async = function (__this, __arguments, generator) {
    return new Promise(function (resolve, reject) {
        var fulfilled = function (value) {
            try {
                step(generator.next(value));
            }
            catch (e) {
                reject(e);
            }
        };
        var rejected = function (value) {
            try {
                step(generator.throw(value));
            }
            catch (e) {
                reject(e);
            }
        };
        var step = function (x) { return x.done ? resolve(x.value) : Promise.resolve(x.value).then(fulfilled, rejected); };
        step((generator = generator.apply(__this, __arguments)).next());
    });
};
// src/index.ts




// src/createDraftSafeSelector.ts


var createDraftSafeSelector = function () {
    var args = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        args[_i] = arguments[_i];
    }
    var selector = reselect__WEBPACK_IMPORTED_MODULE_1__.createSelector.apply(void 0, args);
    var wrappedSelector = function (value) {
        var rest = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            rest[_i - 1] = arguments[_i];
        }
        return selector.apply(void 0, __spreadArray([(0,immer__WEBPACK_IMPORTED_MODULE_2__.isDraft)(value) ? (0,immer__WEBPACK_IMPORTED_MODULE_2__.current)(value) : value], rest));
    };
    return wrappedSelector;
};
// src/configureStore.ts

// src/devtoolsExtension.ts

var composeWithDevTools = typeof window !== "undefined" && window.__REDUX_DEVTOOLS_EXTENSION_COMPOSE__ ? window.__REDUX_DEVTOOLS_EXTENSION_COMPOSE__ : function () {
    if (arguments.length === 0)
        return void 0;
    if (typeof arguments[0] === "object")
        return redux__WEBPACK_IMPORTED_MODULE_0__.compose;
    return redux__WEBPACK_IMPORTED_MODULE_0__.compose.apply(null, arguments);
};
var devToolsEnhancer = typeof window !== "undefined" && window.__REDUX_DEVTOOLS_EXTENSION__ ? window.__REDUX_DEVTOOLS_EXTENSION__ : function () {
    return function (noop2) {
        return noop2;
    };
};
// src/isPlainObject.ts
function isPlainObject(value) {
    if (typeof value !== "object" || value === null)
        return false;
    var proto = Object.getPrototypeOf(value);
    if (proto === null)
        return true;
    var baseProto = proto;
    while (Object.getPrototypeOf(baseProto) !== null) {
        baseProto = Object.getPrototypeOf(baseProto);
    }
    return proto === baseProto;
}
// src/getDefaultMiddleware.ts

// src/tsHelpers.ts
var hasMatchFunction = function (v) {
    return v && typeof v.match === "function";
};
// src/createAction.ts
function createAction(type, prepareAction) {
    function actionCreator() {
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
        }
        if (prepareAction) {
            var prepared = prepareAction.apply(void 0, args);
            if (!prepared) {
                throw new Error("prepareAction did not return an object");
            }
            return __spreadValues(__spreadValues({
                type: type,
                payload: prepared.payload
            }, "meta" in prepared && { meta: prepared.meta }), "error" in prepared && { error: prepared.error });
        }
        return { type: type, payload: args[0] };
    }
    actionCreator.toString = function () { return "" + type; };
    actionCreator.type = type;
    actionCreator.match = function (action) { return action.type === type; };
    return actionCreator;
}
function isAction(action) {
    return isPlainObject(action) && "type" in action;
}
function isActionCreator(action) {
    return typeof action === "function" && "type" in action && hasMatchFunction(action);
}
function isFSA(action) {
    return isAction(action) && typeof action.type === "string" && Object.keys(action).every(isValidKey);
}
function isValidKey(key) {
    return ["type", "payload", "error", "meta"].indexOf(key) > -1;
}
function getType(actionCreator) {
    return "" + actionCreator;
}
// src/actionCreatorInvariantMiddleware.ts
function getMessage(type) {
    var splitType = type ? ("" + type).split("/") : [];
    var actionName = splitType[splitType.length - 1] || "actionCreator";
    return "Detected an action creator with type \"" + (type || "unknown") + "\" being dispatched. \nMake sure you're calling the action creator before dispatching, i.e. `dispatch(" + actionName + "())` instead of `dispatch(" + actionName + ")`. This is necessary even if the action has no payload.";
}
function createActionCreatorInvariantMiddleware(options) {
    if (options === void 0) { options = {}; }
    if (false) {}
    var _c = options.isActionCreator, isActionCreator2 = _c === void 0 ? isActionCreator : _c;
    return function () { return function (next) { return function (action) {
        if (isActionCreator2(action)) {
            console.warn(getMessage(action.type));
        }
        return next(action);
    }; }; };
}
// src/utils.ts

function getTimeMeasureUtils(maxDelay, fnName) {
    var elapsed = 0;
    return {
        measureTime: function (fn) {
            var started = Date.now();
            try {
                return fn();
            }
            finally {
                var finished = Date.now();
                elapsed += finished - started;
            }
        },
        warnIfExceeded: function () {
            if (elapsed > maxDelay) {
                console.warn(fnName + " took " + elapsed + "ms, which is more than the warning threshold of " + maxDelay + "ms. \nIf your state or actions are very large, you may want to disable the middleware as it might cause too much of a slowdown in development mode. See https://redux-toolkit.js.org/api/getDefaultMiddleware for instructions.\nIt is disabled in production builds, so you don't need to worry about that.");
            }
        }
    };
}
var MiddlewareArray = /** @class */ (function (_super) {
    __extends(MiddlewareArray, _super);
    function MiddlewareArray() {
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
        }
        var _this = _super.apply(this, args) || this;
        Object.setPrototypeOf(_this, MiddlewareArray.prototype);
        return _this;
    }
    Object.defineProperty(MiddlewareArray, Symbol.species, {
        get: function () {
            return MiddlewareArray;
        },
        enumerable: false,
        configurable: true
    });
    MiddlewareArray.prototype.concat = function () {
        var arr = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            arr[_i] = arguments[_i];
        }
        return _super.prototype.concat.apply(this, arr);
    };
    MiddlewareArray.prototype.prepend = function () {
        var arr = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            arr[_i] = arguments[_i];
        }
        if (arr.length === 1 && Array.isArray(arr[0])) {
            return new (MiddlewareArray.bind.apply(MiddlewareArray, __spreadArray([void 0], arr[0].concat(this))))();
        }
        return new (MiddlewareArray.bind.apply(MiddlewareArray, __spreadArray([void 0], arr.concat(this))))();
    };
    return MiddlewareArray;
}(Array));
var EnhancerArray = /** @class */ (function (_super) {
    __extends(EnhancerArray, _super);
    function EnhancerArray() {
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
        }
        var _this = _super.apply(this, args) || this;
        Object.setPrototypeOf(_this, EnhancerArray.prototype);
        return _this;
    }
    Object.defineProperty(EnhancerArray, Symbol.species, {
        get: function () {
            return EnhancerArray;
        },
        enumerable: false,
        configurable: true
    });
    EnhancerArray.prototype.concat = function () {
        var arr = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            arr[_i] = arguments[_i];
        }
        return _super.prototype.concat.apply(this, arr);
    };
    EnhancerArray.prototype.prepend = function () {
        var arr = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            arr[_i] = arguments[_i];
        }
        if (arr.length === 1 && Array.isArray(arr[0])) {
            return new (EnhancerArray.bind.apply(EnhancerArray, __spreadArray([void 0], arr[0].concat(this))))();
        }
        return new (EnhancerArray.bind.apply(EnhancerArray, __spreadArray([void 0], arr.concat(this))))();
    };
    return EnhancerArray;
}(Array));
function freezeDraftable(val) {
    return (0,immer__WEBPACK_IMPORTED_MODULE_2__.isDraftable)(val) ? (0,immer__WEBPACK_IMPORTED_MODULE_2__["default"])(val, function () {
    }) : val;
}
// src/immutableStateInvariantMiddleware.ts
var isProduction = "development" === "production";
var prefix = "Invariant failed";
function invariant(condition, message) {
    if (condition) {
        return;
    }
    if (isProduction) {
        throw new Error(prefix);
    }
    throw new Error(prefix + ": " + (message || ""));
}
function stringify(obj, serializer, indent, decycler) {
    return JSON.stringify(obj, getSerialize(serializer, decycler), indent);
}
function getSerialize(serializer, decycler) {
    var stack = [], keys = [];
    if (!decycler)
        decycler = function (_, value) {
            if (stack[0] === value)
                return "[Circular ~]";
            return "[Circular ~." + keys.slice(0, stack.indexOf(value)).join(".") + "]";
        };
    return function (key, value) {
        if (stack.length > 0) {
            var thisPos = stack.indexOf(this);
            ~thisPos ? stack.splice(thisPos + 1) : stack.push(this);
            ~thisPos ? keys.splice(thisPos, Infinity, key) : keys.push(key);
            if (~stack.indexOf(value))
                value = decycler.call(this, key, value);
        }
        else
            stack.push(value);
        return serializer == null ? value : serializer.call(this, key, value);
    };
}
function isImmutableDefault(value) {
    return typeof value !== "object" || value == null || Object.isFrozen(value);
}
function trackForMutations(isImmutable, ignorePaths, obj) {
    var trackedProperties = trackProperties(isImmutable, ignorePaths, obj);
    return {
        detectMutations: function () {
            return detectMutations(isImmutable, ignorePaths, trackedProperties, obj);
        }
    };
}
function trackProperties(isImmutable, ignorePaths, obj, path, checkedObjects) {
    if (ignorePaths === void 0) { ignorePaths = []; }
    if (path === void 0) { path = ""; }
    if (checkedObjects === void 0) { checkedObjects = new Set(); }
    var tracked = { value: obj };
    if (!isImmutable(obj) && !checkedObjects.has(obj)) {
        checkedObjects.add(obj);
        tracked.children = {};
        for (var key in obj) {
            var childPath = path ? path + "." + key : key;
            if (ignorePaths.length && ignorePaths.indexOf(childPath) !== -1) {
                continue;
            }
            tracked.children[key] = trackProperties(isImmutable, ignorePaths, obj[key], childPath);
        }
    }
    return tracked;
}
function detectMutations(isImmutable, ignoredPaths, trackedProperty, obj, sameParentRef, path) {
    if (ignoredPaths === void 0) { ignoredPaths = []; }
    if (sameParentRef === void 0) { sameParentRef = false; }
    if (path === void 0) { path = ""; }
    var prevObj = trackedProperty ? trackedProperty.value : void 0;
    var sameRef = prevObj === obj;
    if (sameParentRef && !sameRef && !Number.isNaN(obj)) {
        return { wasMutated: true, path: path };
    }
    if (isImmutable(prevObj) || isImmutable(obj)) {
        return { wasMutated: false };
    }
    var keysToDetect = {};
    for (var key in trackedProperty.children) {
        keysToDetect[key] = true;
    }
    for (var key in obj) {
        keysToDetect[key] = true;
    }
    var hasIgnoredPaths = ignoredPaths.length > 0;
    var _loop_1 = function (key) {
        var nestedPath = path ? path + "." + key : key;
        if (hasIgnoredPaths) {
            var hasMatches = ignoredPaths.some(function (ignored) {
                if (ignored instanceof RegExp) {
                    return ignored.test(nestedPath);
                }
                return nestedPath === ignored;
            });
            if (hasMatches) {
                return "continue";
            }
        }
        var result = detectMutations(isImmutable, ignoredPaths, trackedProperty.children[key], obj[key], sameRef, nestedPath);
        if (result.wasMutated) {
            return { value: result };
        }
    };
    for (var key in keysToDetect) {
        var state_1 = _loop_1(key);
        if (typeof state_1 === "object")
            return state_1.value;
    }
    return { wasMutated: false };
}
function createImmutableStateInvariantMiddleware(options) {
    if (options === void 0) { options = {}; }
    if (false) {}
    var _c = options.isImmutable, isImmutable = _c === void 0 ? isImmutableDefault : _c, ignoredPaths = options.ignoredPaths, _d = options.warnAfter, warnAfter = _d === void 0 ? 32 : _d, ignore = options.ignore;
    ignoredPaths = ignoredPaths || ignore;
    var track = trackForMutations.bind(null, isImmutable, ignoredPaths);
    return function (_c) {
        var getState = _c.getState;
        var state = getState();
        var tracker = track(state);
        var result;
        return function (next) { return function (action) {
            var measureUtils = getTimeMeasureUtils(warnAfter, "ImmutableStateInvariantMiddleware");
            measureUtils.measureTime(function () {
                state = getState();
                result = tracker.detectMutations();
                tracker = track(state);
                invariant(!result.wasMutated, "A state mutation was detected between dispatches, in the path '" + (result.path || "") + "'.  This may cause incorrect behavior. (https://redux.js.org/style-guide/style-guide#do-not-mutate-state)");
            });
            var dispatchedAction = next(action);
            measureUtils.measureTime(function () {
                state = getState();
                result = tracker.detectMutations();
                tracker = track(state);
                result.wasMutated && invariant(!result.wasMutated, "A state mutation was detected inside a dispatch, in the path: " + (result.path || "") + ". Take a look at the reducer(s) handling the action " + stringify(action) + ". (https://redux.js.org/style-guide/style-guide#do-not-mutate-state)");
            });
            measureUtils.warnIfExceeded();
            return dispatchedAction;
        }; };
    };
}
// src/serializableStateInvariantMiddleware.ts
function isPlain(val) {
    var type = typeof val;
    return val == null || type === "string" || type === "boolean" || type === "number" || Array.isArray(val) || isPlainObject(val);
}
function findNonSerializableValue(value, path, isSerializable, getEntries, ignoredPaths, cache) {
    if (path === void 0) { path = ""; }
    if (isSerializable === void 0) { isSerializable = isPlain; }
    if (ignoredPaths === void 0) { ignoredPaths = []; }
    var foundNestedSerializable;
    if (!isSerializable(value)) {
        return {
            keyPath: path || "<root>",
            value: value
        };
    }
    if (typeof value !== "object" || value === null) {
        return false;
    }
    if (cache == null ? void 0 : cache.has(value))
        return false;
    var entries = getEntries != null ? getEntries(value) : Object.entries(value);
    var hasIgnoredPaths = ignoredPaths.length > 0;
    var _loop_2 = function (key, nestedValue) {
        var nestedPath = path ? path + "." + key : key;
        if (hasIgnoredPaths) {
            var hasMatches = ignoredPaths.some(function (ignored) {
                if (ignored instanceof RegExp) {
                    return ignored.test(nestedPath);
                }
                return nestedPath === ignored;
            });
            if (hasMatches) {
                return "continue";
            }
        }
        if (!isSerializable(nestedValue)) {
            return { value: {
                    keyPath: nestedPath,
                    value: nestedValue
                } };
        }
        if (typeof nestedValue === "object") {
            foundNestedSerializable = findNonSerializableValue(nestedValue, nestedPath, isSerializable, getEntries, ignoredPaths, cache);
            if (foundNestedSerializable) {
                return { value: foundNestedSerializable };
            }
        }
    };
    for (var _i = 0, entries_1 = entries; _i < entries_1.length; _i++) {
        var _c = entries_1[_i], key = _c[0], nestedValue = _c[1];
        var state_2 = _loop_2(key, nestedValue);
        if (typeof state_2 === "object")
            return state_2.value;
    }
    if (cache && isNestedFrozen(value))
        cache.add(value);
    return false;
}
function isNestedFrozen(value) {
    if (!Object.isFrozen(value))
        return false;
    for (var _i = 0, _c = Object.values(value); _i < _c.length; _i++) {
        var nestedValue = _c[_i];
        if (typeof nestedValue !== "object" || nestedValue === null)
            continue;
        if (!isNestedFrozen(nestedValue))
            return false;
    }
    return true;
}
function createSerializableStateInvariantMiddleware(options) {
    if (options === void 0) { options = {}; }
    if (false) {}
    var _c = options.isSerializable, isSerializable = _c === void 0 ? isPlain : _c, getEntries = options.getEntries, _d = options.ignoredActions, ignoredActions = _d === void 0 ? [] : _d, _e = options.ignoredActionPaths, ignoredActionPaths = _e === void 0 ? ["meta.arg", "meta.baseQueryMeta"] : _e, _f = options.ignoredPaths, ignoredPaths = _f === void 0 ? [] : _f, _g = options.warnAfter, warnAfter = _g === void 0 ? 32 : _g, _h = options.ignoreState, ignoreState = _h === void 0 ? false : _h, _j = options.ignoreActions, ignoreActions = _j === void 0 ? false : _j, _k = options.disableCache, disableCache = _k === void 0 ? false : _k;
    var cache = !disableCache && WeakSet ? new WeakSet() : void 0;
    return function (storeAPI) { return function (next) { return function (action) {
        var result = next(action);
        var measureUtils = getTimeMeasureUtils(warnAfter, "SerializableStateInvariantMiddleware");
        if (!ignoreActions && !(ignoredActions.length && ignoredActions.indexOf(action.type) !== -1)) {
            measureUtils.measureTime(function () {
                var foundActionNonSerializableValue = findNonSerializableValue(action, "", isSerializable, getEntries, ignoredActionPaths, cache);
                if (foundActionNonSerializableValue) {
                    var keyPath = foundActionNonSerializableValue.keyPath, value = foundActionNonSerializableValue.value;
                    console.error("A non-serializable value was detected in an action, in the path: `" + keyPath + "`. Value:", value, "\nTake a look at the logic that dispatched this action: ", action, "\n(See https://redux.js.org/faq/actions#why-should-type-be-a-string-or-at-least-serializable-why-should-my-action-types-be-constants)", "\n(To allow non-serializable values see: https://redux-toolkit.js.org/usage/usage-guide#working-with-non-serializable-data)");
                }
            });
        }
        if (!ignoreState) {
            measureUtils.measureTime(function () {
                var state = storeAPI.getState();
                var foundStateNonSerializableValue = findNonSerializableValue(state, "", isSerializable, getEntries, ignoredPaths, cache);
                if (foundStateNonSerializableValue) {
                    var keyPath = foundStateNonSerializableValue.keyPath, value = foundStateNonSerializableValue.value;
                    console.error("A non-serializable value was detected in the state, in the path: `" + keyPath + "`. Value:", value, "\nTake a look at the reducer(s) handling this action type: " + action.type + ".\n(See https://redux.js.org/faq/organizing-state#can-i-put-functions-promises-or-other-non-serializable-items-in-my-store-state)");
                }
            });
            measureUtils.warnIfExceeded();
        }
        return result;
    }; }; };
}
// src/getDefaultMiddleware.ts
function isBoolean(x) {
    return typeof x === "boolean";
}
function curryGetDefaultMiddleware() {
    return function curriedGetDefaultMiddleware(options) {
        return getDefaultMiddleware(options);
    };
}
function getDefaultMiddleware(options) {
    if (options === void 0) { options = {}; }
    var _c = options.thunk, thunk = _c === void 0 ? true : _c, _d = options.immutableCheck, immutableCheck = _d === void 0 ? true : _d, _e = options.serializableCheck, serializableCheck = _e === void 0 ? true : _e, _f = options.actionCreatorCheck, actionCreatorCheck = _f === void 0 ? true : _f;
    var middlewareArray = new MiddlewareArray();
    if (thunk) {
        if (isBoolean(thunk)) {
            middlewareArray.push(redux_thunk__WEBPACK_IMPORTED_MODULE_3__["default"]);
        }
        else {
            middlewareArray.push(redux_thunk__WEBPACK_IMPORTED_MODULE_3__["default"].withExtraArgument(thunk.extraArgument));
        }
    }
    if (true) {
        if (immutableCheck) {
            var immutableOptions = {};
            if (!isBoolean(immutableCheck)) {
                immutableOptions = immutableCheck;
            }
            middlewareArray.unshift(createImmutableStateInvariantMiddleware(immutableOptions));
        }
        if (serializableCheck) {
            var serializableOptions = {};
            if (!isBoolean(serializableCheck)) {
                serializableOptions = serializableCheck;
            }
            middlewareArray.push(createSerializableStateInvariantMiddleware(serializableOptions));
        }
        if (actionCreatorCheck) {
            var actionCreatorOptions = {};
            if (!isBoolean(actionCreatorCheck)) {
                actionCreatorOptions = actionCreatorCheck;
            }
            middlewareArray.unshift(createActionCreatorInvariantMiddleware(actionCreatorOptions));
        }
    }
    return middlewareArray;
}
// src/configureStore.ts
var IS_PRODUCTION = "development" === "production";
function configureStore(options) {
    var curriedGetDefaultMiddleware = curryGetDefaultMiddleware();
    var _c = options || {}, _d = _c.reducer, reducer = _d === void 0 ? void 0 : _d, _e = _c.middleware, middleware = _e === void 0 ? curriedGetDefaultMiddleware() : _e, _f = _c.devTools, devTools = _f === void 0 ? true : _f, _g = _c.preloadedState, preloadedState = _g === void 0 ? void 0 : _g, _h = _c.enhancers, enhancers = _h === void 0 ? void 0 : _h;
    var rootReducer;
    if (typeof reducer === "function") {
        rootReducer = reducer;
    }
    else if (isPlainObject(reducer)) {
        rootReducer = (0,redux__WEBPACK_IMPORTED_MODULE_0__.combineReducers)(reducer);
    }
    else {
        throw new Error('"reducer" is a required argument, and must be a function or an object of functions that can be passed to combineReducers');
    }
    var finalMiddleware = middleware;
    if (typeof finalMiddleware === "function") {
        finalMiddleware = finalMiddleware(curriedGetDefaultMiddleware);
        if (!IS_PRODUCTION && !Array.isArray(finalMiddleware)) {
            throw new Error("when using a middleware builder function, an array of middleware must be returned");
        }
    }
    if (!IS_PRODUCTION && finalMiddleware.some(function (item) { return typeof item !== "function"; })) {
        throw new Error("each middleware provided to configureStore must be a function");
    }
    var middlewareEnhancer = redux__WEBPACK_IMPORTED_MODULE_0__.applyMiddleware.apply(void 0, finalMiddleware);
    var finalCompose = redux__WEBPACK_IMPORTED_MODULE_0__.compose;
    if (devTools) {
        finalCompose = composeWithDevTools(__spreadValues({
            trace: !IS_PRODUCTION
        }, typeof devTools === "object" && devTools));
    }
    var defaultEnhancers = new EnhancerArray(middlewareEnhancer);
    var storeEnhancers = defaultEnhancers;
    if (Array.isArray(enhancers)) {
        storeEnhancers = __spreadArray([middlewareEnhancer], enhancers);
    }
    else if (typeof enhancers === "function") {
        storeEnhancers = enhancers(defaultEnhancers);
    }
    var composedEnhancer = finalCompose.apply(void 0, storeEnhancers);
    return (0,redux__WEBPACK_IMPORTED_MODULE_0__.createStore)(rootReducer, preloadedState, composedEnhancer);
}
// src/createReducer.ts

// src/mapBuilders.ts
function executeReducerBuilderCallback(builderCallback) {
    var actionsMap = {};
    var actionMatchers = [];
    var defaultCaseReducer;
    var builder = {
        addCase: function (typeOrActionCreator, reducer) {
            if (true) {
                if (actionMatchers.length > 0) {
                    throw new Error("`builder.addCase` should only be called before calling `builder.addMatcher`");
                }
                if (defaultCaseReducer) {
                    throw new Error("`builder.addCase` should only be called before calling `builder.addDefaultCase`");
                }
            }
            var type = typeof typeOrActionCreator === "string" ? typeOrActionCreator : typeOrActionCreator.type;
            if (!type) {
                throw new Error("`builder.addCase` cannot be called with an empty action type");
            }
            if (type in actionsMap) {
                throw new Error("`builder.addCase` cannot be called with two reducers for the same action type");
            }
            actionsMap[type] = reducer;
            return builder;
        },
        addMatcher: function (matcher, reducer) {
            if (true) {
                if (defaultCaseReducer) {
                    throw new Error("`builder.addMatcher` should only be called before calling `builder.addDefaultCase`");
                }
            }
            actionMatchers.push({ matcher: matcher, reducer: reducer });
            return builder;
        },
        addDefaultCase: function (reducer) {
            if (true) {
                if (defaultCaseReducer) {
                    throw new Error("`builder.addDefaultCase` can only be called once");
                }
            }
            defaultCaseReducer = reducer;
            return builder;
        }
    };
    builderCallback(builder);
    return [actionsMap, actionMatchers, defaultCaseReducer];
}
// src/createReducer.ts
function isStateFunction(x) {
    return typeof x === "function";
}
var hasWarnedAboutObjectNotation = false;
function createReducer(initialState, mapOrBuilderCallback, actionMatchers, defaultCaseReducer) {
    if (actionMatchers === void 0) { actionMatchers = []; }
    if (true) {
        if (typeof mapOrBuilderCallback === "object") {
            if (!hasWarnedAboutObjectNotation) {
                hasWarnedAboutObjectNotation = true;
                console.warn("The object notation for `createReducer` is deprecated, and will be removed in RTK 2.0. Please use the 'builder callback' notation instead: https://redux-toolkit.js.org/api/createReducer");
            }
        }
    }
    var _c = typeof mapOrBuilderCallback === "function" ? executeReducerBuilderCallback(mapOrBuilderCallback) : [mapOrBuilderCallback, actionMatchers, defaultCaseReducer], actionsMap = _c[0], finalActionMatchers = _c[1], finalDefaultCaseReducer = _c[2];
    var getInitialState;
    if (isStateFunction(initialState)) {
        getInitialState = function () { return freezeDraftable(initialState()); };
    }
    else {
        var frozenInitialState_1 = freezeDraftable(initialState);
        getInitialState = function () { return frozenInitialState_1; };
    }
    function reducer(state, action) {
        if (state === void 0) { state = getInitialState(); }
        var caseReducers = __spreadArray([
            actionsMap[action.type]
        ], finalActionMatchers.filter(function (_c) {
            var matcher = _c.matcher;
            return matcher(action);
        }).map(function (_c) {
            var reducer2 = _c.reducer;
            return reducer2;
        }));
        if (caseReducers.filter(function (cr) { return !!cr; }).length === 0) {
            caseReducers = [finalDefaultCaseReducer];
        }
        return caseReducers.reduce(function (previousState, caseReducer) {
            if (caseReducer) {
                if ((0,immer__WEBPACK_IMPORTED_MODULE_2__.isDraft)(previousState)) {
                    var draft = previousState;
                    var result = caseReducer(draft, action);
                    if (result === void 0) {
                        return previousState;
                    }
                    return result;
                }
                else if (!(0,immer__WEBPACK_IMPORTED_MODULE_2__.isDraftable)(previousState)) {
                    var result = caseReducer(previousState, action);
                    if (result === void 0) {
                        if (previousState === null) {
                            return previousState;
                        }
                        throw Error("A case reducer on a non-draftable value must not return undefined");
                    }
                    return result;
                }
                else {
                    return (0,immer__WEBPACK_IMPORTED_MODULE_2__["default"])(previousState, function (draft) {
                        return caseReducer(draft, action);
                    });
                }
            }
            return previousState;
        }, state);
    }
    reducer.getInitialState = getInitialState;
    return reducer;
}
// src/createSlice.ts
var hasWarnedAboutObjectNotation2 = false;
function getType2(slice, actionKey) {
    return slice + "/" + actionKey;
}
function createSlice(options) {
    var name = options.name;
    if (!name) {
        throw new Error("`name` is a required option for createSlice");
    }
    if (typeof process !== "undefined" && "development" === "development") {
        if (options.initialState === void 0) {
            console.error("You must provide an `initialState` value that is not `undefined`. You may have misspelled `initialState`");
        }
    }
    var initialState = typeof options.initialState == "function" ? options.initialState : freezeDraftable(options.initialState);
    var reducers = options.reducers || {};
    var reducerNames = Object.keys(reducers);
    var sliceCaseReducersByName = {};
    var sliceCaseReducersByType = {};
    var actionCreators = {};
    reducerNames.forEach(function (reducerName) {
        var maybeReducerWithPrepare = reducers[reducerName];
        var type = getType2(name, reducerName);
        var caseReducer;
        var prepareCallback;
        if ("reducer" in maybeReducerWithPrepare) {
            caseReducer = maybeReducerWithPrepare.reducer;
            prepareCallback = maybeReducerWithPrepare.prepare;
        }
        else {
            caseReducer = maybeReducerWithPrepare;
        }
        sliceCaseReducersByName[reducerName] = caseReducer;
        sliceCaseReducersByType[type] = caseReducer;
        actionCreators[reducerName] = prepareCallback ? createAction(type, prepareCallback) : createAction(type);
    });
    function buildReducer() {
        if (true) {
            if (typeof options.extraReducers === "object") {
                if (!hasWarnedAboutObjectNotation2) {
                    hasWarnedAboutObjectNotation2 = true;
                    console.warn("The object notation for `createSlice.extraReducers` is deprecated, and will be removed in RTK 2.0. Please use the 'builder callback' notation instead: https://redux-toolkit.js.org/api/createSlice");
                }
            }
        }
        var _c = typeof options.extraReducers === "function" ? executeReducerBuilderCallback(options.extraReducers) : [options.extraReducers], _d = _c[0], extraReducers = _d === void 0 ? {} : _d, _e = _c[1], actionMatchers = _e === void 0 ? [] : _e, _f = _c[2], defaultCaseReducer = _f === void 0 ? void 0 : _f;
        var finalCaseReducers = __spreadValues(__spreadValues({}, extraReducers), sliceCaseReducersByType);
        return createReducer(initialState, function (builder) {
            for (var key in finalCaseReducers) {
                builder.addCase(key, finalCaseReducers[key]);
            }
            for (var _i = 0, actionMatchers_1 = actionMatchers; _i < actionMatchers_1.length; _i++) {
                var m = actionMatchers_1[_i];
                builder.addMatcher(m.matcher, m.reducer);
            }
            if (defaultCaseReducer) {
                builder.addDefaultCase(defaultCaseReducer);
            }
        });
    }
    var _reducer;
    return {
        name: name,
        reducer: function (state, action) {
            if (!_reducer)
                _reducer = buildReducer();
            return _reducer(state, action);
        },
        actions: actionCreators,
        caseReducers: sliceCaseReducersByName,
        getInitialState: function () {
            if (!_reducer)
                _reducer = buildReducer();
            return _reducer.getInitialState();
        }
    };
}
// src/entities/entity_state.ts
function getInitialEntityState() {
    return {
        ids: [],
        entities: {}
    };
}
function createInitialStateFactory() {
    function getInitialState(additionalState) {
        if (additionalState === void 0) { additionalState = {}; }
        return Object.assign(getInitialEntityState(), additionalState);
    }
    return { getInitialState: getInitialState };
}
// src/entities/state_selectors.ts
function createSelectorsFactory() {
    function getSelectors(selectState) {
        var selectIds = function (state) { return state.ids; };
        var selectEntities = function (state) { return state.entities; };
        var selectAll = createDraftSafeSelector(selectIds, selectEntities, function (ids, entities) { return ids.map(function (id) { return entities[id]; }); });
        var selectId = function (_, id) { return id; };
        var selectById = function (entities, id) { return entities[id]; };
        var selectTotal = createDraftSafeSelector(selectIds, function (ids) { return ids.length; });
        if (!selectState) {
            return {
                selectIds: selectIds,
                selectEntities: selectEntities,
                selectAll: selectAll,
                selectTotal: selectTotal,
                selectById: createDraftSafeSelector(selectEntities, selectId, selectById)
            };
        }
        var selectGlobalizedEntities = createDraftSafeSelector(selectState, selectEntities);
        return {
            selectIds: createDraftSafeSelector(selectState, selectIds),
            selectEntities: selectGlobalizedEntities,
            selectAll: createDraftSafeSelector(selectState, selectAll),
            selectTotal: createDraftSafeSelector(selectState, selectTotal),
            selectById: createDraftSafeSelector(selectGlobalizedEntities, selectId, selectById)
        };
    }
    return { getSelectors: getSelectors };
}
// src/entities/state_adapter.ts

function createSingleArgumentStateOperator(mutator) {
    var operator = createStateOperator(function (_, state) { return mutator(state); });
    return function operation(state) {
        return operator(state, void 0);
    };
}
function createStateOperator(mutator) {
    return function operation(state, arg) {
        function isPayloadActionArgument(arg2) {
            return isFSA(arg2);
        }
        var runMutator = function (draft) {
            if (isPayloadActionArgument(arg)) {
                mutator(arg.payload, draft);
            }
            else {
                mutator(arg, draft);
            }
        };
        if ((0,immer__WEBPACK_IMPORTED_MODULE_2__.isDraft)(state)) {
            runMutator(state);
            return state;
        }
        else {
            return (0,immer__WEBPACK_IMPORTED_MODULE_2__["default"])(state, runMutator);
        }
    };
}
// src/entities/utils.ts
function selectIdValue(entity, selectId) {
    var key = selectId(entity);
    if ( true && key === void 0) {
        console.warn("The entity passed to the `selectId` implementation returned undefined.", "You should probably provide your own `selectId` implementation.", "The entity that was passed:", entity, "The `selectId` implementation:", selectId.toString());
    }
    return key;
}
function ensureEntitiesArray(entities) {
    if (!Array.isArray(entities)) {
        entities = Object.values(entities);
    }
    return entities;
}
function splitAddedUpdatedEntities(newEntities, selectId, state) {
    newEntities = ensureEntitiesArray(newEntities);
    var added = [];
    var updated = [];
    for (var _i = 0, newEntities_1 = newEntities; _i < newEntities_1.length; _i++) {
        var entity = newEntities_1[_i];
        var id = selectIdValue(entity, selectId);
        if (id in state.entities) {
            updated.push({ id: id, changes: entity });
        }
        else {
            added.push(entity);
        }
    }
    return [added, updated];
}
// src/entities/unsorted_state_adapter.ts
function createUnsortedStateAdapter(selectId) {
    function addOneMutably(entity, state) {
        var key = selectIdValue(entity, selectId);
        if (key in state.entities) {
            return;
        }
        state.ids.push(key);
        state.entities[key] = entity;
    }
    function addManyMutably(newEntities, state) {
        newEntities = ensureEntitiesArray(newEntities);
        for (var _i = 0, newEntities_2 = newEntities; _i < newEntities_2.length; _i++) {
            var entity = newEntities_2[_i];
            addOneMutably(entity, state);
        }
    }
    function setOneMutably(entity, state) {
        var key = selectIdValue(entity, selectId);
        if (!(key in state.entities)) {
            state.ids.push(key);
        }
        state.entities[key] = entity;
    }
    function setManyMutably(newEntities, state) {
        newEntities = ensureEntitiesArray(newEntities);
        for (var _i = 0, newEntities_3 = newEntities; _i < newEntities_3.length; _i++) {
            var entity = newEntities_3[_i];
            setOneMutably(entity, state);
        }
    }
    function setAllMutably(newEntities, state) {
        newEntities = ensureEntitiesArray(newEntities);
        state.ids = [];
        state.entities = {};
        addManyMutably(newEntities, state);
    }
    function removeOneMutably(key, state) {
        return removeManyMutably([key], state);
    }
    function removeManyMutably(keys, state) {
        var didMutate = false;
        keys.forEach(function (key) {
            if (key in state.entities) {
                delete state.entities[key];
                didMutate = true;
            }
        });
        if (didMutate) {
            state.ids = state.ids.filter(function (id) { return id in state.entities; });
        }
    }
    function removeAllMutably(state) {
        Object.assign(state, {
            ids: [],
            entities: {}
        });
    }
    function takeNewKey(keys, update, state) {
        var original2 = state.entities[update.id];
        var updated = Object.assign({}, original2, update.changes);
        var newKey = selectIdValue(updated, selectId);
        var hasNewKey = newKey !== update.id;
        if (hasNewKey) {
            keys[update.id] = newKey;
            delete state.entities[update.id];
        }
        state.entities[newKey] = updated;
        return hasNewKey;
    }
    function updateOneMutably(update, state) {
        return updateManyMutably([update], state);
    }
    function updateManyMutably(updates, state) {
        var newKeys = {};
        var updatesPerEntity = {};
        updates.forEach(function (update) {
            if (update.id in state.entities) {
                updatesPerEntity[update.id] = {
                    id: update.id,
                    changes: __spreadValues(__spreadValues({}, updatesPerEntity[update.id] ? updatesPerEntity[update.id].changes : null), update.changes)
                };
            }
        });
        updates = Object.values(updatesPerEntity);
        var didMutateEntities = updates.length > 0;
        if (didMutateEntities) {
            var didMutateIds = updates.filter(function (update) { return takeNewKey(newKeys, update, state); }).length > 0;
            if (didMutateIds) {
                state.ids = Object.keys(state.entities);
            }
        }
    }
    function upsertOneMutably(entity, state) {
        return upsertManyMutably([entity], state);
    }
    function upsertManyMutably(newEntities, state) {
        var _c = splitAddedUpdatedEntities(newEntities, selectId, state), added = _c[0], updated = _c[1];
        updateManyMutably(updated, state);
        addManyMutably(added, state);
    }
    return {
        removeAll: createSingleArgumentStateOperator(removeAllMutably),
        addOne: createStateOperator(addOneMutably),
        addMany: createStateOperator(addManyMutably),
        setOne: createStateOperator(setOneMutably),
        setMany: createStateOperator(setManyMutably),
        setAll: createStateOperator(setAllMutably),
        updateOne: createStateOperator(updateOneMutably),
        updateMany: createStateOperator(updateManyMutably),
        upsertOne: createStateOperator(upsertOneMutably),
        upsertMany: createStateOperator(upsertManyMutably),
        removeOne: createStateOperator(removeOneMutably),
        removeMany: createStateOperator(removeManyMutably)
    };
}
// src/entities/sorted_state_adapter.ts
function createSortedStateAdapter(selectId, sort) {
    var _c = createUnsortedStateAdapter(selectId), removeOne = _c.removeOne, removeMany = _c.removeMany, removeAll = _c.removeAll;
    function addOneMutably(entity, state) {
        return addManyMutably([entity], state);
    }
    function addManyMutably(newEntities, state) {
        newEntities = ensureEntitiesArray(newEntities);
        var models = newEntities.filter(function (model) { return !(selectIdValue(model, selectId) in state.entities); });
        if (models.length !== 0) {
            merge(models, state);
        }
    }
    function setOneMutably(entity, state) {
        return setManyMutably([entity], state);
    }
    function setManyMutably(newEntities, state) {
        newEntities = ensureEntitiesArray(newEntities);
        if (newEntities.length !== 0) {
            merge(newEntities, state);
        }
    }
    function setAllMutably(newEntities, state) {
        newEntities = ensureEntitiesArray(newEntities);
        state.entities = {};
        state.ids = [];
        addManyMutably(newEntities, state);
    }
    function updateOneMutably(update, state) {
        return updateManyMutably([update], state);
    }
    function updateManyMutably(updates, state) {
        var appliedUpdates = false;
        for (var _i = 0, updates_1 = updates; _i < updates_1.length; _i++) {
            var update = updates_1[_i];
            var entity = state.entities[update.id];
            if (!entity) {
                continue;
            }
            appliedUpdates = true;
            Object.assign(entity, update.changes);
            var newId = selectId(entity);
            if (update.id !== newId) {
                delete state.entities[update.id];
                state.entities[newId] = entity;
            }
        }
        if (appliedUpdates) {
            resortEntities(state);
        }
    }
    function upsertOneMutably(entity, state) {
        return upsertManyMutably([entity], state);
    }
    function upsertManyMutably(newEntities, state) {
        var _c = splitAddedUpdatedEntities(newEntities, selectId, state), added = _c[0], updated = _c[1];
        updateManyMutably(updated, state);
        addManyMutably(added, state);
    }
    function areArraysEqual(a, b) {
        if (a.length !== b.length) {
            return false;
        }
        for (var i = 0; i < a.length && i < b.length; i++) {
            if (a[i] === b[i]) {
                continue;
            }
            return false;
        }
        return true;
    }
    function merge(models, state) {
        models.forEach(function (model) {
            state.entities[selectId(model)] = model;
        });
        resortEntities(state);
    }
    function resortEntities(state) {
        var allEntities = Object.values(state.entities);
        allEntities.sort(sort);
        var newSortedIds = allEntities.map(selectId);
        var ids = state.ids;
        if (!areArraysEqual(ids, newSortedIds)) {
            state.ids = newSortedIds;
        }
    }
    return {
        removeOne: removeOne,
        removeMany: removeMany,
        removeAll: removeAll,
        addOne: createStateOperator(addOneMutably),
        updateOne: createStateOperator(updateOneMutably),
        upsertOne: createStateOperator(upsertOneMutably),
        setOne: createStateOperator(setOneMutably),
        setMany: createStateOperator(setManyMutably),
        setAll: createStateOperator(setAllMutably),
        addMany: createStateOperator(addManyMutably),
        updateMany: createStateOperator(updateManyMutably),
        upsertMany: createStateOperator(upsertManyMutably)
    };
}
// src/entities/create_adapter.ts
function createEntityAdapter(options) {
    if (options === void 0) { options = {}; }
    var _c = __spreadValues({
        sortComparer: false,
        selectId: function (instance) { return instance.id; }
    }, options), selectId = _c.selectId, sortComparer = _c.sortComparer;
    var stateFactory = createInitialStateFactory();
    var selectorsFactory = createSelectorsFactory();
    var stateAdapter = sortComparer ? createSortedStateAdapter(selectId, sortComparer) : createUnsortedStateAdapter(selectId);
    return __spreadValues(__spreadValues(__spreadValues({
        selectId: selectId,
        sortComparer: sortComparer
    }, stateFactory), selectorsFactory), stateAdapter);
}
// src/nanoid.ts
var urlAlphabet = "ModuleSymbhasOwnPr-0123456789ABCDEFGHNRVfgctiUvz_KqYTJkLxpZXIjQW";
var nanoid = function (size) {
    if (size === void 0) { size = 21; }
    var id = "";
    var i = size;
    while (i--) {
        id += urlAlphabet[Math.random() * 64 | 0];
    }
    return id;
};
// src/createAsyncThunk.ts
var commonProperties = [
    "name",
    "message",
    "stack",
    "code"
];
var RejectWithValue = /** @class */ (function () {
    function RejectWithValue(payload, meta) {
        this.payload = payload;
        this.meta = meta;
    }
    return RejectWithValue;
}());
var FulfillWithMeta = /** @class */ (function () {
    function FulfillWithMeta(payload, meta) {
        this.payload = payload;
        this.meta = meta;
    }
    return FulfillWithMeta;
}());
var miniSerializeError = function (value) {
    if (typeof value === "object" && value !== null) {
        var simpleError = {};
        for (var _i = 0, commonProperties_1 = commonProperties; _i < commonProperties_1.length; _i++) {
            var property = commonProperties_1[_i];
            if (typeof value[property] === "string") {
                simpleError[property] = value[property];
            }
        }
        return simpleError;
    }
    return { message: String(value) };
};
var createAsyncThunk = (function () {
    function createAsyncThunk2(typePrefix, payloadCreator, options) {
        var fulfilled = createAction(typePrefix + "/fulfilled", function (payload, requestId, arg, meta) { return ({
            payload: payload,
            meta: __spreadProps(__spreadValues({}, meta || {}), {
                arg: arg,
                requestId: requestId,
                requestStatus: "fulfilled"
            })
        }); });
        var pending = createAction(typePrefix + "/pending", function (requestId, arg, meta) { return ({
            payload: void 0,
            meta: __spreadProps(__spreadValues({}, meta || {}), {
                arg: arg,
                requestId: requestId,
                requestStatus: "pending"
            })
        }); });
        var rejected = createAction(typePrefix + "/rejected", function (error, requestId, arg, payload, meta) { return ({
            payload: payload,
            error: (options && options.serializeError || miniSerializeError)(error || "Rejected"),
            meta: __spreadProps(__spreadValues({}, meta || {}), {
                arg: arg,
                requestId: requestId,
                rejectedWithValue: !!payload,
                requestStatus: "rejected",
                aborted: (error == null ? void 0 : error.name) === "AbortError",
                condition: (error == null ? void 0 : error.name) === "ConditionError"
            })
        }); });
        var displayedWarning = false;
        var AC = typeof AbortController !== "undefined" ? AbortController : /** @class */ (function () {
            function class_1() {
                this.signal = {
                    aborted: false,
                    addEventListener: function () {
                    },
                    dispatchEvent: function () {
                        return false;
                    },
                    onabort: function () {
                    },
                    removeEventListener: function () {
                    },
                    reason: void 0,
                    throwIfAborted: function () {
                    }
                };
            }
            class_1.prototype.abort = function () {
                if (true) {
                    if (!displayedWarning) {
                        displayedWarning = true;
                        console.info("This platform does not implement AbortController. \nIf you want to use the AbortController to react to `abort` events, please consider importing a polyfill like 'abortcontroller-polyfill/dist/abortcontroller-polyfill-only'.");
                    }
                }
            };
            return class_1;
        }());
        function actionCreator(arg) {
            return function (dispatch, getState, extra) {
                var requestId = (options == null ? void 0 : options.idGenerator) ? options.idGenerator(arg) : nanoid();
                var abortController = new AC();
                var abortReason;
                var started = false;
                function abort(reason) {
                    abortReason = reason;
                    abortController.abort();
                }
                var promise2 = function () {
                    return __async(this, null, function () {
                        var _a, _b, finalAction, conditionResult, abortedPromise, err_1, skipDispatch;
                        return __generator(this, function (_c) {
                            switch (_c.label) {
                                case 0:
                                    _c.trys.push([0, 4, , 5]);
                                    conditionResult = (_a = options == null ? void 0 : options.condition) == null ? void 0 : _a.call(options, arg, { getState: getState, extra: extra });
                                    if (!isThenable(conditionResult)) return [3 /*break*/, 2];
                                    return [4 /*yield*/, conditionResult];
                                case 1:
                                    conditionResult = _c.sent();
                                    _c.label = 2;
                                case 2:
                                    if (conditionResult === false || abortController.signal.aborted) {
                                        throw {
                                            name: "ConditionError",
                                            message: "Aborted due to condition callback returning false."
                                        };
                                    }
                                    started = true;
                                    abortedPromise = new Promise(function (_, reject) { return abortController.signal.addEventListener("abort", function () { return reject({
                                        name: "AbortError",
                                        message: abortReason || "Aborted"
                                    }); }); });
                                    dispatch(pending(requestId, arg, (_b = options == null ? void 0 : options.getPendingMeta) == null ? void 0 : _b.call(options, { requestId: requestId, arg: arg }, { getState: getState, extra: extra })));
                                    return [4 /*yield*/, Promise.race([
                                            abortedPromise,
                                            Promise.resolve(payloadCreator(arg, {
                                                dispatch: dispatch,
                                                getState: getState,
                                                extra: extra,
                                                requestId: requestId,
                                                signal: abortController.signal,
                                                abort: abort,
                                                rejectWithValue: function (value, meta) {
                                                    return new RejectWithValue(value, meta);
                                                },
                                                fulfillWithValue: function (value, meta) {
                                                    return new FulfillWithMeta(value, meta);
                                                }
                                            })).then(function (result) {
                                                if (result instanceof RejectWithValue) {
                                                    throw result;
                                                }
                                                if (result instanceof FulfillWithMeta) {
                                                    return fulfilled(result.payload, requestId, arg, result.meta);
                                                }
                                                return fulfilled(result, requestId, arg);
                                            })
                                        ])];
                                case 3:
                                    finalAction = _c.sent();
                                    return [3 /*break*/, 5];
                                case 4:
                                    err_1 = _c.sent();
                                    finalAction = err_1 instanceof RejectWithValue ? rejected(null, requestId, arg, err_1.payload, err_1.meta) : rejected(err_1, requestId, arg);
                                    return [3 /*break*/, 5];
                                case 5:
                                    skipDispatch = options && !options.dispatchConditionRejection && rejected.match(finalAction) && finalAction.meta.condition;
                                    if (!skipDispatch) {
                                        dispatch(finalAction);
                                    }
                                    return [2 /*return*/, finalAction];
                            }
                        });
                    });
                }();
                return Object.assign(promise2, {
                    abort: abort,
                    requestId: requestId,
                    arg: arg,
                    unwrap: function () {
                        return promise2.then(unwrapResult);
                    }
                });
            };
        }
        return Object.assign(actionCreator, {
            pending: pending,
            rejected: rejected,
            fulfilled: fulfilled,
            typePrefix: typePrefix
        });
    }
    createAsyncThunk2.withTypes = function () { return createAsyncThunk2; };
    return createAsyncThunk2;
})();
function unwrapResult(action) {
    if (action.meta && action.meta.rejectedWithValue) {
        throw action.payload;
    }
    if (action.error) {
        throw action.error;
    }
    return action.payload;
}
function isThenable(value) {
    return value !== null && typeof value === "object" && typeof value.then === "function";
}
// src/matchers.ts
var matches = function (matcher, action) {
    if (hasMatchFunction(matcher)) {
        return matcher.match(action);
    }
    else {
        return matcher(action);
    }
};
function isAnyOf() {
    var matchers = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        matchers[_i] = arguments[_i];
    }
    return function (action) {
        return matchers.some(function (matcher) { return matches(matcher, action); });
    };
}
function isAllOf() {
    var matchers = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        matchers[_i] = arguments[_i];
    }
    return function (action) {
        return matchers.every(function (matcher) { return matches(matcher, action); });
    };
}
function hasExpectedRequestMetadata(action, validStatus) {
    if (!action || !action.meta)
        return false;
    var hasValidRequestId = typeof action.meta.requestId === "string";
    var hasValidRequestStatus = validStatus.indexOf(action.meta.requestStatus) > -1;
    return hasValidRequestId && hasValidRequestStatus;
}
function isAsyncThunkArray(a) {
    return typeof a[0] === "function" && "pending" in a[0] && "fulfilled" in a[0] && "rejected" in a[0];
}
function isPending() {
    var asyncThunks = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        asyncThunks[_i] = arguments[_i];
    }
    if (asyncThunks.length === 0) {
        return function (action) { return hasExpectedRequestMetadata(action, ["pending"]); };
    }
    if (!isAsyncThunkArray(asyncThunks)) {
        return isPending()(asyncThunks[0]);
    }
    return function (action) {
        var matchers = asyncThunks.map(function (asyncThunk) { return asyncThunk.pending; });
        var combinedMatcher = isAnyOf.apply(void 0, matchers);
        return combinedMatcher(action);
    };
}
function isRejected() {
    var asyncThunks = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        asyncThunks[_i] = arguments[_i];
    }
    if (asyncThunks.length === 0) {
        return function (action) { return hasExpectedRequestMetadata(action, ["rejected"]); };
    }
    if (!isAsyncThunkArray(asyncThunks)) {
        return isRejected()(asyncThunks[0]);
    }
    return function (action) {
        var matchers = asyncThunks.map(function (asyncThunk) { return asyncThunk.rejected; });
        var combinedMatcher = isAnyOf.apply(void 0, matchers);
        return combinedMatcher(action);
    };
}
function isRejectedWithValue() {
    var asyncThunks = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        asyncThunks[_i] = arguments[_i];
    }
    var hasFlag = function (action) {
        return action && action.meta && action.meta.rejectedWithValue;
    };
    if (asyncThunks.length === 0) {
        return function (action) {
            var combinedMatcher = isAllOf(isRejected.apply(void 0, asyncThunks), hasFlag);
            return combinedMatcher(action);
        };
    }
    if (!isAsyncThunkArray(asyncThunks)) {
        return isRejectedWithValue()(asyncThunks[0]);
    }
    return function (action) {
        var combinedMatcher = isAllOf(isRejected.apply(void 0, asyncThunks), hasFlag);
        return combinedMatcher(action);
    };
}
function isFulfilled() {
    var asyncThunks = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        asyncThunks[_i] = arguments[_i];
    }
    if (asyncThunks.length === 0) {
        return function (action) { return hasExpectedRequestMetadata(action, ["fulfilled"]); };
    }
    if (!isAsyncThunkArray(asyncThunks)) {
        return isFulfilled()(asyncThunks[0]);
    }
    return function (action) {
        var matchers = asyncThunks.map(function (asyncThunk) { return asyncThunk.fulfilled; });
        var combinedMatcher = isAnyOf.apply(void 0, matchers);
        return combinedMatcher(action);
    };
}
function isAsyncThunkAction() {
    var asyncThunks = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        asyncThunks[_i] = arguments[_i];
    }
    if (asyncThunks.length === 0) {
        return function (action) { return hasExpectedRequestMetadata(action, ["pending", "fulfilled", "rejected"]); };
    }
    if (!isAsyncThunkArray(asyncThunks)) {
        return isAsyncThunkAction()(asyncThunks[0]);
    }
    return function (action) {
        var matchers = [];
        for (var _i = 0, asyncThunks_1 = asyncThunks; _i < asyncThunks_1.length; _i++) {
            var asyncThunk = asyncThunks_1[_i];
            matchers.push(asyncThunk.pending, asyncThunk.rejected, asyncThunk.fulfilled);
        }
        var combinedMatcher = isAnyOf.apply(void 0, matchers);
        return combinedMatcher(action);
    };
}
// src/listenerMiddleware/utils.ts
var assertFunction = function (func, expected) {
    if (typeof func !== "function") {
        throw new TypeError(expected + " is not a function");
    }
};
var noop = function () {
};
var catchRejection = function (promise2, onError) {
    if (onError === void 0) { onError = noop; }
    promise2.catch(onError);
    return promise2;
};
var addAbortSignalListener = function (abortSignal, callback) {
    abortSignal.addEventListener("abort", callback, { once: true });
    return function () { return abortSignal.removeEventListener("abort", callback); };
};
var abortControllerWithReason = function (abortController, reason) {
    var signal = abortController.signal;
    if (signal.aborted) {
        return;
    }
    if (!("reason" in signal)) {
        Object.defineProperty(signal, "reason", {
            enumerable: true,
            value: reason,
            configurable: true,
            writable: true
        });
    }
    ;
    abortController.abort(reason);
};
// src/listenerMiddleware/exceptions.ts
var task = "task";
var listener = "listener";
var completed = "completed";
var cancelled = "cancelled";
var taskCancelled = "task-" + cancelled;
var taskCompleted = "task-" + completed;
var listenerCancelled = listener + "-" + cancelled;
var listenerCompleted = listener + "-" + completed;
var TaskAbortError = /** @class */ (function () {
    function TaskAbortError(code) {
        this.code = code;
        this.name = "TaskAbortError";
        this.message = task + " " + cancelled + " (reason: " + code + ")";
    }
    return TaskAbortError;
}());
// src/listenerMiddleware/task.ts
var validateActive = function (signal) {
    if (signal.aborted) {
        throw new TaskAbortError(signal.reason);
    }
};
function raceWithSignal(signal, promise2) {
    var cleanup = noop;
    return new Promise(function (resolve, reject) {
        var notifyRejection = function () { return reject(new TaskAbortError(signal.reason)); };
        if (signal.aborted) {
            notifyRejection();
            return;
        }
        cleanup = addAbortSignalListener(signal, notifyRejection);
        promise2.finally(function () { return cleanup(); }).then(resolve, reject);
    }).finally(function () {
        cleanup = noop;
    });
}
var runTask = function (task2, cleanUp) { return __async(void 0, null, function () {
    var value, error_1;
    return __generator(this, function (_c) {
        switch (_c.label) {
            case 0:
                _c.trys.push([0, 3, 4, 5]);
                return [4 /*yield*/, Promise.resolve()];
            case 1:
                _c.sent();
                return [4 /*yield*/, task2()];
            case 2:
                value = _c.sent();
                return [2 /*return*/, {
                        status: "ok",
                        value: value
                    }];
            case 3:
                error_1 = _c.sent();
                return [2 /*return*/, {
                        status: error_1 instanceof TaskAbortError ? "cancelled" : "rejected",
                        error: error_1
                    }];
            case 4:
                cleanUp == null ? void 0 : cleanUp();
                return [7 /*endfinally*/];
            case 5: return [2 /*return*/];
        }
    });
}); };
var createPause = function (signal) {
    return function (promise2) {
        return catchRejection(raceWithSignal(signal, promise2).then(function (output) {
            validateActive(signal);
            return output;
        }));
    };
};
var createDelay = function (signal) {
    var pause = createPause(signal);
    return function (timeoutMs) {
        return pause(new Promise(function (resolve) { return setTimeout(resolve, timeoutMs); }));
    };
};
// src/listenerMiddleware/index.ts
var assign = Object.assign;
var INTERNAL_NIL_TOKEN = {};
var alm = "listenerMiddleware";
var createFork = function (parentAbortSignal, parentBlockingPromises) {
    var linkControllers = function (controller) { return addAbortSignalListener(parentAbortSignal, function () { return abortControllerWithReason(controller, parentAbortSignal.reason); }); };
    return function (taskExecutor, opts) {
        assertFunction(taskExecutor, "taskExecutor");
        var childAbortController = new AbortController();
        linkControllers(childAbortController);
        var result = runTask(function () { return __async(void 0, null, function () {
            var result2;
            return __generator(this, function (_c) {
                switch (_c.label) {
                    case 0:
                        validateActive(parentAbortSignal);
                        validateActive(childAbortController.signal);
                        return [4 /*yield*/, taskExecutor({
                                pause: createPause(childAbortController.signal),
                                delay: createDelay(childAbortController.signal),
                                signal: childAbortController.signal
                            })];
                    case 1:
                        result2 = _c.sent();
                        validateActive(childAbortController.signal);
                        return [2 /*return*/, result2];
                }
            });
        }); }, function () { return abortControllerWithReason(childAbortController, taskCompleted); });
        if (opts == null ? void 0 : opts.autoJoin) {
            parentBlockingPromises.push(result);
        }
        return {
            result: createPause(parentAbortSignal)(result),
            cancel: function () {
                abortControllerWithReason(childAbortController, taskCancelled);
            }
        };
    };
};
var createTakePattern = function (startListening, signal) {
    var take = function (predicate, timeout) { return __async(void 0, null, function () {
        var unsubscribe, tuplePromise, promises, output;
        return __generator(this, function (_c) {
            switch (_c.label) {
                case 0:
                    validateActive(signal);
                    unsubscribe = function () {
                    };
                    tuplePromise = new Promise(function (resolve, reject) {
                        var stopListening = startListening({
                            predicate: predicate,
                            effect: function (action, listenerApi) {
                                listenerApi.unsubscribe();
                                resolve([
                                    action,
                                    listenerApi.getState(),
                                    listenerApi.getOriginalState()
                                ]);
                            }
                        });
                        unsubscribe = function () {
                            stopListening();
                            reject();
                        };
                    });
                    promises = [
                        tuplePromise
                    ];
                    if (timeout != null) {
                        promises.push(new Promise(function (resolve) { return setTimeout(resolve, timeout, null); }));
                    }
                    _c.label = 1;
                case 1:
                    _c.trys.push([1, , 3, 4]);
                    return [4 /*yield*/, raceWithSignal(signal, Promise.race(promises))];
                case 2:
                    output = _c.sent();
                    validateActive(signal);
                    return [2 /*return*/, output];
                case 3:
                    unsubscribe();
                    return [7 /*endfinally*/];
                case 4: return [2 /*return*/];
            }
        });
    }); };
    return function (predicate, timeout) { return catchRejection(take(predicate, timeout)); };
};
var getListenerEntryPropsFrom = function (options) {
    var type = options.type, actionCreator = options.actionCreator, matcher = options.matcher, predicate = options.predicate, effect = options.effect;
    if (type) {
        predicate = createAction(type).match;
    }
    else if (actionCreator) {
        type = actionCreator.type;
        predicate = actionCreator.match;
    }
    else if (matcher) {
        predicate = matcher;
    }
    else if (predicate) {
    }
    else {
        throw new Error("Creating or removing a listener requires one of the known fields for matching an action");
    }
    assertFunction(effect, "options.listener");
    return { predicate: predicate, type: type, effect: effect };
};
var createListenerEntry = function (options) {
    var _c = getListenerEntryPropsFrom(options), type = _c.type, predicate = _c.predicate, effect = _c.effect;
    var id = nanoid();
    var entry = {
        id: id,
        effect: effect,
        type: type,
        predicate: predicate,
        pending: new Set(),
        unsubscribe: function () {
            throw new Error("Unsubscribe not initialized");
        }
    };
    return entry;
};
var cancelActiveListeners = function (entry) {
    entry.pending.forEach(function (controller) {
        abortControllerWithReason(controller, listenerCancelled);
    });
};
var createClearListenerMiddleware = function (listenerMap) {
    return function () {
        listenerMap.forEach(cancelActiveListeners);
        listenerMap.clear();
    };
};
var safelyNotifyError = function (errorHandler, errorToNotify, errorInfo) {
    try {
        errorHandler(errorToNotify, errorInfo);
    }
    catch (errorHandlerError) {
        setTimeout(function () {
            throw errorHandlerError;
        }, 0);
    }
};
var addListener = createAction(alm + "/add");
var clearAllListeners = createAction(alm + "/removeAll");
var removeListener = createAction(alm + "/remove");
var defaultErrorHandler = function () {
    var args = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        args[_i] = arguments[_i];
    }
    console.error.apply(console, __spreadArray([alm + "/error"], args));
};
function createListenerMiddleware(middlewareOptions) {
    var _this = this;
    if (middlewareOptions === void 0) { middlewareOptions = {}; }
    var listenerMap = new Map();
    var extra = middlewareOptions.extra, _c = middlewareOptions.onError, onError = _c === void 0 ? defaultErrorHandler : _c;
    assertFunction(onError, "onError");
    var insertEntry = function (entry) {
        entry.unsubscribe = function () { return listenerMap.delete(entry.id); };
        listenerMap.set(entry.id, entry);
        return function (cancelOptions) {
            entry.unsubscribe();
            if (cancelOptions == null ? void 0 : cancelOptions.cancelActive) {
                cancelActiveListeners(entry);
            }
        };
    };
    var findListenerEntry = function (comparator) {
        for (var _i = 0, _c = Array.from(listenerMap.values()); _i < _c.length; _i++) {
            var entry = _c[_i];
            if (comparator(entry)) {
                return entry;
            }
        }
        return void 0;
    };
    var startListening = function (options) {
        var entry = findListenerEntry(function (existingEntry) { return existingEntry.effect === options.effect; });
        if (!entry) {
            entry = createListenerEntry(options);
        }
        return insertEntry(entry);
    };
    var stopListening = function (options) {
        var _c = getListenerEntryPropsFrom(options), type = _c.type, effect = _c.effect, predicate = _c.predicate;
        var entry = findListenerEntry(function (entry2) {
            var matchPredicateOrType = typeof type === "string" ? entry2.type === type : entry2.predicate === predicate;
            return matchPredicateOrType && entry2.effect === effect;
        });
        if (entry) {
            entry.unsubscribe();
            if (options.cancelActive) {
                cancelActiveListeners(entry);
            }
        }
        return !!entry;
    };
    var notifyListener = function (entry, action, api, getOriginalState) { return __async(_this, null, function () {
        var internalTaskController, take, autoJoinPromises, listenerError_1;
        return __generator(this, function (_c) {
            switch (_c.label) {
                case 0:
                    internalTaskController = new AbortController();
                    take = createTakePattern(startListening, internalTaskController.signal);
                    autoJoinPromises = [];
                    _c.label = 1;
                case 1:
                    _c.trys.push([1, 3, 4, 6]);
                    entry.pending.add(internalTaskController);
                    return [4 /*yield*/, Promise.resolve(entry.effect(action, assign({}, api, {
                            getOriginalState: getOriginalState,
                            condition: function (predicate, timeout) { return take(predicate, timeout).then(Boolean); },
                            take: take,
                            delay: createDelay(internalTaskController.signal),
                            pause: createPause(internalTaskController.signal),
                            extra: extra,
                            signal: internalTaskController.signal,
                            fork: createFork(internalTaskController.signal, autoJoinPromises),
                            unsubscribe: entry.unsubscribe,
                            subscribe: function () {
                                listenerMap.set(entry.id, entry);
                            },
                            cancelActiveListeners: function () {
                                entry.pending.forEach(function (controller, _, set) {
                                    if (controller !== internalTaskController) {
                                        abortControllerWithReason(controller, listenerCancelled);
                                        set.delete(controller);
                                    }
                                });
                            }
                        })))];
                case 2:
                    _c.sent();
                    return [3 /*break*/, 6];
                case 3:
                    listenerError_1 = _c.sent();
                    if (!(listenerError_1 instanceof TaskAbortError)) {
                        safelyNotifyError(onError, listenerError_1, {
                            raisedBy: "effect"
                        });
                    }
                    return [3 /*break*/, 6];
                case 4: return [4 /*yield*/, Promise.allSettled(autoJoinPromises)];
                case 5:
                    _c.sent();
                    abortControllerWithReason(internalTaskController, listenerCompleted);
                    entry.pending.delete(internalTaskController);
                    return [7 /*endfinally*/];
                case 6: return [2 /*return*/];
            }
        });
    }); };
    var clearListenerMiddleware = createClearListenerMiddleware(listenerMap);
    var middleware = function (api) { return function (next) { return function (action) {
        if (!isAction(action)) {
            return next(action);
        }
        if (addListener.match(action)) {
            return startListening(action.payload);
        }
        if (clearAllListeners.match(action)) {
            clearListenerMiddleware();
            return;
        }
        if (removeListener.match(action)) {
            return stopListening(action.payload);
        }
        var originalState = api.getState();
        var getOriginalState = function () {
            if (originalState === INTERNAL_NIL_TOKEN) {
                throw new Error(alm + ": getOriginalState can only be called synchronously");
            }
            return originalState;
        };
        var result;
        try {
            result = next(action);
            if (listenerMap.size > 0) {
                var currentState = api.getState();
                var listenerEntries = Array.from(listenerMap.values());
                for (var _i = 0, listenerEntries_1 = listenerEntries; _i < listenerEntries_1.length; _i++) {
                    var entry = listenerEntries_1[_i];
                    var runListener = false;
                    try {
                        runListener = entry.predicate(action, currentState, originalState);
                    }
                    catch (predicateError) {
                        runListener = false;
                        safelyNotifyError(onError, predicateError, {
                            raisedBy: "predicate"
                        });
                    }
                    if (!runListener) {
                        continue;
                    }
                    notifyListener(entry, action, api, getOriginalState);
                }
            }
        }
        finally {
            originalState = INTERNAL_NIL_TOKEN;
        }
        return result;
    }; }; };
    return {
        middleware: middleware,
        startListening: startListening,
        stopListening: stopListening,
        clearListeners: clearListenerMiddleware
    };
}
// src/autoBatchEnhancer.ts
var SHOULD_AUTOBATCH = "RTK_autoBatch";
var prepareAutoBatched = function () { return function (payload) {
    var _c;
    return ({
        payload: payload,
        meta: (_c = {}, _c[SHOULD_AUTOBATCH] = true, _c)
    });
}; };
var promise;
var queueMicrotaskShim = typeof queueMicrotask === "function" ? queueMicrotask.bind(typeof window !== "undefined" ? window : typeof __webpack_require__.g !== "undefined" ? __webpack_require__.g : globalThis) : function (cb) { return (promise || (promise = Promise.resolve())).then(cb).catch(function (err) { return setTimeout(function () {
    throw err;
}, 0); }); };
var createQueueWithTimer = function (timeout) {
    return function (notify) {
        setTimeout(notify, timeout);
    };
};
var rAF = typeof window !== "undefined" && window.requestAnimationFrame ? window.requestAnimationFrame : createQueueWithTimer(10);
var autoBatchEnhancer = function (options) {
    if (options === void 0) { options = { type: "raf" }; }
    return function (next) { return function () {
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
        }
        var store = next.apply(void 0, args);
        var notifying = true;
        var shouldNotifyAtEndOfTick = false;
        var notificationQueued = false;
        var listeners = new Set();
        var queueCallback = options.type === "tick" ? queueMicrotaskShim : options.type === "raf" ? rAF : options.type === "callback" ? options.queueNotification : createQueueWithTimer(options.timeout);
        var notifyListeners = function () {
            notificationQueued = false;
            if (shouldNotifyAtEndOfTick) {
                shouldNotifyAtEndOfTick = false;
                listeners.forEach(function (l) { return l(); });
            }
        };
        return Object.assign({}, store, {
            subscribe: function (listener2) {
                var wrappedListener = function () { return notifying && listener2(); };
                var unsubscribe = store.subscribe(wrappedListener);
                listeners.add(listener2);
                return function () {
                    unsubscribe();
                    listeners.delete(listener2);
                };
            },
            dispatch: function (action) {
                var _a;
                try {
                    notifying = !((_a = action == null ? void 0 : action.meta) == null ? void 0 : _a[SHOULD_AUTOBATCH]);
                    shouldNotifyAtEndOfTick = !notifying;
                    if (shouldNotifyAtEndOfTick) {
                        if (!notificationQueued) {
                            notificationQueued = true;
                            queueCallback(notifyListeners);
                        }
                    }
                    return store.dispatch(action);
                }
                finally {
                    notifying = true;
                }
            }
        });
    }; };
};
// src/index.ts
(0,immer__WEBPACK_IMPORTED_MODULE_2__.enableES5)();

//# sourceMappingURL=redux-toolkit.esm.js.map

/***/ }),

/***/ "../app/assets/js/utils/utils.js":
/*!***************************************!*\
  !*** ../app/assets/js/utils/utils.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.stringToRemValues = exports.rgbToHex = exports.pxToRem = exports.isOneOf = exports.arrayToObjectByKey = exports.arrayToClassName = void 0;
var _typeof2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js"));
var pxToRem = function pxToRem(pixels) {
  if (!pixels) {
    return;
  } else if ('string' !== typeof pixels) {
    pixels = pixels.toString();
  }
  return pixels.split(' ').map(function (value) {
    return "".concat(value * 0.0625, "rem");
  }).join(' ');
};
exports.pxToRem = pxToRem;
var arrayToClassName = function arrayToClassName(array, action) {
  return array.filter(function (item) {
    return 'object' === (0, _typeof2.default)(item) ? Object.entries(item)[0][1] : item;
  }).map(function (item) {
    var value = 'object' === (0, _typeof2.default)(item) ? Object.entries(item)[0][0] : item;
    return action ? action(value) : value;
  }).join(' ');
};
exports.arrayToClassName = arrayToClassName;
var stringToRemValues = function stringToRemValues(string) {
  return string.split(' ').map(function (value) {
    return pxToRem(value);
  }).join(' ');
};
exports.stringToRemValues = stringToRemValues;
var rgbToHex = function rgbToHex(r, g, b) {
  return '#' + [r, g, b].map(function (x) {
    var hex = x.toString(16);
    return 1 === hex.length ? '0' + hex : hex;
  }).join('');
};
exports.rgbToHex = rgbToHex;
var isOneOf = function isOneOf(filetype, filetypeOptions) {
  return filetypeOptions.some(function (type) {
    return filetype.includes(type);
  });
};
exports.isOneOf = isOneOf;
var arrayToObjectByKey = function arrayToObjectByKey(array, key) {
  var finalObject = {};
  array.forEach(function (item) {
    return finalObject[item[key]] = item;
  });
  return finalObject;
};
exports.arrayToObjectByKey = arrayToObjectByKey;

/***/ }),

/***/ "../assets/dev/js/editor/command-bases/command-container-base.js":
/*!***********************************************************************!*\
  !*** ../assets/dev/js/editor/command-bases/command-container-base.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _commandBase = _interopRequireDefault(__webpack_require__(/*! elementor-api/modules/command-base */ "../modules/web-cli/assets/js/modules/command-base.js"));
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
/**
 * @name $e.modules.editor.CommandContainerBase
 */
var CommandContainerBase = /*#__PURE__*/function (_CommandBase) {
  (0, _inherits2.default)(CommandContainerBase, _CommandBase);
  var _super = _createSuper(CommandContainerBase);
  function CommandContainerBase() {
    (0, _classCallCheck2.default)(this, CommandContainerBase);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(CommandContainerBase, [{
    key: "requireContainer",
    value:
    /**
     * Function requireContainer().
     *
     * Validate `arg.container` & `arg.containers`.
     *
     * @param {{}} args
     *
     * @throws {Error}
     */
    function requireContainer() {
      var _this = this;
      var args = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this.args;
      if (!args.container && !args.containers) {
        throw Error('container or containers are required.');
      }
      if (args.container && args.containers) {
        throw Error('container and containers cannot go together please select one of them.');
      }
      var containers = args.containers || [args.container];
      containers.forEach(function (container) {
        _this.requireArgumentInstance('container', elementorModules.editor.Container, {
          container: container
        });
      });
    }
  }], [{
    key: "getInstanceType",
    value: function getInstanceType() {
      return 'CommandContainerBase';
    }
  }]);
  return CommandContainerBase;
}(_commandBase.default);
exports["default"] = CommandContainerBase;

/***/ }),

/***/ "../assets/dev/js/editor/component-base.js":
/*!*************************************************!*\
  !*** ../assets/dev/js/editor/component-base.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _componentBase = _interopRequireDefault(__webpack_require__(/*! elementor-api/modules/component-base */ "../modules/web-cli/assets/js/modules/component-base.js"));
var _editor = _interopRequireDefault(__webpack_require__(/*! elementor-panel/pages/editor */ "../assets/dev/js/editor/regions/panel/pages/editor.js"));
var _baseData = _interopRequireDefault(__webpack_require__(/*! elementor-controls/base-data */ "../assets/dev/js/editor/controls/base-data.js"));
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var ComponentBase = /*#__PURE__*/function (_ApiComponentBase) {
  (0, _inherits2.default)(ComponentBase, _ApiComponentBase);
  var _super = _createSuper(ComponentBase);
  function ComponentBase() {
    (0, _classCallCheck2.default)(this, ComponentBase);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(ComponentBase, [{
    key: "activateControl",
    value:
    /**
     * Call the activate of the control's view
     *
     * @param {string} controlPath
     */
    function activateControl(controlPath) {
      var _controlView$activate;
      if (!controlPath) {
        return;
      }
      var editor = elementor.getPanelView().getCurrentPageView();
      var currentView = editor.content ? editor.content.currentView : editor;
      var controlView = this.getControlViewByPath(currentView, controlPath);
      (_controlView$activate = controlView.activate) === null || _controlView$activate === void 0 ? void 0 : _controlView$activate.call(controlView);
    }

    /**
     * Get the control's view by path
     *
     * @param {EditorView} currentView
     * @param {string}     controlPath
     *
     * @return {ControlBaseDataView}
     */
  }, {
    key: "getControlViewByPath",
    value: function getControlViewByPath(currentView, controlPath) {
      var controls = controlPath.split('/');
      var controlView = currentView.getControlViewByName(controls[0]);
      controls.slice(1).forEach(function (control) {
        var _controlView$getChild, _controlView;
        controlView = (_controlView$getChild = (_controlView = controlView).getChildControlView) === null || _controlView$getChild === void 0 ? void 0 : _controlView$getChild.call(_controlView, control);
      });
      return controlView;
    }
  }]);
  return ComponentBase;
}(_componentBase.default);
exports["default"] = ComponentBase;

/***/ }),

/***/ "../assets/dev/js/editor/components/browser-import/commands-internal/index.js":
/*!************************************************************************************!*\
  !*** ../assets/dev/js/editor/components/browser-import/commands-internal/index.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
Object.defineProperty(exports, "Validate", ({
  enumerable: true,
  get: function get() {
    return _validate.Validate;
  }
}));
var _validate = __webpack_require__(/*! ./validate */ "../assets/dev/js/editor/components/browser-import/commands-internal/validate.js");

/***/ }),

/***/ "../assets/dev/js/editor/components/browser-import/commands-internal/validate.js":
/*!***************************************************************************************!*\
  !*** ../assets/dev/js/editor/components/browser-import/commands-internal/validate.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.Validate = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var Validate = /*#__PURE__*/function (_$e$modules$CommandBa) {
  (0, _inherits2.default)(Validate, _$e$modules$CommandBa);
  var _super = _createSuper(Validate);
  function Validate() {
    (0, _classCallCheck2.default)(this, Validate);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(Validate, [{
    key: "apply",
    value:
    /**
     * @inheritDoc
     */
    function apply(args) {
      var input = args.input,
        _args$options = args.options,
        options = _args$options === void 0 ? {} : _args$options;
      return this.component.manager.createSession(input, elementor.getPreviewContainer(), options).then(function (session) {
        return session.validate();
      });
    }
  }]);
  return Validate;
}($e.modules.CommandBase);
exports.Validate = Validate;
var _default = Validate;
exports["default"] = _default;

/***/ }),

/***/ "../assets/dev/js/editor/components/browser-import/commands/import.js":
/*!****************************************************************************!*\
  !*** ../assets/dev/js/editor/components/browser-import/commands/import.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.Import = void 0;
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var Import = /*#__PURE__*/function (_$e$modules$CommandBa) {
  (0, _inherits2.default)(Import, _$e$modules$CommandBa);
  var _super = _createSuper(Import);
  function Import() {
    (0, _classCallCheck2.default)(this, Import);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(Import, [{
    key: "validateArgs",
    value:
    /**
     * @inheritDoc
     */
    function validateArgs() {
      this.requireArgumentInstance('target', elementorModules.editor.Container);
    }

    /**
     * @inheritDoc
     */
  }, {
    key: "apply",
    value: function apply(args) {
      var _this = this;
      var _args$targets = args.targets,
        targets = _args$targets === void 0 ? [args.target] : _args$targets,
        input = args.input,
        _args$options = args.options,
        options = _args$options === void 0 ? {} : _args$options,
        result = [];
      targets.forEach(function (target) {
        result.push(_this.component.manager.createSession(input, target, options).then( /*#__PURE__*/function () {
          var _ref = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee(session) {
            return _regenerator.default.wrap(function _callee$(_context) {
              while (1) switch (_context.prev = _context.next) {
                case 0:
                  _context.next = 2;
                  return session.validate();
                case 2:
                  if (!_context.sent) {
                    _context.next = 4;
                    break;
                  }
                  session.apply();
                case 4:
                case "end":
                  return _context.stop();
              }
            }, _callee);
          }));
          return function (_x) {
            return _ref.apply(this, arguments);
          };
        }()));
      });
      return Promise.all(result);
    }
  }]);
  return Import;
}($e.modules.CommandBase);
exports.Import = Import;
var _default = Import;
exports["default"] = _default;

/***/ }),

/***/ "../assets/dev/js/editor/components/browser-import/commands/index.js":
/*!***************************************************************************!*\
  !*** ../assets/dev/js/editor/components/browser-import/commands/index.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
Object.defineProperty(exports, "Import", ({
  enumerable: true,
  get: function get() {
    return _import.Import;
  }
}));
var _import = __webpack_require__(/*! ./import */ "../assets/dev/js/editor/components/browser-import/commands/import.js");

/***/ }),

/***/ "../assets/dev/js/editor/components/browser-import/component.js":
/*!**********************************************************************!*\
  !*** ../assets/dev/js/editor/components/browser-import/component.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var commands = _interopRequireWildcard(__webpack_require__(/*! ./commands */ "../assets/dev/js/editor/components/browser-import/commands/index.js"));
var commandsInternal = _interopRequireWildcard(__webpack_require__(/*! ./commands-internal */ "../assets/dev/js/editor/components/browser-import/commands-internal/index.js"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var Component = /*#__PURE__*/function (_$e$modules$Component) {
  (0, _inherits2.default)(Component, _$e$modules$Component);
  var _super = _createSuper(Component);
  function Component() {
    (0, _classCallCheck2.default)(this, Component);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(Component, [{
    key: "getNamespace",
    value: function getNamespace() {
      return 'editor/browser-import';
    }
  }, {
    key: "defaultCommands",
    value: function defaultCommands() {
      return this.importCommands(commands);
    }
  }, {
    key: "defaultCommandsInternal",
    value: function defaultCommandsInternal() {
      return this.importCommands(commandsInternal);
    }
  }]);
  return Component;
}($e.modules.ComponentBase);
exports["default"] = Component;

/***/ }),

/***/ "../assets/dev/js/editor/components/browser-import/container-factory.js":
/*!******************************************************************************!*\
  !*** ../assets/dev/js/editor/components/browser-import/container-factory.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _element = _interopRequireDefault(__webpack_require__(/*! ../../elements/models/element */ "../assets/dev/js/editor/elements/models/element.js"));
function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
/**
 * @typedef {import('../../container/container')} Container
 */
var ContainerFactory = /*#__PURE__*/function () {
  function ContainerFactory() {
    (0, _classCallCheck2.default)(this, ContainerFactory);
  }
  (0, _createClass2.default)(ContainerFactory, null, [{
    key: "createElementContainer",
    value:
    /**
     * Create an element container.
     *
     * @param {*} element
     * @return {Container} element container
     */
    function createElementContainer(element) {
      var model = new _element.default(this.regenerateIds([Object.assign({
        elType: (element === null || element === void 0 ? void 0 : element.elType) || 'widget'
      }, element)])[0]);
      return new elementorModules.editor.Container({
        id: model.get('id'),
        type: model.get('elType'),
        settings: model.get('settings'),
        model: model,
        parent: false
      });
    }
  }, {
    key: "regenerateIds",
    value: function regenerateIds(elements) {
      var _iterator = _createForOfIteratorHelper(elements),
        _step;
      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var element = _step.value;
          element.id = elementorCommon.helpers.getUniqueId().toString();
          if (element.elements) {
            this.regenerateIds(element.elements);
          }
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }
      return elements;
    }
  }]);
  return ContainerFactory;
}();
exports["default"] = ContainerFactory;

/***/ }),

/***/ "../assets/dev/js/editor/components/browser-import/default-config.js":
/*!***************************************************************************!*\
  !*** ../assets/dev/js/editor/components/browser-import/default-config.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof3 = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _typeof2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js"));
var readers = _interopRequireWildcard(__webpack_require__(/*! ./files/readers */ "../assets/dev/js/editor/components/browser-import/files/readers/index.js"));
var parsers = _interopRequireWildcard(__webpack_require__(/*! ./files/parsers */ "../assets/dev/js/editor/components/browser-import/files/parsers/index.js"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof3(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/**
 * Recursively convert objects to arrays of values.
 *
 * @param {*} object
 * @return {[]} values
 */
var recursiveValues = function recursiveValues(object) {
  return Object.values(object).map(function (value) {
    return 'object' === (0, _typeof2.default)(value) ? Object.values(value) : value;
  });
};
var _default = {
  readers: recursiveValues(readers),
  parsers: recursiveValues(parsers).flat()
};
exports["default"] = _default;

/***/ }),

/***/ "../assets/dev/js/editor/components/browser-import/files/file-parser-base.js":
/*!***********************************************************************************!*\
  !*** ../assets/dev/js/editor/components/browser-import/files/file-parser-base.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
/**
 * @typedef {import('../../../container/container')} Container
 */
/**
 * @typedef {import('./file-reader-base')} FileReaderBase
 */
/**
 * @abstract
 */
var FileParserBase = /*#__PURE__*/function () {
  /**
   * FileParseBase constructor.
   *
   * @param {FileReaderBase} reader
   */
  function FileParserBase(reader) {
    (0, _classCallCheck2.default)(this, FileParserBase);
    /**
     * The file-reader instance.
     *
     * @type {FileReaderBase}
     */
    (0, _defineProperty2.default)(this, "reader", void 0);
    /**
     * Tasks to complete, even after parsing completed.
     *
     * @type {[]}
     */
    (0, _defineProperty2.default)(this, "tasks", []);
    this.reader = reader;
  }

  /**
   * Get the file-parser name.
   *
   * @abstract
   * @return {string} name
   */
  (0, _createClass2.default)(FileParserBase, [{
    key: "parse",
    value:
    /**
     * Parse the the input as needed by this parser, and return Container objects to be processed.
     *
     * @abstract
     * @return {Container[]} containers
     */
    function () {
      var _parse = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee() {
        return _regenerator.default.wrap(function _callee$(_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
            case "end":
              return _context.stop();
          }
        }, _callee);
      }));
      function parse() {
        return _parse.apply(this, arguments);
      }
      return parse;
    }()
    /**
     * Here parsers can validate that an input from a reader can be handled by the parser. This validation has to be
     * very accurate and specific so if the parser can't handle the file for sure, the next parsers will have the
     * opportunity to do so.
     *
     * @param {*} reader
     *
     * @abstract
     * @return {boolean} is valid
     */
  }], [{
    key: "getName",
    value: function getName() {
      return '';
    }

    /**
     * Get all readers the parser can handle with.
     *
     * @abstract
     * @return {string[]} readers
     */
  }, {
    key: "getReaders",
    value: function getReaders() {
      return [];
    }
  }, {
    key: "validate",
    value: function () {
      var _validate = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee2(reader) {
        return _regenerator.default.wrap(function _callee2$(_context2) {
          while (1) switch (_context2.prev = _context2.next) {
            case 0:
              return _context2.abrupt("return", false);
            case 1:
            case "end":
              return _context2.stop();
          }
        }, _callee2);
      }));
      function validate(_x) {
        return _validate.apply(this, arguments);
      }
      return validate;
    }()
  }]);
  return FileParserBase;
}();
exports["default"] = FileParserBase;

/***/ }),

/***/ "../assets/dev/js/editor/components/browser-import/files/file-reader-base.js":
/*!***********************************************************************************!*\
  !*** ../assets/dev/js/editor/components/browser-import/files/file-reader-base.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
/**
 * @abstract
 */
var FileReaderBase = /*#__PURE__*/function () {
  /**
   * FileReaderBase constructor.
   *
   * @param {File} file
   */
  function FileReaderBase(file) {
    (0, _classCallCheck2.default)(this, FileReaderBase);
    /**
     * The File instance.
     *
     * @type {File}
     */
    (0, _defineProperty2.default)(this, "file", void 0);
    this.file = file;
  }

  /**
   * Get the file-reader name.
   *
   * @abstract
   * @return {string} name
   */
  (0, _createClass2.default)(FileReaderBase, [{
    key: "getFile",
    value:
    /**
     * Get the file-reader File object.
     *
     * @return {*} file
     */
    function getFile() {
      return this.file;
    }

    /**
     * Get the file-reader File object content as string.
     *
     * @return {Promise<string>} handler
     */
  }, {
    key: "getContent",
    value: function () {
      var _getContent = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee() {
        var fileReader, handler;
        return _regenerator.default.wrap(function _callee$(_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              fileReader = new FileReader(), handler = new Promise(function (resolve) {
                fileReader.onloadend = function () {
                  return resolve(fileReader.result);
                };
              });
              fileReader.readAsText(this.getFile());
              return _context.abrupt("return", handler);
            case 3:
            case "end":
              return _context.stop();
          }
        }, _callee, this);
      }));
      function getContent() {
        return _getContent.apply(this, arguments);
      }
      return getContent;
    }()
    /**
     * Get the file-reader File object data url string.
     *
     * @return {Promise<string>} data URI
     */
  }, {
    key: "getDataUrl",
    value: function () {
      var _getDataUrl = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee2() {
        var fileReader, handler;
        return _regenerator.default.wrap(function _callee2$(_context2) {
          while (1) switch (_context2.prev = _context2.next) {
            case 0:
              fileReader = new FileReader(), handler = new Promise(function (resolve) {
                fileReader.onloadend = function () {
                  return resolve(fileReader.result);
                };
              });
              fileReader.readAsDataURL(this.getFile());
              return _context2.abrupt("return", handler);
            case 3:
            case "end":
              return _context2.stop();
          }
        }, _callee2, this);
      }));
      function getDataUrl() {
        return _getDataUrl.apply(this, arguments);
      }
      return getDataUrl;
    }()
  }], [{
    key: "getName",
    value: function getName() {
      return '';
    }

    /**
     * Check if the reader is currently active.
     *
     * @abstract
     * @return {boolean}
     */
  }, {
    key: "isActive",
    value: function isActive() {
      return true;
    }

    /**
     * Each file-reader can register the mime-types it supports in this method, so later a File object can be matched
     * to it accordingly.
     *
     * @abstract
     * @return {string[]} mime types
     */
  }, {
    key: "mimeTypes",
    get: function get() {
      return [];
    }

    /**
     * If the file-reader supports an input that's received without an explicit mime-type (such as strings or JavasScript
     * objects), here it can decide whether it can handle it and eventually return a suitable mime-type.
     *
     * @abstract
     * @param {*} input
     * @return {string|boolean} mime type
     */
  }, {
    key: "resolve",
    value: function () {
      var _resolve = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee3(input) {
        return _regenerator.default.wrap(function _callee3$(_context3) {
          while (1) switch (_context3.prev = _context3.next) {
            case 0:
              return _context3.abrupt("return", false);
            case 1:
            case "end":
              return _context3.stop();
          }
        }, _callee3);
      }));
      function resolve(_x) {
        return _resolve.apply(this, arguments);
      }
      return resolve;
    }()
    /**
     * Validate that a file can be handled by the file-reader, according to its mime-type.
     *
     * @param {File} file
     */
  }, {
    key: "validate",
    value: function () {
      var _validate = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee4(file) {
        return _regenerator.default.wrap(function _callee4$(_context4) {
          while (1) switch (_context4.prev = _context4.next) {
            case 0:
              if (!this.validator) {
                this.validator = new RegExp(this.mimeTypes.join('|'), 'i');
              }
              return _context4.abrupt("return", this.validator.test(file.type));
            case 2:
            case "end":
              return _context4.stop();
          }
        }, _callee4, this);
      }));
      function validate(_x2) {
        return _validate.apply(this, arguments);
      }
      return validate;
    }()
  }]);
  return FileReaderBase;
}();
exports["default"] = FileReaderBase;

/***/ }),

/***/ "../assets/dev/js/editor/components/browser-import/files/parsers/base/index.js":
/*!*************************************************************************************!*\
  !*** ../assets/dev/js/editor/components/browser-import/files/parsers/base/index.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
Object.defineProperty(exports, "MediaParser", ({
  enumerable: true,
  get: function get() {
    return _mediaParser.MediaParser;
  }
}));
var _mediaParser = __webpack_require__(/*! ./media-parser */ "../assets/dev/js/editor/components/browser-import/files/parsers/base/media-parser.js");

/***/ }),

/***/ "../assets/dev/js/editor/components/browser-import/files/parsers/base/media-parser.js":
/*!********************************************************************************************!*\
  !*** ../assets/dev/js/editor/components/browser-import/files/parsers/base/media-parser.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.MediaParser = void 0;
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _fileParserBase = _interopRequireDefault(__webpack_require__(/*! elementor-editor/components/browser-import/files/file-parser-base */ "../assets/dev/js/editor/components/browser-import/files/file-parser-base.js"));
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
/**
 * @abstract
 */
var MediaParser = /*#__PURE__*/function (_FileParserBase) {
  (0, _inherits2.default)(MediaParser, _FileParserBase);
  var _super = _createSuper(MediaParser);
  function MediaParser() {
    (0, _classCallCheck2.default)(this, MediaParser);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(MediaParser, [{
    key: "upload",
    value:
    /**
     * Upload a media file to the wordpress media library using the `wp/media` command.
     *
     * @param {*} file
     * @param {*} options
     * @return {{}} result
     */
    function upload(file) {
      var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      return $e.data.run('create', 'wp/media', {
        file: file,
        options: _objectSpread({
          progress: true
        }, options)
      }).catch(function (result) {
        elementor.notifications.showToast({
          message: result.message
        });
        return Promise.reject(result);
      });
    }
  }]);
  return MediaParser;
}(_fileParserBase.default);
exports.MediaParser = MediaParser;

/***/ }),

/***/ "../assets/dev/js/editor/components/browser-import/files/parsers/image/index.js":
/*!**************************************************************************************!*\
  !*** ../assets/dev/js/editor/components/browser-import/files/parsers/image/index.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
Object.defineProperty(exports, "Widget", ({
  enumerable: true,
  get: function get() {
    return _widget.Widget;
  }
}));
var _widget = __webpack_require__(/*! ./widget */ "../assets/dev/js/editor/components/browser-import/files/parsers/image/widget.js");

/***/ }),

/***/ "../assets/dev/js/editor/components/browser-import/files/parsers/image/widget.js":
/*!***************************************************************************************!*\
  !*** ../assets/dev/js/editor/components/browser-import/files/parsers/image/widget.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Widget = void 0;
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _containerFactory = _interopRequireDefault(__webpack_require__(/*! ../../../container-factory */ "../assets/dev/js/editor/components/browser-import/container-factory.js"));
var _base = __webpack_require__(/*! ../base */ "../assets/dev/js/editor/components/browser-import/files/parsers/base/index.js");
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var Widget = /*#__PURE__*/function (_MediaParser) {
  (0, _inherits2.default)(Widget, _MediaParser);
  var _super = _createSuper(Widget);
  function Widget() {
    (0, _classCallCheck2.default)(this, Widget);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(Widget, [{
    key: "parse",
    value:
    /**
     * @inheritDoc
     */
    function () {
      var _parse = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee() {
        var file, container;
        return _regenerator.default.wrap(function _callee$(_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              file = this.reader.getFile();
              _context.t0 = _containerFactory.default;
              _context.next = 4;
              return this.reader.getDataUrl();
            case 4:
              _context.t1 = _context.sent;
              _context.t2 = file.name.split('.')[0];
              _context.t3 = {
                url: _context.t1,
                alt: _context.t2,
                source: 'library'
              };
              _context.t4 = {
                image: _context.t3
              };
              _context.t5 = {
                widgetType: 'image',
                settings: _context.t4
              };
              container = _context.t0.createElementContainer.call(_context.t0, _context.t5);
              this.upload(file).then(function (_ref) {
                var data = _ref.data;
                $e.internal('document/elements/set-settings', {
                  // The reason we use the container id and not the container instance itself is that the container
                  // created above is just a placeholder, which later recreated using the same id.
                  container: elementor.getContainer(container.id),
                  settings: {
                    image: {
                      url: data.source_url,
                      id: data.id
                    }
                  }
                });
              }).catch(function () {
                elementor.documents.getCurrent().history.setActive(false);
                $e.run('document/elements/reset-settings', {
                  container: elementor.getContainer(container.id),
                  options: {
                    external: true
                  }
                });
                elementor.documents.getCurrent().history.setActive(true);
              });
              return _context.abrupt("return", container);
            case 12:
            case "end":
              return _context.stop();
          }
        }, _callee, this);
      }));
      function parse() {
        return _parse.apply(this, arguments);
      }
      return parse;
    }()
    /**
     * @inheritDoc
     */
  }], [{
    key: "getName",
    value:
    /**
     * @inheritDoc
     */
    function getName() {
      return 'widget';
    }

    /**
     * @inheritDoc
     */
  }, {
    key: "getReaders",
    value: function getReaders() {
      return ['image'];
    }
  }, {
    key: "validate",
    value: function () {
      var _validate = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee2() {
        return _regenerator.default.wrap(function _callee2$(_context2) {
          while (1) switch (_context2.prev = _context2.next) {
            case 0:
              return _context2.abrupt("return", true);
            case 1:
            case "end":
              return _context2.stop();
          }
        }, _callee2);
      }));
      function validate() {
        return _validate.apply(this, arguments);
      }
      return validate;
    }()
  }]);
  return Widget;
}(_base.MediaParser);
exports.Widget = Widget;

/***/ }),

/***/ "../assets/dev/js/editor/components/browser-import/files/parsers/index.js":
/*!********************************************************************************!*\
  !*** ../assets/dev/js/editor/components/browser-import/files/parsers/index.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.video = exports.json = exports.image = exports.base = void 0;
var _base = _interopRequireWildcard(__webpack_require__(/*! ./base */ "../assets/dev/js/editor/components/browser-import/files/parsers/base/index.js"));
exports.base = _base;
var _image = _interopRequireWildcard(__webpack_require__(/*! ./image */ "../assets/dev/js/editor/components/browser-import/files/parsers/image/index.js"));
exports.image = _image;
var _json = _interopRequireWildcard(__webpack_require__(/*! ./json */ "../assets/dev/js/editor/components/browser-import/files/parsers/json/index.js"));
exports.json = _json;
var _video = _interopRequireWildcard(__webpack_require__(/*! ./video */ "../assets/dev/js/editor/components/browser-import/files/parsers/video/index.js"));
exports.video = _video;
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/***/ }),

/***/ "../assets/dev/js/editor/components/browser-import/files/parsers/json/elements.js":
/*!****************************************************************************************!*\
  !*** ../assets/dev/js/editor/components/browser-import/files/parsers/json/elements.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Elements = void 0;
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _fileParserBase = _interopRequireDefault(__webpack_require__(/*! ../../file-parser-base */ "../assets/dev/js/editor/components/browser-import/files/file-parser-base.js"));
var _containerFactory = _interopRequireDefault(__webpack_require__(/*! ../../../container-factory */ "../assets/dev/js/editor/components/browser-import/container-factory.js"));
var _filesUploadHandler = _interopRequireDefault(__webpack_require__(/*! ../../../../../utils/files-upload-handler */ "../assets/dev/js/editor/utils/files-upload-handler.js"));
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var Elements = /*#__PURE__*/function (_FileParserBase) {
  (0, _inherits2.default)(Elements, _FileParserBase);
  var _super = _createSuper(Elements);
  function Elements() {
    (0, _classCallCheck2.default)(this, Elements);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(Elements, [{
    key: "parse",
    value:
    /**
     * @inheritDoc
     */
    function () {
      var _parse = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee() {
        return _regenerator.default.wrap(function _callee$(_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              _context.next = 2;
              return this.reader.getData();
            case 2:
              return _context.abrupt("return", _context.sent.content.map(function (element) {
                return _containerFactory.default.createElementContainer(element);
              }));
            case 3:
            case "end":
              return _context.stop();
          }
        }, _callee, this);
      }));
      function parse() {
        return _parse.apply(this, arguments);
      }
      return parse;
    }()
    /**
     * @inheritDoc
     */
  }], [{
    key: "getName",
    value:
    /**
     * @inheritDoc
     */
    function getName() {
      return 'elements';
    }

    /**
     * @inheritDoc
     */
  }, {
    key: "getReaders",
    value: function getReaders() {
      return ['json'];
    }
  }, {
    key: "validate",
    value: function () {
      var _validate = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee3(reader) {
        var _this = this;
        return _regenerator.default.wrap(function _callee3$(_context3) {
          while (1) switch (_context3.prev = _context3.next) {
            case 0:
              if (elementorCommon.config.filesUpload.unfilteredFiles) {
                _context3.next = 2;
                break;
              }
              return _context3.abrupt("return", new Promise(function (resolve) {
                var enableUnfilteredDialog = _filesUploadHandler.default.getUnfilteredFilesNotEnabledImportTemplateDialog( /*#__PURE__*/(0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee2() {
                  var result;
                  return _regenerator.default.wrap(function _callee2$(_context2) {
                    while (1) switch (_context2.prev = _context2.next) {
                      case 0:
                        _context2.next = 2;
                        return _this.validateData(reader);
                      case 2:
                        result = _context2.sent;
                        resolve(result);
                      case 4:
                      case "end":
                        return _context2.stop();
                    }
                  }, _callee2);
                })));
                enableUnfilteredDialog.show();
              }));
            case 2:
              _context3.next = 4;
              return this.validateData(reader);
            case 4:
              return _context3.abrupt("return", _context3.sent);
            case 5:
            case "end":
              return _context3.stop();
          }
        }, _callee3, this);
      }));
      function validate(_x) {
        return _validate.apply(this, arguments);
      }
      return validate;
    }()
  }, {
    key: "validateData",
    value: function () {
      var _validateData = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee4(reader) {
        var data;
        return _regenerator.default.wrap(function _callee4$(_context4) {
          while (1) switch (_context4.prev = _context4.next) {
            case 0:
              _context4.next = 2;
              return reader.getData();
            case 2:
              data = _context4.sent;
              return _context4.abrupt("return", data.version && data.type && Array.isArray(data.content));
            case 4:
            case "end":
              return _context4.stop();
          }
        }, _callee4);
      }));
      function validateData(_x2) {
        return _validateData.apply(this, arguments);
      }
      return validateData;
    }()
  }]);
  return Elements;
}(_fileParserBase.default);
exports.Elements = Elements;

/***/ }),

/***/ "../assets/dev/js/editor/components/browser-import/files/parsers/json/index.js":
/*!*************************************************************************************!*\
  !*** ../assets/dev/js/editor/components/browser-import/files/parsers/json/index.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
Object.defineProperty(exports, "Elements", ({
  enumerable: true,
  get: function get() {
    return _elements.Elements;
  }
}));
var _elements = __webpack_require__(/*! ./elements */ "../assets/dev/js/editor/components/browser-import/files/parsers/json/elements.js");

/***/ }),

/***/ "../assets/dev/js/editor/components/browser-import/files/parsers/video/index.js":
/*!**************************************************************************************!*\
  !*** ../assets/dev/js/editor/components/browser-import/files/parsers/video/index.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
Object.defineProperty(exports, "Widget", ({
  enumerable: true,
  get: function get() {
    return _widget.Widget;
  }
}));
var _widget = __webpack_require__(/*! ./widget */ "../assets/dev/js/editor/components/browser-import/files/parsers/video/widget.js");

/***/ }),

/***/ "../assets/dev/js/editor/components/browser-import/files/parsers/video/widget.js":
/*!***************************************************************************************!*\
  !*** ../assets/dev/js/editor/components/browser-import/files/parsers/video/widget.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Widget = void 0;
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _containerFactory = _interopRequireDefault(__webpack_require__(/*! ../../../container-factory */ "../assets/dev/js/editor/components/browser-import/container-factory.js"));
var _base = __webpack_require__(/*! ../base */ "../assets/dev/js/editor/components/browser-import/files/parsers/base/index.js");
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var Widget = /*#__PURE__*/function (_MediaParser) {
  (0, _inherits2.default)(Widget, _MediaParser);
  var _super = _createSuper(Widget);
  function Widget() {
    (0, _classCallCheck2.default)(this, Widget);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(Widget, [{
    key: "parse",
    value:
    /**
     * @inheritDoc
     */
    function () {
      var _parse = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee() {
        var file, container;
        return _regenerator.default.wrap(function _callee$(_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              file = this.reader.getFile();
              _context.t0 = _containerFactory.default;
              _context.next = 4;
              return this.reader.getDataUrl();
            case 4:
              _context.t1 = _context.sent;
              _context.t2 = file.name.split('.')[0];
              _context.t3 = {
                url: _context.t1,
                alt: _context.t2,
                source: 'library'
              };
              _context.t4 = {
                video_type: 'hosted',
                hosted_url: _context.t3
              };
              _context.t5 = {
                widgetType: 'video',
                settings: _context.t4
              };
              container = _context.t0.createElementContainer.call(_context.t0, _context.t5);
              this.upload(file).then(function (_ref) {
                var data = _ref.data;
                $e.internal('document/elements/set-settings', {
                  // The reason we use the container id and not the container instance itself is that the container
                  // created above is just a placeholder, which later recreated using the same id.
                  container: elementor.getContainer(container.id),
                  settings: {
                    hosted_url: {
                      url: data.source_url,
                      id: data.id
                    }
                  }
                });
              }).catch(function () {
                elementor.documents.getCurrent().history.setActive(false);
                $e.run('document/elements/reset-settings', {
                  container: elementor.getContainer(container.id),
                  options: {
                    external: true
                  }
                });
                elementor.documents.getCurrent().history.setActive(true);
              });
              return _context.abrupt("return", container);
            case 12:
            case "end":
              return _context.stop();
          }
        }, _callee, this);
      }));
      function parse() {
        return _parse.apply(this, arguments);
      }
      return parse;
    }()
    /**
     * @inheritDoc
     */
  }], [{
    key: "getName",
    value:
    /**
     * @inheritDoc
     */
    function getName() {
      return 'widget';
    }

    /**
     * @inheritDoc
     */
  }, {
    key: "getReaders",
    value: function getReaders() {
      return ['video'];
    }
  }, {
    key: "validate",
    value: function () {
      var _validate = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee2() {
        return _regenerator.default.wrap(function _callee2$(_context2) {
          while (1) switch (_context2.prev = _context2.next) {
            case 0:
              return _context2.abrupt("return", true);
            case 1:
            case "end":
              return _context2.stop();
          }
        }, _callee2);
      }));
      function validate() {
        return _validate.apply(this, arguments);
      }
      return validate;
    }()
  }]);
  return Widget;
}(_base.MediaParser);
exports.Widget = Widget;

/***/ }),

/***/ "../assets/dev/js/editor/components/browser-import/files/readers/image.js":
/*!********************************************************************************!*\
  !*** ../assets/dev/js/editor/components/browser-import/files/readers/image.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Image = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _fileReaderBase = _interopRequireDefault(__webpack_require__(/*! ../file-reader-base */ "../assets/dev/js/editor/components/browser-import/files/file-reader-base.js"));
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var Image = /*#__PURE__*/function (_FileReaderBase) {
  (0, _inherits2.default)(Image, _FileReaderBase);
  var _super = _createSuper(Image);
  function Image() {
    (0, _classCallCheck2.default)(this, Image);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(Image, null, [{
    key: "getName",
    value:
    /**
     * @inheritDoc
     */
    function getName() {
      return 'image';
    }

    /**
     * @inheritDoc
     */
  }, {
    key: "mimeTypes",
    get: function get() {
      return ['image\\/\\w+'];
    }
  }]);
  return Image;
}(_fileReaderBase.default);
exports.Image = Image;

/***/ }),

/***/ "../assets/dev/js/editor/components/browser-import/files/readers/index.js":
/*!********************************************************************************!*\
  !*** ../assets/dev/js/editor/components/browser-import/files/readers/index.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
Object.defineProperty(exports, "Image", ({
  enumerable: true,
  get: function get() {
    return _image.Image;
  }
}));
Object.defineProperty(exports, "Json", ({
  enumerable: true,
  get: function get() {
    return _json.Json;
  }
}));
Object.defineProperty(exports, "Video", ({
  enumerable: true,
  get: function get() {
    return _video.Video;
  }
}));
var _image = __webpack_require__(/*! ./image */ "../assets/dev/js/editor/components/browser-import/files/readers/image.js");
var _video = __webpack_require__(/*! ./video */ "../assets/dev/js/editor/components/browser-import/files/readers/video.js");
var _json = __webpack_require__(/*! ./json */ "../assets/dev/js/editor/components/browser-import/files/readers/json.js");

/***/ }),

/***/ "../assets/dev/js/editor/components/browser-import/files/readers/json.js":
/*!*******************************************************************************!*\
  !*** ../assets/dev/js/editor/components/browser-import/files/readers/json.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Json = void 0;
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _fileReaderBase = _interopRequireDefault(__webpack_require__(/*! ../file-reader-base */ "../assets/dev/js/editor/components/browser-import/files/file-reader-base.js"));
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var Json = /*#__PURE__*/function (_FileReaderBase) {
  (0, _inherits2.default)(Json, _FileReaderBase);
  var _super = _createSuper(Json);
  function Json() {
    (0, _classCallCheck2.default)(this, Json);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(Json, [{
    key: "getData",
    value:
    /**
     * Returns the file content as Json object.
     *
     * @return {{}} file content
     */
    function () {
      var _getData = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee() {
        return _regenerator.default.wrap(function _callee$(_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              if (this._data) {
                _context.next = 4;
                break;
              }
              _context.next = 3;
              return this.getContent().then(function (content) {
                return JSON.parse(content);
              });
            case 3:
              this._data = _context.sent;
            case 4:
              return _context.abrupt("return", this._data);
            case 5:
            case "end":
              return _context.stop();
          }
        }, _callee, this);
      }));
      function getData() {
        return _getData.apply(this, arguments);
      }
      return getData;
    }()
  }], [{
    key: "getName",
    value:
    /**
     * @inheritDoc
     */
    function getName() {
      return 'json';
    }
  }, {
    key: "isActive",
    value: function isActive() {
      var _elementor$config$use, _elementor$config$use2;
      return elementor.config.user.is_administrator || ((_elementor$config$use = (_elementor$config$use2 = elementor.config.user.restrictions) === null || _elementor$config$use2 === void 0 ? void 0 : _elementor$config$use2.includes('json-upload')) !== null && _elementor$config$use !== void 0 ? _elementor$config$use : false);
    }

    /**
     * @inheritDoc
     */
  }, {
    key: "mimeTypes",
    get: function get() {
      return ['application/json'];
    }

    /**
     * @inheritDoc
     */
  }, {
    key: "resolve",
    value: function () {
      var _resolve = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee2(input) {
        return _regenerator.default.wrap(function _callee2$(_context2) {
          while (1) switch (_context2.prev = _context2.next) {
            case 0:
              _context2.prev = 0;
              JSON.parse(input);
              return _context2.abrupt("return", 'application/json');
            case 5:
              _context2.prev = 5;
              _context2.t0 = _context2["catch"](0);
              return _context2.abrupt("return", false);
            case 8:
            case "end":
              return _context2.stop();
          }
        }, _callee2, null, [[0, 5]]);
      }));
      function resolve(_x) {
        return _resolve.apply(this, arguments);
      }
      return resolve;
    }()
  }]);
  return Json;
}(_fileReaderBase.default);
exports.Json = Json;

/***/ }),

/***/ "../assets/dev/js/editor/components/browser-import/files/readers/video.js":
/*!********************************************************************************!*\
  !*** ../assets/dev/js/editor/components/browser-import/files/readers/video.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Video = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _fileReaderBase = _interopRequireDefault(__webpack_require__(/*! ../file-reader-base */ "../assets/dev/js/editor/components/browser-import/files/file-reader-base.js"));
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var Video = /*#__PURE__*/function (_FileReaderBase) {
  (0, _inherits2.default)(Video, _FileReaderBase);
  var _super = _createSuper(Video);
  function Video() {
    (0, _classCallCheck2.default)(this, Video);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(Video, null, [{
    key: "getName",
    value:
    /**
     * @inheritDoc
     */
    function getName() {
      return 'video';
    }

    /**
     * @inheritDoc
     */
  }, {
    key: "mimeTypes",
    get: function get() {
      return ['video\\/\\w+'];
    }
  }]);
  return Video;
}(_fileReaderBase.default);
exports.Video = Video;

/***/ }),

/***/ "../assets/dev/js/editor/components/browser-import/items/item-collection.js":
/*!**********************************************************************************!*\
  !*** ../assets/dev/js/editor/components/browser-import/items/item-collection.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _item = _interopRequireDefault(__webpack_require__(/*! ./item */ "../assets/dev/js/editor/components/browser-import/items/item.js"));
function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
var ItemCollection = /*#__PURE__*/function () {
  /**
   * ItemCollection constructor.
   *
   * @param {Array<*>} items
   */
  function ItemCollection() {
    var items = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
    (0, _classCallCheck2.default)(this, ItemCollection);
    /**
     * The Item objects list.
     */
    (0, _defineProperty2.default)(this, "items", void 0);
    this.setItems(items);
  }

  /**
   * Set the Item objects list.
   *
   * @param {Array<*>} items
   */
  (0, _createClass2.default)(ItemCollection, [{
    key: "setItems",
    value: function setItems() {
      var items = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
      var _iterator = _createForOfIteratorHelper(items),
        _step;
      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var item = _step.value;
          if (!(item instanceof _item.default)) {
            throw new Error('ItemCollection can only contain Item objects');
          }
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }
      this.items = items;
    }

    /**
     * Get the Item objects list.
     *
     * @return {[]} items
     */
  }, {
    key: "getItems",
    value: function getItems() {
      return this.items;
    }

    /**
     * Get files of all items.
     *
     * @return {[]} files
     */
  }, {
    key: "getFiles",
    value: function getFiles() {
      return this.items.map(function (item) {
        return item.getFile();
      });
    }
  }]);
  return ItemCollection;
}();
exports["default"] = ItemCollection;

/***/ }),

/***/ "../assets/dev/js/editor/components/browser-import/items/item.js":
/*!***********************************************************************!*\
  !*** ../assets/dev/js/editor/components/browser-import/items/item.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _isInstanceof = _interopRequireDefault(__webpack_require__(/*! ../../../utils/is-instanceof */ "../assets/dev/js/editor/utils/is-instanceof.js"));
var _mime = _interopRequireDefault(__webpack_require__(/*! mime */ "../node_modules/mime/index.js"));
/**
 * @typedef {import('../files/file-parser-base')} FileParserBase
 * @typedef {import('../files/file-reader-base')} FileReaderBase
 */
var Item = /*#__PURE__*/function () {
  /**
   * The Item constructor.
   *
   * @param {*} input
   * @param {*} options
   */
  function Item(input) {
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    (0, _classCallCheck2.default)(this, Item);
    /**
     * The item File object.
     *
     * @type {File}
     */
    (0, _defineProperty2.default)(this, "file", void 0);
    /**
     * The Item options list.
     *
     * @type {{}}
     */
    (0, _defineProperty2.default)(this, "options", {});
    this.file = this.toFile(input);
    this.options = options;
  }

  /**
   * Convert the input into a File object.
   *
   * @param {*} input
   * @return {File} file
   */
  (0, _createClass2.default)(Item, [{
    key: "toFile",
    value: function toFile(input) {
      if (!(0, _isInstanceof.default)(input, File)) {
        var _this$options = this.options,
          fileName = _this$options.fileName,
          type = _this$options.type,
          options = {
            type: type || input.type
          };

        // When the input is not a Blob object, use the mime-type from the options to generate the file.
        input = new File(Array.isArray(input) ? input : [input], fileName || this.constructor.createFileName(options), options);
      }
      return input;
    }

    /**
     * Create a random file name from a Blob/File object while using the suitable extension for the blob mime-type.
     *
     * @param {*} blob
     * @return {string} file name
     */
  }, {
    key: "getFile",
    value:
    /**
     * Get the item File object.
     *
     * @return {File} file
     */
    function getFile() {
      return this.file;
    }

    /**
     * Get the file-reader of the Item.
     *
     * @return {FileReaderBase} reader
     */
  }, {
    key: "getReader",
    value: function getReader() {
      return this.options.reader;
    }

    /**
     * Get the file-parser of the Item.
     *
     * @return {FileParserBase} parser
     */
  }, {
    key: "getParser",
    value: function getParser() {
      return this.options.parser;
    }

    /**
     * Set the file-reader of the Item.
     *
     * @param {FileReaderBase} reader
     */
  }, {
    key: "setReader",
    value: function setReader(reader) {
      this.options.reader = reader;
    }

    /**
     * Set the file-parser of the Item.
     *
     * @param {FileParserBase} parser
     */
  }, {
    key: "setParser",
    value: function setParser(parser) {
      this.options.parser = parser;
    }
  }], [{
    key: "createFileName",
    value: function createFileName(blob) {
      return [elementorCommon.helpers.getUniqueId(), _mime.default.getExtension(blob.type)].join('.');
    }
  }]);
  return Item;
}();
exports["default"] = Item;

/***/ }),

/***/ "../assets/dev/js/editor/components/browser-import/manager.js":
/*!********************************************************************!*\
  !*** ../assets/dev/js/editor/components/browser-import/manager.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _assertThisInitialized2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/assertThisInitialized */ "../node_modules/@babel/runtime/helpers/assertThisInitialized.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _component = _interopRequireDefault(__webpack_require__(/*! ./component */ "../assets/dev/js/editor/components/browser-import/component.js"));
var _defaultConfig = _interopRequireDefault(__webpack_require__(/*! ./default-config */ "../assets/dev/js/editor/components/browser-import/default-config.js"));
var _itemCollection = _interopRequireDefault(__webpack_require__(/*! elementor-editor/components/browser-import/items/item-collection */ "../assets/dev/js/editor/components/browser-import/items/item-collection.js"));
var _normalizer = _interopRequireDefault(__webpack_require__(/*! ./normalizer */ "../assets/dev/js/editor/components/browser-import/normalizer.js"));
var _session = _interopRequireDefault(__webpack_require__(/*! elementor-editor/components/browser-import/session */ "../assets/dev/js/editor/components/browser-import/session.js"));
function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
/**
 * @typedef {import('../../container/container')} Container
 */
/**
 * @typedef {import('./files/file-reader-base')} FileReaderBase
 */
/**
 * @typedef {import('./files/file-parser-base')} FileParserBase
 */
var Manager = /*#__PURE__*/function (_elementorModules$edi) {
  (0, _inherits2.default)(Manager, _elementorModules$edi);
  var _super = _createSuper(Manager);
  /**
   * Manager constructor.
   */
  function Manager() {
    var _this;
    (0, _classCallCheck2.default)(this, Manager);
    _this = _super.call(this);
    /**
     * File-readers list.
     *
     * @type {{}}
     */
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "readers", {});
    /**
     * File-parsers list according to their readers.
     *
     * @type {{}}
     */
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "parsers", {});
    _this.normalizer = new _normalizer.default((0, _assertThisInitialized2.default)(_this));
    $e.components.register(new _component.default({
      manager: (0, _assertThisInitialized2.default)(_this)
    }));
    _this.parseConfig(_defaultConfig.default);
    return _this;
  }

  /**
   * Parse the config for the Manager.
   *
   * @param {*} config
   */
  (0, _createClass2.default)(Manager, [{
    key: "parseConfig",
    value: function parseConfig() {
      var config = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var _iterator = _createForOfIteratorHelper(config.readers || {}),
        _step;
      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var _reader$isActive, _reader$isActive2;
          var reader = _step.value;
          var isActive = (_reader$isActive = (_reader$isActive2 = reader.isActive) === null || _reader$isActive2 === void 0 ? void 0 : _reader$isActive2.call(reader)) !== null && _reader$isActive !== void 0 ? _reader$isActive : true;
          if (isActive) {
            this.registerFileReader(reader);
          }
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }
      var _iterator2 = _createForOfIteratorHelper(config.parsers || {}),
        _step2;
      try {
        for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
          var parser = _step2.value;
          this.registerFileParser(parser);
        }
      } catch (err) {
        _iterator2.e(err);
      } finally {
        _iterator2.f();
      }
    }

    /**
     * Create a new Session instance and normalize input if needed.
     *
     * @param {*}              input
     * @param {Container|null} target
     * @param {{}}             options
     * @return {Session} session
     */
  }, {
    key: "createSession",
    value: function () {
      var _createSession = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee(input, target) {
        var options,
          _args = arguments;
        return _regenerator.default.wrap(function _callee$(_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              options = _args.length > 2 && _args[2] !== undefined ? _args[2] : {};
              if (input instanceof _itemCollection.default) {
                _context.next = 5;
                break;
              }
              _context.next = 4;
              return this.getNormalizer().normalize(input);
            case 4:
              input = _context.sent;
            case 5:
              return _context.abrupt("return", new _session.default(this, input, target, options));
            case 6:
            case "end":
              return _context.stop();
          }
        }, _callee, this);
      }));
      function createSession(_x, _x2) {
        return _createSession.apply(this, arguments);
      }
      return createSession;
    }()
    /**
     * Register a new file-reader.
     *
     * @param {{}} reader
     */
  }, {
    key: "registerFileReader",
    value: function registerFileReader(reader) {
      this.readers[reader.getName()] = reader;
    }

    /**
     * Register a new file-parser.
     *
     * @param {*} parser
     */
  }, {
    key: "registerFileParser",
    value: function registerFileParser(parser) {
      var _iterator3 = _createForOfIteratorHelper(parser.getReaders()),
        _step3;
      try {
        for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
          var readerName = _step3.value;
          if (!this.readers[readerName]) {
            continue;
          } else if (!this.parsers[readerName]) {
            this.parsers[readerName] = {};
          }
          this.parsers[readerName][parser.getName()] = parser;
        }
      } catch (err) {
        _iterator3.e(err);
      } finally {
        _iterator3.f();
      }
    }

    /**
     * Get the file-handler that can handle the File of the given Item.
     *
     * @param {*}       item
     * @param {boolean} instantiate
     * @return {FileReaderBase|boolean} file handler
     */
  }, {
    key: "getReaderOf",
    value: function () {
      var _getReaderOf = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee2(item) {
        var instantiate,
          file,
          readerName,
          readers,
          _i,
          _Object$values,
          reader,
          _args2 = arguments;
        return _regenerator.default.wrap(function _callee2$(_context2) {
          while (1) switch (_context2.prev = _context2.next) {
            case 0:
              instantiate = _args2.length > 1 && _args2[1] !== undefined ? _args2[1] : false;
              file = item.getFile(), readerName = item.getReader(), readers = this.getReaders(readerName);
              _i = 0, _Object$values = Object.values(readers);
            case 3:
              if (!(_i < _Object$values.length)) {
                _context2.next = 13;
                break;
              }
              reader = _Object$values[_i];
              _context2.next = 7;
              return reader.validate(file);
            case 7:
              if (!_context2.sent) {
                _context2.next = 10;
                break;
              }
              if (!readerName) {
                item.setReader(reader.getName());
              }
              return _context2.abrupt("return", instantiate ? new reader(file) : reader);
            case 10:
              _i++;
              _context2.next = 3;
              break;
            case 13:
              return _context2.abrupt("return", false);
            case 14:
            case "end":
              return _context2.stop();
          }
        }, _callee2, this);
      }));
      function getReaderOf(_x3) {
        return _getReaderOf.apply(this, arguments);
      }
      return getReaderOf;
    }()
    /**
     * Get the file-parser that can handle the File of the given Item.
     *
     * @param {*}       item
     * @param {boolean} instantiate
     * @return {Promise<FileParserBase|boolean>} file parser
     */
  }, {
    key: "getParserOf",
    value: function () {
      var _getParserOf = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee3(item) {
        var instantiate,
          reader,
          parserName,
          parsers,
          _i2,
          _Object$values2,
          parser,
          _args3 = arguments;
        return _regenerator.default.wrap(function _callee3$(_context3) {
          while (1) switch (_context3.prev = _context3.next) {
            case 0:
              instantiate = _args3.length > 1 && _args3[1] !== undefined ? _args3[1] : false;
              _context3.next = 3;
              return this.getReaderOf(item, true);
            case 3:
              reader = _context3.sent;
              parserName = item.getParser();
              if (!reader) {
                _context3.next = 18;
                break;
              }
              parsers = this.getParsers(reader.constructor.getName(), parserName);
              _i2 = 0, _Object$values2 = Object.values(parsers);
            case 8:
              if (!(_i2 < _Object$values2.length)) {
                _context3.next = 18;
                break;
              }
              parser = _Object$values2[_i2];
              _context3.next = 12;
              return parser.validate(reader);
            case 12:
              if (!_context3.sent) {
                _context3.next = 15;
                break;
              }
              if (!parserName) {
                item.setParser(parser.getName());
              }
              return _context3.abrupt("return", instantiate ? new parser(reader) : parser);
            case 15:
              _i2++;
              _context3.next = 8;
              break;
            case 18:
              return _context3.abrupt("return", false);
            case 19:
            case "end":
              return _context3.stop();
          }
        }, _callee3, this);
      }));
      function getParserOf(_x4) {
        return _getParserOf.apply(this, arguments);
      }
      return getParserOf;
    }()
    /**
     * Resolve the mime-type for an input using the registered parsers.
     *
     * @param {*} input
     * @return {Promise<string|boolean>} mime type, or false if not found
     */
  }, {
    key: "getMimeTypeOf",
    value: function () {
      var _getMimeTypeOf = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee4(input) {
        var _i3, _Object$values3, reader, mimeType;
        return _regenerator.default.wrap(function _callee4$(_context4) {
          while (1) switch (_context4.prev = _context4.next) {
            case 0:
              _i3 = 0, _Object$values3 = Object.values(this.getReaders());
            case 1:
              if (!(_i3 < _Object$values3.length)) {
                _context4.next = 11;
                break;
              }
              reader = _Object$values3[_i3];
              _context4.next = 5;
              return reader.resolve(input);
            case 5:
              mimeType = _context4.sent;
              if (!mimeType) {
                _context4.next = 8;
                break;
              }
              return _context4.abrupt("return", mimeType);
            case 8:
              _i3++;
              _context4.next = 1;
              break;
            case 11:
              return _context4.abrupt("return", false);
            case 12:
            case "end":
              return _context4.stop();
          }
        }, _callee4, this);
      }));
      function getMimeTypeOf(_x5) {
        return _getMimeTypeOf.apply(this, arguments);
      }
      return getMimeTypeOf;
    }()
    /**
     * Get the Normalizer instance.
     *
     * @return {Normalizer} normalizer
     */
  }, {
    key: "getNormalizer",
    value: function getNormalizer() {
      return this.normalizer;
    }

    /**
     * Get all registered file-readers.
     *
     * @param {*|Array<*>} readers
     * @return {{}} registered file readers
     */
  }, {
    key: "getReaders",
    value: function getReaders() {
      var _this2 = this;
      var readers = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
      readers = Array.isArray(readers) ? readers : [readers];
      if (!readers.length) {
        return this.readers;
      }
      return Object.fromEntries(readers.filter(function (reader) {
        return reader in _this2.readers;
      }).map(function (reader) {
        return [reader, _this2.readers[reader]];
      }));
    }

    /**
     * Get all registered file-parsers, unless a reader name is specified, in which case its parsers are returned.
     *
     * @param {*} reader
     * @param {*} parsers
     * @return {{}} parsers
     */
  }, {
    key: "getParsers",
    value: function getParsers(reader) {
      var _this3 = this;
      var parsers = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];
      parsers = Array.isArray(parsers) ? parsers : [parsers];
      if (!parsers.length) {
        return this.parsers[reader] || {};
      }
      return Object.fromEntries(parsers.filter(function (parser) {
        return parser in _this3.parsers[reader];
      }).map(function (parser) {
        return [parser, _this3.parsers[reader][parser]];
      }));
    }
  }]);
  return Manager;
}(elementorModules.editor.utils.Module);
exports["default"] = Manager;

/***/ }),

/***/ "../assets/dev/js/editor/components/browser-import/normalizer.js":
/*!***********************************************************************!*\
  !*** ../assets/dev/js/editor/components/browser-import/normalizer.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _isInstanceof = _interopRequireDefault(__webpack_require__(/*! ../../utils/is-instanceof */ "../assets/dev/js/editor/utils/is-instanceof.js"));
var _item = _interopRequireDefault(__webpack_require__(/*! ./items/item */ "../assets/dev/js/editor/components/browser-import/items/item.js"));
var _itemCollection = _interopRequireDefault(__webpack_require__(/*! ./items/item-collection */ "../assets/dev/js/editor/components/browser-import/items/item-collection.js"));
/**
 * @typedef {import('../modules/component-base')} ComponentBase
 */
/**
 * @typedef {import('./manager')} Manager
 */
var Normalizer = /*#__PURE__*/function () {
  /**
   * Normalizer constructor.
   *
   * @param {Manager} manager
   */
  function Normalizer(manager) {
    (0, _classCallCheck2.default)(this, Normalizer);
    this.manager = manager;
  }

  /**
   * Normalize input to an ItemCollection, where each item is an Item object. This method can be used to normalize a
   * vast spectrum of input types - from data url strings to blob objects, and array of them. Other kind of parsers
   * can be registered to the Manager.
   *
   * @param {*} input
   * @return {Promise<ItemCollection>} result
   */
  (0, _createClass2.default)(Normalizer, [{
    key: "normalize",
    value: function () {
      var _normalize = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee(input) {
        return _regenerator.default.wrap(function _callee$(_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              if (!(input instanceof _itemCollection.default)) {
                input = this.toItemCollection(input);
              }
              return _context.abrupt("return", input);
            case 2:
            case "end":
              return _context.stop();
          }
        }, _callee, this);
      }));
      function normalize(_x) {
        return _normalize.apply(this, arguments);
      }
      return normalize;
    }()
    /**
     * Convert an single or multiple input subjects into a ItemCollection object. To learn more about the way each
     * subject is treated, please refer the 'toItem' method.
     *
     * @param {*} subjects
     * @return {Promise<ItemCollection>} result
     */
  }, {
    key: "toItemCollection",
    value: function () {
      var _toItemCollection = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee2(subjects) {
        var _this = this;
        return _regenerator.default.wrap(function _callee2$(_context2) {
          while (1) switch (_context2.prev = _context2.next) {
            case 0:
              if (!Array.isArray(subjects)) {
                subjects = (0, _isInstanceof.default)(subjects, FileList) || (0, _isInstanceof.default)(subjects, DataTransferItemList) ? Array.from(subjects) : [subjects];
              }
              return _context2.abrupt("return", Promise.all(subjects.map(function (subject) {
                // Creating a ItemCollection can only be made with an array of Item objects. Therefore, unless the
                // subject is an Item object, we should transform it into one.
                if (!(subject instanceof _item.default)) {
                  subject = _this.toItem(subject);
                }
                return subject;
              })).then(function (items) {
                return new _itemCollection.default(items);
              }));
            case 2:
            case "end":
              return _context2.stop();
          }
        }, _callee2);
      }));
      function toItemCollection(_x2) {
        return _toItemCollection.apply(this, arguments);
      }
      return toItemCollection;
    }()
    /**
     * Convert a single subject into an Item object.
     *
     * @param {*} subject
     * @return {Promise<Item>} result
     */
  }, {
    key: "toItem",
    value: function () {
      var _toItem = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee3(subject) {
        var mimeType;
        return _regenerator.default.wrap(function _callee3$(_context3) {
          while (1) switch (_context3.prev = _context3.next) {
            case 0:
              if ((0, _isInstanceof.default)(subject, [Blob, File, DataTransferItem])) {
                _context3.next = 18;
                break;
              }
              _context3.prev = 1;
              // In order to check whether it's a data url string, we're trying to decode it. If it is a data url,
              // we can extract the blob later using `fetch`.
              window.atob(subject.split(',')[1]);
              _context3.next = 15;
              break;
            case 5:
              _context3.prev = 5;
              _context3.t0 = _context3["catch"](1);
              _context3.next = 9;
              return this.manager.getMimeTypeOf(subject);
            case 9:
              mimeType = _context3.sent;
              if (!mimeType) {
                _context3.next = 14;
                break;
              }
              subject = this.constructor.createDataUrl(subject, mimeType);
              _context3.next = 15;
              break;
            case 14:
              throw new Error('The input provided cannot be resolved');
            case 15:
              _context3.next = 17;
              return fetch(subject).then(function (res) {
                return res.blob();
              });
            case 17:
              subject = _context3.sent;
            case 18:
              return _context3.abrupt("return", new _item.default(subject));
            case 19:
            case "end":
              return _context3.stop();
          }
        }, _callee3, this, [[1, 5]]);
      }));
      function toItem(_x3) {
        return _toItem.apply(this, arguments);
      }
      return toItem;
    }()
    /**
     * A utility for creating a data url string functionally.
     *
     * @param {string}           data
     * @param {string|undefined} mimeType
     * @param {boolean}          base64
     * @return {string} data URI
     */
  }], [{
    key: "createDataUrl",
    value: function createDataUrl(data) {
      var mimeType = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
      var base64 = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;
      if (base64) {
        data = "base64,".concat(btoa(data));
      }
      if (mimeType) {
        mimeType += ';';
      }
      return "data:".concat(mimeType || '').concat(data);
    }
  }]);
  return Normalizer;
}();
exports["default"] = Normalizer;

/***/ }),

/***/ "../assets/dev/js/editor/components/browser-import/session.js":
/*!********************************************************************!*\
  !*** ../assets/dev/js/editor/components/browser-import/session.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
/**
 * @typedef {import('../../container/container')} Container
 */
/**
 * @typedef {import('./manager')} Manager
 */
/**
 * @typedef {import('./items/item-collection')} ItemCollection
 */
var Session = /*#__PURE__*/function () {
  /**
   * Session constructor.
   *
   * @param {Manager}             manager
   * @param {ItemCollection|null} itemCollection
   * @param {Container|null}      target
   * @param {{}}                  options
   */
  function Session(manager) {
    var itemCollection = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
    var target = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
    var options = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};
    (0, _classCallCheck2.default)(this, Session);
    /**
     * The Manager instance.
     *
     * @type {Manager}
     */
    (0, _defineProperty2.default)(this, "manager", void 0);
    /**
     * The ItemCollection instance.
     *
     * @type {ItemCollection}
     */
    (0, _defineProperty2.default)(this, "itemCollection", void 0);
    /**
     * The Target instance.
     *
     * @type {Container}
     */
    (0, _defineProperty2.default)(this, "target", void 0);
    /**
     * The Session options.
     *
     * @type {{}}
     */
    (0, _defineProperty2.default)(this, "options", {
      target: {}
    });
    this.manager = manager;
    this.itemCollection = itemCollection;
    this.target = target;
    Object.assign(this.options, options);
  }

  /**
   * Validate all files in this session can be handled.
   *
   * @return {boolean} true if all items are valid
   */
  (0, _createClass2.default)(Session, [{
    key: "validate",
    value: function () {
      var _validate = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee() {
        var _iterator, _step, item;
        return _regenerator.default.wrap(function _callee$(_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              _iterator = _createForOfIteratorHelper(this.itemCollection.getItems());
              _context.prev = 1;
              _iterator.s();
            case 3:
              if ((_step = _iterator.n()).done) {
                _context.next = 11;
                break;
              }
              item = _step.value;
              _context.next = 7;
              return this.manager.getReaderOf(item);
            case 7:
              if (_context.sent) {
                _context.next = 9;
                break;
              }
              return _context.abrupt("return", false);
            case 9:
              _context.next = 3;
              break;
            case 11:
              _context.next = 16;
              break;
            case 13:
              _context.prev = 13;
              _context.t0 = _context["catch"](1);
              _iterator.e(_context.t0);
            case 16:
              _context.prev = 16;
              _iterator.f();
              return _context.finish(16);
            case 19:
              return _context.abrupt("return", true);
            case 20:
            case "end":
              return _context.stop();
          }
        }, _callee, this, [[1, 13, 16, 19]]);
      }));
      function validate() {
        return _validate.apply(this, arguments);
      }
      return validate;
    }()
    /**
     * Handle files with a suitable file-parser.
     *
     * @return {Container[]} result
     */
  }, {
    key: "apply",
    value: function () {
      var _apply = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee2() {
        var _this = this;
        var parsed, _iterator2, _step2, item, parser;
        return _regenerator.default.wrap(function _callee2$(_context2) {
          while (1) switch (_context2.prev = _context2.next) {
            case 0:
              parsed = [];
              _iterator2 = _createForOfIteratorHelper(this.itemCollection.getItems());
              _context2.prev = 2;
              _iterator2.s();
            case 4:
              if ((_step2 = _iterator2.n()).done) {
                _context2.next = 16;
                break;
              }
              item = _step2.value;
              _context2.next = 8;
              return this.manager.getParserOf(item, true);
            case 8:
              parser = _context2.sent;
              if (!parser) {
                _context2.next = 13;
                break;
              }
              parsed.push(parser.parse());
              _context2.next = 14;
              break;
            case 13:
              throw new Error('An error occurred when trying to parse the input');
            case 14:
              _context2.next = 4;
              break;
            case 16:
              _context2.next = 21;
              break;
            case 18:
              _context2.prev = 18;
              _context2.t0 = _context2["catch"](2);
              _iterator2.e(_context2.t0);
            case 21:
              _context2.prev = 21;
              _iterator2.f();
              return _context2.finish(21);
            case 24:
              return _context2.abrupt("return", Promise.all(parsed).then(function (result) {
                return _this.resolve(result.flat());
              }));
            case 25:
            case "end":
              return _context2.stop();
          }
        }, _callee2, this, [[2, 18, 21, 24]]);
      }));
      function apply() {
        return _apply.apply(this, arguments);
      }
      return apply;
    }()
    /**
     * Resolve containers to fulfill their purpose.
     *
     * @param {*} containers
     * @return {*} result
     */
  }, {
    key: "resolve",
    value: function resolve(containers) {
      var _this2 = this;
      if (Object.values(containers).some(function (element) {
        return 'section' === element.model.get('elType');
      })) {
        this.target = elementor.getPreviewContainer();
      }

      // eslint-disable-next-line array-callback-return
      return containers.map(function (element) {
        switch (element.type) {
          case 'container':
          case 'section':
          case 'column':
          case 'widget':
            return _this2.target.view.createElementFromModel(element.model, Object.assign(_this2.options.target, {
              event: _this2.options.event,
              scrollIntoView: 0 === containers.indexOf(element)
            }));
        }
      });
    }
  }]);
  return Session;
}();
exports["default"] = Session;

/***/ }),

/***/ "../assets/dev/js/editor/components/documents/commands/close.js":
/*!**********************************************************************!*\
  !*** ../assets/dev/js/editor/components/documents/commands/close.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var __ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["__"];


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.Close = void 0;
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var Close = /*#__PURE__*/function (_$e$modules$CommandBa) {
  (0, _inherits2.default)(Close, _$e$modules$CommandBa);
  var _super = _createSuper(Close);
  function Close() {
    (0, _classCallCheck2.default)(this, Close);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(Close, [{
    key: "validateArgs",
    value: function validateArgs(args) {
      this.requireArgument('id', args);
    }
  }, {
    key: "apply",
    value: function () {
      var _apply = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee(args) {
        var id, mode, onClose, document, deferred;
        return _regenerator.default.wrap(function _callee$(_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              id = args.id, mode = args.mode, onClose = args.onClose, document = elementor.documents.get(id); // Already closed.
              if (!('closed' === document.editor.status)) {
                _context.next = 3;
                break;
              }
              return _context.abrupt("return", jQuery.Deferred().resolve());
            case 3:
              if (!(!mode && (document.editor.isChanged || document.isDraft()))) {
                _context.next = 7;
                break;
              }
              deferred = jQuery.Deferred();
              this.getConfirmDialog(deferred).show();
              return _context.abrupt("return", deferred.promise());
            case 7:
              _context.t0 = mode;
              _context.next = _context.t0 === 'autosave' ? 10 : _context.t0 === 'save' ? 13 : _context.t0 === 'discard' ? 16 : 19;
              break;
            case 10:
              _context.next = 12;
              return $e.run('document/save/auto');
            case 12:
              return _context.abrupt("break", 19);
            case 13:
              _context.next = 15;
              return $e.run('document/save/update');
            case 15:
              return _context.abrupt("break", 19);
            case 16:
              _context.next = 18;
              return $e.run('document/save/discard', {
                document: document
              });
            case 18:
              return _context.abrupt("break", 19);
            case 19:
              _context.next = 21;
              return $e.internal('editor/documents/unload', {
                document: document
              });
            case 21:
              if (!onClose) {
                _context.next = 24;
                break;
              }
              _context.next = 24;
              return onClose(document);
            case 24:
              return _context.abrupt("return", jQuery.Deferred().resolve());
            case 25:
            case "end":
              return _context.stop();
          }
        }, _callee, this);
      }));
      function apply(_x) {
        return _apply.apply(this, arguments);
      }
      return apply;
    }()
  }, {
    key: "getConfirmDialog",
    value: function getConfirmDialog(deferred) {
      var _this = this;
      if (this.confirmDialog) {
        return this.confirmDialog;
      }
      this.confirmDialog = elementorCommon.dialogsManager.createWidget('confirm', {
        id: 'elementor-document-save-on-close',
        headerMessage: __('Save Changes', 'elementor'),
        message: __('Would you like to save the changes you\'ve made?', 'elementor'),
        position: {
          my: 'center center',
          at: 'center center'
        },
        strings: {
          confirm: __('Save', 'elementor'),
          cancel: __('Discard', 'elementor')
        },
        onHide: function onHide() {
          // If still not action chosen. use `defer` because onHide is called before onConfirm/onCancel.
          _.defer(function () {
            if (!_this.args.mode) {
              deferred.reject('Close document has been canceled.');
            }
          });
        },
        onConfirm: function onConfirm() {
          _this.args.mode = 'save';

          // Re-run with same args.
          $e.run('editor/documents/close', _this.args).then(function () {
            deferred.resolve();
          });
        },
        onCancel: function onCancel() {
          _this.args.mode = 'discard';

          // Re-run with same args.
          $e.run('editor/documents/close', _this.args).then(function () {
            deferred.resolve();
          });
        }
      });
      return this.confirmDialog;
    }
  }]);
  return Close;
}($e.modules.CommandBase);
exports.Close = Close;
var _default = Close;
exports["default"] = _default;

/***/ }),

/***/ "../assets/dev/js/editor/components/documents/commands/index.js":
/*!**********************************************************************!*\
  !*** ../assets/dev/js/editor/components/documents/commands/index.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
Object.defineProperty(exports, "Close", ({
  enumerable: true,
  get: function get() {
    return _close.Close;
  }
}));
Object.defineProperty(exports, "Open", ({
  enumerable: true,
  get: function get() {
    return _open.Open;
  }
}));
Object.defineProperty(exports, "Preview", ({
  enumerable: true,
  get: function get() {
    return _preview.Preview;
  }
}));
Object.defineProperty(exports, "Switch", ({
  enumerable: true,
  get: function get() {
    return _switch.Switch;
  }
}));
var _close = __webpack_require__(/*! ./close */ "../assets/dev/js/editor/components/documents/commands/close.js");
var _open = __webpack_require__(/*! ./open */ "../assets/dev/js/editor/components/documents/commands/open.js");
var _preview = __webpack_require__(/*! ./preview */ "../assets/dev/js/editor/components/documents/commands/preview.js");
var _switch = __webpack_require__(/*! ./switch */ "../assets/dev/js/editor/components/documents/commands/switch.js");

/***/ }),

/***/ "../assets/dev/js/editor/components/documents/commands/internal/attach-preview.js":
/*!****************************************************************************************!*\
  !*** ../assets/dev/js/editor/components/documents/commands/internal/attach-preview.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.AttachPreview = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var AttachPreview = /*#__PURE__*/function (_$e$modules$CommandIn) {
  (0, _inherits2.default)(AttachPreview, _$e$modules$CommandIn);
  var _super = _createSuper(AttachPreview);
  function AttachPreview() {
    (0, _classCallCheck2.default)(this, AttachPreview);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(AttachPreview, [{
    key: "validateArgs",
    value: function validateArgs() {
      var args = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      if (args.selector) {
        this.requireArgumentType('selector', 'string');
        if (0 === elementor.$previewContents.find(args.selector).length) {
          throw new Error('Invalid argument. The `selector` argument must be existed selector.');
        }
      }
    }
  }, {
    key: "apply",
    value: function apply(args) {
      var _this = this;
      var document = elementor.documents.getCurrent();
      return $e.data.get('globals/index').then(function () {
        elementor.trigger('globals:loaded');
        return _this.attachDocumentToPreview(document, args);
      }).then(function () {
        elementor.toggleDocumentCssFiles(document, false);
        elementor.onEditModeSwitched();
        elementor.checkPageStatus();
        elementor.trigger('document:loaded', document);
        return $e.internal('panel/open-default', {
          refresh: true
        });
      });
    }
  }, {
    key: "attachDocumentToPreview",
    value: function attachDocumentToPreview(document, args) {
      var _args$selector = args.selector,
        selector = _args$selector === void 0 ? '.elementor-' + document.id : _args$selector,
        _args$shouldScroll = args.shouldScroll,
        shouldScroll = _args$shouldScroll === void 0 ? true : _args$shouldScroll;
      return new Promise(function (resolve, reject) {
        // Not yet loaded.
        if (!document) {
          return reject("Can't attach preview, there is no open document.");
        }
        if (!document.config.elements) {
          return resolve();
        }
        document.$element = elementor.$previewContents.find(selector);
        var isInitialDocument = document.id === elementor.config.initial_document.id;
        if (!document.$element.length) {
          if (isInitialDocument) {
            elementor.onPreviewElNotFound();
          }
          return reject("Can't attach preview to document '".concat(document.id, "', element '").concat(selector, "' was not found."));
        }
        document.$element.addClass('elementor-edit-area elementor-edit-mode');
        if (!isInitialDocument) {
          elementor.$previewElementorEl.addClass('elementor-embedded-editor');
        }
        elementor.initElements();
        elementor.initPreviewView(document);
        document.container.view = elementor.getPreviewView();
        document.container.model.attributes.elements = elementor.elements;
        if (shouldScroll) {
          elementor.helpers.scrollToView(document.$element);
        }
        document.$element.addClass('elementor-edit-area-active').removeClass('elementor-editor-preview');
        resolve();
      });
    }
  }]);
  return AttachPreview;
}($e.modules.CommandInternalBase);
exports.AttachPreview = AttachPreview;
var _default = AttachPreview;
exports["default"] = _default;

/***/ }),

/***/ "../assets/dev/js/editor/components/documents/commands/internal/index.js":
/*!*******************************************************************************!*\
  !*** ../assets/dev/js/editor/components/documents/commands/internal/index.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
Object.defineProperty(exports, "AttachPreview", ({
  enumerable: true,
  get: function get() {
    return _attachPreview.AttachPreview;
  }
}));
Object.defineProperty(exports, "Load", ({
  enumerable: true,
  get: function get() {
    return _load.Load;
  }
}));
Object.defineProperty(exports, "Unload", ({
  enumerable: true,
  get: function get() {
    return _unload.Unload;
  }
}));
var _attachPreview = __webpack_require__(/*! ./attach-preview */ "../assets/dev/js/editor/components/documents/commands/internal/attach-preview.js");
var _load = __webpack_require__(/*! ./load */ "../assets/dev/js/editor/components/documents/commands/internal/load.js");
var _unload = __webpack_require__(/*! ./unload */ "../assets/dev/js/editor/components/documents/commands/internal/unload.js");

/***/ }),

/***/ "../assets/dev/js/editor/components/documents/commands/internal/load.js":
/*!******************************************************************************!*\
  !*** ../assets/dev/js/editor/components/documents/commands/internal/load.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.Load = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _document = _interopRequireDefault(__webpack_require__(/*! ../../document */ "../assets/dev/js/editor/components/documents/document.js"));
var _heartbeat = _interopRequireDefault(__webpack_require__(/*! elementor-editor-utils/heartbeat */ "../assets/dev/js/editor/utils/heartbeat.js"));
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var Load = /*#__PURE__*/function (_$e$modules$CommandIn) {
  (0, _inherits2.default)(Load, _$e$modules$CommandIn);
  var _super = _createSuper(Load);
  function Load() {
    (0, _classCallCheck2.default)(this, Load);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(Load, [{
    key: "validateArgs",
    value: function validateArgs() {
      var args = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      this.requireArgument('config', args);
    }
  }, {
    key: "apply",
    value: function apply(args) {
      var config = args.config,
        _args$setAsInitial = args.setAsInitial,
        setAsInitial = _args$setAsInitial === void 0 ? false : _args$setAsInitial,
        _args$shouldScroll = args.shouldScroll,
        shouldScroll = _args$shouldScroll === void 0 ? true : _args$shouldScroll;
      if (elementorCommon.config.experimentalFeatures.additional_custom_breakpoints) {
        // When the Responsive Optimization experiment is active, the responsive controls are generated on the
        // JS side instead of the PHP.
        config.settings.controls = elementor.generateResponsiveControls(config.settings.controls);
      }
      elementor.config.document = config;
      elementor.setAjax();
      elementor.addWidgetsCache(config.widgets);
      elementor.templates.init();
      var document = new _document.default(config);
      elementor.documents.add(document);

      // Must set current before create a container.
      elementor.documents.setCurrent(document);
      if (setAsInitial) {
        elementor.documents.setInitialById(document.id);
      }
      elementor.settings.page = new elementor.settings.modules.page(config.settings);
      document.container = elementor.settings.page.getEditedView().getContainer();

      // Reference container back to document.
      document.container.document = document;
      elementor.heartbeat = new _heartbeat.default(document);
      var isOldPageVersion = elementor.config.document.version && elementor.helpers.compareVersions(elementor.config.document.version, '2.5.0', '<');
      if (!elementor.config.user.introduction.flexbox && isOldPageVersion) {
        elementor.showFlexBoxAttentionDialog();
      }
      if (elementor.loaded) {
        // TODO: Find better solution - Fix issue when globals does not render after saving from kit.
        // The issue is that the css-parser is depends upon cache and cache is not available during this time.
        return $e.data.get('globals/index').then(function () {
          if (setAsInitial) {
            // There is no need to attach preview when the iframe is reloaded. It will be triggerred
            // automatically after the iframe finishes loading (see `EditorBase.onPreviewLoaded()`).
            elementor.reloadPreview();
            return Promise.resolve();
          }
          return $e.internal('editor/documents/attach-preview', {
            shouldScroll: shouldScroll,
            selector: args.selector
          });
        });
      }
      return Promise.resolve(document);
    }
  }]);
  return Load;
}($e.modules.CommandInternalBase);
exports.Load = Load;
var _default = Load;
exports["default"] = _default;

/***/ }),

/***/ "../assets/dev/js/editor/components/documents/commands/internal/unload.js":
/*!********************************************************************************!*\
  !*** ../assets/dev/js/editor/components/documents/commands/internal/unload.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.Unload = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _document = _interopRequireDefault(__webpack_require__(/*! ../../document */ "../assets/dev/js/editor/components/documents/document.js"));
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var Unload = /*#__PURE__*/function (_$e$modules$CommandIn) {
  (0, _inherits2.default)(Unload, _$e$modules$CommandIn);
  var _super = _createSuper(Unload);
  function Unload() {
    (0, _classCallCheck2.default)(this, Unload);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(Unload, [{
    key: "validateArgs",
    value: function validateArgs() {
      var args = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      this.requireArgumentConstructor('document', _document.default, args);
    }
  }, {
    key: "apply",
    value: function apply(args) {
      return new Promise(function (resolve, reject) {
        var document = args.document;
        if (document.id !== elementor.config.document.id) {
          reject();
        }
        elementor.elements = [];
        elementor.saver.stopAutoSave(document);
        elementor.channels.dataEditMode.trigger('switch', 'preview');
        if (document.$element) {
          document.$element.removeClass('elementor-edit-area-active elementor-edit-mode').addClass('elementor-editor-preview');
        }
        elementorCommon.elements.$body.removeClass("elementor-editor-".concat(document.config.type));
        elementor.settings.page.destroy();
        elementor.heartbeat.destroy();
        document.editor.status = 'closed';
        elementor.config.document = {};
        elementor.documents.unsetCurrent();
        elementor.trigger('document:unloaded', document);
        resolve();
      });
    }
  }]);
  return Unload;
}($e.modules.CommandInternalBase);
exports.Unload = Unload;
var _default = Unload;
exports["default"] = _default;

/***/ }),

/***/ "../assets/dev/js/editor/components/documents/commands/open.js":
/*!*********************************************************************!*\
  !*** ../assets/dev/js/editor/components/documents/commands/open.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.Open = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var Open = /*#__PURE__*/function (_$e$modules$CommandBa) {
  (0, _inherits2.default)(Open, _$e$modules$CommandBa);
  var _super = _createSuper(Open);
  function Open() {
    (0, _classCallCheck2.default)(this, Open);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(Open, [{
    key: "validateArgs",
    value: function validateArgs(args) {
      this.requireArgument('id', args);
    }
  }, {
    key: "apply",
    value: function apply(args) {
      var id = args.id,
        selector = args.selector,
        _args$shouldScroll = args.shouldScroll,
        shouldScroll = _args$shouldScroll === void 0 ? true : _args$shouldScroll,
        _args$setAsInitial = args.setAsInitial,
        setAsInitial = _args$setAsInitial === void 0 ? false : _args$setAsInitial,
        currentDocument = elementor.documents.getCurrent();

      // Already opened.
      if (currentDocument && id === currentDocument.id) {
        return jQuery.Deferred().resolve();
      }

      // TODO: move to $e.hooks.ui.
      if (elementor.loaded) {
        elementor.$previewContents.find(".elementor-".concat(id)).addClass('loading');
      }
      if (setAsInitial) {
        // Set the new initial document id to be sent with all requests.
        // The next request needs to have the new initial document id in order to have the correct preview URL.
        elementorCommon.ajax.addRequestConstant('initial_document_id', id);

        // Because the initial document has changed, we need to clear cached values (e.g. header wp_preview URL),
        elementor.documents.invalidateCache();
      }
      return elementor.documents.request(id).then(function (config) {
        elementorCommon.elements.$body.addClass("elementor-editor-".concat(config.type));

        // Tell the editor to load the document.
        return $e.internal('editor/documents/load', {
          config: config,
          selector: selector,
          setAsInitial: setAsInitial,
          shouldScroll: shouldScroll
        });
      }).always(function () {
        // TODO: move to $e.hooks.ui.
        if (elementor.loaded) {
          elementor.$previewContents.find(".elementor-".concat(id)).removeClass('loading');
        }
      });
    }
  }]);
  return Open;
}($e.modules.CommandBase);
exports.Open = Open;
var _default = Open;
exports["default"] = _default;

/***/ }),

/***/ "../assets/dev/js/editor/components/documents/commands/preview.js":
/*!************************************************************************!*\
  !*** ../assets/dev/js/editor/components/documents/commands/preview.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.Preview = void 0;
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var Preview = /*#__PURE__*/function (_$e$modules$CommandBa) {
  (0, _inherits2.default)(Preview, _$e$modules$CommandBa);
  var _super = _createSuper(Preview);
  function Preview() {
    (0, _classCallCheck2.default)(this, Preview);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(Preview, [{
    key: "validateArgs",
    value: function validateArgs(args) {
      this.requireArgument('id', args);
    }

    // TODO: Check if blocking is required.
  }, {
    key: "apply",
    value: function () {
      var _apply = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee(args) {
        var id, _$e$components$get, footerSaver, document;
        return _regenerator.default.wrap(function _callee$(_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              id = args.id, _$e$components$get = $e.components.get('document/save'), footerSaver = _$e$components$get.footerSaver, document = elementor.documents.get(id);
              if (!document.editor.isChanged) {
                _context.next = 4;
                break;
              }
              _context.next = 4;
              return $e.run('document/save/auto', {
                force: true
              });
            case 4:
              // Open immediately in order to avoid popup blockers.
              footerSaver.previewWindow = open(document.config.urls.wp_preview, "wp-preview-".concat(document.id));
            case 5:
            case "end":
              return _context.stop();
          }
        }, _callee);
      }));
      function apply(_x) {
        return _apply.apply(this, arguments);
      }
      return apply;
    }()
  }]);
  return Preview;
}($e.modules.CommandBase);
exports.Preview = Preview;
var _default = Preview;
exports["default"] = _default;

/***/ }),

/***/ "../assets/dev/js/editor/components/documents/commands/switch.js":
/*!***********************************************************************!*\
  !*** ../assets/dev/js/editor/components/documents/commands/switch.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.Switch = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var Switch = /*#__PURE__*/function (_$e$modules$CommandBa) {
  (0, _inherits2.default)(Switch, _$e$modules$CommandBa);
  var _super = _createSuper(Switch);
  function Switch() {
    (0, _classCallCheck2.default)(this, Switch);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(Switch, [{
    key: "validateArgs",
    value: function validateArgs(args) {
      this.requireArgument('id', args);
    }
  }, {
    key: "apply",
    value: function apply(args) {
      var id = args.id,
        mode = args.mode,
        onClose = args.onClose,
        _args$shouldScroll = args.shouldScroll,
        shouldScroll = _args$shouldScroll === void 0 ? true : _args$shouldScroll,
        _args$setAsInitial = args.setAsInitial,
        setAsInitial = _args$setAsInitial === void 0 ? false : _args$setAsInitial;
      if (setAsInitial) {
        // Will be removed by the attach-preview after the iframe has loaded.
        jQuery('#elementor-preview-loading').show();
      }
      return $e.run('editor/documents/close', {
        id: elementor.documents.getCurrentId(),
        mode: mode,
        onClose: onClose,
        selector: args.selector
      }).then(function () {
        return $e.run('editor/documents/open', {
          id: id,
          shouldScroll: shouldScroll,
          selector: args.selector,
          setAsInitial: setAsInitial
        });
      }).then(function () {
        elementor.getPanelView().getPages('menu').view.addExitItem();
      });
    }
  }]);
  return Switch;
}($e.modules.CommandBase);
exports.Switch = Switch;
var _default = Switch;
exports["default"] = _default;

/***/ }),

/***/ "../assets/dev/js/editor/components/documents/component.js":
/*!*****************************************************************!*\
  !*** ../assets/dev/js/editor/components/documents/component.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var __ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["__"];


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _get2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/get */ "../node_modules/@babel/runtime/helpers/get.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _componentBase = _interopRequireDefault(__webpack_require__(/*! elementor-api/modules/component-base */ "../modules/web-cli/assets/js/modules/component-base.js"));
var _document = _interopRequireDefault(__webpack_require__(/*! ./document */ "../assets/dev/js/editor/components/documents/document.js"));
var commands = _interopRequireWildcard(__webpack_require__(/*! ./commands/ */ "../assets/dev/js/editor/components/documents/commands/index.js"));
var internalCommands = _interopRequireWildcard(__webpack_require__(/*! ./commands/internal/ */ "../assets/dev/js/editor/components/documents/commands/internal/index.js"));
var hooks = _interopRequireWildcard(__webpack_require__(/*! ./hooks */ "../assets/dev/js/editor/components/documents/hooks/index.js"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var Component = /*#__PURE__*/function (_ComponentBase) {
  (0, _inherits2.default)(Component, _ComponentBase);
  var _super = _createSuper(Component);
  function Component() {
    (0, _classCallCheck2.default)(this, Component);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(Component, [{
    key: "__construct",
    value: function __construct() {
      var args = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      (0, _get2.default)((0, _getPrototypeOf2.default)(Component.prototype), "__construct", this).call(this, args);

      /**
       * All the documents.
       *
       * @type {Object.<Document>}
       */
      this.documents = {};

      /**
       * Current document.
       *
       * @type {Document}
       */
      this.currentDocument = null;
      this.saveInitialDocumentToCache();
    }
  }, {
    key: "getNamespace",
    value: function getNamespace() {
      return 'editor/documents';
    }
  }, {
    key: "defaultCommands",
    value: function defaultCommands() {
      return this.importCommands(commands);
    }
  }, {
    key: "defaultHooks",
    value: function defaultHooks() {
      return this.importHooks(hooks);
    }
  }, {
    key: "defaultCommandsInternal",
    value: function defaultCommandsInternal() {
      return this.importCommands(internalCommands);
    }

    /**
     * Function add().
     *
     * Add's document to the manager.
     *
     * @param {Document} document
     *
     * @return {Document} document
     */
  }, {
    key: "add",
    value: function add(document) {
      var id = document.id;

      // Save the document.
      this.documents[id] = document;
      return document;
    }

    /**
     * Function addDocumentByConfig().
     *
     * Add document to manager by config.
     *
     * @param {{}} config
     *
     * @return {Document} document
     */
  }, {
    key: "addDocumentByConfig",
    value: function addDocumentByConfig(config) {
      return this.add(new _document.default(config));
    }

    /**
     * Function get().
     *
     * Get document by id.
     *
     * @param {number} id
     *
     * @return {Document|boolean} document, or false if doesn't exist
     */
  }, {
    key: "get",
    value: function get(id) {
      if (undefined !== this.documents[id]) {
        return this.documents[id];
      }
      return false;
    }

    /**
     * Function getCurrent().
     *
     * Return's current document.
     *
     * @return {Document} document
     */
  }, {
    key: "getCurrent",
    value: function getCurrent() {
      return this.currentDocument;
    }

    /**
     * Function getCurrentId().
     *
     * Return's current document id.
     *
     * @return {number} document id
     */
  }, {
    key: "getCurrentId",
    value: function getCurrentId() {
      return this.currentDocument.id;
    }
  }, {
    key: "getInitialId",
    value: function getInitialId() {
      return elementor.config.initial_document.id;
    }
  }, {
    key: "setInitialById",
    value: function setInitialById(id) {
      var document = this.get(id);
      if (!document) {
        return;
      }
      elementor.config.initial_document = document.config;
      elementorCommon.ajax.addRequestConstant('initial_document_id', document.id);
    }

    /**
     * Function setCurrent().
     *
     * set current document by document instance.
     *
     * @param {Document} document
     */
  }, {
    key: "setCurrent",
    value: function setCurrent(document) {
      if (undefined === this.documents[document.id]) {
        throw Error("The document with id: '".concat(document.id, "' does not exist/loaded"));
      }
      if (this.currentDocument) {
        this.currentDocument.editor.status = 'closed';
      }
      this.currentDocument = this.documents[document.id];
      this.currentDocument.editor.status = 'open';
      elementorCommon.ajax.addRequestConstant('editor_post_id', document.id);
    }
  }, {
    key: "isCurrent",
    value: function isCurrent(id) {
      return parseInt(id) === this.currentDocument.id;
    }
  }, {
    key: "unsetCurrent",
    value: function unsetCurrent() {
      this.currentDocument = null;
      elementorCommon.ajax.addRequestConstant('editor_post_id', null);
    }
  }, {
    key: "request",
    value: function request(id) {
      return elementorCommon.ajax.load(this.getRequestArgs(id), true);
    }
  }, {
    key: "invalidateCache",
    value: function invalidateCache() {
      var _this = this;
      var id = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
      if (id) {
        elementorCommon.ajax.invalidateCache(this.getRequestArgs(id));
        return;
      }
      Object.keys(this.documents).forEach(function (docId) {
        elementorCommon.ajax.invalidateCache(_this.getRequestArgs(docId));
      });
    }
  }, {
    key: "getRequestArgs",
    value: function getRequestArgs(id) {
      id = parseInt(id);
      return {
        action: 'get_document_config',
        unique_id: "document-".concat(id),
        data: {
          id: id
        },
        success: function success(config) {
          return config;
        },
        error: function error(data) {
          var message;
          if (_.isString(data)) {
            message = data;
          } else if (data.statusText) {
            message = elementor.createAjaxErrorMessage(data);
            if (0 === data.readyState) {
              message += ' ' + __('Cannot load editor', 'elementor');
            }
          } else if (data[0] && data[0].code) {
            message = __('Server Error', 'elementor') + ' ' + data[0].code;
          }

          // eslint-disable-next-line no-alert
          alert(message);
        }
      };
    }

    /**
     * Temp: Don't request initial document via ajax.
     * Keep the event `elementor:init` before `preview:loaded`.
     */
  }, {
    key: "saveInitialDocumentToCache",
    value: function saveInitialDocumentToCache() {
      var document = elementor.config.initial_document;
      elementorCommon.ajax.addRequestCache(this.getRequestArgs(document.id), document);
    }
  }]);
  return Component;
}(_componentBase.default);
exports["default"] = Component;

/***/ }),

/***/ "../assets/dev/js/editor/components/documents/document.js":
/*!****************************************************************!*\
  !*** ../assets/dev/js/editor/components/documents/document.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _manager = _interopRequireDefault(__webpack_require__(/*! elementor/modules/history/assets/js/history/manager */ "../modules/history/assets/js/history/manager.js"));
var _manager2 = _interopRequireDefault(__webpack_require__(/*! elementor/modules/history/assets/js/revisions/manager */ "../modules/history/assets/js/revisions/manager.js"));
var _editor = _interopRequireDefault(__webpack_require__(/*! ./models/editor */ "../assets/dev/js/editor/components/documents/models/editor.js"));
/**
 * @typedef {import('../../container/container')} Container
 */
var Document = /*#__PURE__*/function () {
  /**
   * Function constructor().
   *
   * Create document.
   *
   * @param {{}} config
   */
  function Document(config) {
    (0, _classCallCheck2.default)(this, Document);
    /**
     * Document id.
     *
     * @type {number|null}
     */
    (0, _defineProperty2.default)(this, "id", null);
    /**
     * History of the document.
     *
     * @type {HistoryManager}
     */
    (0, _defineProperty2.default)(this, "history", null);
    /**
     * Revisions of the document.
     *
     * @type {RevisionsManager}
     */
    (0, _defineProperty2.default)(this, "revisions", null);
    /**
     * Current container.
     *
     * @type {Container}
     */
    (0, _defineProperty2.default)(this, "container", null);
    /**
     * Editor Settings.
     *
     * @type {Editor}
     */
    (0, _defineProperty2.default)(this, "editor", new _editor.default());
    this.config = config;
    this.id = config.id;
    this.history = new _manager.default(this);
    this.revisions = new _manager2.default(this);
  }
  (0, _createClass2.default)(Document, [{
    key: "isDraft",
    value: function isDraft() {
      return this.config.revisions.current_id !== this.config.id;
    }
  }]);
  return Document;
}();
exports["default"] = Document;

/***/ }),

/***/ "../assets/dev/js/editor/components/documents/hooks/index.js":
/*!*******************************************************************!*\
  !*** ../assets/dev/js/editor/components/documents/hooks/index.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
Object.defineProperty(exports, "RemoveActiveDocumentQueryParam", ({
  enumerable: true,
  get: function get() {
    return _removeActiveDocumentQueryParam.RemoveActiveDocumentQueryParam;
  }
}));
Object.defineProperty(exports, "SetActiveDocumentQueryParam", ({
  enumerable: true,
  get: function get() {
    return _setActiveDocumentQueryParam.SetActiveDocumentQueryParam;
  }
}));
Object.defineProperty(exports, "SwitchToActiveDocument", ({
  enumerable: true,
  get: function get() {
    return _switchToActiveDocument.SwitchToActiveDocument;
  }
}));
var _removeActiveDocumentQueryParam = __webpack_require__(/*! ./ui/close/remove-active-document-query-param */ "../assets/dev/js/editor/components/documents/hooks/ui/close/remove-active-document-query-param.js");
var _setActiveDocumentQueryParam = __webpack_require__(/*! ./ui/open/set-active-document-query-param */ "../assets/dev/js/editor/components/documents/hooks/ui/open/set-active-document-query-param.js");
var _switchToActiveDocument = __webpack_require__(/*! ./ui/attach-preview/switch-to-active-document */ "../assets/dev/js/editor/components/documents/hooks/ui/attach-preview/switch-to-active-document.js");

/***/ }),

/***/ "../assets/dev/js/editor/components/documents/hooks/ui/attach-preview/switch-to-active-document.js":
/*!*********************************************************************************************************!*\
  !*** ../assets/dev/js/editor/components/documents/hooks/ui/attach-preview/switch-to-active-document.js ***!
  \*********************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.SwitchToActiveDocument = void 0;
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _queryParams = __webpack_require__(/*! elementor-editor-utils/query-params */ "../assets/dev/js/editor/utils/query-params.js");
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
/**
 * Switch to the document in the `active-document` query param on initial Editor load.
 * This hook runs only once, when the initial document has been attached.
 */
var SwitchToActiveDocument = /*#__PURE__*/function (_$e$modules$hookUI$Af) {
  (0, _inherits2.default)(SwitchToActiveDocument, _$e$modules$hookUI$Af);
  var _super = _createSuper(SwitchToActiveDocument);
  function SwitchToActiveDocument() {
    (0, _classCallCheck2.default)(this, SwitchToActiveDocument);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(SwitchToActiveDocument, [{
    key: "getCommand",
    value: function getCommand() {
      return 'editor/documents/attach-preview';
    }
  }, {
    key: "getId",
    value: function getId() {
      return 'switch-to-active-document';
    }
  }, {
    key: "getConditions",
    value: function getConditions() {
      if (this.constructor.calledOnce) {
        return false;
      }
      return elementor.documents.getCurrentId() === elementor.config.initial_document.id;
    }
  }, {
    key: "apply",
    value: function () {
      var _apply = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee() {
        var activeDocumentId, isLoadedAlready;
        return _regenerator.default.wrap(function _callee$(_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              this.constructor.calledOnce = true;
              activeDocumentId = parseInt((0, _queryParams.getQueryParam)('active-document')), isLoadedAlready = activeDocumentId === elementor.documents.getCurrentId();
              if (!(isNaN(activeDocumentId) || isLoadedAlready)) {
                _context.next = 4;
                break;
              }
              return _context.abrupt("return");
            case 4:
              _context.prev = 4;
              _context.next = 7;
              return $e.run('editor/documents/switch', {
                id: activeDocumentId,
                mode: 'autosave'
              });
            case 7:
              _context.next = 13;
              break;
            case 9:
              _context.prev = 9;
              _context.t0 = _context["catch"](4);
              $e.run('editor/documents/switch', {
                id: elementor.config.initial_document.id,
                mode: 'autosave'
              });
              (0, _queryParams.removeQueryParam)('active-document');
            case 13:
            case "end":
              return _context.stop();
          }
        }, _callee, this, [[4, 9]]);
      }));
      function apply() {
        return _apply.apply(this, arguments);
      }
      return apply;
    }()
  }]);
  return SwitchToActiveDocument;
}($e.modules.hookUI.After);
exports.SwitchToActiveDocument = SwitchToActiveDocument;
(0, _defineProperty2.default)(SwitchToActiveDocument, "calledOnce", false);
var _default = SwitchToActiveDocument;
exports["default"] = _default;

/***/ }),

/***/ "../assets/dev/js/editor/components/documents/hooks/ui/close/remove-active-document-query-param.js":
/*!*********************************************************************************************************!*\
  !*** ../assets/dev/js/editor/components/documents/hooks/ui/close/remove-active-document-query-param.js ***!
  \*********************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.RemoveActiveDocumentQueryParam = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _queryParams = __webpack_require__(/*! elementor-editor-utils/query-params */ "../assets/dev/js/editor/utils/query-params.js");
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var RemoveActiveDocumentQueryParam = /*#__PURE__*/function (_$e$modules$hookUI$Af) {
  (0, _inherits2.default)(RemoveActiveDocumentQueryParam, _$e$modules$hookUI$Af);
  var _super = _createSuper(RemoveActiveDocumentQueryParam);
  function RemoveActiveDocumentQueryParam() {
    (0, _classCallCheck2.default)(this, RemoveActiveDocumentQueryParam);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(RemoveActiveDocumentQueryParam, [{
    key: "getCommand",
    value: function getCommand() {
      return 'editor/documents/close';
    }
  }, {
    key: "getId",
    value: function getId() {
      return 'remove-active-document-query-param';
    }
  }, {
    key: "apply",
    value: function apply(args) {
      var activeDocumentId = parseInt((0, _queryParams.getQueryParam)('active-document')),
        closedDocumentId = parseInt(args.id);
      if (activeDocumentId === closedDocumentId) {
        (0, _queryParams.removeQueryParam)('active-document');
      }
    }
  }]);
  return RemoveActiveDocumentQueryParam;
}($e.modules.hookUI.After);
exports.RemoveActiveDocumentQueryParam = RemoveActiveDocumentQueryParam;
var _default = RemoveActiveDocumentQueryParam;
exports["default"] = _default;

/***/ }),

/***/ "../assets/dev/js/editor/components/documents/hooks/ui/open/set-active-document-query-param.js":
/*!*****************************************************************************************************!*\
  !*** ../assets/dev/js/editor/components/documents/hooks/ui/open/set-active-document-query-param.js ***!
  \*****************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.SetActiveDocumentQueryParam = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _queryParams = __webpack_require__(/*! elementor-editor-utils/query-params */ "../assets/dev/js/editor/utils/query-params.js");
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var SetActiveDocumentQueryParam = /*#__PURE__*/function (_$e$modules$hookUI$Af) {
  (0, _inherits2.default)(SetActiveDocumentQueryParam, _$e$modules$hookUI$Af);
  var _super = _createSuper(SetActiveDocumentQueryParam);
  function SetActiveDocumentQueryParam() {
    (0, _classCallCheck2.default)(this, SetActiveDocumentQueryParam);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(SetActiveDocumentQueryParam, [{
    key: "getCommand",
    value: function getCommand() {
      return 'editor/documents/open';
    }
  }, {
    key: "getId",
    value: function getId() {
      return 'set-active-document-query-param';
    }
  }, {
    key: "getConditions",
    value: function getConditions(args) {
      // Don't run for the initial/default document because it's redundant.
      return parseInt(args.id) !== parseInt(elementor.config.initial_document.id);
    }
  }, {
    key: "apply",
    value: function apply(args) {
      var id = parseInt(args.id);
      if (!isNaN(id)) {
        (0, _queryParams.setQueryParam)('active-document', args.id);
      }
    }
  }]);
  return SetActiveDocumentQueryParam;
}($e.modules.hookUI.After);
exports.SetActiveDocumentQueryParam = SetActiveDocumentQueryParam;
var _default = SetActiveDocumentQueryParam;
exports["default"] = _default;

/***/ }),

/***/ "../assets/dev/js/editor/components/documents/models/editor.js":
/*!*********************************************************************!*\
  !*** ../assets/dev/js/editor/components/documents/models/editor.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var Editor = /*#__PURE__*/(0, _createClass2.default)(function Editor() {
  (0, _classCallCheck2.default)(this, Editor);
  /**
   * Editor status.
   *
   * @type {'open'|'closed'}
   */
  (0, _defineProperty2.default)(this, "status", 'closed');
  /**
   * Is document still saving?.
   *
   * @type {boolean}
   */
  (0, _defineProperty2.default)(this, "isSaving", false);
  /**
   * Is document changed?.
   *
   * @type {boolean}
   */
  (0, _defineProperty2.default)(this, "isChanged", false);
  /**
   * Is document changed during save?.
   *
   * @type {boolean}
   */
  (0, _defineProperty2.default)(this, "isChangedDuringSave", false);
  /**
   * Is document saved?
   *
   * @type {boolean}
   */
  (0, _defineProperty2.default)(this, "isSaved", true);
  /**
   * Last save history id.
   *
   * @type {number}
   */
  (0, _defineProperty2.default)(this, "lastSaveHistoryId", 0);
});
exports["default"] = Editor;

/***/ }),

/***/ "../assets/dev/js/editor/components/dynamic-tags/control-behavior.js":
/*!***************************************************************************!*\
  !*** ../assets/dev/js/editor/components/dynamic-tags/control-behavior.js ***!
  \***************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var __ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["__"];


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var TagPanelView = __webpack_require__(/*! elementor-dynamic-tags/tag-panel-view */ "../assets/dev/js/editor/components/dynamic-tags/tag-panel-view.js");
module.exports = Marionette.Behavior.extend({
  tagView: null,
  listenerAttached: false,
  initialize: function initialize() {
    if (!this.listenerAttached) {
      this.listenTo(this.view.options.container.settings, 'change:external:__dynamic__', this.onAfterExternalChange);
      this.listenerAttached = true;
    }
  },
  shouldRenderTools: function shouldRenderTools() {
    var hasDefault = this.getOption('dynamicSettings').default;
    if (hasDefault) {
      return false;
    }
    var isFeatureAvalibleToUser = elementor.helpers.hasPro() && !elementor.helpers.hasProAndNotConnected(),
      hasTags = this.getOption('tags').length > 0;
    return !isFeatureAvalibleToUser || hasTags;
  },
  renderTools: function renderTools() {
    var _this = this;
    if (!this.shouldRenderTools()) {
      return;
    }
    var $dynamicSwitcher = jQuery(Marionette.Renderer.render('#tmpl-elementor-control-dynamic-switcher'));
    $dynamicSwitcher.on('click', function (event) {
      return _this.onDynamicSwitcherClick(event);
    });
    this.$el.find('.elementor-control-dynamic-switcher-wrapper').append($dynamicSwitcher);
    this.ui.dynamicSwitcher = $dynamicSwitcher;
    if ('color' === this.view.model.get('type')) {
      if (this.view.colorPicker) {
        this.moveDynamicSwitcherToColorPicker();
      } else {
        setTimeout(function () {
          return _this.moveDynamicSwitcherToColorPicker();
        });
      }
    }

    // Add a Tipsy Tooltip to the Dynamic Switcher
    this.ui.dynamicSwitcher.tipsy({
      title: function title() {
        return this.getAttribute('data-tooltip');
      },
      gravity: 's'
    });
  },
  moveDynamicSwitcherToColorPicker: function moveDynamicSwitcherToColorPicker() {
    var $colorPickerToolsContainer = this.view.colorPicker.$pickerToolsContainer;
    this.ui.dynamicSwitcher.removeClass('elementor-control-unit-1').addClass('e-control-tool');
    var $eyedropper = $colorPickerToolsContainer.find('.elementor-control-element-color-picker');
    if ($eyedropper.length) {
      this.ui.dynamicSwitcher.insertBefore($eyedropper);
    } else {
      $colorPickerToolsContainer.append(this.ui.dynamicSwitcher);
    }
  },
  toggleDynamicClass: function toggleDynamicClass() {
    this.$el.toggleClass('elementor-control-dynamic-value', this.isDynamicMode());
  },
  isDynamicMode: function isDynamicMode() {
    var dynamicSettings = this.view.container.settings.get('__dynamic__');
    return !!(dynamicSettings && dynamicSettings[this.view.model.get('name')]);
  },
  createTagsList: function createTagsList() {
    var tags = _.groupBy(this.getOption('tags'), 'group'),
      groups = elementor.dynamicTags.getConfig('groups'),
      $tagsList = this.ui.tagsList = jQuery('<div>', {
        class: 'elementor-tags-list'
      }),
      $tagsListInner = jQuery('<div>', {
        class: 'elementor-tags-list__inner'
      });
    $tagsList.append($tagsListInner);
    jQuery.each(groups, function (groupName) {
      var groupTags = tags[groupName];
      if (!groupTags) {
        return;
      }
      var group = this,
        $groupTitle = jQuery('<div>', {
          class: 'elementor-tags-list__group-title'
        }).text(group.title);
      $tagsListInner.append($groupTitle);
      groupTags.forEach(function (tag) {
        var $tag = jQuery('<div>', {
          class: 'elementor-tags-list__item'
        });
        $tag.text(tag.title).attr('data-tag-name', tag.name);
        $tagsListInner.append($tag);
      });
    });

    // Create and inject pro dynamic teaser template if Pro is not installed
    if (!elementor.helpers.hasPro() && Object.keys(tags).length) {
      var proTeaser = Marionette.Renderer.render('#tmpl-elementor-dynamic-tags-promo', {
        promotionUrl: elementor.config.dynamicPromotionURL.replace('%s', this.view.model.get('name'))
      });
      $tagsListInner.append(proTeaser);
    }
    $tagsListInner.on('click', '.elementor-tags-list__item', this.onTagsListItemClick.bind(this));
    elementorCommon.elements.$body.append($tagsList);
  },
  getTagsList: function getTagsList() {
    if (!this.ui.tagsList) {
      this.createTagsList();
    }
    return this.ui.tagsList;
  },
  toggleTagsList: function toggleTagsList() {
    var $tagsList = this.getTagsList();
    if ($tagsList.is(':visible')) {
      $tagsList.hide();
      return;
    }
    var direction = elementorCommon.config.isRTL ? 'left' : 'right';
    $tagsList.show().position({
      my: "".concat(direction, " top"),
      at: "".concat(direction, " bottom+5"),
      of: this.ui.dynamicSwitcher
    });
  },
  setTagView: function setTagView(id, name, settings) {
    if (this.tagView) {
      this.tagView.destroy();
    }
    var tagView = this.tagView = new TagPanelView({
        id: id,
        name: name,
        settings: settings,
        controlName: this.view.model.get('name'),
        dynamicSettings: this.getOption('dynamicSettings')
      }),
      elementContainer = this.view.options.container,
      tagViewLabel = elementContainer.controls[tagView.options.controlName].label;
    tagView.options.container = new elementorModules.editor.Container({
      type: 'dynamic',
      id: id,
      model: tagView.model,
      settings: tagView.model,
      view: tagView,
      parent: elementContainer,
      label: elementContainer.label + ' ' + tagViewLabel,
      controls: tagView.model.options.controls,
      renderer: elementContainer
    });
    tagView.render();
    this.$el.find('.elementor-control-tag-area').after(tagView.el);
    this.listenTo(tagView, 'remove', this.onTagViewRemove.bind(this));
  },
  setDefaultTagView: function setDefaultTagView() {
    var tagData = elementor.dynamicTags.tagTextToTagData(this.getDynamicValue());
    this.setTagView(tagData.id, tagData.name, tagData.settings);
  },
  tagViewToTagText: function tagViewToTagText() {
    var tagView = this.tagView;
    return elementor.dynamicTags.tagDataToTagText(tagView.getOption('id'), tagView.getOption('name'), tagView.model);
  },
  getDynamicValue: function getDynamicValue() {
    return this.view.container.dynamic.get(this.view.model.get('name'));
  },
  destroyTagView: function destroyTagView() {
    if (this.tagView) {
      this.tagView.destroy();
      this.tagView = null;
    }
  },
  showPromotion: function showPromotion() {
    var hasProAndNotConnected = elementor.helpers.hasProAndNotConnected(),
      dialogOptions = {
        title: __('Dynamic Content', 'elementor'),
        content: __('Create more personalized and dynamic sites by populating data from various sources with dozens of dynamic tags to choose from.', 'elementor'),
        targetElement: this.ui.dynamicSwitcher,
        position: {
          blockStart: '-10'
        },
        actionButton: {
          url: hasProAndNotConnected ? elementorProEditorConfig.urls.connect : elementor.config.dynamicPromotionURL.replace('%s', this.view.model.get('name')),
          text: hasProAndNotConnected ? __('Connect & Activate', 'elementor') : __('Upgrade', 'elementor')
        }
      };
    elementor.promotion.showDialog(dialogOptions);
  },
  onRender: function onRender() {
    this.$el.addClass('elementor-control-dynamic');
    this.renderTools();
    this.toggleDynamicClass();
    if (this.isDynamicMode()) {
      this.setDefaultTagView();
    }
  },
  onDynamicSwitcherClick: function onDynamicSwitcherClick(event) {
    event.stopPropagation();
    if (this.getOption('tags').length) {
      this.toggleTagsList();
    } else {
      this.showPromotion();
    }
  },
  onTagsListItemClick: function onTagsListItemClick(event) {
    var $tag = jQuery(event.currentTarget);
    this.setTagView(elementorCommon.helpers.getUniqueId(), $tag.data('tagName'), {});

    // If an element has an active global value, disable it before applying the dynamic value.
    if (this.view.getGlobalKey()) {
      this.view.triggerMethod('unset:global:value');
    }
    if (this.isDynamicMode()) {
      $e.run('document/dynamic/settings', {
        container: this.view.options.container,
        settings: (0, _defineProperty2.default)({}, this.view.model.get('name'), this.tagViewToTagText())
      });
    } else {
      $e.run('document/dynamic/enable', {
        container: this.view.options.container,
        settings: (0, _defineProperty2.default)({}, this.view.model.get('name'), this.tagViewToTagText())
      });
    }
    this.toggleDynamicClass();
    this.toggleTagsList();
    if (this.tagView.getTagConfig().settings_required) {
      this.tagView.showSettingsPopup();
    }
  },
  onTagViewRemove: function onTagViewRemove() {
    $e.run('document/dynamic/disable', {
      container: this.view.options.container,
      settings: (0, _defineProperty2.default)({}, this.view.model.get('name'), this.tagViewToTagText())
    });
    this.toggleDynamicClass();
  },
  onAfterExternalChange: function onAfterExternalChange() {
    this.destroyTagView();
    if (this.isDynamicMode()) {
      this.setDefaultTagView();
    }
    this.toggleDynamicClass();
  },
  onDestroy: function onDestroy() {
    this.destroyTagView();
    if (this.ui.tagsList) {
      this.ui.tagsList.remove();
    }
  }
});

/***/ }),

/***/ "../assets/dev/js/editor/components/dynamic-tags/manager.js":
/*!******************************************************************!*\
  !*** ../assets/dev/js/editor/components/dynamic-tags/manager.js ***!
  \******************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
module.exports = elementorModules.Module.extend({
  CACHE_KEY_NOT_FOUND_ERROR: 'Cache key not found',
  tags: {
    Base: __webpack_require__(/*! elementor-dynamic-tags/tag */ "../assets/dev/js/editor/components/dynamic-tags/tag.js")
  },
  cache: {},
  cacheRequests: {},
  cacheCallbacks: [],
  addCacheRequest: function addCacheRequest(tag) {
    this.cacheRequests[this.createCacheKey(tag)] = true;
  },
  createCacheKey: function createCacheKey(tag) {
    return btoa(tag.getOption('name')) + '-' + btoa(encodeURIComponent(JSON.stringify(tag.model)));
  },
  loadTagDataFromCache: function loadTagDataFromCache(tag) {
    var cacheKey = this.createCacheKey(tag);
    if (undefined !== this.cache[cacheKey]) {
      return this.cache[cacheKey];
    }
    if (!this.cacheRequests[cacheKey]) {
      this.addCacheRequest(tag);
    }
  },
  loadCacheRequests: function loadCacheRequests() {
    var _this = this;
    var cacheRequests = this.cacheRequests,
      cacheCallbacks = this.cacheCallbacks;
    this.cacheRequests = {};
    this.cacheCallbacks = [];
    elementorCommon.ajax.addRequest('render_tags', {
      data: {
        post_id: elementor.config.document.id,
        tags: Object.keys(cacheRequests)
      },
      success: function success(data) {
        _this.cache = _objectSpread(_objectSpread({}, _this.cache), data);
        cacheCallbacks.forEach(function (callback) {
          callback();
        });
      }
    });
  },
  refreshCacheFromServer: function refreshCacheFromServer(callback) {
    this.cacheCallbacks.push(callback);
    this.loadCacheRequests();
  },
  getConfig: function getConfig(key) {
    return this.getItems(elementor.config.dynamicTags, key);
  },
  parseTagsText: function parseTagsText(text, settings, parseCallback) {
    var self = this;
    if ('object' === settings.returnType) {
      return self.parseTagText(text, settings, parseCallback);
    }
    return text.replace(/\[elementor-tag[^\]]+]/g, function (tagText) {
      return self.parseTagText(tagText, settings, parseCallback);
    });
  },
  parseTagText: function parseTagText(tagText, settings, parseCallback) {
    var tagData = this.tagTextToTagData(tagText);
    if (!tagData) {
      if ('object' === settings.returnType) {
        return {};
      }
      return '';
    }
    return parseCallback(tagData.id, tagData.name, tagData.settings);
  },
  tagTextToTagData: function tagTextToTagData(tagText) {
    var tagIDMatch = tagText.match(/id="(.*?(?="))"/),
      tagNameMatch = tagText.match(/name="(.*?(?="))"/),
      tagSettingsMatch = tagText.match(/settings="(.*?(?="]))/);
    if (!tagIDMatch || !tagNameMatch || !tagSettingsMatch) {
      return false;
    }
    return {
      id: tagIDMatch[1],
      name: tagNameMatch[1],
      settings: JSON.parse(decodeURIComponent(tagSettingsMatch[1]))
    };
  },
  createTag: function createTag(tagID, tagName, tagSettings) {
    var tagConfig = this.getConfig('tags.' + tagName);
    if (!tagConfig) {
      return;
    }
    var TagClass = this.tags[tagName] || this.tags.Base,
      model = new elementorModules.editor.elements.models.BaseSettings(tagSettings, {
        controls: tagConfig.controls
      });
    return new TagClass({
      id: tagID,
      name: tagName,
      model: model
    });
  },
  getTagDataContent: function getTagDataContent(tagID, tagName, tagSettings) {
    var tag = this.createTag(tagID, tagName, tagSettings);
    if (!tag) {
      return;
    }
    return tag.getContent();
  },
  tagDataToTagText: function tagDataToTagText(tagID, tagName, tagSettings) {
    tagSettings = encodeURIComponent(JSON.stringify(tagSettings && tagSettings.toJSON({
      remove: ['default']
    }) || {}));
    return '[elementor-tag id="' + tagID + '" name="' + tagName + '" settings="' + tagSettings + '"]';
  },
  tagContainerToTagText: function tagContainerToTagText( /** Container*/container) {
    return elementor.dynamicTags.tagDataToTagText(container.view.getOption('id'), container.view.getOption('name'), container.view.model);
  },
  cleanCache: function cleanCache() {
    this.cache = {};
  },
  onInit: function onInit() {
    this.loadCacheRequests = _.debounce(this.loadCacheRequests, 300);
  }
});

/***/ }),

/***/ "../assets/dev/js/editor/components/dynamic-tags/tag-controls-stack-empty.js":
/*!***********************************************************************************!*\
  !*** ../assets/dev/js/editor/components/dynamic-tags/tag-controls-stack-empty.js ***!
  \***********************************************************************************/
/***/ ((module) => {

"use strict";


module.exports = Marionette.ItemView.extend({
  className: 'elementor-tag-controls-stack-empty',
  template: '#tmpl-elementor-tag-controls-stack-empty'
});

/***/ }),

/***/ "../assets/dev/js/editor/components/dynamic-tags/tag-controls-stack.js":
/*!*****************************************************************************!*\
  !*** ../assets/dev/js/editor/components/dynamic-tags/tag-controls-stack.js ***!
  \*****************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var EmptyView = __webpack_require__(/*! elementor-dynamic-tags/tag-controls-stack-empty */ "../assets/dev/js/editor/components/dynamic-tags/tag-controls-stack-empty.js");
module.exports = elementorModules.editor.views.ControlsStack.extend({
  activeTab: 'content',
  template: _.noop,
  emptyView: EmptyView,
  isEmpty: function isEmpty() {
    // Ignore the section control
    return this.collection.length < 2;
  },
  childViewOptions: function childViewOptions() {
    return {
      container: this.options.container
    };
  },
  getNamespaceArray: function getNamespaceArray() {
    var currentPageView = elementor.getPanelView().getCurrentPageView(),
      eventNamespace = currentPageView.getNamespaceArray();
    eventNamespace.push(currentPageView.activeSection);
    eventNamespace.push(this.getOption('controlName'));
    eventNamespace.push(this.getOption('name'));
    return eventNamespace;
  },
  onRenderTemplate: function onRenderTemplate() {
    this.activateFirstSection();
  }
});

/***/ }),

/***/ "../assets/dev/js/editor/components/dynamic-tags/tag-panel-view.js":
/*!*************************************************************************!*\
  !*** ../assets/dev/js/editor/components/dynamic-tags/tag-panel-view.js ***!
  \*************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var TagControlsStack = __webpack_require__(/*! elementor-dynamic-tags/tag-controls-stack */ "../assets/dev/js/editor/components/dynamic-tags/tag-controls-stack.js");
module.exports = Marionette.ItemView.extend({
  className: 'elementor-dynamic-cover e-input-style',
  tagControlsStack: null,
  templateHelpers: function templateHelpers() {
    var helpers = {};
    if (this.model) {
      helpers.controls = this.model.options.controls;
    }
    return helpers;
  },
  ui: {
    remove: '.elementor-dynamic-cover__remove'
  },
  events: function events() {
    var events = {
      'click @ui.remove': 'onRemoveClick'
    };
    if (this.hasSettings()) {
      events.click = 'onClick';
    }
    return events;
  },
  getTemplate: function getTemplate() {
    var config = this.getTagConfig(),
      templateFunction = Marionette.TemplateCache.get('#tmpl-elementor-control-dynamic-cover'),
      renderedTemplate = Marionette.Renderer.render(templateFunction, {
        hasSettings: this.hasSettings(),
        isRemovable: !this.getOption('dynamicSettings').default,
        title: config.title,
        content: config.panel_template
      });
    return Marionette.TemplateCache.prototype.compileTemplate(renderedTemplate.trim());
  },
  getTagConfig: function getTagConfig() {
    return elementor.dynamicTags.getConfig('tags.' + this.getOption('name'));
  },
  initSettingsPopup: function initSettingsPopup() {
    var settingsPopupOptions = {
      className: 'elementor-tag-settings-popup',
      position: {
        my: 'left top+5',
        at: 'left bottom',
        of: this.$el,
        autoRefresh: true
      },
      hide: {
        ignore: '.select2-container'
      }
    };
    var settingsPopup = elementorCommon.dialogsManager.createWidget('buttons', settingsPopupOptions);
    this.getSettingsPopup = function () {
      return settingsPopup;
    };
  },
  hasSettings: function hasSettings() {
    return !!Object.values(this.getTagConfig().controls).length;
  },
  showSettingsPopup: function showSettingsPopup() {
    if (!this.tagControlsStack) {
      this.initTagControlsStack();
    }
    var settingsPopup = this.getSettingsPopup();
    if (settingsPopup.isVisible()) {
      return;
    }
    settingsPopup.show();
  },
  initTagControlsStack: function initTagControlsStack() {
    this.tagControlsStack = new TagControlsStack({
      model: this.model,
      controls: this.model.controls,
      name: this.options.name,
      controlName: this.options.controlName,
      container: this.options.container,
      el: this.getSettingsPopup().getElements('message')[0]
    });
    this.tagControlsStack.render();
  },
  initModel: function initModel() {
    this.model = new elementorModules.editor.elements.models.BaseSettings(this.getOption('settings'), {
      controls: this.getTagConfig().controls
    });
  },
  initialize: function initialize() {
    // The `model` should always be available.
    this.initModel();
    if (!this.hasSettings()) {
      return;
    }
    this.initSettingsPopup();
    this.listenTo(this.model, 'change', this.render);
  },
  onClick: function onClick() {
    this.showSettingsPopup();
  },
  onRemoveClick: function onRemoveClick(event) {
    event.stopPropagation();
    this.destroy();
    this.trigger('remove');
  },
  onDestroy: function onDestroy() {
    if (this.hasSettings()) {
      this.getSettingsPopup().destroy();
    }
    if (this.tagControlsStack) {
      this.tagControlsStack.destroy();
    }
  }
});

/***/ }),

/***/ "../assets/dev/js/editor/components/dynamic-tags/tag.js":
/*!**************************************************************!*\
  !*** ../assets/dev/js/editor/components/dynamic-tags/tag.js ***!
  \**************************************************************/
/***/ ((module) => {

"use strict";


module.exports = Marionette.ItemView.extend({
  hasTemplate: true,
  tagName: 'span',
  className: function className() {
    return 'elementor-tag';
  },
  getTemplate: function getTemplate() {
    if (!this.hasTemplate) {
      return false;
    }
    return Marionette.TemplateCache.get('#tmpl-elementor-tag-' + this.getOption('name') + '-content');
  },
  initialize: function initialize() {
    try {
      this.getTemplate();
    } catch (e) {
      this.hasTemplate = false;
    }
  },
  getConfig: function getConfig(key) {
    var config = elementor.dynamicTags.getConfig('tags.' + this.getOption('name'));
    if (key) {
      return config[key];
    }
    return config;
  },
  getContent: function getContent() {
    var contentType = this.getConfig('content_type'),
      data;
    if (!this.hasTemplate) {
      data = elementor.dynamicTags.loadTagDataFromCache(this);
      if (undefined === data) {
        throw new Error(elementor.dynamicTags.CACHE_KEY_NOT_FOUND_ERROR);
      }
    }
    if ('ui' === contentType) {
      this.render();
      if (this.hasTemplate) {
        return this.el.outerHTML;
      }
      if (this.getConfig('wrapped_tag')) {
        data = jQuery(data).html();
      }
      this.$el.html(data);
    }
    return data;
  },
  onRender: function onRender() {
    this.el.id = 'elementor-tag-' + this.getOption('id');
  }
});

/***/ }),

/***/ "../assets/dev/js/editor/components/hotkeys/component.js":
/*!***************************************************************!*\
  !*** ../assets/dev/js/editor/components/hotkeys/component.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _componentModalBase = _interopRequireDefault(__webpack_require__(/*! elementor-api/modules/component-modal-base */ "../modules/web-cli/assets/js/modules/component-modal-base.js"));
var _modalLayout = _interopRequireDefault(__webpack_require__(/*! ./modal-layout */ "../assets/dev/js/editor/components/hotkeys/modal-layout.js"));
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var Component = /*#__PURE__*/function (_ComponentModalBase) {
  (0, _inherits2.default)(Component, _ComponentModalBase);
  var _super = _createSuper(Component);
  function Component() {
    (0, _classCallCheck2.default)(this, Component);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(Component, [{
    key: "getNamespace",
    value: function getNamespace() {
      return 'shortcuts';
    }
  }, {
    key: "defaultShortcuts",
    value: function defaultShortcuts() {
      return {
        '': {
          keys: 'ctrl+?, shift+?',
          exclude: ['input']
        }
      };
    }
  }, {
    key: "getModalLayout",
    value: function getModalLayout() {
      return _modalLayout.default;
    }
  }]);
  return Component;
}(_componentModalBase.default);
exports["default"] = Component;

/***/ }),

/***/ "../assets/dev/js/editor/components/hotkeys/hotkeys.js":
/*!*************************************************************!*\
  !*** ../assets/dev/js/editor/components/hotkeys/hotkeys.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _component = _interopRequireDefault(__webpack_require__(/*! ./component */ "../assets/dev/js/editor/components/hotkeys/component.js"));
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var _default = /*#__PURE__*/function (_elementorModules$Mod) {
  (0, _inherits2.default)(_default, _elementorModules$Mod);
  var _super = _createSuper(_default);
  function _default() {
    (0, _classCallCheck2.default)(this, _default);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(_default, [{
    key: "onInit",
    value: function onInit() {
      $e.components.register(new _component.default({
        manager: this
      }));
    }
  }]);
  return _default;
}(elementorModules.Module);
exports["default"] = _default;

/***/ }),

/***/ "../assets/dev/js/editor/components/hotkeys/modal-content.js":
/*!*******************************************************************!*\
  !*** ../assets/dev/js/editor/components/hotkeys/modal-content.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _environment = _interopRequireDefault(__webpack_require__(/*! elementor-common/utils/environment */ "../core/common/assets/js/utils/environment.js"));
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var _default = /*#__PURE__*/function (_Marionette$LayoutVie) {
  (0, _inherits2.default)(_default, _Marionette$LayoutVie);
  var _super = _createSuper(_default);
  function _default() {
    (0, _classCallCheck2.default)(this, _default);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(_default, [{
    key: "id",
    value: function id() {
      return 'elementor-hotkeys';
    }
  }, {
    key: "templateHelpers",
    value: function templateHelpers() {
      return {
        environment: _environment.default
      };
    }
  }, {
    key: "getTemplate",
    value: function getTemplate() {
      return '#tmpl-elementor-hotkeys';
    }
  }]);
  return _default;
}(Marionette.LayoutView);
exports["default"] = _default;

/***/ }),

/***/ "../assets/dev/js/editor/components/hotkeys/modal-layout.js":
/*!******************************************************************!*\
  !*** ../assets/dev/js/editor/components/hotkeys/modal-layout.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var __ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["__"];


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _get3 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/get */ "../node_modules/@babel/runtime/helpers/get.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _modalContent = _interopRequireDefault(__webpack_require__(/*! ./modal-content */ "../assets/dev/js/editor/components/hotkeys/modal-content.js"));
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var _default = /*#__PURE__*/function (_elementorModules$com) {
  (0, _inherits2.default)(_default, _elementorModules$com);
  var _super = _createSuper(_default);
  function _default() {
    (0, _classCallCheck2.default)(this, _default);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(_default, [{
    key: "getModalOptions",
    value: function getModalOptions() {
      return {
        id: 'elementor-hotkeys__modal'
      };
    }
  }, {
    key: "getLogoOptions",
    value: function getLogoOptions() {
      return {
        title: __('Keyboard Shortcuts', 'elementor')
      };
    }
  }, {
    key: "initialize",
    value: function initialize() {
      var _get2;
      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }
      (_get2 = (0, _get3.default)((0, _getPrototypeOf2.default)(_default.prototype), "initialize", this)).call.apply(_get2, [this].concat(args));
      this.showLogo();
      this.showContentView();
    }
  }, {
    key: "showContentView",
    value: function showContentView() {
      this.modalContent.show(new _modalContent.default());
    }
  }]);
  return _default;
}(elementorModules.common.views.modal.Layout);
exports["default"] = _default;

/***/ }),

/***/ "../assets/dev/js/editor/components/icons-manager/classes/icon-library.js":
/*!********************************************************************************!*\
  !*** ../assets/dev/js/editor/components/icons-manager/classes/icon-library.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _typeof2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _default = /*#__PURE__*/function () {
  function _default() {
    var _this = this;
    (0, _classCallCheck2.default)(this, _default);
    (0, _defineProperty2.default)(this, "loaded", {});
    (0, _defineProperty2.default)(this, "notifyCallback", null);
    (0, _defineProperty2.default)(this, "fetchIcons", function (library) {
      fetch(library.fetchJson, {
        mode: 'cors'
      }).then(function (res) {
        return res.json();
      }).then(function (json) {
        library.icons = json.icons;
        return _this.normalizeIconList(library);
      });
    });
    (0, _defineProperty2.default)(this, "runCallback", function (library) {
      if ('function' !== typeof _this.notifyCallback) {
        return library;
      }
      return _this.notifyCallback(library);
    });
    (0, _defineProperty2.default)(this, "initIconType", function (libraryConfig, callback) {
      _this.notifyCallback = callback;
      var store = elementor.iconManager.store;
      if (_this.loaded[libraryConfig.name]) {
        libraryConfig.icons = store.getIcons(libraryConfig);
        return _this.runCallback(libraryConfig);
      }

      // Enqueue CSS
      if (libraryConfig.enqueue) {
        libraryConfig.enqueue.forEach(function (assetURL) {
          elementor.helpers.enqueueEditorStylesheet(assetURL);
        });
      }
      if (libraryConfig.url) {
        elementor.helpers.enqueueEditorStylesheet(libraryConfig.url);
      }

      // Already saved an stored
      if (store.isValid(libraryConfig)) {
        var data = store.get(store.getKey(libraryConfig));
        return _this.normalizeIconList(data);
      }

      // Comes with icons
      if (libraryConfig.icons && libraryConfig.icons.length) {
        return _this.normalizeIconList(libraryConfig);
      }

      // Get icons from via ajax
      if (libraryConfig.fetchJson) {
        return _this.fetchIcons(libraryConfig);
      }
      // @todo: error handling
    });
  }
  (0, _createClass2.default)(_default, [{
    key: "normalizeIconList",
    value: function normalizeIconList(library) {
      var icons = {};
      var name;
      jQuery.each(library.icons, function (index, icon) {
        name = icon;
        if ('object' === (0, _typeof2.default)(name)) {
          name = Object.entries(name)[0][0];
        }
        if (!name) {
          return;
        }
        icons[name] = {
          prefix: library.prefix,
          selector: library.prefix + name.trim(':'),
          name: elementorCommon.helpers.upperCaseWords(name).trim(':').split('-').join(' '),
          filter: name.trim(':'),
          displayPrefix: library.displayPrefix || library.prefix.replace('-', '')
        };
      });
      if (Object.keys(icons).length) {
        library.icons = icons;
        this.loaded[library.name] = true;
        elementor.iconManager.store.save(library);
        this.runCallback(library);
      }
    }
  }]);
  return _default;
}();
exports["default"] = _default;

/***/ }),

/***/ "../assets/dev/js/editor/components/icons-manager/classes/store.js":
/*!*************************************************************************!*\
  !*** ../assets/dev/js/editor/components/icons-manager/classes/store.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var Store = /*#__PURE__*/function () {
  function Store() {
    (0, _classCallCheck2.default)(this, Store);
  }
  (0, _createClass2.default)(Store, [{
    key: "save",
    value: function save(library) {
      elementorCommon.storage.set(Store.getKey(library), library);
    }
  }, {
    key: "getIcons",
    value: function getIcons(library) {
      var data = this.get(Store.getKey(library));
      if (data && data.icons) {
        return data.icons;
      }
      return false;
    }
  }, {
    key: "get",
    value: function get(key) {
      return elementorCommon.storage.get(key);
    }
  }, {
    key: "isValid",
    value: function isValid(library) {
      var saved = this.get(Store.getKey(library));
      if (!saved) {
        return false;
      }
      if (saved.ver !== library.ver) {
        // @todo: delete from localStorage if version is invalid
        return false;
      }
      return saved.icons && saved.icons.length;
    }
  }], [{
    key: "getKey",
    value: function getKey(library) {
      var name = library.name ? library.name : library;
      return "elementor_".concat(name, "_icons");
    }
  }]);
  return Store;
}();
var _default = Store;
exports["default"] = _default;

/***/ }),

/***/ "../assets/dev/js/editor/components/icons-manager/components/icon-list.js":
/*!********************************************************************************!*\
  !*** ../assets/dev/js/editor/components/icons-manager/components/icon-list.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _assertThisInitialized2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/assertThisInitialized */ "../node_modules/@babel/runtime/helpers/assertThisInitialized.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _react = _interopRequireWildcard(__webpack_require__(/*! react */ "react"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var LazyIconList = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(LazyIconList, _Component);
  var _super = _createSuper(LazyIconList);
  function LazyIconList() {
    var _this;
    (0, _classCallCheck2.default)(this, LazyIconList);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "state", {
      itemSize: {
        width: 0,
        height: 0
      },
      wrapperSize: {
        width: 0,
        height: 0
      },
      firstRowInView: 0
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "selectors", {
      item: '.elementor-icons-manager__tab__item',
      wrapper: 'elementor-icons-manager__tab__wrapper'
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "attachScrollListener", function () {
      var element = document.getElementById(_this.selectors.wrapper);
      if (element) {
        element.addEventListener('scroll', _this.handleScroll);
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "maybeMeasureItem", function () {
      if (_this.state.itemSize.width) {
        return;
      }
      // CSS Item Padding
      var itemPadding = 20,
        testElement = document.querySelector(_this.selectors.item);
      if (!testElement) {
        return;
      }
      var wrapper = document.getElementById(_this.selectors.wrapper);
      var newState = {
        itemSize: {
          width: testElement.offsetWidth + itemPadding,
          height: testElement.offsetHeight + itemPadding
        },
        wrapperSize: {
          width: wrapper.offsetWidth,
          height: wrapper.clientHeight
        }
      };
      return _this.setState(newState, function () {
        _this.maybeScrollToSelected();
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "maybeScrollToSelected", function () {
      if (!_this.hasSelected()) {
        return;
      }
      var selectedIndex = _this.props.selectedIndex,
        _this$state = _this.state,
        wrapperSize = _this$state.wrapperSize,
        itemSize = _this$state.itemSize,
        itemsInRow = Math.floor(wrapperSize.width / itemSize.width),
        selectedItemRow = Math.ceil(selectedIndex / itemsInRow) - 1,
        scrollTop = selectedItemRow * itemSize.height;
      setTimeout(function () {
        _this.props.parentRef.current.scrollTo({
          top: scrollTop,
          left: 0,
          behavior: 'auto'
        });
      }, 0);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleScroll", function () {
      _this.clearDebounceScrollCallback();
      _this._debounce = setTimeout(function () {
        var element = document.getElementById(_this.selectors.wrapper);
        var itemSize = _this.state.itemSize;
        _this.setState({
          firstRowInView: Math.floor(element.scrollTop / itemSize.height)
        });
      }, 10);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "render", function () {
      var _this$state2 = _this.state,
        itemSize = _this$state2.itemSize,
        wrapperSize = _this$state2.wrapperSize;
      var firstRowInView = _this.state.firstRowInView;
      if (!itemSize.width) {
        return _this.renderFirstElementForMeasurement();
      }
      var items = _this.props.items,
        itemsInRow = Math.floor(wrapperSize.width / itemSize.width),
        totalRows = Math.ceil(items.length / itemsInRow),
        spareRows = 4;
      var rowsInView = Math.ceil(wrapperSize.height / itemSize.height) + spareRows;
      if (rowsInView > totalRows) {
        rowsInView = totalRows;
      }

      // Prevent scroll overflow
      if (firstRowInView > totalRows - rowsInView) {
        firstRowInView = totalRows - rowsInView;
      }
      var tailRows = totalRows - firstRowInView - rowsInView,
        firstItemIndexInWindow = firstRowInView * itemsInRow,
        lastItemIndexInWindow = (firstRowInView + rowsInView) * itemsInRow - 1,
        itemsInView = items.slice(firstItemIndexInWindow, lastItemIndexInWindow + 1),
        offsetStyle = {
          height: "".concat(firstRowInView * itemSize.height, "px")
        },
        tailStyle = {
          height: "".concat(tailRows * itemSize.height, "px")
        };
      return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
        className: 'elementor-icons-manager__tab__content__offset',
        style: offsetStyle
      }), /*#__PURE__*/_react.default.createElement("div", {
        id: 'elementor-icons-manager__tab__content'
      }, itemsInView), /*#__PURE__*/_react.default.createElement("div", {
        className: 'elementor-icons-manager__tab__content__tail',
        style: tailStyle
      }));
    });
    return _this;
  }
  (0, _createClass2.default)(LazyIconList, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this.attachScrollListener();
      this.maybeMeasureItem();
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this.clearDebounceScrollCallback();
      var element = document.getElementById(this.selectors.wrapper);
      if (element) {
        element.removeEventListener('scroll', this.handleScroll);
      }
    }
  }, {
    key: "clearDebounceScrollCallback",
    value: function clearDebounceScrollCallback() {
      clearTimeout(this._debounce);
    }
  }, {
    key: "renderFirstElementForMeasurement",
    value: function renderFirstElementForMeasurement() {
      return /*#__PURE__*/_react.default.createElement("div", {
        id: 'elementor-icons-manager__tab__content'
      }, this.props.items[0]);
    }
  }, {
    key: "hasSelected",
    value: function hasSelected() {
      return -1 !== this.props.selectedIndex;
    }
  }]);
  return LazyIconList;
}(_react.Component);
var _default = LazyIconList;
exports["default"] = _default;
LazyIconList.propTypes = {
  items: _propTypes.default.array,
  selectedIndex: _propTypes.default.number,
  parentRef: _propTypes.default.any
};

/***/ }),

/***/ "../assets/dev/js/editor/components/icons-manager/components/icon-manager.js":
/*!***********************************************************************************!*\
  !*** ../assets/dev/js/editor/components/icons-manager/components/icon-manager.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var __ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["__"];


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.renderIconManager = exports["default"] = void 0;
var _react = _interopRequireWildcard(__webpack_require__(/*! react */ "react"));
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _assertThisInitialized2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/assertThisInitialized */ "../node_modules/@babel/runtime/helpers/assertThisInitialized.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _reactDom = __webpack_require__(/*! react-dom */ "react-dom");
var _tab = _interopRequireDefault(__webpack_require__(/*! ./tab */ "../assets/dev/js/editor/components/icons-manager/components/tab.js"));
var _iconsGoPro = _interopRequireDefault(__webpack_require__(/*! ./icons-go-pro */ "../assets/dev/js/editor/components/icons-manager/components/icons-go-pro.js"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var IconsManager = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(IconsManager, _Component);
  var _super = _createSuper(IconsManager);
  function IconsManager() {
    var _this;
    (0, _classCallCheck2.default)(this, IconsManager);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "scrollViewRef", (0, _react.createRef)());
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "state", {
      activeTab: _this.props.activeTab,
      selected: {
        library: '',
        value: ''
      },
      iconTabs: elementor.config.icons.libraries,
      loaded: _this.props.loaded,
      filter: ''
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "cache", {});
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "loadAllTabs", function () {
      var loaded = _this.state.loaded;
      var icons = _this.props.icons;
      icons.forEach(function (tabSettings) {
        if (loaded[tabSettings.name]) {
          return;
        }
        if (-1 < ['all', 'recommended'].indexOf(tabSettings.name)) {
          return;
        }
        elementor.iconManager.library.initIconType(_objectSpread({}, tabSettings), function (library) {
          _this.cache[library.name] = library;
          loaded[tabSettings.name] = true;
        });
      });
      loaded.all = true;
      loaded.recommended = true;
      _this.setState({
        loaded: loaded
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "getActiveTab", function () {
      var activeTab = _this.state.activeTab;
      var loaded = _this.state.loaded,
        icons = _this.props.icons;
      if (!activeTab) {
        if (_this.props.activeTab) {
          activeTab = _this.props.activeTab;
        }
      }
      if ('GoPro' === activeTab) {
        return activeTab;
      }
      if (!loaded[activeTab]) {
        return false;
      }
      var tabSettings = _objectSpread({}, icons.filter(function (tab) {
        return tab.name === activeTab;
      })[0]);
      if (loaded[activeTab]) {
        return _objectSpread({}, tabSettings);
      }
      if ('all' === tabSettings.name && !loaded.all) {
        return _this.loadAllTabs();
      }
      elementor.iconManager.library.initIconType(_objectSpread({}, tabSettings), function (library) {
        _this.cache[library.name] = library;
        _this.updateLoaded(library.name);
      });
      return false;
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "getIconTabsLinks", function () {
      var native = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;
      return _this.props.icons.map(function (tab) {
        if (native ^ _this.isNativeTab(tab)) {
          return '';
        }
        var isCurrentTab = tab.name === _this.state.activeTab;
        var className = 'elementor-icons-manager__tab-link';
        if (isCurrentTab) {
          className += ' elementor-active';
        }
        return (
          /*#__PURE__*/
          // eslint-disable-next-line jsx-a11y/click-events-have-key-events, jsx-a11y/no-static-element-interactions
          _react.default.createElement("div", {
            className: className,
            key: tab.name,
            onClick: function onClick() {
              if (isCurrentTab) {
                return;
              }
              _this.setState({
                activeTab: tab.name
              });
            }
          }, /*#__PURE__*/_react.default.createElement("i", {
            className: tab.labelIcon
          }), tab.label)
        );
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "getActiveTabIcons", function (activeTab) {
      if (activeTab.name) {
        return _this.getActiveTabIcons(activeTab.name);
      }
      if (_this.cache[activeTab]) {
        return _this.cache[activeTab].icons;
      }
      if ('recommended' === activeTab) {
        return _this.state.iconTabs[0].icons;
      }
      if ('all' === activeTab) {
        return _this.getAllIcons();
      }
      if (!_this.state.loaded[activeTab]) {
        var librarySettings = _this.props.icons.filter(function (library) {
          return activeTab === library.name;
        });
        return elementor.iconManager.library.initIconType(_objectSpread({}, librarySettings[0]), function (library) {
          _this.cache[library.name] = library;
          _this.updateLoaded(library.name);
        });
      }
      return elementor.iconManager.store.getIcons(activeTab);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "getAllIcons", function () {
      if (_this.cache.all) {
        return _this.cache.all.icons;
      }
      var icons = {};
      _this.props.icons.forEach(function (tabSettings) {
        if ('all' === tabSettings.name || 'recommended' === tabSettings.name) {
          return;
        }
        icons[tabSettings.name] = _this.getActiveTabIcons(tabSettings.name);
      });
      _this.cache.all = {
        icons: icons
      };
      return icons;
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleSearch", function (event) {
      var filter = event.target.value;
      if (filter && '' !== filter) {
        filter = filter.toLocaleLowerCase();
        if (_this.state.filter === filter) {
          return;
        }
      } else {
        filter = '';
      }
      _this.setState({
        filter: filter
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "setSelected", function (selected) {
      elementor.iconManager.setSettings('selectedIcon', selected);
      _this.setState({
        selected: selected
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "getSelected", function () {
      var selected = _this.state.selected;
      if ('' === selected.value && _this.props.selected && _this.props.selected.value) {
        selected = {
          value: _this.props.selected.value,
          library: _this.props.selected.library
        };
      }
      return selected;
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "render", function () {
      var activeTab = _this.getActiveTab(),
        activeTabName = activeTab.name ? activeTab.name : activeTab,
        _this$props$showSearc = _this.props.showSearch,
        showSearch = _this$props$showSearc === void 0 ? true : _this$props$showSearc,
        filter = _this.state.filter;
      if ('GoPro' !== activeTab) {
        if (!activeTabName || !_this.state.loaded[activeTabName]) {
          return 'Loading';
        }
        if (activeTab) {
          activeTab.icons = _this.getActiveTabIcons(activeTab);
        }
      }
      var selected = _this.getSelected();
      return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
        id: "elementor-icons-manager__sidebar",
        className: 'elementor-templates-modal__sidebar'
      }, /*#__PURE__*/_react.default.createElement("div", {
        id: "elementor-icons-manager__tab-links"
      }, _this.getIconTabsLinks(), _this.getUploadCustomButton(), _this.getIconTabsLinks(false))), /*#__PURE__*/_react.default.createElement("div", {
        id: "elementor-icons-manager__main",
        className: 'elementor-templates-modal__content'
      }, 'GoPro' === activeTabName ? /*#__PURE__*/_react.default.createElement(_iconsGoPro.default, null) : /*#__PURE__*/_react.default.createElement(_react.Fragment, null, showSearch ? _this.getSearchHTML() : '', /*#__PURE__*/_react.default.createElement("div", {
        id: "elementor-icons-manager__tab__wrapper",
        ref: _this.scrollViewRef
      }, /*#__PURE__*/_react.default.createElement("div", {
        id: "elementor-icons-manager__tab__title"
      }, activeTab.label), /*#__PURE__*/_react.default.createElement("div", {
        id: "elementor-icons-manager__tab__content_wrapper"
      }, /*#__PURE__*/_react.default.createElement("input", {
        type: "hidden",
        name: "icon_value",
        id: "icon_value",
        value: selected.value
      }), /*#__PURE__*/_react.default.createElement("input", {
        type: "hidden",
        name: "icon_type",
        id: "icon_type",
        value: selected.library
      }), _this.state.loaded[activeTab.name] ? /*#__PURE__*/_react.default.createElement(_tab.default, (0, _extends2.default)({
        setSelected: _this.setSelected,
        selected: selected,
        filter: filter,
        key: activeTab.name,
        parentRef: _this.scrollViewRef
      }, activeTab)) : 'Loading')))));
    });
    return _this;
  }
  (0, _createClass2.default)(IconsManager, [{
    key: "updateLoaded",
    value: function updateLoaded(libraryName) {
      var loaded = this.state.loaded;
      loaded[libraryName] = true;
      this.setState({
        loaded: loaded
      });
    }
  }, {
    key: "isNativeTab",
    value: function isNativeTab(tab) {
      return ('all' === tab.name || 'recommended' === tab.name || 'fa-' === tab.name.substr(0, 3)) && tab.native;
    }
  }, {
    key: "getUploadCustomButton",
    value: function getUploadCustomButton() {
      var _this2 = this;
      var onClick = function onClick() {
        if ('GoPro' === _this2.state.activeTab) {
          return;
        }
        _this2.setState({
          activeTab: 'GoPro'
        });
      };
      if (this.props.customIconsURL) {
        onClick = function onClick() {
          window.open(_this2.props.customIconsURL, '_blank');
        };
      }
      return /*#__PURE__*/_react.default.createElement("div", {
        id: "elementor-icons-manager__upload"
      }, /*#__PURE__*/_react.default.createElement("div", {
        id: "elementor-icons-manager__upload__title"
      }, __('My Libraries', 'elementor')), /*#__PURE__*/_react.default.createElement("button", {
        id: "elementor-icons-manager__upload__button",
        className: "elementor-button",
        onClick: onClick
      }, __('Upload', 'elementor')));
    }
  }, {
    key: "getSearchHTML",
    value: function getSearchHTML() {
      return /*#__PURE__*/_react.default.createElement("div", {
        id: "elementor-icons-manager__search"
      }, /*#__PURE__*/_react.default.createElement("input", {
        placeholder: 'Filter by name...',
        onInput: this.handleSearch
      }), /*#__PURE__*/_react.default.createElement("i", {
        className: 'eicon-search'
      }));
    }
  }]);
  return IconsManager;
}(_react.Component);
var _default = IconsManager;
exports["default"] = _default;
var renderIconManager = function renderIconManager(props) {
  var containerElement = document.querySelector('#elementor-icons-manager-modal .dialog-content');
  return (0, _reactDom.render)( /*#__PURE__*/_react.default.createElement(IconsManager, (0, _extends2.default)({}, props, {
    containerElement: containerElement
  })), containerElement);
};
exports.renderIconManager = renderIconManager;
IconsManager.propTypes = {
  activeTab: _propTypes.default.any,
  customIconsURL: _propTypes.default.string,
  icons: _propTypes.default.any,
  loaded: _propTypes.default.any,
  modalView: _propTypes.default.any,
  recommended: _propTypes.default.oneOfType([_propTypes.default.bool, _propTypes.default.object]),
  selected: _propTypes.default.any,
  showSearch: _propTypes.default.bool
};

/***/ }),

/***/ "../assets/dev/js/editor/components/icons-manager/components/icon.js":
/*!***************************************************************************!*\
  !*** ../assets/dev/js/editor/components/icons-manager/components/icon.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireWildcard(__webpack_require__(/*! react */ "react"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _assertThisInitialized2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/assertThisInitialized */ "../node_modules/@babel/runtime/helpers/assertThisInitialized.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var Icon = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(Icon, _Component);
  var _super = _createSuper(Icon);
  function Icon() {
    var _this;
    (0, _classCallCheck2.default)(this, Icon);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "setSelected", function () {
      _this.props.setSelectedHandler({
        value: _this.props.data.displayPrefix + ' ' + _this.props.data.selector,
        library: _this.props.library
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "render", function () {
      return (
        /*#__PURE__*/
        // eslint-disable-next-line jsx-a11y/click-events-have-key-events, jsx-a11y/no-static-element-interactions
        _react.default.createElement("div", {
          className: _this.props.containerClass,
          key: _this.props.keyID,
          onClick: _this.setSelected,
          filter: _this.props.data.filter
        }, /*#__PURE__*/_react.default.createElement("div", {
          className: "elementor-icons-manager__tab__item__content"
        }, /*#__PURE__*/_react.default.createElement("i", {
          className: 'elementor-icons-manager__tab__item__icon ' + _this.props.className
        }), /*#__PURE__*/_react.default.createElement("div", {
          className: 'elementor-icons-manager__tab__item__name',
          title: _this.props.data.name
        }, _this.props.data.name)))
      );
    });
    return _this;
  }
  return (0, _createClass2.default)(Icon);
}(_react.Component);
exports["default"] = Icon;
Icon.propTypes = {
  className: _propTypes.default.string,
  containerClass: _propTypes.default.string,
  data: _propTypes.default.object,
  keyID: _propTypes.default.string,
  library: _propTypes.default.string,
  selector: _propTypes.default.string,
  setSelectedHandler: _propTypes.default.func
};

/***/ }),

/***/ "../assets/dev/js/editor/components/icons-manager/components/icons-go-pro.js":
/*!***********************************************************************************!*\
  !*** ../assets/dev/js/editor/components/icons-manager/components/icons-go-pro.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var __ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["__"];


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireWildcard(__webpack_require__(/*! react */ "react"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _assertThisInitialized2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/assertThisInitialized */ "../node_modules/@babel/runtime/helpers/assertThisInitialized.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var IconsGoPro = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(IconsGoPro, _Component);
  var _super = _createSuper(IconsGoPro);
  function IconsGoPro() {
    var _this;
    (0, _classCallCheck2.default)(this, IconsGoPro);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "render", function () {
      return /*#__PURE__*/_react.default.createElement("div", {
        id: "elementor-icons-manager__promotion"
      }, /*#__PURE__*/_react.default.createElement("i", {
        id: "elementor-icons-manager__promotion__icon",
        className: "eicon-nerd"
      }), /*#__PURE__*/_react.default.createElement("div", {
        id: "elementor-icons-manager__promotion__text"
      }, __('Become a Pro user to upload unlimited font icon folders to your website.', 'elementor')), /*#__PURE__*/_react.default.createElement("a", {
        href: elementor.config.icons.goProURL,
        id: "elementor-icons-manager__promotion__link",
        className: "elementor-button go-pro",
        target: "_blank",
        rel: "noopener noreferrer"
      }, __('Upgrade Now', 'elementor')));
    });
    return _this;
  }
  return (0, _createClass2.default)(IconsGoPro);
}(_react.Component);
var _default = IconsGoPro;
exports["default"] = _default;

/***/ }),

/***/ "../assets/dev/js/editor/components/icons-manager/components/tab.js":
/*!**************************************************************************!*\
  !*** ../assets/dev/js/editor/components/icons-manager/components/tab.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireWildcard(__webpack_require__(/*! react */ "react"));
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "../node_modules/@babel/runtime/helpers/slicedToArray.js"));
var _toConsumableArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/toConsumableArray */ "../node_modules/@babel/runtime/helpers/toConsumableArray.js"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _assertThisInitialized2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/assertThisInitialized */ "../node_modules/@babel/runtime/helpers/assertThisInitialized.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _iconList = _interopRequireDefault(__webpack_require__(/*! ./icon-list */ "../assets/dev/js/editor/components/icons-manager/components/icon-list.js"));
var _icon = _interopRequireDefault(__webpack_require__(/*! ./icon */ "../assets/dev/js/editor/components/icons-manager/components/icon.js"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var Tab = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(Tab, _Component);
  var _super = _createSuper(Tab);
  function Tab() {
    var _this;
    (0, _classCallCheck2.default)(this, Tab);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "componentDidMount", function () {
      if (_this.props.selected && _this.props.selected.value) {
        setTimeout(function () {
          var element = document.querySelector('.elementor-selected');
          if (element) {
            element.scrollIntoView(false);
          }
        }, 0);
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleFullIconList", function () {
      var fullIconList = [];
      Object.entries(_this.props.icons).forEach(function (library) {
        if ('recommended' !== library[0]) {
          fullIconList = [].concat((0, _toConsumableArray2.default)(fullIconList), (0, _toConsumableArray2.default)(_this.getIconsOfType(library[0], library[1])));
        }
      });
      return fullIconList.sort(function (a, b) {
        return a.filter === b.filter ? 0 : +(a.filter > b.filter) || -1;
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "getLibrary", function (libraryName) {
      var icons = elementor.config.icons.libraries.filter(function (library) {
        return libraryName === library.name;
      });
      return icons;
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleRecommendedList", function () {
      var recommendedIconList = [];
      Object.entries(_this.props.icons).forEach(function (library) {
        var iconLibrary = _this.getLibrary(library[0]),
          iconsOfType = iconLibrary[0].icons,
          recommendedIconsOfType = {};
        library[1].forEach(function (iconName) {
          if (iconsOfType[iconName]) {
            recommendedIconsOfType[iconName] = iconsOfType[iconName];
          }
        });
        recommendedIconList = [].concat((0, _toConsumableArray2.default)(recommendedIconList), (0, _toConsumableArray2.default)(_this.getIconsOfType(library[0], recommendedIconsOfType)));
      });
      return recommendedIconList;
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "getIconsComponentList", function () {
      var iconsToShow = [];
      var _this$props = _this.props,
        name = _this$props.name,
        icons = _this$props.icons,
        filter = _this$props.filter;
      switch (name) {
        case 'all':
          iconsToShow = _this.handleFullIconList();
          break;
        case 'recommended':
          iconsToShow = _this.handleRecommendedList();
          break;
        default:
          iconsToShow = _this.getIconsOfType(name, icons);
          break;
      }
      if (filter) {
        iconsToShow = Object.values(iconsToShow).filter(function (icon) {
          return icon.props.data.name.toLowerCase().indexOf(filter) > -1;
        });
      }
      return iconsToShow;
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "render", function () {
      var icons = _this.getIconsComponentList();
      var selectedIndex = -1;
      var _iterator = _createForOfIteratorHelper(icons.entries()),
        _step;
      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var _step$value = (0, _slicedToArray2.default)(_step.value, 2),
            index = _step$value[0],
            icon = _step$value[1];
          if (icon.props.containerClass.includes('elementor-selected')) {
            selectedIndex = index;
            break;
          }
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }
      return /*#__PURE__*/_react.default.createElement(_iconList.default, {
        selectedIndex: selectedIndex,
        items: icons,
        parentRef: _this.props.parentRef
      });
    });
    return _this;
  }
  (0, _createClass2.default)(Tab, [{
    key: "getIconsOfType",
    value: function getIconsOfType(type, icons) {
      var _this2 = this;
      var _this$props2 = this.props,
        selected = _this$props2.selected,
        filter = _this$props2.filter;
      return Object.entries(icons).map(function (icon) {
        var iconData = icon[1],
          iconName = icon[0],
          className = iconData.displayPrefix + ' ' + iconData.selector;
        var containerClass = 'elementor-icons-manager__tab__item';
        if (selected.value === className) {
          containerClass += ' elementor-selected';
        }
        var key = containerClass + type + '-' + iconName + filter;
        return /*#__PURE__*/_react.default.createElement(_icon.default, {
          key: key,
          library: type,
          keyID: iconName,
          containerClass: containerClass,
          className: className,
          setSelectedHandler: _this2.props.setSelected,
          data: iconData
        });
      });
    }
  }]);
  return Tab;
}(_react.Component);
Tab.propTypes = {
  data: _propTypes.default.any,
  filter: _propTypes.default.any,
  icons: _propTypes.default.object,
  name: _propTypes.default.string,
  selected: _propTypes.default.object,
  setSelected: _propTypes.default.func,
  parentRef: _propTypes.default.any
};
var _default = Tab;
exports["default"] = _default;

/***/ }),

/***/ "../assets/dev/js/editor/components/icons-manager/icons-manager.js":
/*!*************************************************************************!*\
  !*** ../assets/dev/js/editor/components/icons-manager/icons-manager.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var __ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["__"];


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _modalLayout = _interopRequireDefault(__webpack_require__(/*! ./modal-layout */ "../assets/dev/js/editor/components/icons-manager/modal-layout.js"));
var _iconManager = __webpack_require__(/*! ./components/icon-manager */ "../assets/dev/js/editor/components/icons-manager/components/icon-manager.js");
var _iconLibrary = _interopRequireDefault(__webpack_require__(/*! ./classes/icon-library */ "../assets/dev/js/editor/components/icons-manager/classes/icon-library.js"));
var _store = _interopRequireDefault(__webpack_require__(/*! ./classes/store */ "../assets/dev/js/editor/components/icons-manager/classes/store.js"));
var _reactDom = __webpack_require__(/*! react-dom */ "react-dom");
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var _default = /*#__PURE__*/function (_elementorModules$Mod) {
  (0, _inherits2.default)(_default, _elementorModules$Mod);
  var _super = _createSuper(_default);
  function _default() {
    (0, _classCallCheck2.default)(this, _default);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(_default, [{
    key: "onInit",
    value: function onInit() {
      // Init icon library helper
      this.library = new _iconLibrary.default();
      // Init Icon library Storage helper
      this.store = new _store.default();
      // Fetch fa4 to fa5 migration data
      elementor.helpers.fetchFa4ToFa5Mapping();
      this.cache = {};
    }
  }, {
    key: "getLayout",
    value: function getLayout() {
      var _this = this;
      if (!this.layout) {
        this.layout = new _modalLayout.default();
        var layoutModal = this.layout.getModal();
        layoutModal.addButton({
          name: 'insert_icon',
          text: __('Insert', 'elementor'),
          classes: 'elementor-button e-primary',
          callback: function callback() {
            _this.updateControlValue();
            _this.unMountIconManager();
          }
        });
        layoutModal.on('show', this.onPickerShow.bind(this)).on('hide', this.unMountIconManager);
      }
      return this.layout;
    }
  }, {
    key: "getDefaultSettings",
    value: function getDefaultSettings() {
      return {
        selectedIcon: {}
      };
    }
  }, {
    key: "unMountIconManager",
    value: function unMountIconManager() {
      var containerElement = document.querySelector('#elementor-icons-manager-modal .dialog-content');
      (0, _reactDom.unmountComponentAtNode)(containerElement);
    }
  }, {
    key: "loadIconLibraries",
    value: function loadIconLibraries() {
      if (!this.cache.loaded) {
        elementor.config.icons.libraries.forEach(function (library) {
          if ('all' === library.name) {
            return;
          }
          elementor.iconManager.library.initIconType(library);
        });
        this.cache.loaded = true;
      }
    }
  }, {
    key: "onPickerShow",
    value: function onPickerShow() {
      var controlView = this.getSettings('controlView'),
        loaded = {
          GoPro: true
        },
        iconManagerConfig = {
          recommended: controlView.model.get('recommended') || false
        };
      var selected = controlView.getControlValue(),
        icons = elementor.config.icons.libraries;
      if (!selected.library || !selected.value) {
        selected = {
          value: '',
          library: ''
        };
      }
      iconManagerConfig.selected = selected;
      this.setSettings('selectedIcon', selected);
      if (iconManagerConfig.recommended) {
        var hasRecommended = false;
        icons.forEach(function (library, index) {
          if ('recommended' === library.name) {
            hasRecommended = true;
            icons[index].icons = iconManagerConfig.recommended;
          }
        });
        if (!hasRecommended) {
          icons.unshift({
            name: 'recommended',
            label: 'Recommended',
            icons: iconManagerConfig.recommended,
            labelIcon: 'eicon-star-o',
            native: true
          });
        }
      } else {
        icons = icons.filter(function (library) {
          return 'recommended' !== library.name;
        });
      }
      icons.forEach(function (tab, index) {
        if (-1 === ['all', 'recommended'].indexOf(tab.name)) {
          elementor.iconManager.library.initIconType(tab, function (lib) {
            icons[index] = lib;
          });
        }
        loaded[tab.name] = true;
      });
      iconManagerConfig.loaded = loaded;
      iconManagerConfig.icons = icons;

      // Set active tab
      var activeTab = selected.library || icons[0].name;
      if ('svg' === selected.library) {
        activeTab = icons[0].name;
      }

      // Selected Library exists
      if (!Object.keys(icons).some(function (library) {
        return library === activeTab;
      })) {
        activeTab = icons[0].name;
      }

      // Show recommended tab if selected from it
      if (iconManagerConfig.recommended && '' !== selected.library && '' !== selected.value && Object.prototype.hasOwnProperty.call(iconManagerConfig.recommended, selected.library)) {
        var iconLibrary = icons.filter(function (library) {
          return selected.library === library.name;
        });
        var selectedIconName = selected.value.replace(iconLibrary[0].displayPrefix + ' ' + iconLibrary[0].prefix, '');
        if (iconManagerConfig.recommended[selected.library].some(function (icon) {
          return -1 < icon.indexOf(selectedIconName);
        })) {
          activeTab = icons[0].name;
        }
      }
      iconManagerConfig.customIconsURL = elementor.config.customIconsURL;
      iconManagerConfig.activeTab = activeTab;
      return (0, _iconManager.renderIconManager)(iconManagerConfig);
    }
  }, {
    key: "updateControlValue",
    value: function updateControlValue() {
      var settings = this.getSettings();
      settings.controlView.setValue(settings.selectedIcon);
      settings.controlView.applySavedValue();
    }
  }, {
    key: "show",
    value: function show(options) {
      this.setSettings('controlView', options.view);
      this.getLayout().showModal(options);
    }
  }]);
  return _default;
}(elementorModules.Module);
exports["default"] = _default;

/***/ }),

/***/ "../assets/dev/js/editor/components/icons-manager/modal-layout.js":
/*!************************************************************************!*\
  !*** ../assets/dev/js/editor/components/icons-manager/modal-layout.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var __ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["__"];


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _get3 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/get */ "../node_modules/@babel/runtime/helpers/get.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _layout = _interopRequireDefault(__webpack_require__(/*! elementor-common/views/modal/layout */ "../core/common/assets/js/views/modal/layout.js"));
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var _default = /*#__PURE__*/function (_BaseModalLayout) {
  (0, _inherits2.default)(_default, _BaseModalLayout);
  var _super = _createSuper(_default);
  function _default() {
    (0, _classCallCheck2.default)(this, _default);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(_default, [{
    key: "getModalOptions",
    value: function getModalOptions() {
      return {
        id: 'elementor-icons-manager-modal'
      };
    }
  }, {
    key: "getLogoOptions",
    value: function getLogoOptions() {
      return {
        title: __('Icon Library', 'elementor')
      };
    }
  }, {
    key: "initialize",
    value: function initialize() {
      var _get2;
      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }
      (_get2 = (0, _get3.default)((0, _getPrototypeOf2.default)(_default.prototype), "initialize", this)).call.apply(_get2, [this].concat(args));
      this.showLogo();
    }
  }]);
  return _default;
}(_layout.default);
exports["default"] = _default;

/***/ }),

/***/ "../assets/dev/js/editor/components/preview/commands/drop.js":
/*!*******************************************************************!*\
  !*** ../assets/dev/js/editor/components/preview/commands/drop.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Drop = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var Drop = /*#__PURE__*/function (_$e$modules$CommandBa) {
  (0, _inherits2.default)(Drop, _$e$modules$CommandBa);
  var _super = _createSuper(Drop);
  function Drop() {
    (0, _classCallCheck2.default)(this, Drop);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(Drop, [{
    key: "validateArgs",
    value: function validateArgs() {
      var args = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      this.requireContainer(args);
      this.requireArgumentType('model', 'object', args);
    }
  }, {
    key: "apply",
    value: function apply() {
      var args = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var _args$containers = args.containers,
        containers = _args$containers === void 0 ? [args.container] : _args$containers,
        _args$options = args.options,
        options = _args$options === void 0 ? {} : _args$options,
        result = [];
      containers.forEach(function (container) {
        result.push(container.view.createElementFromModel(args.model, options));
      });
      if (1 === containers.length) {
        return result[0];
      }
      return result;
    }
  }]);
  return Drop;
}($e.modules.CommandBase);
exports.Drop = Drop;

/***/ }),

/***/ "../assets/dev/js/editor/components/preview/commands/index.js":
/*!********************************************************************!*\
  !*** ../assets/dev/js/editor/components/preview/commands/index.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
Object.defineProperty(exports, "Drop", ({
  enumerable: true,
  get: function get() {
    return _drop.Drop;
  }
}));
Object.defineProperty(exports, "Reload", ({
  enumerable: true,
  get: function get() {
    return _reload.Reload;
  }
}));
var _drop = __webpack_require__(/*! ./drop */ "../assets/dev/js/editor/components/preview/commands/drop.js");
var _reload = __webpack_require__(/*! ./reload */ "../assets/dev/js/editor/components/preview/commands/reload.js");

/***/ }),

/***/ "../assets/dev/js/editor/components/preview/commands/reload.js":
/*!*********************************************************************!*\
  !*** ../assets/dev/js/editor/components/preview/commands/reload.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Reload = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var Reload = /*#__PURE__*/function (_$e$modules$CommandBa) {
  (0, _inherits2.default)(Reload, _$e$modules$CommandBa);
  var _super = _createSuper(Reload);
  function Reload() {
    (0, _classCallCheck2.default)(this, Reload);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(Reload, [{
    key: "apply",
    value: function apply() {
      elementor.reloadPreview();
    }
  }]);
  return Reload;
}($e.modules.CommandBase);
exports.Reload = Reload;

/***/ }),

/***/ "../assets/dev/js/editor/components/preview/component.js":
/*!***************************************************************!*\
  !*** ../assets/dev/js/editor/components/preview/component.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var commands = _interopRequireWildcard(__webpack_require__(/*! ./commands/ */ "../assets/dev/js/editor/components/preview/commands/index.js"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var Component = /*#__PURE__*/function (_$e$modules$Component) {
  (0, _inherits2.default)(Component, _$e$modules$Component);
  var _super = _createSuper(Component);
  function Component() {
    (0, _classCallCheck2.default)(this, Component);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(Component, [{
    key: "getNamespace",
    value: function getNamespace() {
      return 'preview';
    }
  }, {
    key: "defaultCommands",
    value: function defaultCommands() {
      return this.importCommands(commands);
    }
  }]);
  return Component;
}($e.modules.ComponentBase);
exports["default"] = Component;

/***/ }),

/***/ "../assets/dev/js/editor/components/selection/manager.js":
/*!***************************************************************!*\
  !*** ../assets/dev/js/editor/components/selection/manager.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _assertThisInitialized2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/assertThisInitialized */ "../node_modules/@babel/runtime/helpers/assertThisInitialized.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
/**
 * @typedef {import('../../container/container')} Container
 */
var Manager = /*#__PURE__*/function (_elementorModules$edi) {
  (0, _inherits2.default)(Manager, _elementorModules$edi);
  var _super = _createSuper(Manager);
  /**
   * Manager constructor.
   *
   * @return {Manager} manager
   */
  function Manager() {
    var _this;
    (0, _classCallCheck2.default)(this, Manager);
    _this = _super.call(this);

    // Using a Proxy in order to use update methods only once on external invocations, but internally the `add` or
    // `remove` methods may be executed many times, when update methods will be used only once.
    /**
     * Selected elements.
     *
     * The list of the selected elements.
     *
     * @type {{}}
     */
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "elements", {});
    /**
     * Selected elements type.
     *
     * Represents the common type of multiple selected elements, or false when the selected elements are of different
     * types.
     *
     * @type {string|boolean}
     */
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "type", false);
    return (0, _possibleConstructorReturn2.default)(_this, new Proxy((0, _assertThisInitialized2.default)(_this), {
      get: function get(target, prop) {
        if (['add', 'remove'].includes(prop)) {
          return function () {
            var result = target[prop].apply(target, arguments);
            target.updateType();
            target.updateSortable();
            target.updatePanelPage();
            target.updateNavigator();
            return result;
          };
        }
        return Reflect.get.apply(Reflect, arguments);
      }
    }));
  }

  /**
   * Get selection elements.
   *
   * Get the list of selected elements as an array of containers. If a fallback element container specified, it will
   * be returned when there are no selected elements.
   *
   * @param {Container[]|Container} fallback
   * @return {Container[]} selection elements
   */
  (0, _createClass2.default)(Manager, [{
    key: "getElements",
    value: function getElements() {
      var fallback = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
      var result = Object.values(this.elements);
      if (!result.length && fallback) {
        result = Array.isArray(fallback) ? fallback : [fallback];
      }
      return result;
    }

    /**
     * Add elements to selection.
     *
     * Add new elements to selection by their container, and clear the currently selected elements unless appending is
     * active, in which case the new elements are just added to the current selection.
     *
     * @param {Container[]|Container} containers
     * @param {boolean}               append
     */
  }, {
    key: "add",
    value: function add(containers) {
      var append = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      containers = Array.isArray(containers) ? containers : [containers];

      // If command/ctrl+click not clicked, clear selected elements.
      if (!append) {
        this.remove([], true);
      }
      var _iterator = _createForOfIteratorHelper(containers),
        _step;
      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var container = _step.value;
          this.elements[container.id] = container;
          container.view.select();
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }
    }

    /**
     * Remove elements from selection.
     *
     * Remove elements from selection by their container, unless the parameter for clearing all selected elements is
     * active, in which case the the whole selection is cleared.
     *
     * @param {Container[]|Container} containers
     * @param {boolean}               all
     */
  }, {
    key: "remove",
    value: function remove(containers) {
      var all = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      containers = Array.isArray(containers) ? containers : [containers];
      if (all) {
        containers = this.getElements();
      }
      var _iterator2 = _createForOfIteratorHelper(containers),
        _step2;
      try {
        for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
          var container = _step2.value;
          delete this.elements[container.id];
          container.view.deselect();
        }
      } catch (err) {
        _iterator2.e(err);
      } finally {
        _iterator2.f();
      }
    }

    /**
     * Does element selected.
     *
     * Check whether an element container exists in the selected elements.
     *
     * @param {Container} container
     * @return {boolean} true if the container exists in the selected elements
     */
  }, {
    key: "has",
    value: function has(container) {
      return this.getElements().includes(container);
    }

    /**
     * Update selected elements type.
     *
     * Resolve the common type of all selected elements and assign it as class property. When the selected objects are
     * of different types, `false` is assigned.
     */
  }, {
    key: "updateType",
    value: function updateType() {
      var elements = this.getElements();
      this.type = Boolean(elements.length) && elements.reduce(function (previous, current) {
        if (previous === current.type) {
          return current.type;
        }
        return false;
      }, elements[0].type);
    }

    /**
     * Update sortable state.
     *
     * In case more than one element is selected, currently sorting supposed to be disabled, and vice-versa.
     */
  }, {
    key: "updateSortable",
    value: function updateSortable() {
      elementor.toggleSortableState(!this.isMultiple());
    }

    /**
     * Update the panel page.
     *
     * Selected elements affect the panel panel in a way that when element is selected - its settings page is displayed,
     * and when the element is blurred (unfocused) - the the default page opened. When more than one element selected,
     * the default page should appear.
     */
  }, {
    key: "updatePanelPage",
    value: function updatePanelPage() {
      var elements = this.getElements();
      if (1 === elements.length) {
        $e.run('panel/editor/open', {
          model: elements[0].model,
          view: elements[0].view
        });
      } else {
        $e.internal('panel/open-default', {
          autoFocusSearch: false
        });
      }
    }

    /**
     * Update navigator selections.
     *
     * Any change in the document selected elements should be reflected in the navigator, this method is responsible for
     * updating the navigator.
     */
  }, {
    key: "updateNavigator",
    value: function updateNavigator() {
      elementor.navigator.getLayout().elements.currentView.recursiveChildInvoke('updateSelection');
    }

    /**
     * Is multiple selection.
     *
     * Check whether multiple elements were selected.
     *
     * @return {boolean} true if multiple elements were selected
     */
  }, {
    key: "isMultiple",
    value: function isMultiple() {
      return this.getElements().length > 1;
    }

    /**
     * Is selection of same type.
     *
     * Check whether the selected elements are of same type.
     *
     * @return {boolean} true if the selected elements are of same type
     */
  }, {
    key: "isSameType",
    value: function isSameType() {
      return !this.getElements().length || Boolean(this.type);
    }
  }]);
  return Manager;
}(elementorModules.editor.utils.Module);
exports["default"] = Manager;

/***/ }),

/***/ "../assets/dev/js/editor/components/settings/base/manager.js":
/*!*******************************************************************!*\
  !*** ../assets/dev/js/editor/components/settings/base/manager.js ***!
  \*******************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var ControlsCSSParser = __webpack_require__(/*! elementor-editor-utils/controls-css-parser */ "../assets/dev/js/editor/utils/controls-css-parser.js");
module.exports = elementorModules.ViewModule.extend({
  model: null,
  hasChange: false,
  changeCallbacks: {},
  addChangeCallback: function addChangeCallback(attribute, callback) {
    this.changeCallbacks[attribute] = callback;
  },
  bindEvents: function bindEvents() {
    elementor.on('document:loaded', this.onElementorDocumentLoaded);
    this.model.on('change', this.onModelChange);
  },
  unbindEvents: function unbindEvents() {
    elementor.off('document:loaded', this.onElementorDocumentLoaded);
  },
  addPanelPage: function addPanelPage() {
    var name = this.getSettings('name');
    elementor.getPanelView().addPage(name + '_settings', {
      view: elementor.settings.panelPages[name] || elementor.settings.panelPages.base,
      title: this.getSettings('panelPage.title'),
      options: {
        editedView: this.getEditedView(),
        model: this.model,
        controls: this.model.controls,
        name: name
      }
    });
  },
  getContainerType: function getContainerType() {
    return this.getSettings('name') + '_settings';
  },
  /**
   * @deprecated since 3.7.0, use `getContainerType()` instead.
   */
  getContainerId: function getContainerId() {
    elementorDevTools.deprecation.deprecated('getContainerId()', '3.7.0', 'getContainerType()');
    return this.getContainerType();
  },
  // Emulate an element view/model structure with the parts needed for a container.
  getEditedView: function getEditedView() {
    var documentElementType = elementor.elementsManager.getElementTypeClass('document'),
      ModelClass = documentElementType.getModel(),
      type = this.getContainerType(),
      editModel = new ModelClass({
        id: type,
        elType: type,
        settings: this.model
      });
    var container = new elementorModules.editor.Container({
      type: type,
      id: type,
      model: editModel,
      settings: editModel.get('settings'),
      view: false,
      parent: false,
      label: this.getSettings('panelPage').title,
      controls: this.model.controls,
      document: this.getDocument(),
      renderer: false
    });
    return {
      getContainer: function getContainer() {
        return container;
      },
      getEditModel: function getEditModel() {
        return editModel;
      },
      model: editModel,
      container: container
    };
  },
  getDocument: function getDocument() {
    return false;
  },
  updateStylesheet: function updateStylesheet(keepOldEntries) {
    var controlsCSS = this.getControlsCSS();
    if (!keepOldEntries) {
      controlsCSS.stylesheet.empty();
    }
    this.model.handleRepeaterData(this.model.attributes);
    controlsCSS.addStyleRules(this.model.getStyleControls(), this.model.attributes, this.model.controls, [/{{WRAPPER}}/g], [this.getSettings('cssWrapperSelector')]);
    controlsCSS.addStyleToDocument({
      // Ensures we don't override default global style
      at: 'before',
      of: '#elementor-style-e-global-style'
    });
  },
  initModel: function initModel() {
    this.model = new elementorModules.editor.elements.models.BaseSettings(this.getSettings('settings'), {
      controls: this.getSettings('controls')
    });
  },
  getStyleId: function getStyleId() {
    return this.getSettings('name');
  },
  initControlsCSSParser: function initControlsCSSParser() {
    var controlsCSS;
    this.destroyControlsCSS = function () {
      controlsCSS.removeStyleFromDocument();
    };
    this.getControlsCSS = function () {
      if (!controlsCSS) {
        controlsCSS = new ControlsCSSParser({
          id: this.getStyleId(),
          settingsModel: this.model,
          context: this.getEditedView()
        });
      }
      return controlsCSS;
    };
  },
  getDataToSave: function getDataToSave(data) {
    return data;
  },
  save: function save(callback) {
    var _this = this;
    return (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee() {
      var self, settings, data;
      return _regenerator.default.wrap(function _callee$(_context) {
        while (1) switch (_context.prev = _context.next) {
          case 0:
            self = _this;
            if (self.hasChange) {
              _context.next = 3;
              break;
            }
            return _context.abrupt("return");
          case 3:
            settings = _this.model.toJSON({
              remove: ['default']
            }), data = _this.getDataToSave({
              data: settings
            });
            NProgress.start();
            return _context.abrupt("return", elementorCommon.ajax.addRequest('save_' + _this.getSettings('name') + '_settings', {
              data: data,
              success: function success() {
                NProgress.done();
                self.setSettings('settings', settings);
                self.hasChange = false;
                if (callback) {
                  callback.apply(self, arguments);
                }
              },
              error: function error() {
                // eslint-disable-next-line no-alert
                alert('An error occurred.');
              }
            }));
          case 6:
          case "end":
            return _context.stop();
        }
      }, _callee);
    }))();
  },
  onInit: function onInit() {
    this.initModel();
    this.initControlsCSSParser();
    this.addPanelMenuItem();
    this.debounceSave = _.debounce(this.save, 3000);
    elementorModules.ViewModule.prototype.onInit.apply(this, arguments);
  },
  /**
   * BC for custom settings without a JS component.
   */
  addPanelMenuItem: function addPanelMenuItem() {
    var menuSettings = this.getSettings('panelPage.menu');
    if (!menuSettings) {
      return;
    }
    var namespace = 'panel/' + this.getSettings('name') + '-settings',
      menuItemOptions = {
        icon: menuSettings.icon,
        title: this.getSettings('panelPage.title'),
        type: 'page',
        pageName: this.getSettings('name') + '_settings',
        callback: function callback() {
          return $e.route("".concat(namespace, "/settings"));
        }
      };
    $e.bc.ensureTab(namespace, 'settings', menuItemOptions.pageName);
    elementor.modules.layouts.panel.pages.menu.Menu.addItem(menuItemOptions, 'settings', menuSettings.beforeItem);
  },
  onModelChange: function onModelChange(model) {
    var self = this;
    self.hasChange = true;
    this.getControlsCSS().stylesheet.empty();
    _.each(model.changed, function (value, key) {
      if (self.changeCallbacks[key]) {
        self.changeCallbacks[key].call(self, value);
      }
    });
    self.updateStylesheet(true);
    self.debounceSave();
  },
  onElementorDocumentLoaded: function onElementorDocumentLoaded() {
    this.updateStylesheet();
    this.addPanelPage();
  },
  destroy: function destroy() {
    this.unbindEvents();
    this.model.destroy();
  }
});

/***/ }),

/***/ "../assets/dev/js/editor/components/settings/base/panel.js":
/*!*****************************************************************!*\
  !*** ../assets/dev/js/editor/components/settings/base/panel.js ***!
  \*****************************************************************/
/***/ ((module) => {

"use strict";


module.exports = elementorModules.editor.views.ControlsStack.extend({
  id: function id() {
    return 'elementor-panel-' + this.getOption('name') + '-settings';
  },
  getTemplate: function getTemplate() {
    return '#tmpl-elementor-panel-' + this.getOption('name') + '-settings';
  },
  childViewContainer: function childViewContainer() {
    return '#elementor-panel-' + this.getOption('name') + '-settings-controls';
  },
  childViewOptions: function childViewOptions() {
    return {
      container: this.getOption('editedView').getContainer()
    };
  }
});

/***/ }),

/***/ "../assets/dev/js/editor/components/settings/editor-preferences/manager.js":
/*!*********************************************************************************!*\
  !*** ../assets/dev/js/editor/components/settings/editor-preferences/manager.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _manager = _interopRequireDefault(__webpack_require__(/*! ../base/manager */ "../assets/dev/js/editor/components/settings/base/manager.js"));
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var _default = /*#__PURE__*/function (_BaseManager) {
  (0, _inherits2.default)(_default, _BaseManager);
  var _super = _createSuper(_default);
  function _default() {
    var _this;
    (0, _classCallCheck2.default)(this, _default);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _this.changeCallbacks = {
      ui_theme: _this.onUIThemeChanged,
      panel_width: _this.onPanelWidthChanged,
      edit_buttons: _this.onEditButtonsChanged,
      show_hidden_elements: _this.onShowHiddenElementsChange
    };
    return _this;
  }
  (0, _createClass2.default)(_default, [{
    key: "getDefaultSettings",
    value: function getDefaultSettings() {
      return {
        darkModeLinkID: 'elementor-editor-dark-mode-css'
      };
    }
  }, {
    key: "onUIThemeChanged",
    value: function onUIThemeChanged(newValue) {
      var $lightUi = jQuery('#e-theme-ui-light-css');
      var $darkUi = jQuery('#e-theme-ui-dark-css');
      if ('auto' === newValue) {
        $lightUi.attr('media', '(prefers-color-scheme: light)');
        $darkUi.attr('media', '(prefers-color-scheme: dark)');
        return;
      }
      if ('light' === newValue) {
        $lightUi.attr('media', 'all');
        $darkUi.attr('media', 'none');
      } else {
        $lightUi.attr('media', 'none');
        $darkUi.attr('media', 'all');
      }
    }
  }, {
    key: "onPanelWidthChanged",
    value: function onPanelWidthChanged(newValue) {
      elementor.panel.saveSize({
        width: newValue.size + newValue.unit
      });
      elementor.panel.setSize();
    }
  }, {
    key: "onEditButtonsChanged",
    value: function onEditButtonsChanged() {
      // Let the button change before the high-performance action of rendering the entire page
      setTimeout(function () {
        return elementor.getPreviewView()._renderChildren();
      }, 300);
    }
  }, {
    key: "onShowHiddenElementsChange",
    value: function onShowHiddenElementsChange() {
      elementorFrontend.elements.$body.toggleClass('e-preview--show-hidden-elements');
    }
  }]);
  return _default;
}(_manager.default);
exports["default"] = _default;

/***/ }),

/***/ "../assets/dev/js/editor/components/settings/page/component.js":
/*!*********************************************************************!*\
  !*** ../assets/dev/js/editor/components/settings/page/component.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var __ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["__"];


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _componentBase = _interopRequireDefault(__webpack_require__(/*! elementor-editor/component-base */ "../assets/dev/js/editor/component-base.js"));
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var Component = /*#__PURE__*/function (_ComponentBase) {
  (0, _inherits2.default)(Component, _ComponentBase);
  var _super = _createSuper(Component);
  function Component() {
    (0, _classCallCheck2.default)(this, Component);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(Component, [{
    key: "getNamespace",
    value: function getNamespace() {
      return 'panel/page-settings';
    }
  }, {
    key: "defaultTabs",
    value: function defaultTabs() {
      return {
        settings: {
          title: __('Settings', 'elementor')
        },
        style: {
          title: __('Style', 'elementor')
        },
        advanced: {
          title: __('Advanced', 'elementor')
        }
      };
    }
  }, {
    key: "renderTab",
    value: function renderTab(tab, args) {
      var activeControl = args.activeControl,
        _args$refresh = args.refresh,
        refresh = _args$refresh === void 0 ? false : _args$refresh;
      if (this.shouldRenderPage(tab) || refresh) {
        elementor.getPanelView().setPage('page_settings').activateTab(tab);
      }
      this.activateControl(activeControl);
    }
  }, {
    key: "shouldRenderPage",
    value: function shouldRenderPage(tab) {
      var _currentPanelView$get;
      var currentPanelView = elementor.getPanelView();
      var isSamePage = 'page_settings' === currentPanelView.getCurrentPageName();
      var isSameTab = tab === ((_currentPanelView$get = currentPanelView.getCurrentPageView()) === null || _currentPanelView$get === void 0 ? void 0 : _currentPanelView$get.activeTab);
      return !isSamePage || !isSameTab;
    }
  }, {
    key: "getTabsWrapperSelector",
    value: function getTabsWrapperSelector() {
      return '.elementor-panel-navigation';
    }
  }]);
  return Component;
}(_componentBase.default);
exports["default"] = Component;

/***/ }),

/***/ "../assets/dev/js/editor/components/settings/page/manager.js":
/*!*******************************************************************!*\
  !*** ../assets/dev/js/editor/components/settings/page/manager.js ***!
  \*******************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _construct2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/construct */ "../node_modules/@babel/runtime/helpers/construct.js"));
var _toConsumableArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/toConsumableArray */ "../node_modules/@babel/runtime/helpers/toConsumableArray.js"));
var _component = _interopRequireDefault(__webpack_require__(/*! ./component */ "../assets/dev/js/editor/components/settings/page/component.js"));
var _childrenArray = _interopRequireDefault(__webpack_require__(/*! elementor-editor/container/model/children-array */ "../assets/dev/js/editor/container/model/children-array.js"));
var BaseSettings = __webpack_require__(/*! elementor-editor/components/settings/base/manager */ "../assets/dev/js/editor/components/settings/base/manager.js");
module.exports = BaseSettings.extend({
  getStyleId: function getStyleId() {
    return this.getSettings('name') + '-' + elementor.documents.getCurrent().id;
  },
  onInit: function onInit() {
    BaseSettings.prototype.onInit.apply(this);
    $e.components.register(new _component.default({
      manager: this
    }));
  },
  save: function save() {},
  getDataToSave: function getDataToSave(data) {
    data.id = elementor.config.document.id;
    return data;
  },
  // Emulate an element view/model structure with the parts needed for a container.
  getEditedView: function getEditedView() {
    var _this = this;
    if (this.editedView) {
      return this.editedView;
    }
    var documentElementType = elementor.elementsManager.getElementTypeClass('document'),
      ModelClass = documentElementType.getModel(),
      type = this.getContainerType(),
      editModel = new ModelClass({
        id: type,
        elType: type,
        settings: this.model,
        elements: elementor.elements
      }),
      container = new elementorModules.editor.Container({
        type: type,
        id: editModel.id,
        model: editModel,
        settings: editModel.get('settings'),
        label: elementor.config.document.panel.title,
        controls: this.model.controls,
        children: (0, _construct2.default)(_childrenArray.default, (0, _toConsumableArray2.default)(elementor.elements || [])),
        parent: false,
        // Emulate a view that can render the style.
        renderer: {
          view: {
            lookup: function lookup() {
              return container;
            },
            renderOnChange: function renderOnChange() {
              return _this.updateStylesheet();
            },
            renderUI: function renderUI() {
              return _this.updateStylesheet();
            }
          }
        }
      });
    this.editedView = {
      getContainer: function getContainer() {
        return container;
      },
      getEditModel: function getEditModel() {
        return editModel;
      },
      model: editModel,
      container: container
    };
    return this.editedView;
  },
  getContainerType: function getContainerType() {
    return 'document';
  },
  /**
   * @deprecated since 3.7.0, use `getContainerType()` instead.
   */
  getContainerId: function getContainerId() {
    elementorDevTools.deprecation.deprecated('getContainerId()', '3.7.0', 'getContainerType()');
    return this.getContainerType();
  }
});

/***/ }),

/***/ "../assets/dev/js/editor/components/settings/settings.js":
/*!***************************************************************!*\
  !*** ../assets/dev/js/editor/components/settings/settings.js ***!
  \***************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _manager = _interopRequireDefault(__webpack_require__(/*! ./editor-preferences/manager */ "../assets/dev/js/editor/components/settings/editor-preferences/manager.js"));
module.exports = elementorModules.Module.extend({
  modules: {
    base: __webpack_require__(/*! elementor-editor/components/settings/base/manager */ "../assets/dev/js/editor/components/settings/base/manager.js"),
    page: __webpack_require__(/*! elementor-editor/components/settings/page/manager */ "../assets/dev/js/editor/components/settings/page/manager.js"),
    editorPreferences: _manager.default
  },
  panelPages: {
    base: __webpack_require__(/*! elementor-editor/components/settings/base/panel */ "../assets/dev/js/editor/components/settings/base/panel.js")
  },
  onInit: function onInit() {
    this.initSettings();
  },
  initSettings: function initSettings() {
    var self = this;
    _.each(elementor.config.settings, function (config, name) {
      var Manager = self.modules[name] || self.modules.base;
      self[name] = new Manager(config);
    });
  }
});

/***/ }),

/***/ "../assets/dev/js/editor/components/template-library/behaviors/insert-template.js":
/*!****************************************************************************************!*\
  !*** ../assets/dev/js/editor/components/template-library/behaviors/insert-template.js ***!
  \****************************************************************************************/
/***/ ((module) => {

"use strict";


var InsertTemplateHandler;
InsertTemplateHandler = Marionette.Behavior.extend({
  ui: {
    insertButton: '.elementor-template-library-template-insert'
  },
  events: {
    'click @ui.insertButton': 'onInsertButtonClick'
  },
  onInsertButtonClick: function onInsertButtonClick() {
    var args = {
      model: this.view.model
    };
    this.ui.insertButton.addClass('elementor-disabled');
    if ('remote' === args.model.get('source') && !elementor.config.library_connect.is_connected) {
      $e.route('library/connect', args);
      return;
    }
    $e.run('library/insert-template', args);
  }
});
module.exports = InsertTemplateHandler;

/***/ }),

/***/ "../assets/dev/js/editor/components/template-library/collections/templates.js":
/*!************************************************************************************!*\
  !*** ../assets/dev/js/editor/components/template-library/collections/templates.js ***!
  \************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var TemplateLibraryTemplateModel = __webpack_require__(/*! elementor-templates/models/template */ "../assets/dev/js/editor/components/template-library/models/template.js"),
  TemplateLibraryCollection;
TemplateLibraryCollection = Backbone.Collection.extend({
  model: TemplateLibraryTemplateModel
});
module.exports = TemplateLibraryCollection;

/***/ }),

/***/ "../assets/dev/js/editor/components/template-library/commands-data/index.js":
/*!**********************************************************************************!*\
  !*** ../assets/dev/js/editor/components/template-library/commands-data/index.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
Object.defineProperty(exports, "Templates", ({
  enumerable: true,
  get: function get() {
    return _templates.Templates;
  }
}));
var _templates = __webpack_require__(/*! ./templates */ "../assets/dev/js/editor/components/template-library/commands-data/templates.js");

/***/ }),

/***/ "../assets/dev/js/editor/components/template-library/commands-data/templates.js":
/*!**************************************************************************************!*\
  !*** ../assets/dev/js/editor/components/template-library/commands-data/templates.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.Templates = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var Templates = /*#__PURE__*/function (_$e$modules$CommandDa) {
  (0, _inherits2.default)(Templates, _$e$modules$CommandDa);
  var _super = _createSuper(Templates);
  function Templates() {
    (0, _classCallCheck2.default)(this, Templates);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(Templates, null, [{
    key: "getEndpointFormat",
    value: function getEndpointFormat() {
      return 'template-library/templates';
    }
  }]);
  return Templates;
}($e.modules.CommandData);
exports.Templates = Templates;
var _default = Templates;
exports["default"] = _default;

/***/ }),

/***/ "../assets/dev/js/editor/components/template-library/commands/index.js":
/*!*****************************************************************************!*\
  !*** ../assets/dev/js/editor/components/template-library/commands/index.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
Object.defineProperty(exports, "InsertTemplate", ({
  enumerable: true,
  get: function get() {
    return _insertTemplate.InsertTemplate;
  }
}));
Object.defineProperty(exports, "Open", ({
  enumerable: true,
  get: function get() {
    return _open.Open;
  }
}));
var _insertTemplate = __webpack_require__(/*! ./insert-template */ "../assets/dev/js/editor/components/template-library/commands/insert-template.js");
var _open = __webpack_require__(/*! ./open */ "../assets/dev/js/editor/components/template-library/commands/open.js");

/***/ }),

/***/ "../assets/dev/js/editor/components/template-library/commands/insert-template.js":
/*!***************************************************************************************!*\
  !*** ../assets/dev/js/editor/components/template-library/commands/insert-template.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.InsertTemplate = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var InsertTemplate = /*#__PURE__*/function (_$e$modules$CommandBa) {
  (0, _inherits2.default)(InsertTemplate, _$e$modules$CommandBa);
  var _super = _createSuper(InsertTemplate);
  function InsertTemplate() {
    (0, _classCallCheck2.default)(this, InsertTemplate);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(InsertTemplate, [{
    key: "apply",
    value: function apply(args) {
      return this.component.insertTemplate(args);
    }
  }]);
  return InsertTemplate;
}($e.modules.CommandBase);
exports.InsertTemplate = InsertTemplate;
var _default = InsertTemplate;
exports["default"] = _default;

/***/ }),

/***/ "../assets/dev/js/editor/components/template-library/commands/open.js":
/*!****************************************************************************!*\
  !*** ../assets/dev/js/editor/components/template-library/commands/open.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.Open = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var Open = /*#__PURE__*/function (_$e$modules$CommandBa) {
  (0, _inherits2.default)(Open, _$e$modules$CommandBa);
  var _super = _createSuper(Open);
  function Open() {
    (0, _classCallCheck2.default)(this, Open);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(Open, [{
    key: "apply",
    value: function apply(args) {
      return this.component.show(args);
    }
  }]);
  return Open;
}($e.modules.CommandBase);
exports.Open = Open;
var _default = Open;
exports["default"] = _default;

/***/ }),

/***/ "../assets/dev/js/editor/components/template-library/component.js":
/*!************************************************************************!*\
  !*** ../assets/dev/js/editor/components/template-library/component.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var __ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["__"];


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _get2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/get */ "../node_modules/@babel/runtime/helpers/get.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _componentModalBase = _interopRequireDefault(__webpack_require__(/*! elementor-api/modules/component-modal-base */ "../modules/web-cli/assets/js/modules/component-modal-base.js"));
var commands = _interopRequireWildcard(__webpack_require__(/*! ./commands/ */ "../assets/dev/js/editor/components/template-library/commands/index.js"));
var commandsData = _interopRequireWildcard(__webpack_require__(/*! ./commands-data/ */ "../assets/dev/js/editor/components/template-library/commands-data/index.js"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var TemplateLibraryLayoutView = __webpack_require__(/*! elementor-templates/views/library-layout */ "../assets/dev/js/editor/components/template-library/views/library-layout.js");
var Component = /*#__PURE__*/function (_ComponentModalBase) {
  (0, _inherits2.default)(Component, _ComponentModalBase);
  var _super = _createSuper(Component);
  function Component() {
    (0, _classCallCheck2.default)(this, Component);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(Component, [{
    key: "__construct",
    value: function __construct(args) {
      (0, _get2.default)((0, _getPrototypeOf2.default)(Component.prototype), "__construct", this).call(this, args);

      // When switching documents update defaultTabs.
      elementor.on('document:loaded', this.onDocumentLoaded.bind(this));

      // Remove whole component cache data.
      $e.data.deleteCache(this, 'library');
    }
  }, {
    key: "getNamespace",
    value: function getNamespace() {
      return 'library';
    }
  }, {
    key: "defaultTabs",
    value: function defaultTabs() {
      return {
        'templates/blocks': {
          title: __('Blocks', 'elementor'),
          getFilter: function getFilter() {
            return {
              source: 'remote',
              type: 'block',
              subtype: elementor.config.document.remoteLibrary.category
            };
          }
        },
        'templates/pages': {
          title: __('Pages', 'elementor'),
          filter: {
            source: 'remote',
            type: 'page'
          }
        },
        'templates/my-templates': {
          title: __('My Templates', 'elementor'),
          filter: {
            source: 'local'
          }
        }
      };
    }
  }, {
    key: "defaultRoutes",
    value: function defaultRoutes() {
      var _this = this;
      return {
        import: function _import() {
          _this.manager.layout.showImportView();
        },
        'save-template': function saveTemplate(args) {
          _this.manager.layout.showSaveTemplateView(args.model);
        },
        preview: function preview(args) {
          _this.manager.layout.showPreviewView(args.model);
        },
        connect: function connect(args) {
          args.texts = {
            title: __('Connect to Template Library', 'elementor'),
            message: __('Access this template and our entire library by creating a free personal account', 'elementor'),
            button: __('Get Started', 'elementor')
          };
          _this.manager.layout.showConnectView(args);
        }
      };
    }
  }, {
    key: "defaultCommands",
    value: function defaultCommands() {
      var modalCommands = (0, _get2.default)((0, _getPrototypeOf2.default)(Component.prototype), "defaultCommands", this).call(this);
      return _objectSpread(_objectSpread({}, modalCommands), this.importCommands(commands));
    }
  }, {
    key: "defaultData",
    value: function defaultData() {
      return this.importCommands(commandsData);
    }
  }, {
    key: "defaultShortcuts",
    value: function defaultShortcuts() {
      return {
        open: {
          keys: 'ctrl+shift+l'
        }
      };
    }
  }, {
    key: "onDocumentLoaded",
    value: function onDocumentLoaded(document) {
      this.setDefaultRoute(document.config.remoteLibrary.default_route);
      this.maybeOpenLibrary();
    }
  }, {
    key: "renderTab",
    value: function renderTab(tab) {
      var currentTab = this.tabs[tab],
        filter = currentTab.getFilter ? currentTab.getFilter() : currentTab.filter;
      this.manager.setScreen(filter);
    }
  }, {
    key: "activateTab",
    value: function activateTab(tab) {
      $e.routes.saveState('library');
      (0, _get2.default)((0, _getPrototypeOf2.default)(Component.prototype), "activateTab", this).call(this, tab);
    }
  }, {
    key: "open",
    value: function open() {
      (0, _get2.default)((0, _getPrototypeOf2.default)(Component.prototype), "open", this).call(this);
      if (!this.manager.layout) {
        this.manager.layout = this.layout;
      }
      this.manager.layout.setHeaderDefaultParts();
      return true;
    }
  }, {
    key: "close",
    value: function close() {
      if (!(0, _get2.default)((0, _getPrototypeOf2.default)(Component.prototype), "close", this).call(this)) {
        return false;
      }
      this.manager.modalConfig = {};
      return true;
    }
  }, {
    key: "show",
    value: function show(args) {
      this.manager.modalConfig = args;
      if (args.toDefault || !$e.routes.restoreState('library')) {
        $e.route(this.getDefaultRoute());
      }
    }

    // TODO: Move function to 'insert-template' command.
  }, {
    key: "insertTemplate",
    value: function insertTemplate(args) {
      this.downloadTemplate(args, function (data, callbackParams) {
        $e.run('document/elements/import', {
          model: callbackParams.model,
          data: data,
          options: callbackParams.importOptions
        });
      });
    }
  }, {
    key: "downloadTemplate",
    value: function downloadTemplate(args, callback) {
      var _this2 = this;
      var autoImportSettings = elementor.config.document.remoteLibrary.autoImportSettings,
        model = args.model;
      var _args$withPageSetting = args.withPageSettings,
        withPageSettings = _args$withPageSetting === void 0 ? null : _args$withPageSetting;
      if (autoImportSettings) {
        withPageSettings = true;
      }
      if (null === withPageSettings && model.get('hasPageSettings')) {
        var insertTemplateHandler = this.getImportSettingsDialog();
        insertTemplateHandler.showImportDialog(model);
        return;
      }
      this.manager.layout.showLoadingView();
      this.manager.requestTemplateContent(model.get('source'), model.get('template_id'), {
        data: {
          with_page_settings: withPageSettings
        },
        success: function success(data) {
          // Clone the `modalConfig.importOptions` because it deleted during the closing.
          var importOptions = jQuery.extend({}, _this2.manager.modalConfig.importOptions);
          importOptions.withPageSettings = withPageSettings;

          // Hide for next open.
          _this2.manager.layout.hideLoadingView();
          _this2.manager.layout.hideModal();
          callback(data, {
            model: model,
            importOptions: importOptions
          });
        },
        error: function error(data) {
          _this2.manager.showErrorDialog(data);
        },
        complete: function complete() {
          _this2.manager.layout.hideLoadingView();
        }
      });
    }
  }, {
    key: "getImportSettingsDialog",
    value: function getImportSettingsDialog() {
      // Moved from ./behaviors/insert-template.js
      var InsertTemplateHandler = {
        dialog: null,
        showImportDialog: function showImportDialog(model) {
          var dialog = InsertTemplateHandler.getDialog(model);
          dialog.onConfirm = function () {
            $e.run('library/insert-template', {
              model: model,
              withPageSettings: true
            });
          };
          dialog.onCancel = function () {
            $e.run('library/insert-template', {
              model: model,
              withPageSettings: false
            });
          };
          dialog.show();
        },
        initDialog: function initDialog(model) {
          InsertTemplateHandler.dialog = elementorCommon.dialogsManager.createWidget('confirm', {
            id: 'elementor-insert-template-settings-dialog',
            /* Translators: %s is the type content */
            headerMessage: __('Apply the settings of this %s too?', 'elementor').replace('%s', elementor.translate(model.attributes.type)),
            /* Translators: %s is the type content */
            message: __('This will override the design, layout, and other settings of the %s you’re working on.', 'elementor').replace('%s', elementor.documents.getCurrent().container.label),
            strings: {
              confirm: __('Apply', 'elementor'),
              cancel: __('Don’t apply', 'elementor')
            }
          });
        },
        getDialog: function getDialog(model) {
          if (!InsertTemplateHandler.dialog) {
            InsertTemplateHandler.initDialog(model);
          }
          return InsertTemplateHandler.dialog;
        }
      };
      return InsertTemplateHandler;
    }
  }, {
    key: "getTabsWrapperSelector",
    value: function getTabsWrapperSelector() {
      return '#elementor-template-library-header-menu';
    }
  }, {
    key: "getModalLayout",
    value: function getModalLayout() {
      return TemplateLibraryLayoutView;
    }
  }, {
    key: "maybeOpenLibrary",
    value: function maybeOpenLibrary() {
      if ('#library' === location.hash) {
        $e.run('library/open');
        location.hash = '';
      }
    }
  }]);
  return Component;
}(_componentModalBase.default);
exports["default"] = Component;

/***/ }),

/***/ "../assets/dev/js/editor/components/template-library/manager.js":
/*!**********************************************************************!*\
  !*** ../assets/dev/js/editor/components/template-library/manager.js ***!
  \**********************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var __ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["__"];
/* provided dependency */ var sprintf = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["sprintf"];


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _component = _interopRequireDefault(__webpack_require__(/*! ./component */ "../assets/dev/js/editor/components/template-library/component.js"));
var TemplateLibraryCollection = __webpack_require__(/*! elementor-templates/collections/templates */ "../assets/dev/js/editor/components/template-library/collections/templates.js"),
  TemplateLibraryManager;
TemplateLibraryManager = function TemplateLibraryManager() {
  this.modalConfig = {};
  var self = this,
    templateTypes = {};
  var deleteDialog,
    errorDialog,
    templatesCollection,
    config = {},
    filterTerms = {};
  var registerDefaultTemplateTypes = function registerDefaultTemplateTypes() {
    var data = {
      saveDialog: {
        description: __('Your designs will be available for export and reuse on any page or website', 'elementor')
      },
      ajaxParams: {
        success: function success(successData) {
          $e.route('library/templates/my-templates', {
            onBefore: function onBefore() {
              if (templatesCollection) {
                var itemExist = templatesCollection.findWhere({
                  template_id: successData.template_id
                });
                if (!itemExist) {
                  templatesCollection.add(successData);
                }
              }
            }
          });
        },
        error: function error(errorData) {
          self.showErrorDialog(errorData);
        }
      }
    };
    var translationMap = (0, _defineProperty2.default)({
      page: __('Page', 'elementor'),
      section: __('Section', 'elementor'),
      container: __('Container', 'elementor')
    }, elementor.config.document.type, elementor.config.document.panel.title);
    jQuery.each(translationMap, function (type, title) {
      var safeData = jQuery.extend(true, {}, data, {
        saveDialog: {
          /* Translators: %s: Template type. */
          title: sprintf(__('Save Your %s to Library', 'elementor'), title)
        }
      });
      self.registerTemplateType(type, safeData);
    });
  };
  var registerDefaultFilterTerms = function registerDefaultFilterTerms() {
    filterTerms = {
      text: {
        callback: function callback(value) {
          value = value.toLowerCase();
          if (this.get('title').toLowerCase().indexOf(value) >= 0) {
            return true;
          }
          return _.any(this.get('tags'), function (tag) {
            return tag.toLowerCase().indexOf(value) >= 0;
          });
        }
      },
      type: {},
      subtype: {},
      favorite: {}
    };
  };
  this.init = function () {
    registerDefaultTemplateTypes();
    registerDefaultFilterTerms();
    this.component = $e.components.register(new _component.default({
      manager: this
    }));
    elementor.addBackgroundClickListener('libraryToggleMore', {
      element: '.elementor-template-library-template-more'
    });
  };
  this.getTemplateTypes = function (type) {
    if (type) {
      return templateTypes[type];
    }
    return templateTypes;
  };
  this.registerTemplateType = function (type, data) {
    templateTypes[type] = data;
  };
  this.deleteTemplate = function (templateModel, options) {
    var dialog = self.getDeleteDialog();
    dialog.onConfirm = function () {
      if (options.onConfirm) {
        options.onConfirm();
      }
      elementorCommon.ajax.addRequest('delete_template', {
        data: {
          source: templateModel.get('source'),
          template_id: templateModel.get('template_id')
        },
        success: function success(response) {
          templatesCollection.remove(templateModel, {
            silent: true
          });
          if (options.onSuccess) {
            options.onSuccess(response);
          }
        }
      });
    };
    dialog.show();
  };

  /**
   * @param {*}      model - Template model.
   * @param {Object} args  - Template arguments.
   * @deprecated since 2.8.0, use `$e.run( 'library/insert-template' )` instead.
   */
  this.importTemplate = function (model) {
    var args = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    elementorDevTools.deprecation.deprecated('importTemplate', '2.8.0', "$e.run( 'library/insert-template' )");
    args.model = model;
    $e.run('library/insert-template', args);
  };
  this.saveTemplate = function (type, data) {
    var templateType = templateTypes[type];
    _.extend(data, {
      source: 'local',
      type: type
    });
    if (templateType.prepareSavedData) {
      data = templateType.prepareSavedData(data);
    }
    data.content = JSON.stringify(data.content);
    var ajaxParams = {
      data: data
    };
    if (templateType.ajaxParams) {
      _.extend(ajaxParams, templateType.ajaxParams);
    }
    elementorCommon.ajax.addRequest('save_template', ajaxParams);
  };
  this.requestTemplateContent = function (source, id, ajaxOptions) {
    var options = {
      unique_id: id,
      data: {
        source: source,
        edit_mode: true,
        display: true,
        template_id: id
      }
    };
    if (ajaxOptions) {
      jQuery.extend(true, options, ajaxOptions);
    }
    return elementorCommon.ajax.addRequest('get_template_data', options);
  };
  this.markAsFavorite = function (templateModel, favorite) {
    var options = {
      data: {
        source: templateModel.get('source'),
        template_id: templateModel.get('template_id'),
        favorite: favorite
      }
    };
    return elementorCommon.ajax.addRequest('mark_template_as_favorite', options);
  };
  this.getDeleteDialog = function () {
    if (!deleteDialog) {
      deleteDialog = elementorCommon.dialogsManager.createWidget('confirm', {
        id: 'elementor-template-library-delete-dialog',
        headerMessage: __('Delete Template', 'elementor'),
        message: __('Are you sure you want to delete this template?', 'elementor'),
        strings: {
          confirm: __('Delete', 'elementor')
        }
      });
    }
    return deleteDialog;
  };
  this.getErrorDialog = function () {
    if (!errorDialog) {
      errorDialog = elementorCommon.dialogsManager.createWidget('alert', {
        id: 'elementor-template-library-error-dialog',
        headerMessage: __('An error occurred.', 'elementor')
      });
    }
    return errorDialog;
  };
  this.getTemplatesCollection = function () {
    return templatesCollection;
  };
  this.getConfig = function (item) {
    if (item) {
      return config[item] ? config[item] : {};
    }
    return config;
  };
  this.requestLibraryData = function (options) {
    if (templatesCollection && !options.forceUpdate) {
      if (options.onUpdate) {
        options.onUpdate();
      }
      return;
    }
    if (options.onBeforeUpdate) {
      options.onBeforeUpdate();
    }
    var ajaxOptions = {
      data: {},
      success: function success(data) {
        templatesCollection = new TemplateLibraryCollection(data.templates);
        if (data.config) {
          config = data.config;
        }
        if (options.onUpdate) {
          options.onUpdate();
        }
      }
    };
    if (options.forceSync) {
      ajaxOptions.data.sync = true;
    }
    elementorCommon.ajax.addRequest('get_library_data', ajaxOptions);
  };
  this.getFilter = function (name) {
    return elementor.channels.templates.request('filter:' + name);
  };
  this.setFilter = function (name, value, silent) {
    elementor.channels.templates.reply('filter:' + name, value);
    if (!silent) {
      elementor.channels.templates.trigger('filter:change');
    }
  };
  this.getFilterTerms = function (termName) {
    if (termName) {
      return filterTerms[termName];
    }
    return filterTerms;
  };
  this.setScreen = function (args) {
    elementor.channels.templates.stopReplying();
    self.setFilter('source', args.source, true);
    self.setFilter('type', args.type, true);
    self.setFilter('subtype', args.subtype, true);
    self.showTemplates();
  };
  this.loadTemplates = function (onUpdate) {
    self.layout.showLoadingView();
    var query = {
        source: this.getFilter('source')
      },
      options = {};

    // TODO: Remove - it when all the data commands is ready, manage the cache!.
    if ('local' === query.source) {
      options.refresh = true;
    }
    $e.data.get('library/templates', query, options).then(function (result) {
      templatesCollection = new TemplateLibraryCollection(result.data.templates);
      if (result.data.config) {
        config = result.data.config;
      }
      self.layout.hideLoadingView();
      if (onUpdate) {
        onUpdate();
      }
    });
  };
  this.showTemplates = function () {
    // The tabs should exist in DOM on loading.
    self.layout.setHeaderDefaultParts();
    self.loadTemplates(function () {
      var templatesToShow = self.filterTemplates();
      self.layout.showTemplatesView(new TemplateLibraryCollection(templatesToShow));
    });
  };
  this.filterTemplates = function () {
    var activeSource = self.getFilter('source');
    return templatesCollection.filter(function (model) {
      if (activeSource !== model.get('source')) {
        return false;
      }
      var typeInfo = templateTypes[model.get('type')];
      return !typeInfo || false !== typeInfo.showInLibrary;
    });
  };
  this.showErrorDialog = function (errorMessage) {
    if ('object' === (0, _typeof2.default)(errorMessage)) {
      var message = '';
      _.each(errorMessage, function (error) {
        if (!(error !== null && error !== void 0 && error.message)) {
          return;
        }
        message += '<div>' + error.message + '.</div>';
      });
      errorMessage = message;
    } else if (errorMessage) {
      errorMessage += '.';
    }
    if (errorMessage) {
      errorMessage = __('The following error(s) occurred while processing the request:', 'elementor') + '<div id="elementor-template-library-error-info">' + errorMessage + '</div>';
    } else {
      errorMessage = __('Please try again.', 'elementor');
    }
    self.getErrorDialog().setMessage(errorMessage).show();
  };
};
module.exports = new TemplateLibraryManager();

/***/ }),

/***/ "../assets/dev/js/editor/components/template-library/models/template.js":
/*!******************************************************************************!*\
  !*** ../assets/dev/js/editor/components/template-library/models/template.js ***!
  \******************************************************************************/
/***/ ((module) => {

"use strict";


module.exports = Backbone.Model.extend({
  defaults: {
    template_id: 0,
    title: '',
    source: '',
    type: '',
    subtype: '',
    author: '',
    thumbnail: '',
    url: '',
    export_link: '',
    tags: []
  }
});

/***/ }),

/***/ "../assets/dev/js/editor/components/template-library/views/library-layout.js":
/*!***********************************************************************************!*\
  !*** ../assets/dev/js/editor/components/template-library/views/library-layout.js ***!
  \***********************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var __ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["__"];


var TemplateLibraryHeaderActionsView = __webpack_require__(/*! elementor-templates/views/parts/header-parts/actions */ "../assets/dev/js/editor/components/template-library/views/parts/header-parts/actions.js"),
  TemplateLibraryHeaderMenuView = __webpack_require__(/*! elementor-templates/views/parts/header-parts/menu */ "../assets/dev/js/editor/components/template-library/views/parts/header-parts/menu.js"),
  TemplateLibraryHeaderPreviewView = __webpack_require__(/*! elementor-templates/views/parts/header-parts/preview */ "../assets/dev/js/editor/components/template-library/views/parts/header-parts/preview.js"),
  TemplateLibraryHeaderBackView = __webpack_require__(/*! elementor-templates/views/parts/header-parts/back */ "../assets/dev/js/editor/components/template-library/views/parts/header-parts/back.js"),
  TemplateLibraryCollectionView = __webpack_require__(/*! elementor-templates/views/parts/templates */ "../assets/dev/js/editor/components/template-library/views/parts/templates.js"),
  TemplateLibrarySaveTemplateView = __webpack_require__(/*! elementor-templates/views/parts/save-template */ "../assets/dev/js/editor/components/template-library/views/parts/save-template.js"),
  TemplateLibraryImportView = __webpack_require__(/*! elementor-templates/views/parts/import */ "../assets/dev/js/editor/components/template-library/views/parts/import.js"),
  TemplateLibraryConnectView = __webpack_require__(/*! elementor-templates/views/parts/connect */ "../assets/dev/js/editor/components/template-library/views/parts/connect.js"),
  TemplateLibraryPreviewView = __webpack_require__(/*! elementor-templates/views/parts/preview */ "../assets/dev/js/editor/components/template-library/views/parts/preview.js");
module.exports = elementorModules.common.views.modal.Layout.extend({
  getModalOptions: function getModalOptions() {
    return {
      id: 'elementor-template-library-modal'
    };
  },
  getLogoOptions: function getLogoOptions() {
    return {
      title: __('Library', 'elementor'),
      click: function click() {
        $e.run('library/open', {
          toDefault: true
        });
      }
    };
  },
  getTemplateActionButton: function getTemplateActionButton(templateData) {
    var subscriptionPlans = elementor.config.library_connect.subscription_plans,
      baseAccessTier = elementor.config.library_connect.base_access_tier,
      templateAccessTier = templateData.accessTier,
      shouldUpgrade = baseAccessTier !== templateAccessTier;
    var viewId = '#tmpl-elementor-template-library-' + (shouldUpgrade ? 'upgrade-plan-button' : 'insert-button');
    viewId = elementor.hooks.applyFilters('elementor/editor/template-library/template/action-button', viewId, templateData);
    var template = Marionette.TemplateCache.get(viewId);
    var subscriptionPlan = subscriptionPlans[templateAccessTier];
    var promotionText = elementorAppConfig.hasPro ? 'Upgrade' : "Go ".concat(subscriptionPlan.label);
    return Marionette.Renderer.render(template, {
      promotionText: promotionText,
      promotionLink: subscriptionPlan.promotion_url
    });
  },
  setHeaderDefaultParts: function setHeaderDefaultParts() {
    var headerView = this.getHeaderView();
    headerView.tools.show(new TemplateLibraryHeaderActionsView());
    headerView.menuArea.show(new TemplateLibraryHeaderMenuView());
    this.showLogo();
  },
  showTemplatesView: function showTemplatesView(templatesCollection) {
    this.modalContent.show(new TemplateLibraryCollectionView({
      collection: templatesCollection
    }));
  },
  showImportView: function showImportView() {
    var headerView = this.getHeaderView();
    headerView.menuArea.reset();
    this.modalContent.show(new TemplateLibraryImportView());
    headerView.logoArea.show(new TemplateLibraryHeaderBackView());
  },
  showConnectView: function showConnectView(args) {
    this.getHeaderView().menuArea.reset();
    this.modalContent.show(new TemplateLibraryConnectView(args));
  },
  showSaveTemplateView: function showSaveTemplateView(elementModel) {
    this.getHeaderView().menuArea.reset();
    this.modalContent.show(new TemplateLibrarySaveTemplateView({
      model: elementModel
    }));
  },
  showPreviewView: function showPreviewView(templateModel) {
    this.modalContent.show(new TemplateLibraryPreviewView({
      url: templateModel.get('url')
    }));
    var headerView = this.getHeaderView();
    headerView.menuArea.reset();
    headerView.tools.show(new TemplateLibraryHeaderPreviewView({
      model: templateModel
    }));
    headerView.logoArea.show(new TemplateLibraryHeaderBackView());
  }
});

/***/ }),

/***/ "../assets/dev/js/editor/components/template-library/views/parts/connect.js":
/*!**********************************************************************************!*\
  !*** ../assets/dev/js/editor/components/template-library/views/parts/connect.js ***!
  \**********************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var __ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["__"];


module.exports = Marionette.ItemView.extend({
  template: '#tmpl-elementor-template-library-connect',
  id: 'elementor-template-library-connect',
  ui: {
    connect: '#elementor-template-library-connect__button',
    thumbnails: '#elementor-template-library-connect-thumbnails'
  },
  templateHelpers: function templateHelpers() {
    return this.getOption('texts');
  },
  onRender: function onRender() {
    var _this = this;
    this.ui.connect.elementorConnect({
      parseUrl: function parseUrl(url) {
        return url.replace('%%template_type%%', _this.model.get('type'));
      },
      success: function success() {
        elementor.config.library_connect.is_connected = true;

        // If is connecting during insert template.
        if (_this.getOption('model')) {
          $e.run('library/insert-template', {
            model: _this.getOption('model')
          });
        } else {
          $e.run('library/close');
          elementor.notifications.showToast({
            message: __('Connected successfully.', 'elementor')
          });
        }
      },
      error: function error() {
        elementor.config.library_connect.is_connected = false;
      }
    });
  }
});

/***/ }),

/***/ "../assets/dev/js/editor/components/template-library/views/parts/header-parts/actions.js":
/*!***********************************************************************************************!*\
  !*** ../assets/dev/js/editor/components/template-library/views/parts/header-parts/actions.js ***!
  \***********************************************************************************************/
/***/ ((module) => {

"use strict";


module.exports = Marionette.ItemView.extend({
  template: '#tmpl-elementor-template-library-header-actions',
  id: 'elementor-template-library-header-actions',
  ui: {
    import: '#elementor-template-library-header-import i',
    sync: '#elementor-template-library-header-sync i',
    save: '#elementor-template-library-header-save i'
  },
  events: {
    'click @ui.import': 'onImportClick',
    'click @ui.sync': 'onSyncClick',
    'click @ui.save': 'onSaveClick'
  },
  onImportClick: function onImportClick() {
    $e.route('library/import');
  },
  onSyncClick: function onSyncClick() {
    var self = this;
    self.ui.sync.addClass('eicon-animation-spin');
    elementor.templates.requestLibraryData({
      onUpdate: function onUpdate() {
        self.ui.sync.removeClass('eicon-animation-spin');
        $e.routes.refreshContainer('library');
      },
      forceUpdate: true,
      forceSync: true
    });
  },
  onSaveClick: function onSaveClick() {
    $e.route('library/save-template');
  }
});

/***/ }),

/***/ "../assets/dev/js/editor/components/template-library/views/parts/header-parts/back.js":
/*!********************************************************************************************!*\
  !*** ../assets/dev/js/editor/components/template-library/views/parts/header-parts/back.js ***!
  \********************************************************************************************/
/***/ ((module) => {

"use strict";


module.exports = Marionette.ItemView.extend({
  template: '#tmpl-elementor-template-library-header-back',
  id: 'elementor-template-library-header-preview-back',
  events: {
    click: 'onClick'
  },
  onClick: function onClick() {
    $e.routes.restoreState('library');
  }
});

/***/ }),

/***/ "../assets/dev/js/editor/components/template-library/views/parts/header-parts/menu.js":
/*!********************************************************************************************!*\
  !*** ../assets/dev/js/editor/components/template-library/views/parts/header-parts/menu.js ***!
  \********************************************************************************************/
/***/ ((module) => {

"use strict";


module.exports = Marionette.ItemView.extend({
  template: '#tmpl-elementor-template-library-header-menu',
  id: 'elementor-template-library-header-menu',
  templateHelpers: function templateHelpers() {
    return {
      tabs: $e.components.get('library').getTabs()
    };
  }
});

/***/ }),

/***/ "../assets/dev/js/editor/components/template-library/views/parts/header-parts/preview.js":
/*!***********************************************************************************************!*\
  !*** ../assets/dev/js/editor/components/template-library/views/parts/header-parts/preview.js ***!
  \***********************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var TemplateLibraryInsertTemplateBehavior = __webpack_require__(/*! elementor-templates/behaviors/insert-template */ "../assets/dev/js/editor/components/template-library/behaviors/insert-template.js");
module.exports = Marionette.ItemView.extend({
  template: '#tmpl-elementor-template-library-header-preview',
  id: 'elementor-template-library-header-preview',
  behaviors: {
    insertTemplate: {
      behaviorClass: TemplateLibraryInsertTemplateBehavior
    }
  }
});

/***/ }),

/***/ "../assets/dev/js/editor/components/template-library/views/parts/import.js":
/*!*********************************************************************************!*\
  !*** ../assets/dev/js/editor/components/template-library/views/parts/import.js ***!
  \*********************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _filesUploadHandler = _interopRequireDefault(__webpack_require__(/*! ../../../../utils/files-upload-handler */ "../assets/dev/js/editor/utils/files-upload-handler.js"));
var _jsonUploadWarningMessage = __webpack_require__(/*! elementor-utils/json-upload-warning-message */ "../assets/dev/js/utils/json-upload-warning-message.js");
var TemplateLibraryImportView;
TemplateLibraryImportView = Marionette.ItemView.extend({
  template: '#tmpl-elementor-template-library-import',
  id: 'elementor-template-library-import',
  ui: {
    uploadForm: '#elementor-template-library-import-form',
    fileInput: '#elementor-template-library-import-form-input'
  },
  events: {
    'change @ui.fileInput': 'onFileInputChange'
  },
  droppedFiles: null,
  submitForm: function submitForm() {
    var _this = this;
    var file;
    if (this.droppedFiles) {
      file = this.droppedFiles[0];
      this.droppedFiles = null;
    } else {
      file = this.ui.fileInput[0].files[0];
      this.ui.uploadForm[0].reset();
    }
    var fileReader = new FileReader();
    fileReader.onload = function (event) {
      return _this.importTemplate(file.name, event.target.result.replace(/^[^,]+,/, ''));
    };
    fileReader.readAsDataURL(file);
  },
  importTemplate: function importTemplate(fileName, fileData) {
    var _this2 = this;
    return (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee() {
      var layout, enableUnfilteredFilesModal;
      return _regenerator.default.wrap(function _callee$(_context) {
        while (1) switch (_context.prev = _context.next) {
          case 0:
            layout = elementor.templates.layout;
            _this2.options = {
              data: {
                fileName: fileName,
                fileData: fileData
              },
              success: function success(successData) {
                elementor.templates.getTemplatesCollection().add(successData);
                $e.route('library/templates/my-templates');
              },
              error: function error(errorData) {
                elementor.templates.showErrorDialog(errorData);
                layout.showImportView();
              },
              complete: function complete() {
                layout.hideLoadingView();
              }
            };
            _context.next = 4;
            return (0, _jsonUploadWarningMessage.showJsonUploadWarningMessageIfNeeded)({
              introductionMap: window.elementor.config.user.introduction,
              IntroductionClass: window.elementorModules.editor.utils.Introduction
            });
          case 4:
            if (!elementorCommon.config.filesUpload.unfilteredFiles) {
              enableUnfilteredFilesModal = _filesUploadHandler.default.getUnfilteredFilesNotEnabledImportTemplateDialog(function () {
                return _this2.sendImportRequest();
              });
              enableUnfilteredFilesModal.show();
            } else {
              _this2.sendImportRequest();
            }
          case 5:
          case "end":
            return _context.stop();
        }
      }, _callee);
    }))();
  },
  sendImportRequest: function sendImportRequest() {
    elementorCommon.ajax.addRequest('import_template', this.options);
    elementor.templates.layout.showLoadingView();
  },
  onRender: function onRender() {
    this.ui.uploadForm.on({
      'drag dragstart dragend dragover dragenter dragleave drop': this.onFormActions.bind(this),
      dragenter: this.onFormDragEnter.bind(this),
      'dragleave drop': this.onFormDragLeave.bind(this),
      drop: this.onFormDrop.bind(this)
    });
  },
  onFormActions: function onFormActions(event) {
    event.preventDefault();
    event.stopPropagation();
  },
  onFormDragEnter: function onFormDragEnter() {
    this.ui.uploadForm.addClass('elementor-drag-over');
  },
  onFormDragLeave: function onFormDragLeave(event) {
    if (jQuery(event.relatedTarget).closest(this.ui.uploadForm).length) {
      return;
    }
    this.ui.uploadForm.removeClass('elementor-drag-over');
  },
  onFormDrop: function onFormDrop(event) {
    this.droppedFiles = event.originalEvent.dataTransfer.files;
    this.submitForm();
  },
  onFileInputChange: function onFileInputChange() {
    this.submitForm();
  }
});
module.exports = TemplateLibraryImportView;

/***/ }),

/***/ "../assets/dev/js/editor/components/template-library/views/parts/preview.js":
/*!**********************************************************************************!*\
  !*** ../assets/dev/js/editor/components/template-library/views/parts/preview.js ***!
  \**********************************************************************************/
/***/ ((module) => {

"use strict";


var TemplateLibraryPreviewView;
TemplateLibraryPreviewView = Marionette.ItemView.extend({
  template: '#tmpl-elementor-template-library-preview',
  id: 'elementor-template-library-preview',
  ui: {
    iframe: '> iframe'
  },
  onRender: function onRender() {
    this.ui.iframe.attr('src', this.getOption('url'));
  }
});
module.exports = TemplateLibraryPreviewView;

/***/ }),

/***/ "../assets/dev/js/editor/components/template-library/views/parts/save-template.js":
/*!****************************************************************************************!*\
  !*** ../assets/dev/js/editor/components/template-library/views/parts/save-template.js ***!
  \****************************************************************************************/
/***/ ((module) => {

"use strict";


var TemplateLibrarySaveTemplateView;
TemplateLibrarySaveTemplateView = Marionette.ItemView.extend({
  id: 'elementor-template-library-save-template',
  template: '#tmpl-elementor-template-library-save-template',
  ui: {
    form: '#elementor-template-library-save-template-form',
    submitButton: '#elementor-template-library-save-template-submit'
  },
  events: {
    'submit @ui.form': 'onFormSubmit'
  },
  getSaveType: function getSaveType() {
    var type;
    if (this.model) {
      type = this.model.get('elType');
    } else if (elementor.config.document.library && elementor.config.document.library.save_as_same_type) {
      type = elementor.config.document.type;
    } else {
      type = 'page';
    }
    return type;
  },
  templateHelpers: function templateHelpers() {
    var saveType = this.getSaveType(),
      templateType = elementor.templates.getTemplateTypes(saveType);
    return templateType.saveDialog;
  },
  onFormSubmit: function onFormSubmit(event) {
    event.preventDefault();
    var formData = this.ui.form.elementorSerializeObject(),
      saveType = this.getSaveType(),
      JSONParams = {
        remove: ['default']
      };
    formData.content = this.model ? [this.model.toJSON(JSONParams)] : elementor.elements.toJSON(JSONParams);
    this.ui.submitButton.addClass('elementor-button-state');
    elementor.templates.saveTemplate(saveType, formData);
  }
});
module.exports = TemplateLibrarySaveTemplateView;

/***/ }),

/***/ "../assets/dev/js/editor/components/template-library/views/parts/templates-empty.js":
/*!******************************************************************************************!*\
  !*** ../assets/dev/js/editor/components/template-library/views/parts/templates-empty.js ***!
  \******************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var __ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["__"];


var TemplateLibraryTemplatesEmptyView;
TemplateLibraryTemplatesEmptyView = Marionette.ItemView.extend({
  id: 'elementor-template-library-templates-empty',
  template: '#tmpl-elementor-template-library-templates-empty',
  ui: {
    title: '.elementor-template-library-blank-title',
    message: '.elementor-template-library-blank-message'
  },
  modesStrings: {
    empty: {
      title: __('Haven’t Saved Templates Yet?', 'elementor'),
      message: __('This is where your templates should be. Design it. Save it. Reuse it.', 'elementor')
    },
    noResults: {
      title: __('No Results Found', 'elementor'),
      message: __('Please make sure your search is spelled correctly or try a different words.', 'elementor')
    },
    noFavorites: {
      title: __('No Favorite Templates', 'elementor'),
      message: __('You can mark any pre-designed template as a favorite.', 'elementor')
    }
  },
  getCurrentMode: function getCurrentMode() {
    if (elementor.templates.getFilter('text')) {
      return 'noResults';
    }
    if (elementor.templates.getFilter('favorite')) {
      return 'noFavorites';
    }
    return 'empty';
  },
  onRender: function onRender() {
    var modeStrings = this.modesStrings[this.getCurrentMode()];
    this.ui.title.html(modeStrings.title);
    this.ui.message.html(modeStrings.message);
  }
});
module.exports = TemplateLibraryTemplatesEmptyView;

/***/ }),

/***/ "../assets/dev/js/editor/components/template-library/views/parts/templates.js":
/*!************************************************************************************!*\
  !*** ../assets/dev/js/editor/components/template-library/views/parts/templates.js ***!
  \************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var __ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["__"];


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _select = _interopRequireDefault(__webpack_require__(/*! elementor-editor-utils/select2.js */ "../assets/dev/js/editor/utils/select2.js"));
var TemplateLibraryTemplateLocalView = __webpack_require__(/*! elementor-templates/views/template/local */ "../assets/dev/js/editor/components/template-library/views/template/local.js"),
  TemplateLibraryTemplateRemoteView = __webpack_require__(/*! elementor-templates/views/template/remote */ "../assets/dev/js/editor/components/template-library/views/template/remote.js"),
  TemplateLibraryCollectionView;
TemplateLibraryCollectionView = Marionette.CompositeView.extend({
  template: '#tmpl-elementor-template-library-templates',
  id: 'elementor-template-library-templates',
  childViewContainer: '#elementor-template-library-templates-container',
  reorderOnSort: true,
  emptyView: function emptyView() {
    var EmptyView = __webpack_require__(/*! elementor-templates/views/parts/templates-empty */ "../assets/dev/js/editor/components/template-library/views/parts/templates-empty.js");
    return new EmptyView();
  },
  ui: {
    textFilter: '#elementor-template-library-filter-text',
    selectFilter: '.elementor-template-library-filter-select',
    myFavoritesFilter: '#elementor-template-library-filter-my-favorites',
    orderInputs: '.elementor-template-library-order-input',
    orderLabels: 'label.elementor-template-library-order-label'
  },
  events: {
    'input @ui.textFilter': 'onTextFilterInput',
    'change @ui.selectFilter': 'onSelectFilterChange',
    'change @ui.myFavoritesFilter': 'onMyFavoritesFilterChange',
    'mousedown @ui.orderLabels': 'onOrderLabelsClick'
  },
  comparators: {
    title: function title(model) {
      return model.get('title').toLowerCase();
    },
    popularityIndex: function popularityIndex(model) {
      var popularityIndex = model.get('popularityIndex');
      if (!popularityIndex) {
        popularityIndex = model.get('date');
      }
      return -popularityIndex;
    },
    trendIndex: function trendIndex(model) {
      var trendIndex = model.get('trendIndex');
      if (!trendIndex) {
        trendIndex = model.get('date');
      }
      return -trendIndex;
    }
  },
  getChildView: function getChildView(childModel) {
    if ('remote' === childModel.get('source')) {
      return TemplateLibraryTemplateRemoteView;
    }
    return TemplateLibraryTemplateLocalView;
  },
  initialize: function initialize() {
    this.listenTo(elementor.channels.templates, 'filter:change', this._renderChildren);
  },
  filter: function filter(childModel) {
    var filterTerms = elementor.templates.getFilterTerms(),
      passingFilter = true;
    jQuery.each(filterTerms, function (filterTermName) {
      var filterValue = elementor.templates.getFilter(filterTermName);
      if (!filterValue) {
        return;
      }
      if (this.callback) {
        var callbackResult = this.callback.call(childModel, filterValue);
        if (!callbackResult) {
          passingFilter = false;
        }
        return callbackResult;
      }
      var filterResult = filterValue === childModel.get(filterTermName);
      if (!filterResult) {
        passingFilter = false;
      }
      return filterResult;
    });
    return passingFilter;
  },
  order: function order(by, reverseOrder) {
    var comparator = this.comparators[by] || by;
    if (reverseOrder) {
      comparator = this.reverseOrder(comparator);
    }
    this.collection.comparator = comparator;
    this.collection.sort();
  },
  reverseOrder: function reverseOrder(comparator) {
    if ('function' !== typeof comparator) {
      var comparatorValue = comparator;
      comparator = function comparator(model) {
        return model.get(comparatorValue);
      };
    }
    return function (left, right) {
      var l = comparator(left);
      if (undefined === l) {
        return -1;
      }
      var r = comparator(right);
      if (undefined === r) {
        return 1;
      }
      if (l < r) {
        return 1;
      }
      if (l > r) {
        return -1;
      }
      return 0;
    };
  },
  addSourceData: function addSourceData() {
    var isEmpty = this.children.isEmpty();
    this.$el.attr('data-template-source', isEmpty ? 'empty' : elementor.templates.getFilter('source'));
  },
  setFiltersUI: function setFiltersUI() {
    if (!this.select2Instance) {
      var $filters = this.$(this.ui.selectFilter),
        select2Options = {
          placeholder: __('Category', 'elementor'),
          allowClear: true,
          width: 150,
          dropdownParent: this.$el
        };
      this.select2Instance = new _select.default({
        $element: $filters,
        options: select2Options
      });
    }
  },
  setMasonrySkin: function setMasonrySkin() {
    var masonry = new elementorModules.utils.Masonry({
      container: this.$childViewContainer,
      items: this.$childViewContainer.children()
    });
    this.$childViewContainer.imagesLoaded(masonry.run.bind(masonry));
  },
  toggleFilterClass: function toggleFilterClass() {
    this.$el.toggleClass('elementor-templates-filter-active', !!(elementor.templates.getFilter('text') || elementor.templates.getFilter('favorite')));
  },
  isPageOrLandingPageTemplates: function isPageOrLandingPageTemplates() {
    var templatesType = elementor.templates.getFilter('type');
    return 'page' === templatesType || 'lp' === templatesType;
  },
  onRender: function onRender() {
    if ('remote' === elementor.templates.getFilter('source') && 'page' !== elementor.templates.getFilter('type') && 'lb' !== elementor.templates.getFilter('type')) {
      this.setFiltersUI();
    }
  },
  onRenderCollection: function onRenderCollection() {
    this.addSourceData();
    this.toggleFilterClass();
    if ('remote' === elementor.templates.getFilter('source') && !this.isPageOrLandingPageTemplates()) {
      this.setMasonrySkin();
    }
  },
  onBeforeRenderEmpty: function onBeforeRenderEmpty() {
    this.addSourceData();
  },
  onTextFilterInput: function onTextFilterInput() {
    elementor.templates.setFilter('text', this.ui.textFilter.val());
  },
  onSelectFilterChange: function onSelectFilterChange(event) {
    var $select = jQuery(event.currentTarget),
      filterName = $select.data('elementor-filter');
    elementor.templates.setFilter(filterName, $select.val());
  },
  onMyFavoritesFilterChange: function onMyFavoritesFilterChange() {
    elementor.templates.setFilter('favorite', this.ui.myFavoritesFilter[0].checked);
  },
  onOrderLabelsClick: function onOrderLabelsClick(event) {
    var $clickedInput = jQuery(event.currentTarget.control),
      toggle;
    if (!$clickedInput[0].checked) {
      toggle = 'asc' !== $clickedInput.data('default-ordering-direction');
    }
    $clickedInput.toggleClass('elementor-template-library-order-reverse', toggle);
    this.order($clickedInput.val(), $clickedInput.hasClass('elementor-template-library-order-reverse'));
  }
});
module.exports = TemplateLibraryCollectionView;

/***/ }),

/***/ "../assets/dev/js/editor/components/template-library/views/template/base.js":
/*!**********************************************************************************!*\
  !*** ../assets/dev/js/editor/components/template-library/views/template/base.js ***!
  \**********************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var TemplateLibraryInsertTemplateBehavior = __webpack_require__(/*! elementor-templates/behaviors/insert-template */ "../assets/dev/js/editor/components/template-library/behaviors/insert-template.js"),
  TemplateLibraryTemplateView;
var _require = __webpack_require__(/*! elementor-utils/tiers */ "../assets/dev/js/utils/tiers.js"),
  isTierAtLeast = _require.isTierAtLeast,
  TIERS = _require.TIERS;
TemplateLibraryTemplateView = Marionette.ItemView.extend({
  className: function className() {
    var classes = 'elementor-template-library-template',
      source = this.model.get('source');
    classes += ' elementor-template-library-template-' + source;
    if ('remote' === source) {
      classes += ' elementor-template-library-template-' + this.model.get('type');
    }
    if (elementor.config.library_connect.base_access_tier !== this.model.get('accessTier')) {
      classes += ' elementor-template-library-pro-template';
    }
    return classes;
  },
  attributes: function attributes() {
    var userAccessTier = elementor.config.library_connect.current_access_tier;
    var templateAccessTier = this.model.get('accessTier');
    var canDownloadTemplate = isTierAtLeast(userAccessTier, templateAccessTier);

    // User with access to the template shouldn't see the badge.
    if (canDownloadTemplate) {
      return {};
    }
    var subscriptionPlans = elementor.config.library_connect.subscription_plans;
    var subscriptionPlan = subscriptionPlans[templateAccessTier];

    // Free user should see a generic "Pro" badge.
    if (userAccessTier === TIERS.free) {
      subscriptionPlan = subscriptionPlans.essential;
    }
    if (!subscriptionPlan) {
      return {};
    }
    return {
      style: "--elementor-template-library-subscription-plan-label: \"".concat(subscriptionPlan.label, "\";--elementor-template-library-subscription-plan-color: ").concat(subscriptionPlan.color, ";")
    };
  },
  ui: function ui() {
    return {
      previewButton: '.elementor-template-library-template-preview'
    };
  },
  events: function events() {
    return {
      'click @ui.previewButton': 'onPreviewButtonClick'
    };
  },
  behaviors: function behaviors() {
    var behaviors = {
      insertTemplate: {
        behaviorClass: TemplateLibraryInsertTemplateBehavior
      }
    };
    return elementor.hooks.applyFilters('elementor/editor/template-library/template/behaviors', behaviors, this);
  }
});
module.exports = TemplateLibraryTemplateView;

/***/ }),

/***/ "../assets/dev/js/editor/components/template-library/views/template/local.js":
/*!***********************************************************************************!*\
  !*** ../assets/dev/js/editor/components/template-library/views/template/local.js ***!
  \***********************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var TemplateLibraryTemplateView = __webpack_require__(/*! elementor-templates/views/template/base */ "../assets/dev/js/editor/components/template-library/views/template/base.js"),
  TemplateLibraryTemplateLocalView;
TemplateLibraryTemplateLocalView = TemplateLibraryTemplateView.extend({
  template: '#tmpl-elementor-template-library-template-local',
  ui: function ui() {
    return _.extend(TemplateLibraryTemplateView.prototype.ui.apply(this, arguments), {
      deleteButton: '.elementor-template-library-template-delete',
      morePopup: '.elementor-template-library-template-more',
      toggleMore: '.elementor-template-library-template-more-toggle',
      toggleMoreIcon: '.elementor-template-library-template-more-toggle i'
    });
  },
  events: function events() {
    return _.extend(TemplateLibraryTemplateView.prototype.events.apply(this, arguments), {
      'click @ui.deleteButton': 'onDeleteButtonClick',
      'click @ui.toggleMore': 'onToggleMoreClick'
    });
  },
  onDeleteButtonClick: function onDeleteButtonClick() {
    var toggleMoreIcon = this.ui.toggleMoreIcon;
    elementor.templates.deleteTemplate(this.model, {
      onConfirm: function onConfirm() {
        toggleMoreIcon.removeClass('eicon-ellipsis-h').addClass('eicon-loading eicon-animation-spin');
      },
      onSuccess: function onSuccess() {
        elementor.templates.showTemplates();
      }
    });
  },
  onToggleMoreClick: function onToggleMoreClick() {
    this.ui.morePopup.show();
  },
  onPreviewButtonClick: function onPreviewButtonClick() {
    open(this.model.get('url'), '_blank');
  }
});
module.exports = TemplateLibraryTemplateLocalView;

/***/ }),

/***/ "../assets/dev/js/editor/components/template-library/views/template/remote.js":
/*!************************************************************************************!*\
  !*** ../assets/dev/js/editor/components/template-library/views/template/remote.js ***!
  \************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var TemplateLibraryTemplateView = __webpack_require__(/*! elementor-templates/views/template/base */ "../assets/dev/js/editor/components/template-library/views/template/base.js"),
  TemplateLibraryTemplateRemoteView;
TemplateLibraryTemplateRemoteView = TemplateLibraryTemplateView.extend({
  template: '#tmpl-elementor-template-library-template-remote',
  ui: function ui() {
    return jQuery.extend(TemplateLibraryTemplateView.prototype.ui.apply(this, arguments), {
      favoriteCheckbox: '.elementor-template-library-template-favorite-input'
    });
  },
  events: function events() {
    return jQuery.extend(TemplateLibraryTemplateView.prototype.events.apply(this, arguments), {
      'change @ui.favoriteCheckbox': 'onFavoriteCheckboxChange'
    });
  },
  onPreviewButtonClick: function onPreviewButtonClick() {
    $e.route('library/preview', {
      model: this.model
    });
  },
  onFavoriteCheckboxChange: function onFavoriteCheckboxChange() {
    var isFavorite = this.ui.favoriteCheckbox[0].checked;
    this.model.set('favorite', isFavorite);
    elementor.templates.markAsFavorite(this.model, isFavorite);
    if (!isFavorite && elementor.templates.getFilter('favorite')) {
      elementor.channels.templates.trigger('filter:change');
    }
  }
});
module.exports = TemplateLibraryTemplateRemoteView;

/***/ }),

/***/ "../assets/dev/js/editor/components/validator/base.js":
/*!************************************************************!*\
  !*** ../assets/dev/js/editor/components/validator/base.js ***!
  \************************************************************/
/***/ ((module) => {

"use strict";


module.exports = elementorModules.Module.extend({
  errors: [],
  __construct: function __construct(settings) {
    var customValidationMethod = settings.customValidationMethod;
    if (customValidationMethod) {
      this.validationMethod = customValidationMethod;
    }
  },
  getDefaultSettings: function getDefaultSettings() {
    return {
      validationTerms: {}
    };
  },
  isValid: function isValid() {
    var validationErrors = this.validationMethod.apply(this, arguments);
    if (validationErrors.length) {
      this.errors = validationErrors;
      return false;
    }
    return true;
  },
  validationMethod: function validationMethod(newValue) {
    var validationTerms = this.getSettings('validationTerms'),
      errors = [];
    if (validationTerms.required) {
      if (!('' + newValue).length) {
        errors.push('Required value is empty');
      }
    }
    return errors;
  }
});

/***/ }),

/***/ "../assets/dev/js/editor/components/validator/breakpoint.js":
/*!******************************************************************!*\
  !*** ../assets/dev/js/editor/components/validator/breakpoint.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var NumberValidator = __webpack_require__(/*! elementor-validator/number */ "../assets/dev/js/editor/components/validator/number.js");
var BreakpointValidator = /*#__PURE__*/function (_NumberValidator) {
  (0, _inherits2.default)(BreakpointValidator, _NumberValidator);
  var _super = _createSuper(BreakpointValidator);
  function BreakpointValidator() {
    (0, _classCallCheck2.default)(this, BreakpointValidator);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(BreakpointValidator, [{
    key: "getDefaultSettings",
    value: function getDefaultSettings() {
      return {
        validationTerms: {
          // Max width we allow in general
          max: 5120
        }
      };
    }

    /**
     * Get Panel Active Breakpoints
     *
     * Since the active kit used in the Site Settings panel could be a draft, we need to use the panel's active
     * breakpoints settings and not the elementorFrontend.config values (which come from the DB).
     *
     * @return {*} Object
     */
  }, {
    key: "getPanelActiveBreakpoints",
    value: function getPanelActiveBreakpoints() {
      var panelBreakpoints = elementor.documents.currentDocument.config.settings.settings.active_breakpoints.map(function (breakpointName) {
          return breakpointName.replace('viewport_', '');
        }),
        panelActiveBreakpoints = {};
      panelBreakpoints.forEach(function (breakpointName) {
        panelActiveBreakpoints[breakpointName] = elementorFrontend.config.responsive.breakpoints[breakpointName];
      });
      return panelActiveBreakpoints;
    }
  }, {
    key: "initBreakpointProperties",
    value: function initBreakpointProperties() {
      var _activeBreakpoints$br, _activeBreakpoints$br2;
      var validationTerms = this.getSettings('validationTerms'),
        activeBreakpoints = this.getPanelActiveBreakpoints(),
        breakpointKeys = Object.keys(activeBreakpoints);
      this.breakpointIndex = breakpointKeys.indexOf(validationTerms.breakpointName);
      this.topBreakpoint = (_activeBreakpoints$br = activeBreakpoints[breakpointKeys[this.breakpointIndex + 1]]) === null || _activeBreakpoints$br === void 0 ? void 0 : _activeBreakpoints$br.value;
      this.bottomBreakpoint = (_activeBreakpoints$br2 = activeBreakpoints[breakpointKeys[this.breakpointIndex - 1]]) === null || _activeBreakpoints$br2 === void 0 ? void 0 : _activeBreakpoints$br2.value;
    }
  }, {
    key: "validationMethod",
    value: function validationMethod(newValue) {
      var validationTerms = this.getSettings('validationTerms'),
        errors = NumberValidator.prototype.validationMethod.call(this, newValue);

      // Validate both numeric and empty values, since breakpoints utilize default values when empty.
      if (_.isFinite(newValue) || '' === newValue) {
        if (!this.validateMinMaxForBreakpoint(newValue, validationTerms)) {
          errors.push('Value is not between the breakpoints above or under the edited breakpoint');
        }
      }
      return errors;
    }
  }, {
    key: "validateMinMaxForBreakpoint",
    value: function validateMinMaxForBreakpoint(newValue, validationTerms) {
      var breakpointDefaultValue = elementorFrontend.config.responsive.breakpoints[validationTerms.breakpointName].default_value;
      var isValid = true;
      this.initBreakpointProperties();

      // Since the following comparison is <=, allow usage of the 320px value for the mobile breakpoint.
      if ('mobile' === validationTerms.breakpointName && 320 === this.bottomBreakpoint) {
        this.bottomBreakpoint -= 1;
      }

      // If there is a breakpoint below the currently edited breakpoint
      if (this.bottomBreakpoint) {
        // Check that the new value is not under the bottom breakpoint's value.
        if ('' !== newValue && newValue <= this.bottomBreakpoint) {
          isValid = false;
        }

        // If the new value is empty, check that the default breakpoint value is not below the bottom breakpoint.
        if ('' === newValue && breakpointDefaultValue <= this.bottomBreakpoint) {
          isValid = false;
        }
      }

      // If there is a breakpoint above the currently edited breakpoint.
      if (this.topBreakpoint) {
        // Check that the value is not above the top breakpoint's value.
        if ('' !== newValue && newValue >= this.topBreakpoint) {
          isValid = false;
        }

        // If the new value is empty, check that the default breakpoint value is not above the top breakpoint.
        if ('' === newValue && breakpointDefaultValue >= this.topBreakpoint) {
          isValid = false;
        }
      }
      return isValid;
    }
  }]);
  return BreakpointValidator;
}(NumberValidator);
exports["default"] = BreakpointValidator;

/***/ }),

/***/ "../assets/dev/js/editor/components/validator/number.js":
/*!**************************************************************!*\
  !*** ../assets/dev/js/editor/components/validator/number.js ***!
  \**************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var Validator = __webpack_require__(/*! elementor-validator/base */ "../assets/dev/js/editor/components/validator/base.js");
module.exports = Validator.extend({
  validationMethod: function validationMethod(newValue) {
    var validationTerms = this.getSettings('validationTerms'),
      errors = [];
    if (_.isFinite(newValue)) {
      if (undefined !== validationTerms.min && newValue < validationTerms.min) {
        errors.push('Value is less than minimum');
      }
      if (undefined !== validationTerms.max && newValue > validationTerms.max) {
        errors.push('Value is greater than maximum');
      }
    }
    return errors;
  }
});

/***/ }),

/***/ "../assets/dev/js/editor/container/model/children-array.js":
/*!*****************************************************************!*\
  !*** ../assets/dev/js/editor/container/model/children-array.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _wrapNativeSuper2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/wrapNativeSuper */ "../node_modules/@babel/runtime/helpers/wrapNativeSuper.js"));
function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
/**
 * @typedef {import('../container')} Container
 */
var ChildrenArray = /*#__PURE__*/function (_Array) {
  (0, _inherits2.default)(ChildrenArray, _Array);
  var _super = _createSuper(ChildrenArray);
  function ChildrenArray() {
    (0, _classCallCheck2.default)(this, ChildrenArray);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(ChildrenArray, [{
    key: "clear",
    value: function clear() {
      this.length = 0;
    }

    /**
     * Function findRecursive().
     *
     * Will run over children recursively and pass the children to the callback till the callback returns positive value.
     *
     * @param {function(Container) : *} callback
     *
     * @return {Container|false} child
     */
  }, {
    key: "findRecursive",
    value: function findRecursive(callback) {
      var _iterator = _createForOfIteratorHelper(this),
        _step;
      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var container = _step.value;
          if (callback(container)) {
            return container;
          }
          if (container.children.length) {
            var foundChildren = container.children.findRecursive(callback);
            if (foundChildren) {
              return foundChildren;
            }
          }
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }
      return false;
    }

    /**
     * Function forEachRecursive().
     *
     * Will run over children recursively.
     *
     * @param {function(Container) : *} callback
     *
     * @return {void}
     */
  }, {
    key: "forEachRecursive",
    value: function forEachRecursive(callback) {
      var _iterator2 = _createForOfIteratorHelper(this),
        _step2;
      try {
        for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
          var container = _step2.value;
          callback(container);
          if (container.children.length) {
            container.children.forEachRecursive(callback);
          }
        }
      } catch (err) {
        _iterator2.e(err);
      } finally {
        _iterator2.f();
      }
    }

    /**
     * Function someRecursive().
     *
     * Will run over children recursively, breaks if the callback return true.
     *
     * @param {function(Container) : *} callback
     *
     */
  }, {
    key: "someRecursive",
    value: function someRecursive(callback) {
      var _iterator3 = _createForOfIteratorHelper(this),
        _step3;
      try {
        for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
          var _container$children;
          var container = _step3.value;
          if (callback(container)) {
            return true;
          }
          if ((_container$children = container.children) !== null && _container$children !== void 0 && _container$children.length) {
            if (container.children.someRecursive(callback)) {
              return true;
            }
          }
        }
      } catch (err) {
        _iterator3.e(err);
      } finally {
        _iterator3.f();
      }
      return false;
    }
  }]);
  return ChildrenArray;
}( /*#__PURE__*/(0, _wrapNativeSuper2.default)(Array));
exports["default"] = ChildrenArray;

/***/ }),

/***/ "../assets/dev/js/editor/controls/base-data.js":
/*!*****************************************************!*\
  !*** ../assets/dev/js/editor/controls/base-data.js ***!
  \*****************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "../node_modules/@babel/runtime/helpers/slicedToArray.js"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _breakpoint = _interopRequireDefault(__webpack_require__(/*! elementor-validator/breakpoint */ "../assets/dev/js/editor/components/validator/breakpoint.js"));
function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
var ControlBaseView = __webpack_require__(/*! elementor-controls/base */ "../assets/dev/js/editor/controls/base.js"),
  TagsBehavior = __webpack_require__(/*! elementor-dynamic-tags/control-behavior */ "../assets/dev/js/editor/components/dynamic-tags/control-behavior.js"),
  Validator = __webpack_require__(/*! elementor-validator/base */ "../assets/dev/js/editor/components/validator/base.js"),
  NumberValidator = __webpack_require__(/*! elementor-validator/number */ "../assets/dev/js/editor/components/validator/number.js"),
  ControlBaseDataView;
ControlBaseDataView = ControlBaseView.extend({
  validatorTypes: {
    Base: Validator,
    Number: NumberValidator,
    Breakpoint: _breakpoint.default
  },
  ui: function ui() {
    var ui = ControlBaseView.prototype.ui.apply(this, arguments);
    _.extend(ui, {
      input: 'input[data-setting][type!="checkbox"][type!="radio"]',
      checkbox: 'input[data-setting][type="checkbox"]',
      radio: 'input[data-setting][type="radio"]',
      select: 'select[data-setting]',
      textarea: 'textarea[data-setting]',
      responsiveSwitchersSibling: "".concat(ui.controlTitle, "[data-e-responsive-switcher-sibling!=\"false\"]"),
      responsiveSwitchers: '.elementor-responsive-switcher',
      contentEditable: '[contenteditable="true"]'
    });
    return ui;
  },
  templateHelpers: function templateHelpers() {
    var controlData = ControlBaseView.prototype.templateHelpers.apply(this, arguments);
    controlData.data.controlValue = this.getControlValue();
    return controlData;
  },
  events: function events() {
    return {
      'input @ui.input': 'onBaseInputTextChange',
      'change @ui.checkbox': 'onBaseInputChange',
      'change @ui.radio': 'onBaseInputChange',
      'input @ui.textarea': 'onBaseInputTextChange',
      'change @ui.select': 'onBaseInputChange',
      'input @ui.contentEditable': 'onBaseInputTextChange',
      'click @ui.responsiveSwitchers': 'onResponsiveSwitchersClick'
    };
  },
  behaviors: function behaviors() {
    var behaviors = ControlBaseView.prototype.behaviors.apply(this, arguments),
      dynamicSettings = this.options.model.get('dynamic');
    if (dynamicSettings && dynamicSettings.active) {
      var tags = _.filter(elementor.dynamicTags.getConfig('tags'), function (tag) {
        return tag.editable && _.intersection(tag.categories, dynamicSettings.categories).length;
      });
      if (tags.length || elementor.config.user.is_administrator) {
        behaviors.tags = {
          behaviorClass: TagsBehavior,
          tags: tags,
          dynamicSettings: dynamicSettings
        };
      }
    }
    return behaviors;
  },
  initialize: function initialize() {
    ControlBaseView.prototype.initialize.apply(this, arguments);
    this.registerValidators();
    if (this.model.get('responsive')) {
      this.setPlaceholderFromParent();
    }
    if (undefined === this.model.get('inherit_placeholders')) {
      this.model.set('inherit_placeholders', true);
    }

    // TODO: this.elementSettingsModel is deprecated since 2.8.0.
    var settings = this.container ? this.container.settings : this.elementSettingsModel;
    this.listenTo(settings, 'change:external:' + this.model.get('name'), this.onAfterExternalChange);
  },
  getControlValue: function getControlValue() {
    return this.container.settings.get(this.model.get('name'));
  },
  getGlobalKey: function getGlobalKey() {
    return this.container.globals.get(this.model.get('name'));
  },
  getGlobalValue: function getGlobalValue() {
    return this.globalValue;
  },
  getGlobalDefault: function getGlobalDefault() {
    var controlGlobalArgs = this.model.get('global');
    if (controlGlobalArgs !== null && controlGlobalArgs !== void 0 && controlGlobalArgs.default) {
      // If the control is a color/typography control and default colors/typography are disabled, don't return the global value.
      if (!elementor.config.globals.defaults_enabled[this.getGlobalMeta().controlType]) {
        return '';
      }
      var _$e$data$commandExtra = $e.data.commandExtractArgs(controlGlobalArgs.default),
        command = _$e$data$commandExtra.command,
        args = _$e$data$commandExtra.args,
        result = $e.data.getCache($e.components.get('globals'), command, args.query);
      return result === null || result === void 0 ? void 0 : result.value;
    }

    // No global default.
    return '';
  },
  getCurrentValue: function getCurrentValue() {
    if (this.getGlobalKey() && !this.globalValue) {
      return '';
    }
    if (this.globalValue) {
      return this.globalValue;
    }
    var controlValue = this.getControlValue();
    if (controlValue) {
      return controlValue;
    }
    return this.getGlobalDefault();
  },
  isGlobalActive: function isGlobalActive() {
    var _this$options$model$g;
    return (_this$options$model$g = this.options.model.get('global')) === null || _this$options$model$g === void 0 ? void 0 : _this$options$model$g.active;
  },
  setValue: function setValue(value) {
    this.setSettingsModel(value);
  },
  setSettingsModel: function setSettingsModel(value) {
    var key = this.model.get('name');
    $e.run('document/elements/settings', {
      container: this.options.container,
      settings: (0, _defineProperty2.default)({}, key, value)
    });
    this.triggerMethod('settings:change');
  },
  applySavedValue: function applySavedValue() {
    this.setInputValue('[data-setting="' + this.model.get('name') + '"]', this.getControlValue());
  },
  getEditSettings: function getEditSettings(setting) {
    var settings = this.getOption('elementEditSettings').toJSON();
    if (setting) {
      return settings[setting];
    }
    return settings;
  },
  setEditSetting: function setEditSetting(settingKey, settingValue) {
    var settings = this.getOption('elementEditSettings') || this.getOption('container').settings;
    settings.set(settingKey, settingValue);
  },
  /**
   * Get the placeholder for the current control.
   *
   * @return {*} placeholder
   */
  getControlPlaceholder: function getControlPlaceholder() {
    var placeholder = this.model.get('placeholder');
    if (this.model.get('responsive') && this.model.get('inherit_placeholders')) {
      placeholder = placeholder || this.container.placeholders[this.model.get('name')];
    }
    return placeholder;
  },
  /**
   * Get the responsive parent view if exists.
   *
   * @return {ControlBaseDataView|undefined} responsive parent view if exists
   */
  getResponsiveParentView: function getResponsiveParentView() {
    var parent = this.model.get('parent');
    try {
      return parent && this.container.panel.getControlView(parent);
      // eslint-disable-next-line no-empty
    } catch (e) {}
  },
  /**
   * Get the responsive children views if exists.
   *
   * @return {ControlBaseDataView|null} responsive children views if exists
   */
  getResponsiveChildrenViews: function getResponsiveChildrenViews() {
    var children = this.model.get('inheritors'),
      views = [];
    try {
      var _iterator = _createForOfIteratorHelper(children),
        _step;
      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var child = _step.value;
          views.push(this.container.panel.getControlView(child));
        }
        // eslint-disable-next-line no-empty
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }
    } catch (e) {}
    return views;
  },
  /**
   * Get prepared placeholder from the responsive parent, and put it into current
   * control model as placeholder.
   */
  setPlaceholderFromParent: function setPlaceholderFromParent() {
    var parent = this.getResponsiveParentView();
    if (parent) {
      this.container.placeholders[this.model.get('name')] = parent.preparePlaceholderForChildren();
    }
  },
  /**
   * Returns the value of the current control if exists, or the parent value if not,
   * so responsive children can set it as their placeholder. When there are multiple
   * inputs, the inputs which are empty on this control will inherit their values
   * from the responsive parent.
   * For example, if on desktop the padding of all edges is 10, and on tablet only
   * padding right and left is set to 15, the mobile control placeholder will
   * eventually be: { top: 10, right: 15, left: 15, bottom: 10 }, because of the
   * inheritance of multiple values.
   *
   * @return {*} value of the current control if exists, or the parent value if not
   */
  preparePlaceholderForChildren: function preparePlaceholderForChildren() {
    var _this$getResponsivePa;
    var cleanValue = this.getCleanControlValue(),
      parentValue = (_this$getResponsivePa = this.getResponsiveParentView()) === null || _this$getResponsivePa === void 0 ? void 0 : _this$getResponsivePa.preparePlaceholderForChildren();
    if (cleanValue instanceof Object) {
      return Object.assign({}, parentValue, cleanValue);
    }
    return cleanValue || parentValue;
  },
  /**
   * Start the re-rendering recursive chain from the responsive child of this
   * control. It's useful when the current control value is changed and we want
   * to update all responsive children. In this case, the re-rendering is supposed
   * to be applied only from the responsive child of this control and on.
   */
  propagatePlaceholder: function propagatePlaceholder() {
    var children = this.getResponsiveChildrenViews();
    var _iterator2 = _createForOfIteratorHelper(children),
      _step2;
    try {
      for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
        var child = _step2.value;
        child.renderWithChildren();
      }
    } catch (err) {
      _iterator2.e(err);
    } finally {
      _iterator2.f();
    }
  },
  /**
   * Re-render current control and trigger this method on the responsive child.
   * The purpose of those actions is to recursively re-render all responsive
   * children.
   */
  renderWithChildren: function renderWithChildren() {
    this.render();
    this.propagatePlaceholder();
  },
  /**
   * Get control value without empty properties, and without default values.
   *
   * @return {{}} control value without empty properties, and without default values
   */
  getCleanControlValue: function getCleanControlValue() {
    var value = this.getControlValue();
    return value && value !== this.model.get('default') ? value : undefined;
  },
  onAfterChange: function onAfterChange(control) {
    if (Object.keys(control.changed).includes(this.model.get('name'))) {
      this.propagatePlaceholder();
    }
    ControlBaseView.prototype.onAfterChange.apply(this, arguments);
  },
  getInputValue: function getInputValue(input) {
    var $input = this.$(input);
    if ($input.is('[contenteditable="true"]')) {
      return $input.html();
    }
    var inputValue = $input.val(),
      inputType = $input.attr('type');
    if (-1 !== ['radio', 'checkbox'].indexOf(inputType)) {
      return $input.prop('checked') ? inputValue : '';
    }
    if ('number' === inputType && _.isFinite(inputValue)) {
      return +inputValue;
    }

    // Temp fix for jQuery (< 3.0) that return null instead of empty array
    if ('SELECT' === input.tagName && $input.prop('multiple') && null === inputValue) {
      inputValue = [];
    }
    return inputValue;
  },
  setInputValue: function setInputValue(input, value) {
    var $input = this.$(input),
      inputType = $input.attr('type');
    if ('checkbox' === inputType) {
      $input.prop('checked', !!value);
    } else if ('radio' === inputType) {
      $input.filter('[value="' + value + '"]').prop('checked', true);
    } else {
      $input.val(value);
    }
  },
  addValidator: function addValidator(validator) {
    this.validators.push(validator);
  },
  registerValidators: function registerValidators() {
    var _this = this;
    this.validators = [];
    var validationTerms = {};
    if (this.model.get('required')) {
      validationTerms.required = true;
    }
    if (!jQuery.isEmptyObject(validationTerms)) {
      this.addValidator(new this.validatorTypes.Base({
        validationTerms: validationTerms
      }));
    }
    var validators = this.model.get('validators');
    if (validators) {
      Object.entries(validators).forEach(function (_ref) {
        var _ref2 = (0, _slicedToArray2.default)(_ref, 2),
          key = _ref2[0],
          args = _ref2[1];
        _this.addValidator(new _this.validatorTypes[key]({
          validationTerms: args
        }));
      });
    }
  },
  onBeforeRender: function onBeforeRender() {
    this.setPlaceholderFromParent();
  },
  onRender: function onRender() {
    ControlBaseView.prototype.onRender.apply(this, arguments);
    if (this.model.get('responsive')) {
      this.renderResponsiveSwitchers();
    }
    this.applySavedValue();
    this.triggerMethod('ready');
    this.toggleControlVisibility();
    this.addTooltip();
  },
  onBaseInputTextChange: function onBaseInputTextChange(event) {
    this.onBaseInputChange(event);
  },
  onBaseInputChange: function onBaseInputChange(event) {
    clearTimeout(this.correctionTimeout);
    var input = event.currentTarget,
      value = this.getInputValue(input),
      validators = this.validators.slice(0),
      settingsValidators = this.container.settings.validators[this.model.get('name')];
    if (settingsValidators) {
      validators = validators.concat(settingsValidators);
    }
    if (validators) {
      var oldValue = this.getControlValue(input.dataset.setting);
      var isValidValue = validators.every(function (validator) {
        return validator.isValid(value, oldValue);
      });
      if (!isValidValue) {
        this.correctionTimeout = setTimeout(this.setInputValue.bind(this, input, oldValue), 1200);
        return;
      }
    }
    this.updateElementModel(value, input);
    this.triggerMethod('input:change', event);
  },
  onResponsiveSwitchersClick: function onResponsiveSwitchersClick(event) {
    var $switcher = jQuery(event.currentTarget),
      device = $switcher.data('device'),
      $switchersWrapper = this.ui.responsiveSwitchersWrapper,
      selectedOption = $switcher.index();
    $switchersWrapper.toggleClass('elementor-responsive-switchers-open');
    $switchersWrapper[0].style.setProperty('--selected-option', selectedOption);
    this.triggerMethod('responsive:switcher:click', device);
    elementor.changeDeviceMode(device);
  },
  renderResponsiveSwitchers: function renderResponsiveSwitchers() {
    var templateHtml = Marionette.Renderer.render('#tmpl-elementor-control-responsive-switchers', this.model.attributes);
    this.ui.responsiveSwitchersSibling.after(templateHtml);
    this.ui.responsiveSwitchersWrapper = this.$el.find('.elementor-control-responsive-switchers');
  },
  onAfterExternalChange: function onAfterExternalChange() {
    this.hideTooltip();
    this.applySavedValue();
  },
  addTooltip: function addTooltip() {
    this.ui.tooltipTargets = this.$el.find('.tooltip-target');
    if (!this.ui.tooltipTargets.length) {
      return;
    }

    // Create tooltip on controls
    this.ui.tooltipTargets.tipsy({
      gravity: function gravity() {
        // `n` for down, `s` for up
        var gravity = jQuery(this).data('tooltip-pos');
        if (undefined !== gravity) {
          return gravity;
        }
        return 's';
      },
      title: function title() {
        return this.getAttribute('data-tooltip');
      }
    });
  },
  hideTooltip: function hideTooltip() {
    if (this.ui.tooltipTargets.length) {
      this.ui.tooltipTargets.tipsy('hide');
    }
  },
  updateElementModel: function updateElementModel(value) {
    this.setValue(value);
  }
}, {
  // Static methods
  getStyleValue: function getStyleValue(placeholder, controlValue, controlData) {
    if ('DEFAULT' === placeholder) {
      return controlData.default;
    }
    return controlValue;
  },
  onPasteStyle: function onPasteStyle() {
    return true;
  }
});
module.exports = ControlBaseDataView;

/***/ }),

/***/ "../assets/dev/js/editor/controls/base-multiple.js":
/*!*********************************************************!*\
  !*** ../assets/dev/js/editor/controls/base-multiple.js ***!
  \*********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js"));
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "../node_modules/@babel/runtime/helpers/slicedToArray.js"));
var ControlBaseDataView = __webpack_require__(/*! elementor-controls/base-data */ "../assets/dev/js/editor/controls/base-data.js"),
  ControlBaseMultipleItemView;
ControlBaseMultipleItemView = ControlBaseDataView.extend({
  applySavedValue: function applySavedValue() {
    var values = this.getControlValue(),
      $inputs = this.$('[data-setting]'),
      self = this;
    _.each(values, function (value, key) {
      var $input = $inputs.filter(function () {
        return key === this.dataset.setting;
      });
      self.setInputValue($input, value);
    });
  },
  getControlValue: function getControlValue(key) {
    var values = this.container.settings.get(this.model.get('name'));
    if (!jQuery.isPlainObject(values)) {
      return {};
    }
    if (key) {
      var value = values[key];
      if (undefined === value) {
        value = '';
      }
      return value;
    }
    return elementorCommon.helpers.cloneObject(values);
  },
  /**
   * @inheritDoc
   */
  getCleanControlValue: function getCleanControlValue(key) {
    var _this = this;
    var values = Object.fromEntries(Object.entries(this.getControlValue()).filter(function (_ref) {
      var _ref2 = (0, _slicedToArray2.default)(_ref, 2),
        k = _ref2[0],
        v = _ref2[1];
      return v && _this.model.get('default')[k] !== v;
    }));
    if (key) {
      return values === null || values === void 0 ? void 0 : values[key];
    }
    return Object.keys(values).length ? values : undefined;
  },
  setValue: function setValue(key, value) {
    var values = this.getControlValue();
    if ('object' === (0, _typeof2.default)(key)) {
      _.each(key, function (internalValue, internalKey) {
        values[internalKey] = internalValue;
      });
    } else {
      values[key] = value;
    }
    this.setSettingsModel(values);
  },
  updateElementModel: function updateElementModel(value, input) {
    var key = input.dataset.setting;
    this.setValue(key, value);
  }
}, {
  // Static methods
  getStyleValue: function getStyleValue(placeholder, controlValue) {
    if (!_.isObject(controlValue)) {
      return ''; // Invalid
    }

    return controlValue[placeholder.toLowerCase()];
  }
});
module.exports = ControlBaseMultipleItemView;

/***/ }),

/***/ "../assets/dev/js/editor/controls/base-units.js":
/*!******************************************************!*\
  !*** ../assets/dev/js/editor/controls/base-units.js ***!
  \******************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
var ControlBaseMultipleItemView = __webpack_require__(/*! elementor-controls/base-multiple */ "../assets/dev/js/editor/controls/base-multiple.js"),
  ControlBaseUnitsItemView;
ControlBaseUnitsItemView = ControlBaseMultipleItemView.extend({
  ui: function ui() {
    return Object.assign(ControlBaseMultipleItemView.prototype.ui.apply(this, arguments), {
      units: '.e-units-choices>input',
      unitSwitcher: '.e-units-switcher',
      unitChoices: '.e-units-choices'
    });
  },
  events: function events() {
    return Object.assign(ControlBaseMultipleItemView.prototype.events.apply(this, arguments), {
      'change @ui.units': 'onUnitChange',
      'click @ui.units': 'onUnitClick',
      'click @ui.unitSwitcher': 'onUnitLabelClick'
    });
  },
  updatePlaceholder: function updatePlaceholder() {
    var _this$getControlPlace;
    var placeholder = (_this$getControlPlace = this.getControlPlaceholder()) === null || _this$getControlPlace === void 0 ? void 0 : _this$getControlPlace.unit;
    this.ui.units.removeClass('e-units-placeholder');
    var currentUnitSelected = this.getControlValue('unit');
    if (placeholder !== currentUnitSelected) {
      this.ui.units.filter("[value=\"".concat(placeholder, "\"]")).addClass('e-units-placeholder');
    }
  },
  recursiveUnitChange: function recursiveUnitChange() {
    var includingSelf = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;
    var parent = this.getResponsiveParentView();
    if (parent && includingSelf) {
      var unit = parent.getControlValue('unit'),
        values = Object.keys(this.getCleanControlValue() || {});

      // Remove `unit` from values, so only control values are indicated.
      values.splice(values.indexOf('unit'), 1);

      // Only set the unit when no control values are already specified.
      if (unit && !values.length) {
        this.setValue('unit', unit);
        this.render();
      }
    }
    var _iterator = _createForOfIteratorHelper(this.getResponsiveChildrenViews()),
      _step;
    try {
      for (_iterator.s(); !(_step = _iterator.n()).done;) {
        var child = _step.value;
        child.recursiveUnitChange();
      }
    } catch (err) {
      _iterator.e(err);
    } finally {
      _iterator.f();
    }
  },
  onRender: function onRender() {
    ControlBaseMultipleItemView.prototype.onRender.apply(this, arguments);
    this.updatePlaceholder();
    this.updateUnitChoices();
  },
  onUnitChange: function onUnitChange() {
    this.toggleUnitChoices(false);
    this.recursiveUnitChange(false);
    this.updatePlaceholder();
    this.updateUnitChoices();
  },
  toggleUnitChoices: function toggleUnitChoices(stateVal) {
    this.ui.unitChoices.toggleClass('e-units-choices-open', stateVal);
  },
  updateUnitChoices: function updateUnitChoices() {
    var unit = this.getControlValue('unit');
    this.ui.unitSwitcher.attr('data-selected', unit).find('span').html(unit);
    this.$el.toggleClass('e-units-custom', this.isCustomUnit());
  },
  onUnitClick: function onUnitClick() {
    this.toggleUnitChoices(false);
  },
  onUnitLabelClick: function onUnitLabelClick(event) {
    event.preventDefault();
    this.toggleUnitChoices();
  },
  getCurrentRange: function getCurrentRange() {
    return this.getUnitRange(this.getControlValue('unit'));
  },
  getUnitRange: function getUnitRange(unit) {
    var ranges = this.model.get('range');
    if (!ranges) {
      return false;
    }
    if (!ranges[unit]) {
      ranges[unit] = Object.values(ranges)[0];
    }
    return ranges[unit];
  },
  isCustomUnit: function isCustomUnit() {
    return 'custom' === this.getControlValue('unit');
  }
}, {
  // Static methods
  getStyleValue: function getStyleValue(placeholder, controlValue) {
    var returnValue = ControlBaseMultipleItemView.getStyleValue(placeholder, controlValue);
    if ('UNIT' === placeholder && 'custom' === returnValue) {
      returnValue = '__EMPTY__';
    }
    return returnValue;
  }
});
module.exports = ControlBaseUnitsItemView;

/***/ }),

/***/ "../assets/dev/js/editor/controls/base.js":
/*!************************************************!*\
  !*** ../assets/dev/js/editor/controls/base.js ***!
  \************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
var ControlBaseView;
ControlBaseView = Marionette.CompositeView.extend({
  ui: function ui() {
    return {
      controlTitle: '.elementor-control-title'
    };
  },
  behaviors: function behaviors() {
    var behaviors = {};
    return elementor.hooks.applyFilters('controls/base/behaviors', behaviors, this);
  },
  getBehavior: function getBehavior(name) {
    return this._behaviors[Object.keys(this.behaviors()).indexOf(name)];
  },
  className: function className() {
    // TODO: Any better classes for that?
    var classes = 'elementor-control elementor-control-' + this.model.get('name') + ' elementor-control-type-' + this.model.get('type'),
      modelClasses = this.model.get('classes'),
      responsive = this.model.get('responsive');
    if (!_.isEmpty(modelClasses)) {
      classes += ' ' + modelClasses;
    }
    if (!_.isEmpty(responsive)) {
      var responsiveControlName = responsive.max || responsive.min;
      classes += ' elementor-control-responsive-' + responsiveControlName;
    }
    return classes;
  },
  templateHelpers: function templateHelpers() {
    var controlData = {
      _cid: this.model.cid
    };
    return {
      view: this,
      data: _.extend({}, this.model.toJSON(), controlData)
    };
  },
  getTemplate: function getTemplate() {
    return Marionette.TemplateCache.get('#tmpl-elementor-control-' + this.model.get('type') + '-content');
  },
  initialize: function initialize(options) {
    var label = this.model.get('label');

    // TODO: Temp backwards compatibility. since 2.8.0.
    Object.defineProperty(this, 'container', {
      get: function get() {
        if (!options.container) {
          var settingsModel = options.elementSettingsModel,
            view = $e.components.get('document').utils.findViewById(settingsModel.id);

          // Element control.
          if (view && view.getContainer) {
            options.container = view.getContainer();
          } else {
            if (!settingsModel.id) {
              settingsModel.id = 'bc-' + elementorCommon.helpers.getUniqueId();
            }

            // Document/General/Other control.
            options.container = new elementorModules.editor.Container({
              type: 'bc-container',
              id: settingsModel.id,
              model: settingsModel,
              settings: settingsModel,
              label: label,
              view: false,
              parent: false,
              renderer: false,
              controls: settingsModel.options.controls
            });
          }
        }
        return options.container;
      }
    });

    // Use `defineProperty` because `get elementSettingsModel()` fails during the `Marionette.CompositeView.extend`.
    Object.defineProperty(this, 'elementSettingsModel', {
      get: function get() {
        elementorDevTools.deprecation.deprecated('elementSettingsModel', '2.8.0', 'container.settings');
        return options.container ? options.container.settings : options.elementSettingsModel;
      }
    });
    var controlType = this.model.get('type'),
      controlSettings = jQuery.extend(true, {}, elementor.config.controls[controlType], this.model.attributes);
    this.model.set(controlSettings);

    // TODO: this.elementSettingsModel is deprecated since 2.8.0.
    var settings = this.container ? this.container.settings : this.elementSettingsModel;
    this.listenTo(settings, 'change', this.onAfterChange);
    if (this.model.attributes.responsive) {
      this.onDeviceModeChange = this.onDeviceModeChange.bind(this);
      elementor.listenTo(elementor.channels.deviceMode, 'change', this.onDeviceModeChange);
    }
  },
  onDestroy: function onDestroy() {
    elementor.stopListening(elementor.channels.deviceMode, 'change', this.onDeviceModeChange);
  },
  onDeviceModeChange: function onDeviceModeChange() {
    this.toggleControlVisibility();
  },
  onAfterChange: function onAfterChange() {
    this.toggleControlVisibility();
  },
  toggleControlVisibility: function toggleControlVisibility() {
    // TODO: this.elementSettingsModel is deprecated since 2.8.0.
    var settings = this.container ? this.container.settings : this.elementSettingsModel;
    var isVisible = elementor.helpers.isActiveControl(this.model, settings.attributes, settings.controls);
    this.$el.toggleClass('elementor-hidden-control', !isVisible);
    elementor.getPanelView().updateScrollbar();
  },
  onRender: function onRender() {
    var layoutType = this.model.get('label_block') ? 'block' : 'inline',
      showLabel = this.model.get('show_label'),
      elClasses = 'elementor-label-' + layoutType;
    elClasses += ' elementor-control-separator-' + this.model.get('separator');
    if (!showLabel) {
      elClasses += ' elementor-control-hidden-label';
    }
    this.$el.addClass(elClasses);
    this.toggleControlVisibility();
  },
  reRoute: function reRoute(controlActive) {
    $e.route($e.routes.getCurrent('panel'), this.getControlInRouteArgs(controlActive ? this.getControlPath() : ''), {
      history: false
    });
  },
  getControlInRouteArgs: function getControlInRouteArgs(path) {
    return _objectSpread(_objectSpread({}, $e.routes.getCurrentArgs('panel')), {}, {
      activeControl: path
    });
  },
  getControlPath: function getControlPath() {
    var controlPath = this.model.get('name'),
      parent = this._parent;
    while (!parent.$el.hasClass('elementor-controls-stack')) {
      var parentName = parent.model.get('name') || parent.model.get('_id');
      controlPath = parentName + '/' + controlPath;
      parent = parent._parent;
    }
    return controlPath;
  }
});
module.exports = ControlBaseView;

/***/ }),

/***/ "../assets/dev/js/editor/controls/behaviors/scrubbing.js":
/*!***************************************************************!*\
  !*** ../assets/dev/js/editor/controls/behaviors/scrubbing.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _assertThisInitialized2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/assertThisInitialized */ "../node_modules/@babel/runtime/helpers/assertThisInitialized.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _uiStates = __webpack_require__(/*! elementor-document/ui-states */ "../assets/dev/js/editor/document/ui-states/index.js");
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var SCRUB_REGULAR = 'UPDATE-VALUE';
var SCRUB_ENHANCED = 'UPDATE-VALUE-ENHANCED';
var SKIP_SCRUB = 'SKIP-UPDATE-VALUE';
var Scrubbing = /*#__PURE__*/function (_Marionette$Behavior) {
  (0, _inherits2.default)(Scrubbing, _Marionette$Behavior);
  var _super = _createSuper(Scrubbing);
  function Scrubbing() {
    var _this;
    (0, _classCallCheck2.default)(this, Scrubbing);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "checkIntentTimeout", null);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "skipperCount", 0);
    var userOptions = _this.getOption('scrubSettings') || {};
    _this.scrubSettings = _objectSpread({
      intentTime: 600,
      skipperSteps: 10,
      valueModifier: 1,
      enhancedNumber: 10,
      scrubbingActiveClass: 'e-scrubbing--active',
      scrubbingOverClass: 'e-scrubbing-over'
    }, userOptions);
    return _this;
  }
  (0, _createClass2.default)(Scrubbing, [{
    key: "ui",
    value: function ui() {
      return {
        input: 'input[type=number]',
        label: 'label[for^="elementor-control-"]'
      };
    }
  }, {
    key: "events",
    value: function events() {
      return {
        'mousedown @ui.input': 'onMouseDownInput',
        'mousedown @ui.label': 'onMouseDownLabel',
        'mouseenter @ui.label': 'onMouseEnterLabel',
        'mouseleave @ui.label': 'onMouseLeaveLabel'
      };
    }
  }, {
    key: "scrub",
    value: function scrub(input, movementEvent) {
      var movementType = this.getMovementType(movementEvent);
      if (SKIP_SCRUB === movementType) {
        return;
      }
      switch (movementType) {
        case SCRUB_REGULAR:
          input.value = this.getModifiedValue({
            value: input.value,
            change: movementEvent.movementX,
            modifier: this.scrubSettings.valueModifier
          });
          break;
        case SCRUB_ENHANCED:
          input.value = this.getModifiedValue({
            value: input.value,
            change: movementEvent.movementX,
            modifier: this.scrubSettings.enhancedNumber
          });
          break;
        default:
          break;
      }

      // Fire an input event so other behaviors/validators can handle the new input
      input.dispatchEvent(new Event('input', {
        bubbles: true
      }));
    }
  }, {
    key: "getMovementType",
    value: function getMovementType(movementEvent) {
      if (movementEvent.altKey) {
        this.skipperCount++;

        // When ALT key is pressed, skipping x times before updating input value.
        // 'skipperSteps' defines the exact times to skip, can be changed to any number.
        if (this.skipperCount <= this.scrubSettings.skipperSteps) {
          return SKIP_SCRUB;
        }
        this.skipperCount = 0;
        return SCRUB_REGULAR;
      }
      return movementEvent.ctrlKey || movementEvent.metaKey ? SCRUB_ENHANCED : SCRUB_REGULAR;
    }
  }, {
    key: "getModifiedValue",
    value: function getModifiedValue(_ref) {
      var value = _ref.value,
        change = _ref.change,
        modifier = _ref.modifier;
      if ('function' === typeof modifier) {
        modifier = modifier();
      }
      var newValue = +value + change * modifier;

      // Prevent cases where the value resolves to something like 1.0000000000000001.
      return parseFloat(newValue.toFixed(1));
    }
  }, {
    key: "isInputValidForScrubbing",
    value: function isInputValidForScrubbing(input) {
      return input && !input.disabled && 'number' === input.type;
    }

    /**
     * @param {HTMLElement[]} elements
     */
  }, {
    key: "setActive",
    value: function setActive(elements) {
      var _this2 = this;
      elements.forEach(function (element) {
        element.classList.add(_this2.scrubSettings.scrubbingActiveClass);
      });
    }

    /**
     * @param {HTMLElement[]} elements
     */
  }, {
    key: "setInactive",
    value: function setInactive(elements) {
      var _this3 = this;
      elements.forEach(function (element) {
        element.classList.remove(_this3.scrubSettings.scrubbingActiveClass);
      });
    }
  }, {
    key: "onMouseDownInput",
    value: function onMouseDownInput(e) {
      var _this4 = this;
      var input = e.target;
      if (!this.isInputValidForScrubbing(input)) {
        return;
      }
      var trackMovement = function trackMovement(movementEvent) {
        _this4.scrub(input, movementEvent);
      };

      // For input, scrubbing effect works only after X time the mouse is down.
      var checkIntentTimeout = setTimeout(function () {
        clearTimeout(checkIntentTimeout);
        document.addEventListener('mousemove', trackMovement);
        $e.uiStates.set('document/scrubbing-mode', _uiStates.ScrubbingMode.ON);
        _this4.setActive([input]);
      }, this.scrubSettings.intentTime);
      document.addEventListener('mouseup', function () {
        document.removeEventListener('mousemove', trackMovement);
        clearTimeout(checkIntentTimeout);
        $e.uiStates.remove('document/scrubbing-mode');
        _this4.setInactive([input]);
      }, {
        once: true
      });
    }
  }, {
    key: "onMouseDownLabel",
    value: function onMouseDownLabel(e) {
      var _this5 = this;
      var label = e.target;
      var input = e.target.control;
      if (!this.isInputValidForScrubbing(input)) {
        return;
      }
      $e.uiStates.set('document/scrubbing-mode', _uiStates.ScrubbingMode.ON);
      this.setActive([input, label]);
      var trackMovement = function trackMovement(movementEvent) {
        _this5.scrub(input, movementEvent);
      };
      document.addEventListener('mousemove', trackMovement);
      document.addEventListener('mouseup', function () {
        document.removeEventListener('mousemove', trackMovement);
        $e.uiStates.remove('document/scrubbing-mode');
        _this5.setInactive([input, label]);
      }, {
        once: true
      });
    }
  }, {
    key: "onMouseEnterLabel",
    value: function onMouseEnterLabel(e) {
      var input = e.target.control;
      if (!this.isInputValidForScrubbing(input)) {
        return;
      }
      e.target.classList.add(this.scrubSettings.scrubbingOverClass);
    }
  }, {
    key: "onMouseLeaveLabel",
    value: function onMouseLeaveLabel(e) {
      var input = e.target.control;
      if (!this.isInputValidForScrubbing(input)) {
        return;
      }
      e.target.classList.remove(this.scrubSettings.scrubbingOverClass);
    }
  }]);
  return Scrubbing;
}(Marionette.Behavior);
exports["default"] = Scrubbing;

/***/ }),

/***/ "../assets/dev/js/editor/controls/box-shadow.js":
/*!******************************************************!*\
  !*** ../assets/dev/js/editor/controls/box-shadow.js ***!
  \******************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _colorPicker = _interopRequireDefault(__webpack_require__(/*! ../utils/color-picker */ "../assets/dev/js/editor/utils/color-picker.js"));
var ControlMultipleBaseItemView = __webpack_require__(/*! elementor-controls/base-multiple */ "../assets/dev/js/editor/controls/base-multiple.js"),
  ControlBoxShadowItemView;
ControlBoxShadowItemView = ControlMultipleBaseItemView.extend({
  ui: function ui() {
    var ui = ControlMultipleBaseItemView.prototype.ui.apply(this, arguments);
    ui.sliders = '.elementor-slider';
    ui.colorPickerPlaceholder = '.elementor-color-picker-placeholder';
    return ui;
  },
  initSliders: function initSliders() {
    var _this = this;
    var value = this.getControlValue();
    this.ui.sliders.each(function (index, slider) {
      var $input = jQuery(slider).next('.elementor-slider-input').find('input');
      var sliderInstance = noUiSlider.create(slider, {
        start: [value[slider.dataset.input]],
        step: 1,
        range: {
          min: +$input.attr('min'),
          max: +$input.attr('max')
        },
        format: {
          to: function to(sliderValue) {
            return +sliderValue.toFixed(1);
          },
          from: function from(sliderValue) {
            return +sliderValue;
          }
        }
      });
      sliderInstance.on('slide', function (values) {
        var type = sliderInstance.target.dataset.input;
        $input.val(values[0]);
        _this.setValue(type, values[0]);
      });
    });
  },
  initColors: function initColors() {
    var _this2 = this;
    this.colorPicker = new _colorPicker.default({
      picker: {
        el: this.ui.colorPickerPlaceholder[0],
        default: this.getControlValue('color')
      },
      onChange: function onChange() {
        _this2.setValue('color', _this2.colorPicker.getColor());
      },
      onClear: function onClear() {
        _this2.setValue('color', '');
      }
    });
  },
  onInputChange: function onInputChange(event) {
    var type = event.currentTarget.dataset.setting,
      $slider = this.ui.sliders.filter('[data-input="' + type + '"]');
    $slider[0].noUiSlider.set(this.getControlValue(type));
  },
  onReady: function onReady() {
    this.initSliders();
    this.initColors();
  },
  onBeforeDestroy: function onBeforeDestroy() {
    this.colorPicker.destroy();
  }
});
module.exports = ControlBoxShadowItemView;

/***/ }),

/***/ "../assets/dev/js/editor/controls/button.js":
/*!**************************************************!*\
  !*** ../assets/dev/js/editor/controls/button.js ***!
  \**************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var ControlBaseView = __webpack_require__(/*! elementor-controls/base */ "../assets/dev/js/editor/controls/base.js");
module.exports = ControlBaseView.extend({
  ui: function ui() {
    var ui = ControlBaseView.prototype.ui.apply(this, arguments);
    ui.button = 'button';
    return ui;
  },
  events: {
    'click @ui.button': 'onButtonClick'
  },
  onButtonClick: function onButtonClick() {
    var eventName = this.model.get('event');
    elementor.channels.editor.trigger(eventName, this);
  }
});

/***/ }),

/***/ "../assets/dev/js/editor/controls/choose.js":
/*!**************************************************!*\
  !*** ../assets/dev/js/editor/controls/choose.js ***!
  \**************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var ControlBaseDataView = __webpack_require__(/*! elementor-controls/base-data */ "../assets/dev/js/editor/controls/base-data.js"),
  ControlChooseItemView;
ControlChooseItemView = ControlBaseDataView.extend({
  ui: function ui() {
    var ui = ControlBaseDataView.prototype.ui.apply(this, arguments);
    ui.inputs = '[type="radio"]';
    return ui;
  },
  events: function events() {
    return _.extend(ControlBaseDataView.prototype.events.apply(this, arguments), {
      'mousedown label': 'onMouseDownLabel',
      'click @ui.inputs': 'onClickInput',
      'change @ui.inputs': 'onBaseInputChange'
    });
  },
  updatePlaceholder: function updatePlaceholder() {
    var placeholder = this.getControlPlaceholder();
    if (!this.getControlValue() && placeholder) {
      // Find the input which has value equals to the placeholder (which is the parent's value),
      // and add it a placeholder class, to indicate which value is selected in the parent.
      this.ui.inputs.filter("[value=\"".concat(this.getControlPlaceholder(), "\"]")).addClass('e-choose-placeholder');
    } else {
      this.ui.inputs.removeClass('e-choose-placeholder');
    }
  },
  onReady: function onReady() {
    this.updatePlaceholder();
  },
  applySavedValue: function applySavedValue() {
    var currentValue = this.getControlValue();
    if (currentValue) {
      this.ui.inputs.filter('[value="' + currentValue + '"]').prop('checked', true);
    } else {
      this.ui.inputs.filter(':checked').prop('checked', false);
    }
  },
  onMouseDownLabel: function onMouseDownLabel(event) {
    var $clickedLabel = this.$(event.currentTarget),
      $selectedInput = this.$('#' + $clickedLabel.attr('for'));
    $selectedInput.data('checked', $selectedInput.prop('checked'));
  },
  onClickInput: function onClickInput(event) {
    if (!this.model.get('toggle')) {
      return;
    }
    var $selectedInput = this.$(event.currentTarget);
    if ($selectedInput.data('checked')) {
      $selectedInput.prop('checked', false).trigger('change');
    }
  },
  onBaseInputChange: function onBaseInputChange() {
    ControlBaseDataView.prototype.onBaseInputChange.apply(this, arguments);
    this.updatePlaceholder();
  }
}, {
  onPasteStyle: function onPasteStyle(control, clipboardValue) {
    return '' === clipboardValue || undefined !== control.options[clipboardValue];
  }
});
module.exports = ControlChooseItemView;

/***/ }),

/***/ "../assets/dev/js/editor/controls/code.js":
/*!************************************************!*\
  !*** ../assets/dev/js/editor/controls/code.js ***!
  \************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var ControlBaseDataView = __webpack_require__(/*! elementor-controls/base-data */ "../assets/dev/js/editor/controls/base-data.js"),
  ControlCodeEditorItemView;
ControlCodeEditorItemView = ControlBaseDataView.extend({
  ui: function ui() {
    var ui = ControlBaseDataView.prototype.ui.apply(this, arguments);
    ui.editor = '.elementor-code-editor';
    return ui;
  },
  onReady: function onReady() {
    var self = this;
    if ('undefined' === typeof ace) {
      return;
    }
    var langTools = ace.require('ace/ext/language_tools'),
      uiTheme = elementor.settings.editorPreferences.model.get('ui_theme'),
      userPrefersDark = matchMedia('(prefers-color-scheme: dark)').matches;
    self.editor = ace.edit(this.ui.editor[0]);

    // Since the code control is wrapped with a dynamic div, the class elementor-control-tag-area need to be had dynamically to handle the dynamic tag functionality.
    jQuery(self.editor.container).addClass('e-input-style elementor-code-editor elementor-control-tag-area');
    self.editor.setOptions({
      mode: 'ace/mode/' + self.model.attributes.language,
      minLines: 10,
      maxLines: Infinity,
      showGutter: true,
      useWorker: true,
      enableBasicAutocompletion: true,
      enableLiveAutocompletion: true
    });
    if ('dark' === uiTheme || 'auto' === uiTheme && userPrefersDark) {
      self.editor.setTheme('ace/theme/merbivore_soft');
    }
    self.editor.getSession().setUseWrapMode(true);
    elementor.panel.$el.on('resize.aceEditor', self.onResize.bind(this));
    if ('css' === self.model.attributes.language) {
      var selectorCompleter = {
        getCompletions: function getCompletions(editor, session, pos, prefix, callback) {
          var list = [],
            token = session.getTokenAt(pos.row, pos.column);
          if (0 < prefix.length && 'selector'.match(prefix) && 'constant' === token.type) {
            list = [{
              name: 'selector',
              value: 'selector',
              score: 1,
              meta: 'Elementor'
            }];
          }
          callback(null, list);
        }
      };
      langTools.addCompleter(selectorCompleter);
    }
    self.editor.setValue(self.getControlValue(), -1); // -1 =  move cursor to the start

    self.editor.on('change', function () {
      self.setValue(self.editor.getValue());
    });
    if ('html' === self.model.attributes.language) {
      // Remove the `doctype` annotation
      var session = self.editor.getSession();
      session.on('changeAnnotation', function () {
        var annotations = session.getAnnotations() || [],
          annotationsLength = annotations.length,
          index = annotations.length;
        while (index--) {
          if (/doctype first\. Expected/.test(annotations[index].text)) {
            annotations.splice(index, 1);
          }
        }
        if (annotationsLength > annotations.length) {
          session.setAnnotations(annotations);
        }
      });
    }
  },
  onResize: function onResize() {
    this.editor.resize();
  },
  onDestroy: function onDestroy() {
    elementor.panel.$el.off('resize.aceEditor');
  }
});
module.exports = ControlCodeEditorItemView;

/***/ }),

/***/ "../assets/dev/js/editor/controls/color.js":
/*!*************************************************!*\
  !*** ../assets/dev/js/editor/controls/color.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var __ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["__"];


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _toConsumableArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/toConsumableArray */ "../node_modules/@babel/runtime/helpers/toConsumableArray.js"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _get2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/get */ "../node_modules/@babel/runtime/helpers/get.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _baseData = _interopRequireDefault(__webpack_require__(/*! ./base-data */ "../assets/dev/js/editor/controls/base-data.js"));
var _colorPicker = _interopRequireDefault(__webpack_require__(/*! ../utils/color-picker */ "../assets/dev/js/editor/utils/color-picker.js"));
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var _default = /*#__PURE__*/function (_ControlBaseDataView) {
  (0, _inherits2.default)(_default, _ControlBaseDataView);
  var _super = _createSuper(_default);
  function _default() {
    (0, _classCallCheck2.default)(this, _default);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(_default, [{
    key: "ui",
    value: function ui() {
      var ui = (0, _get2.default)((0, _getPrototypeOf2.default)(_default.prototype), "ui", this).call(this);
      ui.pickerContainer = '.elementor-color-picker-placeholder';
      return ui;
    }
  }, {
    key: "applySavedValue",
    value: function applySavedValue() {
      // Gets the current OR default value of the control.
      var currentValue = this.getCurrentValue();
      if (this.colorPicker) {
        // When there is a global set on the control but there is no value/it doesn't exist, don't show a value.
        if (currentValue) {
          var _this$colorPicker$pic;
          // Set the picker color without triggering the 'onChange' event.
          var parsedColor = this.colorPicker.picker._parseLocalColor(currentValue);
          (_this$colorPicker$pic = this.colorPicker.picker).setHSVA.apply(_this$colorPicker$pic, (0, _toConsumableArray2.default)(parsedColor.values).concat([false]));
        } else {
          this.colorPicker.picker._clearColor(true);
        }
      } else {
        this.initPicker();
      }
      this.$el.toggleClass('e-control-color--no-value', !currentValue);
    }
  }, {
    key: "initPicker",
    value: function initPicker() {
      var _this$model$get,
        _this = this;
      var options = {
        picker: {
          el: this.ui.pickerContainer[0],
          default: this.getCurrentValue(),
          components: {
            opacity: this.model.get('alpha')
          },
          defaultRepresentation: 'HEX'
        },
        // Don't create the add button in the Global Settings color pickers.
        addButton: (_this$model$get = this.model.get('global')) === null || _this$model$get === void 0 ? void 0 : _this$model$get.active,
        onChange: function onChange() {
          return _this.onPickerChange();
        },
        onClear: function onClear() {
          return _this.onPickerClear();
        },
        onAddButtonClick: function onAddButtonClick() {
          return _this.onAddGlobalButtonClick();
        },
        onPickerShow: function onPickerShow() {
          return _this.reRoute(true);
        },
        onPickerHide: function onPickerHide() {
          return _this.reRoute(false);
        }
      };
      this.colorPicker = new _colorPicker.default(options);
      this.hidePickerOnPreviewClick();
      this.$pickerButton = jQuery(this.colorPicker.picker.getRoot().button);
      this.addTipsyToPickerButton();
      this.addEyedropper();
      this.$pickerButton.on('click', function () {
        return _this.onPickerButtonClick();
      });
      jQuery(this.colorPicker.picker.getRoot().root).addClass('elementor-control-unit-1 elementor-control-tag-area');
    }
  }, {
    key: "hidePickerOnPreviewClick",
    value: function hidePickerOnPreviewClick() {
      var picker = this.colorPicker.picker;
      var pickerUtils = picker.constructor.utils;

      // Adding to the eventBindings to unbind in the picker's destroy
      picker._eventBindings.push(pickerUtils.on(elementorFrontend.elements.window.document, ['touchstart', 'pointerdown'], function () {
        if (picker.isOpen()) {
          picker.hide();
        }
      }));
    }
  }, {
    key: "addTipsyToPickerButton",
    value: function addTipsyToPickerButton() {
      var _this2 = this;
      this.$pickerButton.tipsy({
        title: function title() {
          var currentValue = _this2.getCurrentValue();

          // If there is a global enabled for the control, but the global has no value.
          if (_this2.getGlobalKey() && !currentValue) {
            currentValue = "".concat(__('Invalid Global Color', 'elementor'));
          }
          return currentValue || '';
        },
        offset: 4,
        gravity: function gravity() {
          return 's';
        }
      });
    }
  }, {
    key: "addEyedropper",
    value: function addEyedropper() {
      var _this3 = this;
      var $colorPicker = jQuery(Marionette.Renderer.render('#tmpl-elementor-control-element-color-picker')),
        $colorPickerToolsContainer = this.colorPicker.$pickerToolsContainer,
        container = this.getOption('container');
      var kit = null;

      // When it's a kit (i.e "Site Settings").
      if ('kit' === container.document.config.type) {
        kit = container.document;
      }

      // Add a tooltip to the Eye Dropper.
      $colorPicker.tipsy({
        title: function title() {
          return __('Color Sampler', 'elementor');
        },
        gravity: 's'
      });
      $colorPicker.on('click', function () {
        $e.run('elements-color-picker/start', {
          container: container,
          kit: kit,
          control: _this3.model.get('name'),
          trigger: $colorPicker[0]
        });
      });
      $colorPickerToolsContainer.append($colorPicker);
    }
  }, {
    key: "getGlobalMeta",
    value: function getGlobalMeta() {
      return {
        commandName: this.getGlobalCommand(),
        key: this.model.get('name'),
        controlType: 'colors',
        route: 'panel/global/global-colors'
      };
    }
  }, {
    key: "getNameAlreadyExistsMessage",
    value: function getNameAlreadyExistsMessage() {
      return '<i class="eicon-info-circle"></i> ' + __('Please note that the same exact color already exists in your Global Colors list. Are you sure you want to create it?', 'elementor');
    }
  }, {
    key: "getConfirmTextMessage",
    value: function getConfirmTextMessage() {
      return __('Are you sure you want to create a new Global Color?', 'elementor');
    }
  }, {
    key: "getAddGlobalConfirmMessage",
    value: function getAddGlobalConfirmMessage(globalColors) {
      var colorTitle = __('New Global Color', 'elementor'),
        currentValue = this.getCurrentValue(),
        $message = jQuery('<div>', {
          class: 'e-global__confirm-message'
        }),
        $messageText = jQuery('<div>', {
          class: 'e-global__confirm-message-text'
        }),
        $inputWrapper = jQuery('<div>', {
          class: 'e-global__confirm-input-wrapper'
        }),
        $colorPreview = this.createColorPreviewBox(currentValue),
        $input = jQuery('<input>', {
          type: 'text',
          name: 'global-name',
          placeholder: colorTitle
        }).val(colorTitle);
      var messageContent;

      // Check if the color already exists in the global colors, and display an appropriate message.
      for (var _i = 0, _Object$values = Object.values(globalColors); _i < _Object$values.length; _i++) {
        var globalColor = _Object$values[_i];
        if (currentValue === globalColor.value) {
          messageContent = this.getNameAlreadyExistsMessage();
          break;
        } else if (colorTitle === globalColor.title) {
          messageContent = this.getConfirmTextMessage();
          break;
        } else {
          messageContent = __('Are you sure you want to create a new Global Color?', 'elementor');
        }
      }
      $messageText.html(messageContent);
      $inputWrapper.append($colorPreview, $input);
      $message.append($messageText, $inputWrapper);
      return $message;
    }
  }, {
    key: "getGlobalCommand",
    value: function getGlobalCommand() {
      return 'globals/colors';
    }

    // The globalData parameter is received from the Data API.
  }, {
    key: "createGlobalItemMarkup",
    value: function createGlobalItemMarkup(globalData) {
      var $color = jQuery('<div>', {
          class: 'e-global__preview-item e-global__color',
          'data-global-id': globalData.id
        }),
        $colorPreview = this.createColorPreviewBox(globalData.value),
        $colorTitle = jQuery('<span>', {
          class: 'e-global__color-title'
        }).html(globalData.title),
        $colorHex = jQuery('<span>', {
          class: 'e-global__color-hex'
        }).html(globalData.value);
      $color.append($colorPreview, $colorTitle, $colorHex);
      return $color;
    }
  }, {
    key: "createColorPreviewBox",
    value: function createColorPreviewBox(color) {
      var $colorPreviewContainer = jQuery('<div>', {
          class: 'e-global__color-preview-container'
        }),
        $colorPreviewColor = jQuery('<div>', {
          class: 'e-global__color-preview-color',
          style: 'background-color: ' + color
        }),
        $colorPreviewBg = jQuery('<div>', {
          class: 'e-global__color-preview-transparent-bg'
        });
      $colorPreviewContainer.append($colorPreviewBg, $colorPreviewColor);
      return $colorPreviewContainer;
    }
  }, {
    key: "getGlobalsList",
    value: function () {
      var _getGlobalsList = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee() {
        var result;
        return _regenerator.default.wrap(function _callee$(_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              _context.next = 2;
              return $e.data.get(this.getGlobalCommand());
            case 2:
              result = _context.sent;
              return _context.abrupt("return", result.data);
            case 4:
            case "end":
              return _context.stop();
          }
        }, _callee, this);
      }));
      function getGlobalsList() {
        return _getGlobalsList.apply(this, arguments);
      }
      return getGlobalsList;
    }() // Create the markup for the colors in the global select dropdown.
  }, {
    key: "buildGlobalsList",
    value: function buildGlobalsList(globalColors, $globalPreviewItemsContainer) {
      var _this4 = this;
      Object.values(globalColors).forEach(function (color) {
        if (!color.value) {
          return;
        }
        var $color = _this4.createGlobalItemMarkup(color);
        $globalPreviewItemsContainer.append($color);
      });
    }
  }, {
    key: "onPickerChange",
    value: function onPickerChange() {
      this.setValue(this.colorPicker.picker.getColor().toHEXA().toString());
      if (!this.isCustom) {
        this.triggerMethod('value:type:change');
        this.colorPicker.toggleClearButtonState(true);
        if (this.$el.hasClass('e-control-color--no-value')) {
          this.$el.removeClass('e-control-color--no-value');
        }
        this.isCustom = true;
      }
    }
  }, {
    key: "onPickerClear",
    value: function onPickerClear() {
      this.isCustom = false;

      // Empty the value saved in the control.
      this.setValue('');

      // Adjust the Global select box text according to the cleared value.
      this.triggerMethod('value:type:change');
      this.applySavedValue();
      this.colorPicker.toggleClearButtonState(false);
    }
  }, {
    key: "onPickerButtonClick",
    value: function onPickerButtonClick() {
      if (this.getGlobalKey()) {
        this.triggerMethod('unset:global:value');
      } else if (this.isGlobalActive() && !this.getControlValue() && this.getGlobalDefault()) {
        this.triggerMethod('unlink:global:default');
      }

      // If there is a value in the control, set the clear button to active, if not, deactivate it.
      this.colorPicker.toggleClearButtonState(!!this.getCurrentValue());
    }
  }, {
    key: "onAddGlobalButtonClick",
    value: function onAddGlobalButtonClick() {
      var _this5 = this;
      this.getGlobalsList().then(function (globalsList) {
        _this5.globalsList = globalsList;
        _this5.triggerMethod('add:global:to:list', _this5.getAddGlobalConfirmMessage(globalsList));
      });
    }
  }, {
    key: "activate",
    value: function activate() {
      this.colorPicker.picker.show();
    }
  }, {
    key: "onBeforeDestroy",
    value: function onBeforeDestroy() {
      if (this.colorPicker) {
        this.colorPicker.destroy();
      }
    }
  }]);
  return _default;
}(_baseData.default);
exports["default"] = _default;

/***/ }),

/***/ "../assets/dev/js/editor/controls/date-time.js":
/*!*****************************************************!*\
  !*** ../assets/dev/js/editor/controls/date-time.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _get2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/get */ "../node_modules/@babel/runtime/helpers/get.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var ControlBaseDataView = __webpack_require__(/*! elementor-controls/base-data */ "../assets/dev/js/editor/controls/base-data.js");
var _default = /*#__PURE__*/function (_ControlBaseDataView) {
  (0, _inherits2.default)(_default, _ControlBaseDataView);
  var _super = _createSuper(_default);
  function _default() {
    (0, _classCallCheck2.default)(this, _default);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(_default, [{
    key: "onReady",
    value: function onReady() {
      var options = _.extend({
        enableTime: true,
        minuteIncrement: 1
      }, this.model.get('picker_options'));
      this.ui.input.flatpickr(options);
    }
  }, {
    key: "onBaseInputChange",
    value: function onBaseInputChange() {
      var _this$model$get;
      (0, _get2.default)((0, _getPrototypeOf2.default)(_default.prototype), "onBaseInputChange", this).apply(this, arguments);
      if ((_this$model$get = this.model.get('validation')) !== null && _this$model$get !== void 0 && _this$model$get.date_time) {
        this.validateDateTime();
      }
    }
  }, {
    key: "validateDateTime",
    value: function validateDateTime() {
      var _this$model$get$date_ = this.model.get('validation').date_time,
        controlName = _this$model$get$date_.control_name,
        operator = _this$model$get$date_.operator;
      var startDate = this.options.container.settings.get(controlName);
      var endDate = this.ui.input.val();
      if (!startDate || !endDate) {
        return;
      }
      var startDateTimestamp = new Date(startDate).getTime();
      var endDateTimestamp = new Date(endDate).getTime();
      if (elementor.conditions.compare(startDateTimestamp, endDateTimestamp, operator)) {
        this.ui.input.val('');
      }
    }
  }, {
    key: "onBeforeDestroy",
    value: function onBeforeDestroy() {
      this.ui.input.flatpickr().destroy();
    }
  }]);
  return _default;
}(ControlBaseDataView);
exports["default"] = _default;

/***/ }),

/***/ "../assets/dev/js/editor/controls/dimensions.js":
/*!******************************************************!*\
  !*** ../assets/dev/js/editor/controls/dimensions.js ***!
  \******************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _scrubbing = _interopRequireDefault(__webpack_require__(/*! ./behaviors/scrubbing */ "../assets/dev/js/editor/controls/behaviors/scrubbing.js"));
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
var ControlBaseUnitsItemView = __webpack_require__(/*! elementor-controls/base-units */ "../assets/dev/js/editor/controls/base-units.js"),
  ControlDimensionsItemView;
ControlDimensionsItemView = ControlBaseUnitsItemView.extend({
  behaviors: function behaviors() {
    var _this = this;
    return _objectSpread(_objectSpread({}, ControlBaseUnitsItemView.prototype.behaviors.apply(this)), {}, {
      Scrubbing: {
        behaviorClass: _scrubbing.default,
        scrubSettings: {
          intentTime: 800,
          valueModifier: function valueModifier() {
            var currentUnit = _this.getControlValue('unit');
            return ['rem', 'em'].includes(currentUnit) ? 0.1 : 1;
          },
          enhancedNumber: function enhancedNumber() {
            var currentUnit = _this.getControlValue('unit');
            return ['rem', 'em'].includes(currentUnit) ? 0.5 : 10;
          }
        }
      }
    });
  },
  ui: function ui() {
    var ui = ControlBaseUnitsItemView.prototype.ui.apply(this, arguments);
    ui.controls = '.elementor-control-dimension > input:enabled';
    ui.link = 'button.elementor-link-dimensions';
    return ui;
  },
  events: function events() {
    return _.extend(ControlBaseUnitsItemView.prototype.events.apply(this, arguments), {
      'click @ui.link': 'onLinkDimensionsClicked'
    });
  },
  // Default value must be 0, because the CSS generator (in dimensions) expects the 4 dimensions to be filled together (or all are empty).
  defaultDimensionValue: 0,
  initialize: function initialize() {
    ControlBaseUnitsItemView.prototype.initialize.apply(this, arguments);

    // TODO: Need to be in helpers, and not in variable
    this.model.set('allowed_dimensions', this.filterDimensions(this.model.get('allowed_dimensions')));
  },
  getPossibleDimensions: function getPossibleDimensions() {
    return ['top', 'right', 'bottom', 'left'];
  },
  filterDimensions: function filterDimensions(filter) {
    filter = filter || 'all';
    var dimensions = this.getPossibleDimensions();
    if ('all' === filter) {
      return dimensions;
    }
    if (!_.isArray(filter)) {
      if ('horizontal' === filter) {
        filter = ['right', 'left'];
      } else if ('vertical' === filter) {
        filter = ['top', 'bottom'];
      }
    }
    return filter;
  },
  onReady: function onReady() {
    var self = this,
      currentValue = self.getControlValue();
    if (!self.isLinkedDimensions()) {
      self.ui.link.addClass('unlinked');
      self.ui.controls.each(function (index, element) {
        var value = currentValue[element.dataset.setting];
        if (_.isEmpty(value)) {
          value = self.defaultDimensionValue;
        }
        self.$(element).val(value);
      });
    }
    self.fillEmptyDimensions();
  },
  updateDimensionsValue: function updateDimensionsValue() {
    var currentValue = {},
      dimensions = this.getPossibleDimensions(),
      $controls = this.ui.controls,
      defaultDimensionValue = this.defaultDimensionValue;
    dimensions.forEach(function (dimension) {
      var $element = $controls.filter('[data-setting="' + dimension + '"]');
      currentValue[dimension] = $element.length ? $element.val() : defaultDimensionValue;
    });
    this.setValue(currentValue);
  },
  fillEmptyDimensions: function fillEmptyDimensions() {
    var $controls = this.ui.controls,
      defaultDimensionValue = this.defaultDimensionValue;
    if (this.isLinkedDimensions()) {
      return;
    }
    var allowedDimensions = this.model.get('allowed_dimensions'),
      dimensions = this.getPossibleDimensions();
    dimensions.forEach(function (dimension) {
      var $element = $controls.filter('[data-setting="' + dimension + '"]'),
        isAllowedDimension = -1 !== _.indexOf(allowedDimensions, dimension);
      if (isAllowedDimension && $element.length && _.isEmpty($element.val())) {
        $element.val(defaultDimensionValue);
      }
    });
  },
  updateDimensions: function updateDimensions() {
    this.fillEmptyDimensions();
    this.updateDimensionsValue();
  },
  resetDimensions: function resetDimensions() {
    this.ui.controls.val('');
    this.updateDimensionsValue();
  },
  onInputChange: function onInputChange(event) {
    var _event$originalEvent;
    var inputSetting = event.target.dataset.setting;
    if ('unit' === inputSetting) {
      this.resetDimensions();
    }
    if (!_.contains(this.getPossibleDimensions(), inputSetting)) {
      return;
    }

    // When using input with type="number" and the user starts typing `-`, the actual value (`event.target.value`) is
    // an empty string. Since the user probably has the intention to insert a negative value, the methods below will
    // not be triggered. This will prevent updating the input again with an empty string.
    var hasIntentionForNegativeNumber = '-' === (event === null || event === void 0 ? void 0 : (_event$originalEvent = event.originalEvent) === null || _event$originalEvent === void 0 ? void 0 : _event$originalEvent.data) && !event.target.value;
    if (hasIntentionForNegativeNumber) {
      return;
    }
    if (this.isLinkedDimensions()) {
      var $thisControl = this.$(event.target);
      this.ui.controls.val($thisControl.val());
    }
    this.updateDimensions();
  },
  onLinkDimensionsClicked: function onLinkDimensionsClicked(event) {
    event.preventDefault();
    event.stopPropagation();
    this.ui.link.toggleClass('unlinked');
    this.setValue('isLinked', !this.ui.link.hasClass('unlinked'));
    if (this.isLinkedDimensions()) {
      // Set all controls value from the first control.
      this.ui.controls.val(this.ui.controls.eq(0).val());
    }
    this.updateDimensions();
  },
  isLinkedDimensions: function isLinkedDimensions() {
    return this.getControlValue('isLinked');
  },
  updateUnitChoices: function updateUnitChoices() {
    ControlBaseUnitsItemView.prototype.updateUnitChoices.apply(this, arguments);
    var inputType = 'number';
    if (this.isCustomUnit()) {
      inputType = 'text';
    }
    this.ui.controls.attr('type', inputType);
  }
});
module.exports = ControlDimensionsItemView;

/***/ }),

/***/ "../assets/dev/js/editor/controls/font.js":
/*!************************************************!*\
  !*** ../assets/dev/js/editor/controls/font.js ***!
  \************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var ControlSelect2View = __webpack_require__(/*! elementor-controls/select2 */ "../assets/dev/js/editor/controls/select2.js");
module.exports = ControlSelect2View.extend({
  $previewContainer: null,
  getSelect2Options: function getSelect2Options() {
    return {
      dir: elementorCommon.config.isRTL ? 'rtl' : 'ltr',
      templateSelection: this.fontPreviewTemplate,
      templateResult: this.fontPreviewTemplate
    };
  },
  onReady: function onReady() {
    var self = this;
    this.ui.select.select2(this.getSelect2Options());
    this.ui.select.on('select2:open', function () {
      self.$previewContainer = jQuery('.select2-results__options[role="tree"]:visible');
      // Load initial?
      setTimeout(function () {
        self.enqueueFontsInView();
      }, 100);

      // On search
      jQuery('input.select2-search__field:visible').on('keyup', function () {
        self.typeStopDetection.action.apply(self);
      });

      // On scroll
      self.$previewContainer.on('scroll', function () {
        self.scrollStopDetection.onScroll.apply(self);
      });
    });
  },
  typeStopDetection: {
    idle: 350,
    timeOut: null,
    action: function action() {
      var parent = this,
        self = this.typeStopDetection;
      clearTimeout(self.timeOut);
      self.timeOut = setTimeout(function () {
        parent.enqueueFontsInView();
      }, self.idle);
    }
  },
  scrollStopDetection: {
    idle: 350,
    timeOut: null,
    onScroll: function onScroll() {
      var parent = this,
        self = this.scrollStopDetection;
      clearTimeout(self.timeOut);
      self.timeOut = setTimeout(function () {
        parent.enqueueFontsInView();
      }, self.idle);
    }
  },
  enqueueFontsInView: function enqueueFontsInView() {
    var containerOffset = this.$previewContainer.offset(),
      top = containerOffset.top,
      bottom = top + this.$previewContainer.innerHeight(),
      fontsInView = [];
    this.$previewContainer.children().find('li:visible').each(function (index, font) {
      var $font = jQuery(font),
        offset = $font.offset();
      if (offset && offset.top > top && offset.top < bottom) {
        fontsInView.push($font);
      }
    });
    fontsInView.forEach(function (font) {
      var fontFamily = jQuery(font).find('span').html();
      elementor.helpers.enqueueFont(fontFamily, 'editor');
    });
  },
  fontPreviewTemplate: function fontPreviewTemplate(state) {
    if (!state.id) {
      return state.text;
    }
    return jQuery('<span>', {
      text: state.text,
      css: {
        'font-family': state.element.value.toString()
      }
    });
  },
  templateHelpers: function templateHelpers() {
    var helpers = ControlSelect2View.prototype.templateHelpers.apply(this, arguments),
      fonts = this.model.get('options');
    helpers.getFontsByGroups = function (groups) {
      var filteredFonts = {};
      _.each(fonts, function (fontType, fontName) {
        if (_.isArray(groups) && _.contains(groups, fontType) || fontType === groups) {
          filteredFonts[fontName] = fontName;
        }
      });
      return filteredFonts;
    };
    return helpers;
  }
});

/***/ }),

/***/ "../assets/dev/js/editor/controls/gallery.js":
/*!***************************************************!*\
  !*** ../assets/dev/js/editor/controls/gallery.js ***!
  \***************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var sprintf = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["sprintf"];
/* provided dependency */ var __ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["__"];


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _filesUploadHandler = _interopRequireDefault(__webpack_require__(/*! ../utils/files-upload-handler */ "../assets/dev/js/editor/utils/files-upload-handler.js"));
var ControlBaseDataView = __webpack_require__(/*! elementor-controls/base-data */ "../assets/dev/js/editor/controls/base-data.js"),
  ControlMediaItemView;
ControlMediaItemView = ControlBaseDataView.extend({
  ui: function ui() {
    var ui = ControlBaseDataView.prototype.ui.apply(this, arguments);
    ui.addImages = '.elementor-control-gallery-add';
    ui.clearGallery = '.elementor-control-gallery-clear';
    ui.galleryThumbnails = '.elementor-control-gallery-thumbnails';
    ui.status = '.elementor-control-gallery-status-title';
    // eslint-disable-next-line capitalized-comments
    // ui.warnings = '.elementor-control-media__warnings';
    ui.promotions = '.elementor-control-media__promotions';
    ui.promotions_dismiss = '.elementor-control-media__promotions .elementor-control-notice-dismiss';
    ui.promotions_action = '.elementor-control-media__promotions .elementor-control-notice-main-actions button';
    return ui;
  },
  events: function events() {
    return _.extend(ControlBaseDataView.prototype.events.apply(this, arguments), {
      'click @ui.addImages': 'onAddImagesClick',
      'click @ui.clearGallery': 'onClearGalleryClick',
      'click @ui.galleryThumbnails': 'onGalleryThumbnailsClick',
      'click @ui.promotions_dismiss': 'onPromotionDismiss',
      'click @ui.promotions_action': 'onPromotionAction',
      'keyup @ui.galleryThumbnails': 'onGalleryThumbnailsKeyPress'
    });
  },
  onReady: function onReady() {
    this.initRemoveDialog();
  },
  applySavedValue: function applySavedValue() {
    var _this = this;
    return (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee() {
      var images, imagesCount, hasImages, imagesWithoutOptimization, promotionsAlwaysOn, hasPromotions, $galleryThumbnails, attachments;
      return _regenerator.default.wrap(function _callee$(_context) {
        while (1) switch (_context.prev = _context.next) {
          case 0:
            images = _this.getControlValue(), imagesCount = images.length, hasImages = !!imagesCount, imagesWithoutOptimization = 0, promotionsAlwaysOn = false;
            hasPromotions = _this.ui.promotions.length && !elementor.config.user.dismissed_editor_notices.includes(_this.getDismissPromotionEventName());
            _this.$el.toggleClass('elementor-gallery-has-images', hasImages).toggleClass('elementor-gallery-empty', !hasImages);
            $galleryThumbnails = _this.ui.galleryThumbnails;
            $galleryThumbnails.empty();

            /* Translators: %s: Selected images count. */
            _this.ui.status.text(hasImages ? sprintf(__('%s Images Selected', 'elementor'), imagesCount) : __('No Images Selected', 'elementor'));
            if (hasPromotions) {
              promotionsAlwaysOn = _this.ui.promotions.find('.elementor-control-notice').data('display') || false;
            }
            if (hasImages) {
              _context.next = 9;
              break;
            }
            return _context.abrupt("return");
          case 9:
            attachments = [];
            _this.getControlValue().forEach(function (image, thumbIndex) {
              var $thumbnail = jQuery('<img>', {
                class: 'elementor-control-gallery-thumbnail',
                src: image.url,
                alt: 'gallery-thumbnail-' + thumbIndex
              });
              $galleryThumbnails.append($thumbnail);
              var handleHints = function handleHints(attachment) {
                var hasAlt = _this.imageHasAlt(attachment);
                if (!hasAlt) {
                  $thumbnail.addClass('unoptimized__image');
                  // eslint-disable-next-line capitalized-comments
                  // imagesWithoutAlt += hasAlt ? 0 : 1;
                }

                if (hasPromotions && _this.imageNotOptimized(attachment)) {
                  imagesWithoutOptimization += 1;
                }
              };
              attachments.push(wp.media.attachment(image.id).fetch().then(handleHints));
            });

            // Ensure all attachments are fetched before updating the warnings
            _context.next = 13;
            return Promise.all(attachments).then(function () {
              // eslint-disable-next-line capitalized-comments
              // this.ui.warnings.toggle( !! imagesWithoutAlt );
              if (hasPromotions) {
                var showHints = promotionsAlwaysOn || !!imagesWithoutOptimization;
                _this.ui.promotions.toggle(showHints);
              }
            });
          case 13:
          case "end":
            return _context.stop();
        }
      }, _callee);
    }))();
  },
  hasImages: function hasImages() {
    return !!this.getControlValue().length;
  },
  imageHasAlt: function imageHasAlt(attachment) {
    var _attachment$alt;
    var attachmentAlt = (attachment === null || attachment === void 0 ? void 0 : (_attachment$alt = attachment.alt) === null || _attachment$alt === void 0 ? void 0 : _attachment$alt.trim()) || '';
    return !!attachmentAlt;
  },
  imageNotOptimized: function imageNotOptimized(attachment) {
    var checks = {
      height: 1080,
      width: 1920,
      filesizeInBytes: 200000
    };
    return Object.keys(checks).some(function (key) {
      var value = attachment[key] || false;
      return value && value > checks[key];
    });
  },
  openFrame: function openFrame(action) {
    this.initFrame(action);
    this.frame.open();

    // Set params to trigger sanitizer
    if (_filesUploadHandler.default.isUploadEnabled('svg')) {
      _filesUploadHandler.default.setUploadTypeCaller(this.frame);
    }
  },
  initFrame: function initFrame(action) {
    var frameStates = {
      create: 'gallery',
      add: 'gallery-library',
      edit: 'gallery-edit'
    };
    var options = {
      frame: 'post',
      multiple: true,
      state: frameStates[action],
      button: {
        text: __('Insert Media', 'elementor')
      }
    };
    if (this.hasImages()) {
      options.selection = this.fetchSelection();
    }
    this.frame = wp.media(options);
    this.addSvgMimeType();

    // When a file is selected, run a callback.
    this.frame.on({
      update: this.select,
      'menu:render:default': this.menuRender,
      'content:render:browse': this.gallerySettings
    }, this);
  },
  addSvgMimeType: function addSvgMimeType() {
    if (!_filesUploadHandler.default.isUploadEnabled('svg')) {
      return;
    }

    // Add the SVG to the currently allowed extensions
    var oldExtensions = _wpPluploadSettings.defaults.filters.mime_types[0].extensions;
    this.frame.on('ready', function () {
      _wpPluploadSettings.defaults.filters.mime_types[0].extensions = oldExtensions + ',svg';
    });

    // Restore allowed upload extensions
    this.frame.on('close', function () {
      _wpPluploadSettings.defaults.filters.mime_types[0].extensions = oldExtensions;
    });
  },
  menuRender: function menuRender(view) {
    view.unset('insert');
    view.unset('featured-image');
  },
  gallerySettings: function gallerySettings(browser) {
    browser.sidebar.on('ready', function () {
      browser.sidebar.unset('gallery');
    });
  },
  fetchSelection: function fetchSelection() {
    var attachments = wp.media.query({
      orderby: 'post__in',
      order: 'ASC',
      type: 'image',
      perPage: -1,
      post__in: _.pluck(this.getControlValue(), 'id')
    });
    return new wp.media.model.Selection(attachments.models, {
      props: attachments.props.toJSON(),
      multiple: true
    });
  },
  /**
   * Callback handler for when an attachment is selected in the media modal.
   * Gets the selected image information, and sets it within the control.
   *
   * @param {Array<*>} selection
   */
  select: function select(selection) {
    var images = [];
    selection.each(function (image) {
      images.push({
        id: image.get('id'),
        url: image.get('url')
      });
    });
    this.setValue(images);
    this.applySavedValue();
  },
  onPromotionDismiss: function onPromotionDismiss() {
    this.dismissPromotion(this.getDismissPromotionEventName());
  },
  getDismissPromotionEventName: function getDismissPromotionEventName() {
    var _$dismissButton$, _$dismissButton$$data;
    var $promotions = this.ui.promotions;
    var $dismissButton = $promotions.find('.elementor-control-notice-dismiss');
    // Remove listener
    $dismissButton.off('click');
    return ((_$dismissButton$ = $dismissButton[0]) === null || _$dismissButton$ === void 0 ? void 0 : (_$dismissButton$$data = _$dismissButton$.dataset) === null || _$dismissButton$$data === void 0 ? void 0 : _$dismissButton$$data.event) || false;
  },
  hidePromotion: function hidePromotion() {
    var eventName = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
    var $promotions = this.ui.promotions;
    $promotions.hide();
    if (!eventName) {
      eventName = this.getDismissPromotionEventName();
    }
    // Prevent opening the same promotion again in current editor session.
    elementor.config.user.dismissed_editor_notices.push(eventName);
  },
  onPromotionAction: function onPromotionAction(event) {
    var _JSON$parse = JSON.parse(event.target.closest('button').dataset.settings),
      _JSON$parse$action_ur = _JSON$parse.action_url,
      actionURL = _JSON$parse$action_ur === void 0 ? null : _JSON$parse$action_ur;
    if (actionURL) {
      window.open(actionURL, '_blank');
    }
    this.hidePromotion();
  },
  dismissPromotion: function dismissPromotion(eventName) {
    var $promotions = this.ui.promotions;
    $promotions.hide();
    if (eventName) {
      elementorCommon.ajax.addRequest('dismissed_editor_notices', {
        data: {
          dismissId: eventName
        }
      });

      // Prevent opening the same promotion again in current editor session.
      elementor.config.user.dismissed_editor_notices.push(eventName);
    }
  },
  onBeforeDestroy: function onBeforeDestroy() {
    if (this.frame) {
      this.frame.off();
    }
    this.$el.remove();
  },
  clearGallery: function clearGallery() {
    this.setValue([]);
    this.applySavedValue();

    // eslint-disable-next-line capitalized-comments
    // this.ui.warnings.hide();

    if (this.ui.promotions) {
      this.ui.promotions.hide();
    }
  },
  initRemoveDialog: function initRemoveDialog() {
    var removeDialog;
    this.getRemoveDialog = function () {
      if (!removeDialog) {
        removeDialog = elementorCommon.dialogsManager.createWidget('confirm', {
          message: __('Are you sure you want to clear this gallery?', 'elementor'),
          headerMessage: __('Clear gallery', 'elementor'),
          strings: {
            confirm: __('Clear', 'elementor'),
            cancel: __('Cancel', 'elementor')
          },
          defaultOption: 'confirm',
          onConfirm: this.clearGallery.bind(this)
        });
      }
      return removeDialog;
    };
  },
  onAddImagesClick: function onAddImagesClick() {
    this.openFrame(this.hasImages() ? 'add' : 'create');
  },
  onClearGalleryClick: function onClearGalleryClick() {
    this.getRemoveDialog().show();
  },
  onGalleryThumbnailsClick: function onGalleryThumbnailsClick() {
    this.openFrame('edit');
  },
  onGalleryThumbnailsKeyPress: function onGalleryThumbnailsKeyPress(event) {
    var ENTER_KEY = 13,
      SPACE_KEY = 32;
    if (ENTER_KEY === event.which || SPACE_KEY === event.which) {
      this.onGalleryThumbnailsClick(event);
    }
  }
});
module.exports = ControlMediaItemView;

/***/ }),

/***/ "../assets/dev/js/editor/controls/gaps.js":
/*!************************************************!*\
  !*** ../assets/dev/js/editor/controls/gaps.js ***!
  \************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js"));
// eslint-disable-next-line prefer-const
var ControlDimensionsView = __webpack_require__(/*! elementor-controls/dimensions */ "../assets/dev/js/editor/controls/dimensions.js"),
  ControlGapItemView;

// eslint-disable-next-line prefer-const
ControlGapItemView = ControlDimensionsView.extend({
  ui: function ui() {
    // eslint-disable-next-line prefer-const
    var ui = ControlDimensionsView.prototype.ui.apply(this, arguments);
    ui.controls = '.elementor-control-gap > input:enabled';
    ui.link = 'button.elementor-link-gaps';
    return ui;
  },
  getPossibleDimensions: function getPossibleDimensions() {
    return ['row', 'column'];
  },
  setValue: function setValue(key, value) {
    var values = this.getControlValue();
    if ('object' === (0, _typeof2.default)(key)) {
      _.each(key, function (internalValue, internalKey) {
        values[internalKey] = internalValue;
      });
    } else {
      values[key] = value;
    }
    var conversion = this.model.get('conversion_map');
    if (conversion && conversion.old_key && conversion.new_key) {
      values[conversion.old_key] = parseInt(values[conversion.new_key]);
    }
    this.setSettingsModel(values);
  },
  getControlValue: function getControlValue(key) {
    var valuesUpdated = ControlDimensionsView.prototype.getControlValue.apply(this, arguments);
    if (this.shouldUpdateGapsValues(valuesUpdated)) {
      valuesUpdated.column = '' + valuesUpdated.size;
      valuesUpdated.row = '' + valuesUpdated.size;
      valuesUpdated.isLinked = true;
    }
    return valuesUpdated;
  },
  shouldUpdateGapsValues: function shouldUpdateGapsValues(valuesUpdated) {
    return !!valuesUpdated.hasOwnProperty('size') && '' !== valuesUpdated.size && !valuesUpdated.hasOwnProperty('column');
  }
});
module.exports = ControlGapItemView;

/***/ }),

/***/ "../assets/dev/js/editor/controls/hidden.js":
/*!**************************************************!*\
  !*** ../assets/dev/js/editor/controls/hidden.js ***!
  \**************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _baseData = _interopRequireDefault(__webpack_require__(/*! ./base-data */ "../assets/dev/js/editor/controls/base-data.js"));
module.exports = _baseData.default.extend({}, {
  onPasteStyle: function onPasteStyle() {
    return false;
  }
});

/***/ }),

/***/ "../assets/dev/js/editor/controls/icon.js":
/*!************************************************!*\
  !*** ../assets/dev/js/editor/controls/icon.js ***!
  \************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var ControlSelect2View = __webpack_require__(/*! elementor-controls/select2 */ "../assets/dev/js/editor/controls/select2.js"),
  ControlIconView;
ControlIconView = ControlSelect2View.extend({
  initialize: function initialize() {
    ControlSelect2View.prototype.initialize.apply(this, arguments);
    this.filterIcons();
  },
  filterIcons: function filterIcons() {
    var icons = this.model.get('options'),
      include = this.model.get('include');
    if (include) {
      var filteredIcons = {};
      _.each(include, function (iconKey) {
        filteredIcons[iconKey] = icons[iconKey];
      });
      this.model.set('options', filteredIcons);
      return;
    }
    var exclude = this.model.get('exclude');
    if (exclude) {
      _.each(exclude, function (iconKey) {
        delete icons[iconKey];
      });
    }
  },
  iconsList: function iconsList(icon) {
    if (!icon.id) {
      return icon.text;
    }
    return jQuery('<span><i class="' + icon.id + '"></i> ' + icon.text + '</span>');
  },
  getSelect2Options: function getSelect2Options() {
    return {
      allowClear: true,
      templateResult: this.iconsList.bind(this),
      templateSelection: this.iconsList.bind(this)
    };
  }
});
module.exports = ControlIconView;

/***/ }),

/***/ "../assets/dev/js/editor/controls/icons.js":
/*!*************************************************!*\
  !*** ../assets/dev/js/editor/controls/icons.js ***!
  \*************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var __ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["__"];


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _get2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/get */ "../node_modules/@babel/runtime/helpers/get.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _filesUploadHandler = _interopRequireDefault(__webpack_require__(/*! ../utils/files-upload-handler */ "../assets/dev/js/editor/utils/files-upload-handler.js"));
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var ControlMultipleBaseItemView = __webpack_require__(/*! elementor-controls/base-multiple */ "../assets/dev/js/editor/controls/base-multiple.js");
var ControlIconsView = /*#__PURE__*/function (_ControlMultipleBaseI) {
  (0, _inherits2.default)(ControlIconsView, _ControlMultipleBaseI);
  var _super = _createSuper(ControlIconsView);
  function ControlIconsView() {
    var _this;
    (0, _classCallCheck2.default)(this, ControlIconsView);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _this.cache = {
      loaded: false,
      dialog: false,
      enableClicked: false,
      fa4Mapping: false,
      migratedFlag: {}
    };
    _this.dataKeys = {
      migratedKey: '__fa4_migrated',
      fa4MigrationFlag: 'fa4compatibility'
    };
    return _this;
  }
  (0, _createClass2.default)(ControlIconsView, [{
    key: "enqueueIconFonts",
    value: function enqueueIconFonts(iconType) {
      var iconSetting = elementor.helpers.getIconLibrarySettings(iconType);
      if (false === iconSetting || !this.isMigrationAllowed()) {
        return;
      }
      if (iconSetting.enqueue) {
        iconSetting.enqueue.forEach(function (assetURL) {
          elementor.helpers.enqueueEditorStylesheet(assetURL);
          elementor.helpers.enqueuePreviewStylesheet(assetURL);
        });
      }
      if (iconSetting.url) {
        elementor.helpers.enqueueEditorStylesheet(iconSetting.url);
        elementor.helpers.enqueuePreviewStylesheet(iconSetting.url);
      }
    }
  }, {
    key: "ui",
    value: function ui() {
      var ui = (0, _get2.default)((0, _getPrototypeOf2.default)(ControlIconsView.prototype), "ui", this).call(this),
        skin = this.model.get('skin');
      ui.controlMedia = '.elementor-control-media';
      ui.svgUploader = 'media' === skin ? '.elementor-control-svg-uploader' : '.elementor-control-icons--inline__svg';
      ui.iconPickers = 'media' === skin ? '.elementor-control-icon-picker, .elementor-control-media__preview, .elementor-control-media-upload-button' : '.elementor-control-icons--inline__icon';
      ui.deleteButton = 'media' === skin ? '.elementor-control-media__remove' : '.elementor-control-icons--inline__none';
      ui.previewPlaceholder = '.elementor-control-media__preview';
      ui.previewContainer = '.elementor-control-preview-area';
      ui.inlineIconContainer = '.elementor-control-inline-icon';
      ui.inlineDisplayedIcon = '.elementor-control-icons--inline__displayed-icon';
      ui.radioInputs = '[type="radio"]';
      return ui;
    }
  }, {
    key: "events",
    value: function events() {
      return jQuery.extend(ControlMultipleBaseItemView.prototype.events.apply(this, arguments), {
        'click @ui.iconPickers': 'openPicker',
        'click @ui.svgUploader': 'openFrame',
        'click @ui.radioInputs': 'onClickInput',
        'click @ui.deleteButton': 'deleteIcon'
      });
    }
  }, {
    key: "getControlValue",
    value: function getControlValue() {
      var model = this.model,
        valueToMigrate = this.getValueToMigrate();
      if (!this.isMigrationAllowed()) {
        return valueToMigrate;
      }

      // Bail if no migration flag or no value to migrate
      var value = (0, _get2.default)((0, _getPrototypeOf2.default)(ControlIconsView.prototype), "getControlValue", this).call(this);
      if (!valueToMigrate) {
        return value;
      }
      var controlName = model.get('name');

      // Check if migration had been done and is stored locally
      if (this.cache.migratedFlag[controlName]) {
        return this.cache.migratedFlag[controlName];
      }
      // Check if already migrated
      var didMigration = this.elementSettingsModel.get(this.dataKeys.migratedKey);
      if (didMigration && didMigration[controlName]) {
        return value;
      }

      // Do migration
      return this.migrateFa4toFa5(valueToMigrate);
    }
  }, {
    key: "migrateFa4toFa5",
    value: function migrateFa4toFa5(fa4Value) {
      var fa5Value = elementor.helpers.mapFa4ToFa5(fa4Value);
      this.cache.migratedFlag[this.model.get('name')] = fa5Value;
      this.enqueueIconFonts(fa5Value.library);
      return fa5Value;
    }
  }, {
    key: "setControlAsMigrated",
    value: function setControlAsMigrated(controlName) {
      var didMigration = this.elementSettingsModel.get(this.dataKeys.migratedKey) || {};
      didMigration[controlName] = true;
      this.elementSettingsModel.set(this.dataKeys.migratedKey, didMigration, {
        silent: true
      });
    }
  }, {
    key: "isMigrationAllowed",
    value: function isMigrationAllowed() {
      return !elementor.config.icons_update_needed;
    }
  }, {
    key: "getValueToMigrate",
    value: function getValueToMigrate() {
      var controlToMigrate = this.model.get(this.dataKeys.fa4MigrationFlag);
      if (!controlToMigrate) {
        return false;
      }

      // Check if there is a value to migrate
      var valueToMigrate = this.container.settings.get(controlToMigrate);
      if (valueToMigrate) {
        return valueToMigrate;
      }
      return false;
    }
  }, {
    key: "onReady",
    value: function onReady() {
      var _this2 = this;
      // Is migration allowed from fa4
      if (!this.isMigrationAllowed()) {
        var migrationPopupTrigger = 'media' === this.model.get('skin') ? this.ui.previewContainer[0] : this.ui.inlineIconContainer[0];
        migrationPopupTrigger.addEventListener('click', function (event) {
          // Prevent default to prevent marking the inline icons as selected on click when migration is not allowed
          event.preventDefault();
          event.stopPropagation();
          var onConfirm = function onConfirm() {
            var _elementor$documents$;
            window.location.href = elementor.config.tools_page_link + '&redirect_to_document=' + ((_elementor$documents$ = elementor.documents.getCurrent()) === null || _elementor$documents$ === void 0 ? void 0 : _elementor$documents$.id) + '&_wpnonce=' + elementor.config.tools_page_nonce + '#tab-fontawesome4_migration';
          };
          var enableMigrationDialog = elementor.helpers.getSimpleDialog('elementor-enable-fa5-dialog', __('Elementor\'s New Icon Library', 'elementor'), __('Elementor v2.6 includes an upgrade from Font Awesome 4 to 5. In order to continue using icons, be sure to click "Update".', 'elementor') + ' <a href="https://go.elementor.com/fontawesome-migration/" target="_blank">' + __('Learn More', 'elementor') + '</a>', __('Update', 'elementor'), onConfirm);
          enableMigrationDialog.show();
          return false;
        }, true);
      }
      var controlName = this.model.get('name');
      if (this.cache.migratedFlag[controlName]) {
        this.setControlAsMigrated(controlName);
        setTimeout(function () {
          _this2.setValue(_this2.cache.migratedFlag[controlName]);
        }, 10);
      }
    }
  }, {
    key: "onRender",
    value: function onRender() {
      (0, _get2.default)((0, _getPrototypeOf2.default)(ControlIconsView.prototype), "onRender", this).call(this);
      if (this.isMigrationAllowed()) {
        elementor.iconManager.loadIconLibraries();
      }
    }
  }, {
    key: "initFrame",
    value: function initFrame() {
      var _this3 = this;
      // Set current doc id to attach uploaded images.
      wp.media.view.settings.post.id = elementor.config.document.id;
      this.frame = wp.media({
        button: {
          text: __('Insert Media', 'elementor')
        },
        library: {
          type: ['image/svg+xml']
        },
        states: [new wp.media.controller.Library({
          title: __('Insert Media', 'elementor'),
          library: wp.media.query({
            type: ['image/svg+xml']
          }),
          multiple: false,
          date: false
        })]
      });
      var handleSelect = function handleSelect() {
        return _this3.selectSvg();
      };

      // When a file is selected, run a callback.
      this.frame.on('insert select', handleSelect);
      this.setUploadMimeType(this.frame, 'svg');
    }
  }, {
    key: "setUploadMimeType",
    value: function setUploadMimeType(frame, ext) {
      // Set svg as only allowed upload extensions
      var oldExtensions = _wpPluploadSettings.defaults.filters.mime_types[0].extensions;
      frame.on('ready', function () {
        _wpPluploadSettings.defaults.filters.mime_types[0].extensions = ext;
      });
      this.frame.on('close', function () {
        // Restore allowed upload extensions
        _wpPluploadSettings.defaults.filters.mime_types[0].extensions = oldExtensions;
      });
    }

    /**
     * Callback handler for when an attachment is selected in the media modal.
     * Gets the selected image information, and sets it within the control.
     */
  }, {
    key: "selectSvg",
    value: function selectSvg() {
      this.trigger('before:select');

      // Get the attachment from the modal frame.
      var attachment = this.frame.state().get('selection').first().toJSON();
      if (attachment.url) {
        this.setValue({
          value: {
            url: attachment.url,
            id: attachment.id
          },
          library: 'svg'
        });
        this.applySavedValue();
      }
      this.trigger('after:select');
    }
  }, {
    key: "openFrame",
    value: function openFrame() {
      var _this4 = this;
      if (!_filesUploadHandler.default.isUploadEnabled('svg')) {
        _filesUploadHandler.default.getUnfilteredFilesNotEnabledDialog(function () {
          return _this4.openFrame();
        }).show();
        return false;
      }
      if (!this.frame) {
        this.initFrame();
      }
      this.frame.open();

      // Set params to trigger sanitizer
      _filesUploadHandler.default.setUploadTypeCaller(this.frame);
      var selectedId = this.getControlValue('id');
      if (!selectedId) {
        return;
      }
      var selection = this.frame.state().get('selection');
      selection.add(wp.media.attachment(selectedId));
    }
  }, {
    key: "openPicker",
    value: function openPicker() {
      elementor.iconManager.show({
        view: this
      });
    }
  }, {
    key: "applySavedValue",
    value: function applySavedValue() {
      var _this5 = this;
      var controlValue = this.getControlValue(),
        skin = this.model.get('skin'),
        iconContainer = 'inline' === skin ? this.ui.inlineDisplayedIcon : this.ui.previewPlaceholder,
        disableActiveState = this.model.get('disable_initial_active_state'),
        defaultIcon = this.model.get('default');
      var iconValue = controlValue.value,
        iconType = controlValue.library;
      if (!this.isMigrationAllowed() && !iconValue && this.getValueToMigrate()) {
        iconValue = this.getControlValue();
        iconType = '';
      }
      if ('media' === skin) {
        this.ui.controlMedia.toggleClass('e-media-empty', !iconValue);
      }
      if ('inline' === skin && !disableActiveState || iconType) {
        this.markChecked(iconType);
      }
      if (!iconValue) {
        if ('inline' === skin) {
          this.setDefaultIconLibraryLabel(defaultIcon, iconContainer);
          return;
        }
        this.ui.previewPlaceholder.html('');
        return;
      }
      if ('svg' === iconType && 'inline' !== skin) {
        return elementor.helpers.fetchInlineSvg(iconValue.url, function (data) {
          _this5.ui.previewPlaceholder.html(data);
        });
      }
      if ('media' === skin || 'svg' !== iconType) {
        var previewHTML = '<i class="' + iconValue + '"></i>';
        iconContainer.html(previewHTML);
      }
      this.enqueueIconFonts(iconType);
    }
  }, {
    key: "setDefaultIconLibraryLabel",
    value: function setDefaultIconLibraryLabel(defaultIcon, iconContainer) {
      // Check if the control has a default icon
      if ('' !== defaultIcon.value && 'svg' !== defaultIcon.library) {
        // If the default icon is not an SVG, set the icon-library label's icon to the default icon
        iconContainer.html('<i class="' + defaultIcon.value + '"></i>');
      } else {
        // If (1) the control does NOT have a default icon,
        // OR (2) the control DOES have a default icon BUT the default icon is an SVG,
        // set the default icon-library label's icon to a simple circle
        var skinOptions = this.model.get('skin_settings');
        iconContainer.html('<i class="' + skinOptions.inline.icon.icon + '"></i>');
      }
    }
  }, {
    key: "markChecked",
    value: function markChecked(iconType) {
      this.ui.radioInputs.filter(':checked').prop('checked', false);
      if (!iconType) {
        return this.ui.radioInputs.filter('[value="none"]').prop('checked', true);
      }
      if ('svg' !== iconType) {
        iconType = 'icon';
      }
      this.ui.radioInputs.filter('[value="' + iconType + '"]').prop('checked', true);
    }
  }, {
    key: "onClickInput",
    value: function onClickInput() {
      this.markChecked(this.getControlValue().library);
    }
  }, {
    key: "deleteIcon",
    value: function deleteIcon(event) {
      event.stopPropagation();
      this.setValue({
        value: '',
        library: ''
      });
      this.applySavedValue();
    }
  }, {
    key: "onBeforeDestroy",
    value: function onBeforeDestroy() {
      this.$el.remove();
    }
  }]);
  return ControlIconsView;
}(ControlMultipleBaseItemView);
module.exports = ControlIconsView;

/***/ }),

/***/ "../assets/dev/js/editor/controls/image-dimensions.js":
/*!************************************************************!*\
  !*** ../assets/dev/js/editor/controls/image-dimensions.js ***!
  \************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _scrubbing = _interopRequireDefault(__webpack_require__(/*! ./behaviors/scrubbing */ "../assets/dev/js/editor/controls/behaviors/scrubbing.js"));
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
var ControlMultipleBaseItemView = __webpack_require__(/*! elementor-controls/base-multiple */ "../assets/dev/js/editor/controls/base-multiple.js"),
  ControlImageDimensionsItemView;
ControlImageDimensionsItemView = ControlMultipleBaseItemView.extend({
  behaviors: function behaviors() {
    return _objectSpread(_objectSpread({}, ControlMultipleBaseItemView.prototype.behaviors.apply(this)), {}, {
      Scrubbing: {
        behaviorClass: _scrubbing.default,
        scrubSettings: {
          intentTime: 800
        }
      }
    });
  },
  ui: function ui() {
    return {
      inputWidth: 'input[data-setting="width"]',
      inputHeight: 'input[data-setting="height"]',
      btnApply: 'button.elementor-image-dimensions-apply-button'
    };
  },
  // Override the base events
  events: function events() {
    return {
      'click @ui.btnApply': 'onApplyClicked',
      'keyup @ui.inputWidth': 'onDimensionKeyUp',
      'keyup @ui.inputHeight': 'onDimensionKeyUp'
    };
  },
  onDimensionKeyUp: function onDimensionKeyUp(event) {
    var ENTER_KEY = 13;
    if (ENTER_KEY === event.keyCode) {
      this.onApplyClicked(event);
    }
  },
  onApplyClicked: function onApplyClicked(event) {
    event.preventDefault();
    this.setValue({
      width: this.ui.inputWidth.val(),
      height: this.ui.inputHeight.val()
    });
  }
});
module.exports = ControlImageDimensionsItemView;

/***/ }),

/***/ "../assets/dev/js/editor/controls/media.js":
/*!*************************************************!*\
  !*** ../assets/dev/js/editor/controls/media.js ***!
  \*************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var __ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["__"];


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _filesUploadHandler = _interopRequireDefault(__webpack_require__(/*! ../utils/files-upload-handler */ "../assets/dev/js/editor/utils/files-upload-handler.js"));
var _jsonUploadWarningMessage = __webpack_require__(/*! elementor-utils/json-upload-warning-message */ "../assets/dev/js/utils/json-upload-warning-message.js");
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
var ControlMultipleBaseItemView = __webpack_require__(/*! elementor-controls/base-multiple */ "../assets/dev/js/editor/controls/base-multiple.js"),
  ControlMediaItemView;
ControlMediaItemView = ControlMultipleBaseItemView.extend({
  ui: function ui() {
    var ui = ControlMultipleBaseItemView.prototype.ui.apply(this, arguments);
    ui.controlMedia = '.elementor-control-media';
    ui.mediaImage = '.elementor-control-media__preview';
    ui.mediaVideo = '.elementor-control-media-video';
    ui.frameOpeners = '.elementor-control-preview-area';
    ui.removeButton = '.elementor-control-media__remove';
    // eslint-disable-next-line capitalized-comments
    // ui.warnings = '.elementor-control-media__warnings';
    ui.promotions = '.elementor-control-media__promotions';
    ui.promotions_dismiss = '.elementor-control-media__promotions .elementor-control-notice-dismiss';
    ui.promotions_action = '.elementor-control-media__promotions .elementor-control-notice-main-actions button';
    ui.fileName = '.elementor-control-media__file__content__info__name';
    ui.mediaInputImageSize = '.e-image-size-select';
    return ui;
  },
  events: function events() {
    return _.extend(ControlMultipleBaseItemView.prototype.events.apply(this, arguments), {
      'click @ui.frameOpeners': 'openFrame',
      'click @ui.removeButton': 'deleteImage',
      'change @ui.mediaInputImageSize': 'onMediaInputImageSizeChange',
      'click @ui.promotions_dismiss': 'onPromotionDismiss',
      'click @ui.promotions_action': 'onPromotionAction'
    });
  },
  getMediaType: function getMediaType() {
    // `get( 'media_type' )` is for BC.
    return this.mediaType || this.model.get('media_type') || this.model.get('media_types')[0];
  },
  /**
   * Get library type for `wp.media` using a given media type.
   *
   * @param {string} mediaType - The media type to get the library for.
   * @return {string} library media type
   */
  getLibraryType: function getLibraryType(mediaType) {
    if (!mediaType) {
      mediaType = this.getMediaType();
    }
    return 'svg' === mediaType ? 'image/svg+xml' : mediaType;
  },
  applySavedValue: function applySavedValue() {
    var _this$getControlPlace,
      _this = this;
    var value = this.getControlValue('url'),
      url = value || ((_this$getControlPlace = this.getControlPlaceholder()) === null || _this$getControlPlace === void 0 ? void 0 : _this$getControlPlace.url),
      attachmentId = this.getControlValue('id'),
      isPlaceholder = !value && url,
      mediaType = this.getMediaType();
    if (['image', 'svg'].includes(mediaType)) {
      this.ui.mediaImage.css('background-image', url ? 'url(' + url + ')' : '');
      if (isPlaceholder) {
        this.ui.mediaImage.css('opacity', 0.5);
      }
    } else if ('video' === mediaType) {
      this.ui.mediaVideo.attr('src', url);
    } else {
      var fileName = url ? url.split('/').pop() : '';
      this.ui.fileName.text(fileName);
    }
    if (this.ui.mediaInputImageSize) {
      var imageSize = this.getControlValue('size');
      if (isPlaceholder) {
        var _this$getControlPlace2;
        imageSize = (_this$getControlPlace2 = this.getControlPlaceholder()) === null || _this$getControlPlace2 === void 0 ? void 0 : _this$getControlPlace2.size;
      }
      this.ui.mediaInputImageSize.val(imageSize).toggleClass('e-select-placeholder', isPlaceholder);
    }
    this.ui.controlMedia.toggleClass('e-media-empty', !value).toggleClass('e-media-empty-placeholder', !value && !isPlaceholder);
    if ('image' === mediaType) {
      if (attachmentId) {
        var dismissPromotionEventName = this.getDismissPromotionEventName();
        var handleHints = function handleHints(attachment) {
          // eslint-disable-next-line capitalized-comments
          // this.ui.warnings.toggle( ! this.imageHasAlt( attachment ) );
          if (_this.ui.promotions.length && !elementor.config.user.dismissed_editor_notices.includes(dismissPromotionEventName)) {
            var alwaysOn = _this.ui.promotions.find('.elementor-control-notice').data('display') || false;
            var showHint = alwaysOn || _this.imageNotOptimized(attachment);
            _this.ui.promotions.toggle(showHint);
          }
        };
        wp.media.attachment(attachmentId).fetch().then(handleHints);
      } else {
        // eslint-disable-next-line capitalized-comments
        // this.ui.warnings.hide();

        // eslint-disable-next-line no-lonely-if
        if (this.ui.promotions.length) {
          this.ui.promotions.hide();
        }
      }
    }
  },
  openFrame: function openFrame(e) {
    var _arguments = arguments,
      _this2 = this;
    return (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee() {
      var _e$target, _e$target$dataset;
      var source, mediaType, selectedId;
      return _regenerator.default.wrap(function _callee$(_context) {
        while (1) switch (_context.prev = _context.next) {
          case 0:
            source = _arguments.length > 1 && _arguments[1] !== undefined ? _arguments[1] : null;
            mediaType = (e === null || e === void 0 ? void 0 : (_e$target = e.target) === null || _e$target === void 0 ? void 0 : (_e$target$dataset = _e$target.dataset) === null || _e$target$dataset === void 0 ? void 0 : _e$target$dataset.mediaType) || _this2.getMediaType();
            _this2.mediaType = mediaType;
            if (mediaType) {
              _context.next = 5;
              break;
            }
            return _context.abrupt("return");
          case 5:
            if (_filesUploadHandler.default.isUploadEnabled(mediaType)) {
              _context.next = 8;
              break;
            }
            _filesUploadHandler.default.getUnfilteredFilesNotEnabledDialog(function () {
              return _this2.openFrame(e, 'filter-popup');
            }).show();
            return _context.abrupt("return", false);
          case 8:
            if (!(source !== 'filter-popup' && ['application/json', 'json'].includes(mediaType))) {
              _context.next = 11;
              break;
            }
            _context.next = 11;
            return (0, _jsonUploadWarningMessage.showJsonUploadWarningMessageIfNeeded)({
              introductionMap: window.elementor.config.user.introduction,
              IntroductionClass: window.elementorModules.editor.utils.Introduction
            });
          case 11:
            // If there is no frame, or the current initialized frame contains a different library than
            // the `data-media-type` of the clicked button, (re)initialize the frame.
            if (!_this2.frame || _this2.getLibraryType(mediaType) !== _this2.currentLibraryType) {
              _this2.initFrame();
            }
            _this2.frame.open();

            // Set params to trigger sanitizer
            _filesUploadHandler.default.setUploadTypeCaller(_this2.frame);
            selectedId = _this2.getControlValue('id');
            if (selectedId) {
              _context.next = 17;
              break;
            }
            return _context.abrupt("return");
          case 17:
            _this2.frame.state().get('selection').add(wp.media.attachment(selectedId));
          case 18:
          case "end":
            return _context.stop();
        }
      }, _callee);
    }))();
  },
  deleteImage: function deleteImage(event) {
    event.stopPropagation();
    this.setValue({
      url: '',
      id: ''
    });
    this.applySavedValue();
  },
  imageHasAlt: function imageHasAlt(attachment) {
    var _attachment$alt;
    var attachmentAlt = (attachment === null || attachment === void 0 ? void 0 : (_attachment$alt = attachment.alt) === null || _attachment$alt === void 0 ? void 0 : _attachment$alt.trim()) || '';
    return !!attachmentAlt;
  },
  imageNotOptimized: function imageNotOptimized(attachment) {
    var checks = {
      height: 1080,
      width: 1920,
      filesizeInBytes: 200000
    };
    return Object.keys(checks).some(function (key) {
      var value = attachment[key] || false;
      return value && value > checks[key];
    });
  },
  getDismissPromotionEventName: function getDismissPromotionEventName() {
    var _$dismissButton$, _$dismissButton$$data;
    var $promotions = this.ui.promotions;
    var $dismissButton = $promotions.find('.elementor-control-notice-dismiss');
    // Remove listener
    $dismissButton.off('click');
    return ((_$dismissButton$ = $dismissButton[0]) === null || _$dismissButton$ === void 0 ? void 0 : (_$dismissButton$$data = _$dismissButton$.dataset) === null || _$dismissButton$$data === void 0 ? void 0 : _$dismissButton$$data.event) || false;
  },
  onPromotionDismiss: function onPromotionDismiss() {
    this.dismissPromotion(this.getDismissPromotionEventName());
  },
  onPromotionAction: function onPromotionAction(event) {
    var _JSON$parse = JSON.parse(event.target.closest('button').dataset.settings),
      _JSON$parse$action_ur = _JSON$parse.action_url,
      actionURL = _JSON$parse$action_ur === void 0 ? null : _JSON$parse$action_ur;
    if (actionURL) {
      window.open(actionURL, '_blank');
    }
    this.hidePromotion();
  },
  dismissPromotion: function dismissPromotion(eventName) {
    this.hidePromotion(eventName);
    if (eventName) {
      elementorCommon.ajax.addRequest('dismissed_editor_notices', {
        data: {
          dismissId: eventName
        }
      });
    }
  },
  hidePromotion: function hidePromotion() {
    var eventName = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
    var $promotions = this.ui.promotions;
    $promotions.hide();
    if (!eventName) {
      eventName = this.getDismissPromotionEventName();
    }
    // Prevent opening the same promotion again in current editor session.
    elementor.config.user.dismissed_editor_notices.push(eventName);
  },
  onMediaInputImageSizeChange: function onMediaInputImageSizeChange() {
    var _this3 = this;
    if (!this.model.get('has_sizes')) {
      return;
    }
    var currentControlValue = this.getControlValue(),
      placeholder = this.getControlPlaceholder();
    var hasImage = '' !== (currentControlValue === null || currentControlValue === void 0 ? void 0 : currentControlValue.id),
      hasPlaceholder = placeholder === null || placeholder === void 0 ? void 0 : placeholder.id,
      hasValue = hasImage || hasPlaceholder;
    if (!hasValue) {
      return;
    }
    var shouldUpdateFromPlaceholder = hasPlaceholder && !hasImage;
    if (shouldUpdateFromPlaceholder) {
      this.setValue(_objectSpread(_objectSpread({}, placeholder), {}, {
        size: currentControlValue.size
      }));
      if (this.model.get('responsive')) {
        // Render is already calls `applySavedValue`, therefore there's no need for it in this case.
        this.renderWithChildren();
      } else {
        this.applySavedValue();
      }
      this.onMediaInputImageSizeChange();
      return;
    }
    var imageURL;
    elementor.channels.editor.once('imagesManager:detailsReceived', function (data) {
      var _data$currentControlV;
      imageURL = (_data$currentControlV = data[currentControlValue.id]) === null || _data$currentControlV === void 0 ? void 0 : _data$currentControlV[currentControlValue.size];
      if (imageURL) {
        currentControlValue.url = imageURL;
        _this3.setValue(currentControlValue);
      }
    });
    imageURL = elementor.imagesManager.getImageUrl({
      id: currentControlValue.id,
      url: currentControlValue.url,
      size: currentControlValue.size
    });
    if (imageURL) {
      currentControlValue.url = imageURL;
      this.setValue(currentControlValue);
    }
  },
  /**
   * Create a media modal select frame, and store it so the instance can be reused when needed.
   */
  initFrame: function initFrame() {
    var mediaType = this.getMediaType();
    this.currentLibraryType = this.getLibraryType(mediaType);

    // Set current doc id to attach uploaded images.
    wp.media.view.settings.post.id = elementor.config.document.id;
    this.frame = wp.media({
      frame: 'post',
      type: 'image',
      multiple: false,
      states: [new wp.media.controller.Library({
        title: __('Insert Media', 'elementor'),
        library: wp.media.query({
          type: this.currentLibraryType
        }),
        multiple: false,
        date: false
      })]
    });

    // Remove unwanted elements when frame is opened.
    this.frame.on('ready open', this.onFrameReady.bind(this));

    // When a file is selected, run a callback.
    this.frame.on('insert select', this.select.bind(this));
    if (elementorCommon.config.filesUpload.unfilteredFiles) {
      this.setUploadMimeType(this.frame, mediaType);
    }
  },
  /**
   * Hack to remove unwanted elements from modal & Open the `Insert from URL` tab.
   */
  onFrameReady: function onFrameReady() {
    var $frame = this.frame.$el;
    var elementsToRemove = ['#menu-item-insert', '#menu-item-gallery', '#menu-item-playlist', '#menu-item-video-playlist', '.embed-link-settings'];
    $frame.find(elementsToRemove.join(',')).remove();

    // Change the default button text using CSS by passing the text as a variable.
    $frame.css('--button-text', "'".concat(__('Insert Media', 'elementor'), "'"));

    // Remove elements from the URL upload tab.
    $frame.addClass('e-wp-media-elements-removed');
    if ('url' === this.getControlValue('source')) {
      // Go to the url tab.
      $frame.find('#menu-item-embed').trigger('click');

      // Hide the top media tabs ( WordPress does that automatically if a real user clicks the url tab ).
      $frame.addClass('hide-router');

      // Load the image URL.
      this.frame.views.get('.media-frame-content')[0].url.model.set({
        url: this.getControlValue('url'),
        alt: this.getControlValue('alt')
      });
    } else {
      // Go to the upload tab.
      $frame.find('#menu-item-library').trigger('click');
    }
  },
  setUploadMimeType: function setUploadMimeType(frame, ext) {
    // Add unfiltered files to the allowed upload extensions
    var oldExtensions = _wpPluploadSettings.defaults.filters.mime_types[0].extensions;
    frame.on('ready', function () {
      _wpPluploadSettings.defaults.filters.mime_types[0].extensions = 'application/json' === ext ? 'json' : oldExtensions + ',svg';
    });
    this.frame.on('close', function () {
      // Restore allowed upload extensions
      _wpPluploadSettings.defaults.filters.mime_types[0].extensions = oldExtensions;
    });
  },
  /**
   * Callback handler for when an attachment is selected in the media modal.
   * Gets the selected image information, and sets it within the control.
   */
  select: function select() {
    this.trigger('before:select');
    var state = this.frame.state();
    var attachment;
    if ('embed' === state.get('id')) {
      // Insert from URL.
      attachment = {
        url: state.props.get('url'),
        id: '',
        alt: state.props.get('alt'),
        source: 'url'
      };
    } else {
      // Get the attachment from the modal frame.
      attachment = this.frame.state().get('selection').first().toJSON();
      attachment.source = 'library';
    }
    if (attachment.url) {
      this.setValue({
        url: attachment.url,
        id: attachment.id,
        alt: attachment.alt,
        source: attachment.source,
        size: this.model.get('default').size
      });
      if (this.model.get('responsive')) {
        // Render is already calls `applySavedValue`, therefore there's no need for it in this case.
        this.renderWithChildren();
      } else {
        this.applySavedValue();
      }
    }
    this.onMediaInputImageSizeChange();
    this.trigger('after:select');
  },
  onBeforeDestroy: function onBeforeDestroy() {
    this.$el.remove();
  }
});
module.exports = ControlMediaItemView;

/***/ }),

/***/ "../assets/dev/js/editor/controls/notice.js":
/*!**************************************************!*\
  !*** ../assets/dev/js/editor/controls/notice.js ***!
  \**************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _toConsumableArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/toConsumableArray */ "../node_modules/@babel/runtime/helpers/toConsumableArray.js"));
var ControlBaseView = __webpack_require__(/*! elementor-controls/base */ "../assets/dev/js/editor/controls/base.js");
module.exports = ControlBaseView.extend({
  ui: function ui() {
    var ui = ControlBaseView.prototype.ui.apply(this, arguments);
    ui.button = '.elementor-control-notice-dismiss';
    return ui;
  },
  events: {
    'click @ui.button.e-btn-1': 'onButton1Click',
    'click @ui.button.e-btn-2': 'onButton2Click',
    'click @ui.button.elementor-control-notice-dismiss': 'onDismissButtonClick'
  },
  onButton1Click: function onButton1Click() {
    var eventName = this.model.get('event');
    elementor.channels.editor.trigger(eventName, this);
  },
  onButton2Click: function onButton2Click() {
    var eventName = this.model.get('event');
    elementor.channels.editor.trigger(eventName, this);
  },
  getDismissId: function getDismissId() {
    var _this$options, _this$options$element, _this$options$element2, _this$options$element3, _this$options2, _this$options2$elemen, _this$options2$elemen2, _this$options2$elemen3, _this$options3, _this$options3$elemen, _this$options3$elemen2, _this$options3$elemen3;
    var controlName = this.model.get('name');
    var elementType = 'widget' === ((_this$options = this.options) === null || _this$options === void 0 ? void 0 : (_this$options$element = _this$options.element) === null || _this$options$element === void 0 ? void 0 : (_this$options$element2 = _this$options$element.model) === null || _this$options$element2 === void 0 ? void 0 : (_this$options$element3 = _this$options$element2.attributes) === null || _this$options$element3 === void 0 ? void 0 : _this$options$element3.elType) ? (_this$options2 = this.options) === null || _this$options2 === void 0 ? void 0 : (_this$options2$elemen = _this$options2.element) === null || _this$options2$elemen === void 0 ? void 0 : (_this$options2$elemen2 = _this$options2$elemen.model) === null || _this$options2$elemen2 === void 0 ? void 0 : (_this$options2$elemen3 = _this$options2$elemen2.attributes) === null || _this$options2$elemen3 === void 0 ? void 0 : _this$options2$elemen3.widgetType : (_this$options3 = this.options) === null || _this$options3 === void 0 ? void 0 : (_this$options3$elemen = _this$options3.element) === null || _this$options3$elemen === void 0 ? void 0 : (_this$options3$elemen2 = _this$options3$elemen.model) === null || _this$options3$elemen2 === void 0 ? void 0 : (_this$options3$elemen3 = _this$options3$elemen2.attributes) === null || _this$options3$elemen3 === void 0 ? void 0 : _this$options3$elemen3.elType;
    return "".concat(elementType, "-").concat(controlName);
  },
  onDismissButtonClick: function onDismissButtonClick() {
    var _this = this;
    var dismissId = this.getDismissId();
    elementorCommon.ajax.addRequest('dismissed_editor_notices', {
      data: {
        dismissId: dismissId
      },
      success: function success() {
        var _elementor, _elementor$config, _elementor$config$use;
        _this.$el.remove();
        var dismissedNotices = (_elementor = elementor) !== null && _elementor !== void 0 && (_elementor$config = _elementor.config) !== null && _elementor$config !== void 0 && (_elementor$config$use = _elementor$config.user) !== null && _elementor$config$use !== void 0 && _elementor$config$use.dismissed_editor_notices ? (0, _toConsumableArray2.default)(elementor.config.user.dismissed_editor_notices) : [];
        elementor.config.user.dismissed_editor_notices = [].concat((0, _toConsumableArray2.default)(dismissedNotices), [dismissId]);
      }
    });
  },
  templateHelpers: function templateHelpers() {
    var _elementor2, _elementor2$config, _elementor2$config$us;
    var controlData = ControlBaseView.prototype.templateHelpers.apply(this, arguments);
    var dismissedNotices = (_elementor2 = elementor) !== null && _elementor2 !== void 0 && (_elementor2$config = _elementor2.config) !== null && _elementor2$config !== void 0 && (_elementor2$config$us = _elementor2$config.user) !== null && _elementor2$config$us !== void 0 && _elementor2$config$us.dismissed_editor_notices ? (0, _toConsumableArray2.default)(elementor.config.user.dismissed_editor_notices) : [];
    var dismissId = this.getDismissId();
    controlData.data.shouldRenderNotice = !dismissedNotices.includes(dismissId);
    return controlData;
  }
});

/***/ }),

/***/ "../assets/dev/js/editor/controls/number.js":
/*!**************************************************!*\
  !*** ../assets/dev/js/editor/controls/number.js ***!
  \**************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _scrubbing = _interopRequireDefault(__webpack_require__(/*! ./behaviors/scrubbing */ "../assets/dev/js/editor/controls/behaviors/scrubbing.js"));
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
var ControlBaseDataView = __webpack_require__(/*! elementor-controls/base-data */ "../assets/dev/js/editor/controls/base-data.js"),
  ControlNumberItemView;
ControlNumberItemView = ControlBaseDataView.extend({
  behaviors: function behaviors() {
    return _objectSpread(_objectSpread({}, ControlBaseDataView.prototype.behaviors.apply(this)), {}, {
      Scrubbing: {
        behaviorClass: _scrubbing.default,
        scrubSettings: {
          intentTime: 800
        }
      }
    });
  },
  registerValidators: function registerValidators() {
    ControlBaseDataView.prototype.registerValidators.apply(this, arguments);
    var validationTerms = {},
      model = this.model;
    ['min', 'max'].forEach(function (term) {
      var termValue = model.get(term);
      if (_.isFinite(termValue)) {
        validationTerms[term] = termValue;
      }
    });
    if (!jQuery.isEmptyObject(validationTerms)) {
      this.addValidator(new this.validatorTypes.Number({
        validationTerms: validationTerms
      }));
    }
  }
});
module.exports = ControlNumberItemView;

/***/ }),

/***/ "../assets/dev/js/editor/controls/popover-toggle.js":
/*!**********************************************************!*\
  !*** ../assets/dev/js/editor/controls/popover-toggle.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var __ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["__"];


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "../node_modules/@babel/runtime/helpers/slicedToArray.js"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var ControlChooseView = __webpack_require__(/*! elementor-controls/choose */ "../assets/dev/js/editor/controls/choose.js");
var ControlPopoverStarterView = /*#__PURE__*/function (_ControlChooseView) {
  (0, _inherits2.default)(ControlPopoverStarterView, _ControlChooseView);
  var _super = _createSuper(ControlPopoverStarterView);
  function ControlPopoverStarterView() {
    (0, _classCallCheck2.default)(this, ControlPopoverStarterView);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(ControlPopoverStarterView, [{
    key: "ui",
    value: function ui() {
      var ui = ControlChooseView.prototype.ui.apply(this, arguments);
      ui.popoverToggle = '.elementor-control-popover-toggle-toggle';
      ui.resetInput = '.elementor-control-popover-toggle-reset';
      return ui;
    }
  }, {
    key: "events",
    value: function events() {
      return _.extend(ControlChooseView.prototype.events.apply(this, arguments), {
        'click @ui.popoverToggle': 'onPopoverToggleClick',
        'click @ui.resetInput': 'onResetInputClick'
      });
    }
  }, {
    key: "onShow",
    value: function onShow() {
      var _this = this;
      var $popover = this.$el.next('.elementor-controls-popover');

      // Attach the current control as a toggle of its popover.
      if ($popover.length) {
        $popover[0].dataset.popoverToggle = "elementor-control-default-".concat(this.model.cid);
        $popover.on('hide', function () {
          return _this.onPopoverHide();
        });
        $popover.attr('data-on-hide', true);
      }
    }
  }, {
    key: "onPopoverHide",
    value: function onPopoverHide() {
      this.reRoute(false);
    }
  }, {
    key: "onResetInputClick",
    value: function onResetInputClick() {
      var globalData = this.model.get('global');
      if (globalData !== null && globalData !== void 0 && globalData.active) {
        this.triggerMethod('value:type:change');
      }
    }
  }, {
    key: "onInputChange",
    value: function onInputChange(event) {
      if (event.currentTarget !== this.ui.popoverToggle[0]) {
        return;
      }

      // If the control has a global value, unset the global.
      if (this.getGlobalKey()) {
        this.triggerMethod('unset:global:value');
      } else if (this.isGlobalActive()) {
        this.triggerMethod('value:type:change');
      }
    }
  }, {
    key: "onPopoverToggleClick",
    value: function onPopoverToggleClick() {
      var _this2 = this;
      if (this.isGlobalActive() && !this.getControlValue() && !this.getGlobalKey() && this.getGlobalDefault()) {
        this.triggerMethod('unlink:global:default');
      }
      var $popover = this.$el.next('.elementor-controls-popover');
      if (!$popover.attr('data-on-hide')) {
        $popover.attr('data-on-hide', true);
        $popover.on('hide', function () {
          return _this2.onPopoverHide();
        });
      }
      if (!$popover.is(':visible')) {
        this.reRoute(true);
      } else {
        $popover.hide();
        $popover.trigger('hide');
      }
    }
  }, {
    key: "activate",
    value: function activate() {
      this.$el.next('.elementor-controls-popover').show();
    }
  }, {
    key: "getGlobalCommand",
    value: function getGlobalCommand() {
      return 'globals/typography';
    }
  }, {
    key: "buildPreviewItemCSS",
    value: function buildPreviewItemCSS(globalValue) {
      var cssObject = {};
      Object.entries(globalValue).forEach(function (_ref) {
        var _ref2 = (0, _slicedToArray2.default)(_ref, 2),
          property = _ref2[0],
          value = _ref2[1];
        // If a control value is empty, ignore it.
        if (!value || '' === value.size) {
          return;
        }
        if (property.startsWith('typography_')) {
          property = property.replace('typography_', '');
        }
        if ('font_family' === property) {
          elementor.helpers.enqueueFont(value, 'editor');
        }
        if ('font_size' === property) {
          var fontSize = 'custom' === value.unit ? value.size : "".concat(value.size).concat(value.unit);
          cssObject.fontSize = "min(".concat(fontSize, ", 28px)");
        } else {
          // Convert the snake case property names into camel case to match their corresponding CSS property names.
          if (property.includes('_')) {
            property = property.replace(/([_][a-z])/g, function (result) {
              return result.toUpperCase().replace('_', '');
            });
          }
          cssObject[property] = value;
        }
      });
      return cssObject;
    }
  }, {
    key: "createGlobalItemMarkup",
    value: function createGlobalItemMarkup(globalData) {
      var $typographyPreview = jQuery('<div>', {
        class: 'e-global__preview-item e-global__typography',
        'data-global-id': globalData.id,
        title: globalData.title
      });
      $typographyPreview.html(globalData.title).css(this.buildPreviewItemCSS(globalData.value));
      return $typographyPreview;
    }
  }, {
    key: "getGlobalMeta",
    value: function getGlobalMeta() {
      return {
        commandName: this.getGlobalCommand(),
        key: this.model.get('name'),
        title: __('New Typography Setting', 'elementor'),
        controlType: 'typography',
        route: 'panel/global/global-typography'
      };
    }
  }, {
    key: "getAddGlobalConfirmMessage",
    value: function getAddGlobalConfirmMessage() {
      var globalData = this.getGlobalMeta(),
        $message = jQuery('<div>', {
          class: 'e-global__confirm-message'
        }),
        $messageText = jQuery('<div>').html(__('Are you sure you want to create a new Global Font setting?', 'elementor')),
        $inputWrapper = jQuery('<div>', {
          class: 'e-global__confirm-input-wrapper'
        }),
        $input = jQuery('<input>', {
          type: 'text',
          name: 'global-name',
          placeholder: globalData.title
        }).val(globalData.title);
      $inputWrapper.append($input);
      $message.append($messageText, $inputWrapper);
      return $message;
    }
  }, {
    key: "getGlobalsList",
    value: function () {
      var _getGlobalsList = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee() {
        var result;
        return _regenerator.default.wrap(function _callee$(_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              _context.next = 2;
              return $e.data.get(this.getGlobalCommand());
            case 2:
              result = _context.sent;
              return _context.abrupt("return", result.data);
            case 4:
            case "end":
              return _context.stop();
          }
        }, _callee, this);
      }));
      function getGlobalsList() {
        return _getGlobalsList.apply(this, arguments);
      }
      return getGlobalsList;
    }()
  }, {
    key: "buildGlobalsList",
    value: function buildGlobalsList(globalTypographies, $globalPreviewItemsContainer) {
      var _this3 = this;
      Object.values(globalTypographies).forEach(function (typography) {
        // Only build markup if the typography is valid.
        if (typography) {
          var $typographyPreview = _this3.createGlobalItemMarkup(typography);
          $globalPreviewItemsContainer.append($typographyPreview);
        }
      });
    }
  }, {
    key: "onAddGlobalButtonClick",
    value: function onAddGlobalButtonClick() {
      this.triggerMethod('add:global:to:list', this.getAddGlobalConfirmMessage());
    }
  }]);
  return ControlPopoverStarterView;
}(ControlChooseView);
exports["default"] = ControlPopoverStarterView;
ControlPopoverStarterView.onPasteStyle = function (control, clipboardValue) {
  return !clipboardValue || clipboardValue === control.return_value;
};

/***/ }),

/***/ "../assets/dev/js/editor/controls/repeater-row.js":
/*!********************************************************!*\
  !*** ../assets/dev/js/editor/controls/repeater-row.js ***!
  \********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var sprintf = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["sprintf"];
/* provided dependency */ var __ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["__"];


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _controlsStack = _interopRequireDefault(__webpack_require__(/*! elementor-views/controls-stack */ "../assets/dev/js/editor/views/controls-stack.js"));
module.exports = Marionette.CompositeView.extend({
  template: Marionette.TemplateCache.get('#tmpl-elementor-repeater-row'),
  className: 'elementor-repeater-fields',
  ui: function ui() {
    return {
      duplicateButton: '.elementor-repeater-tool-duplicate',
      editButton: '.elementor-repeater-tool-edit',
      removeButton: '.elementor-repeater-tool-remove',
      itemTitle: '.elementor-repeater-row-item-title'
    };
  },
  behaviors: {
    HandleInnerTabs: {
      behaviorClass: __webpack_require__(/*! elementor-behaviors/inner-tabs */ "../assets/dev/js/editor/elements/views/behaviors/inner-tabs.js")
    }
  },
  triggers: {
    'click @ui.removeButton': 'click:remove',
    'click @ui.duplicateButton': 'click:duplicate',
    'click @ui.itemTitle': 'click:edit'
  },
  modelEvents: {
    change: 'onModelChange'
  },
  templateHelpers: function templateHelpers() {
    return {
      itemIndex: this.getOption('itemIndex'),
      itemActions: this.getOption('itemActions')
    };
  },
  childViewContainer: '.elementor-repeater-row-controls',
  getChildView: function getChildView(item) {
    var controlType = item.get('type');
    return elementor.getControlView(controlType);
  },
  getChildControlView: function getChildControlView(name) {
    return this.getControlViewByModel(this.getControlModel(name));
  },
  getControlViewByModel: function getControlViewByModel(model) {
    return this.children.findByModelCid(model.cid);
  },
  getControlModel: function getControlModel(name) {
    return this.collection.findWhere({
      name: name
    });
  },
  childViewOptions: function childViewOptions() {
    return {
      container: this.options.container
    };
  },
  updateIndex: function updateIndex(newIndex) {
    this.itemIndex = newIndex;
  },
  setTitle: function setTitle() {
    var titleField = this.getOption('titleField');
    var title = '';
    if (titleField) {
      title = Marionette.TemplateCache.prototype.compileTemplate(titleField)(this.model.parseDynamicSettings());
    }
    if (!title) {
      /* Translators: %s: Item Index (number). */
      title = sprintf(__('Item #%s', 'elementor'), this.getOption('itemIndex'));
    }
    this.ui.itemTitle.html(title);
  },
  toggleSort: function toggleSort(enable) {
    this.$el.toggleClass('elementor-repeater-row--disable-sort', !enable);
  },
  initialize: function initialize(options) {
    this.itemIndex = 0;

    // Collection for Controls list
    this.collection = new Backbone.Collection(_.values(elementor.mergeControlsSettings(options.controlFields)));
  },
  onRender: function onRender() {
    this.setTitle();
    _controlsStack.default.handlePopovers(this);
  },
  onModelChange: function onModelChange() {
    if (this.getOption('titleField')) {
      this.setTitle();
    }
  },
  onChildviewResponsiveSwitcherClick: function onChildviewResponsiveSwitcherClick(childView, device) {
    if ('desktop' === device) {
      elementor.getPanelView().getCurrentPageView().$el.toggleClass('elementor-responsive-switchers-open');
    }
  }
});

/***/ }),

/***/ "../assets/dev/js/editor/controls/repeater.js":
/*!****************************************************!*\
  !*** ../assets/dev/js/editor/controls/repeater.js ***!
  \****************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var ControlBaseDataView = __webpack_require__(/*! elementor-controls/base-data */ "../assets/dev/js/editor/controls/base-data.js"),
  RepeaterRowView = __webpack_require__(/*! elementor-controls/repeater-row */ "../assets/dev/js/editor/controls/repeater-row.js"),
  ControlRepeaterItemView;
ControlRepeaterItemView = ControlBaseDataView.extend({
  ui: {
    btnAddRow: '.elementor-repeater-add',
    fieldContainer: '.elementor-repeater-fields-wrapper'
  },
  events: function events() {
    return {
      'click @ui.btnAddRow': 'onButtonAddRowClick',
      'sortstart @ui.fieldContainer': 'onSortStart',
      'sortupdate @ui.fieldContainer': 'onSortUpdate',
      'sortstop @ui.fieldContainer': 'onSortStop'
    };
  },
  childView: RepeaterRowView,
  childViewContainer: '.elementor-repeater-fields-wrapper',
  templateHelpers: function templateHelpers() {
    return {
      itemActions: this.model.get('item_actions'),
      data: _.extend({}, this.model.toJSON(), {
        controlValue: []
      })
    };
  },
  childViewOptions: function childViewOptions(rowModel, index) {
    var elementContainer = this.getOption('container');
    return {
      container: elementContainer.repeaters[this.model.get('name')].children[index],
      controlFields: this.model.get('fields'),
      titleField: this.model.get('title_field'),
      itemActions: this.model.get('item_actions')
    };
  },
  createItemModel: function createItemModel(attrs, options, controlView) {
    options.controls = controlView.model.get('fields');
    return new elementorModules.editor.elements.models.BaseSettings(attrs, options);
  },
  fillCollection: function fillCollection() {
    // TODO: elementSettingsModel is deprecated since 2.8.0.
    var settings = this.container ? this.container.settings : this.elementSettingsModel;
    var controlName = this.model.get('name');
    this.collection = settings.get(controlName);

    // Hack for history redo/undo
    if (!(this.collection instanceof Backbone.Collection)) {
      this.collection = new Backbone.Collection(this.collection, {
        // Use `partial` to supply the `this` as an argument, but not as context
        // the `_` is a place holder for original arguments: `attrs` & `options`
        model: _.partial(this.createItemModel, _, _, this)
      });

      // Set the value silent
      settings.set(controlName, this.collection, {
        silent: true
      });
    }
  },
  initialize: function initialize() {
    ControlBaseDataView.prototype.initialize.apply(this, arguments);
    this.fillCollection();
    this.listenTo(this.collection, 'reset', this.resetContainer.bind(this));
    this.listenTo(this.collection, 'add', this.updateContainer.bind(this));
  },
  editRow: function editRow(rowView) {
    if (this.currentEditableChild) {
      var currentEditable = this.currentEditableChild.getChildViewContainer(this.currentEditableChild);
      currentEditable.removeClass('editable');

      // If the repeater contains TinyMCE editors, fire the `hide` trigger to hide floated toolbars
      currentEditable.find('.elementor-wp-editor').each(function () {
        tinymce.get(this.id).fire('hide');
      });
    }
    if (this.currentEditableChild === rowView) {
      delete this.currentEditableChild;
      return;
    }
    rowView.getChildViewContainer(rowView).addClass('editable');
    this.currentEditableChild = rowView;
    this.updateActiveRow();
  },
  toggleMinRowsClass: function toggleMinRowsClass() {
    if (!this.model.get('prevent_empty')) {
      return;
    }
    this.$el.toggleClass('elementor-repeater-has-minimum-rows', 1 >= this.collection.length);
  },
  updateActiveRow: function updateActiveRow() {
    var activeItemIndex = 1;
    if (this.currentEditableChild) {
      activeItemIndex = this.currentEditableChild.itemIndex;
    }
    this.setEditSetting('activeItemIndex', activeItemIndex);
  },
  updateChildIndexes: function updateChildIndexes() {
    var collection = this.collection;
    this.children.each(function (view) {
      view.updateIndex(collection.indexOf(view.model) + 1);
      view.setTitle();
    });
  },
  getSortableParams: function getSortableParams() {
    return {
      axis: 'y',
      handle: '.elementor-repeater-row-tools',
      items: ' > :not(.elementor-repeater-row--disable-sort)',
      cancel: '' // Elements that do not allow sorting (by default it includs buttons).
    };
  },
  onRender: function onRender() {
    ControlBaseDataView.prototype.onRender.apply(this, arguments);
    if (this.model.get('item_actions').sort) {
      this.ui.fieldContainer.sortable(this.getSortableParams());
    }
    this.toggleMinRowsClass();
  },
  onSortStart: function onSortStart(event, ui) {
    ui.item.data('oldIndex', ui.item.index());
  },
  onSortStop: function onSortStop(event, ui) {
    // Reload TinyMCE editors (if exist), it's a bug that TinyMCE content is missing after stop dragging
    var self = this,
      sortedIndex = ui.item.index();
    if (-1 === sortedIndex) {
      return;
    }
    var sortedRowView = self.children.findByIndex(ui.item.index()),
      rowControls = sortedRowView.children._views;
    jQuery.each(rowControls, function () {
      if ('wysiwyg' === this.model.get('type')) {
        sortedRowView.render();
        delete self.currentEditableChild;
        return false;
      }
    });
  },
  onSortUpdate: function onSortUpdate(event, ui) {
    var oldIndex = ui.item.data('oldIndex'),
      newIndex = ui.item.index();
    $e.run('document/repeater/move', {
      container: this.options.container,
      name: this.model.get('name'),
      sourceIndex: oldIndex,
      targetIndex: newIndex
    });
  },
  onAddChild: function onAddChild() {
    this.updateChildIndexes();
    this.updateActiveRow();
  },
  /**
   * Update container to ensure that new child elements appear in container children.
   *
   * @param {*} model - Container model.
   */
  updateContainer: function updateContainer(model) {
    var container = this.options.container.repeaters[this.model.get('name')],
      isInChildren = container.children.filter(function (child) {
        return child.id === model.get('_id');
      });
    if (!isInChildren.length) {
      elementorDevTools.deprecation.deprecated('Don\'t add models directly to the repeater.', '3.0.0', '$e.run( \'document/repeater/insert\' )');
      this.options.container.addRepeaterItem(this.model.get('name'), model, model.collection.indexOf(model));
    }
  },
  /**
   * Reset container to ensure that container children are reset on collection reset.
   *
   * @deprecated since 3.0.0, use `$e.run( 'document/repeater/remove' )` instead.
   */
  resetContainer: function resetContainer() {
    elementorDevTools.deprecation.deprecated('Don\'t reset repeater collection directly.', '3.0.0', '$e.run( \'document/repeater/remove\' )');
    this.options.container.repeaters[this.model.get('name')].children = [];
  },
  getDefaults: function getDefaults() {
    var defaults = {};

    // Get default fields.
    _.each(this.model.get('fields'), function (field) {
      defaults[field.name] = field.default;
    });
    return defaults;
  },
  getChildControlView: function getChildControlView(id) {
    return this.getControlViewByModel(this.getControlModel(id));
  },
  getControlViewByModel: function getControlViewByModel(model) {
    return this.children.findByModelCid(model.cid);
  },
  getControlModel: function getControlModel(_id) {
    return this.collection.findWhere({
      _id: _id
    });
  },
  onButtonAddRowClick: function onButtonAddRowClick() {
    var newModel = $e.run('document/repeater/insert', {
      container: this.options.container,
      name: this.model.get('name'),
      model: this.getDefaults()
    });
    var newChild = this.children.findByModel(newModel);
    this.editRow(newChild);
    this.toggleMinRowsClass();
  },
  onChildviewClickRemove: function onChildviewClickRemove(childView) {
    if (childView === this.currentEditableChild) {
      delete this.currentEditableChild;
    }
    $e.run('document/repeater/remove', {
      container: this.options.container,
      name: this.model.get('name'),
      index: childView._index
    });
    this.updateActiveRow();
    this.updateChildIndexes();
    this.toggleMinRowsClass();
  },
  onChildviewClickDuplicate: function onChildviewClickDuplicate(childView) {
    $e.run('document/repeater/duplicate', {
      container: this.options.container,
      name: this.model.get('name'),
      index: childView._index
    });
    this.toggleMinRowsClass();
  },
  onChildviewClickEdit: function onChildviewClickEdit(childView) {
    this.editRow(childView);
  },
  onAfterExternalChange: function onAfterExternalChange() {
    // Update the collection with current value
    this.fillCollection();
    ControlBaseDataView.prototype.onAfterExternalChange.apply(this, arguments);
  }
});
module.exports = ControlRepeaterItemView;

/***/ }),

/***/ "../assets/dev/js/editor/controls/section.js":
/*!***************************************************!*\
  !*** ../assets/dev/js/editor/controls/section.js ***!
  \***************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var ControlBaseView = __webpack_require__(/*! elementor-controls/base */ "../assets/dev/js/editor/controls/base.js"),
  ControlSectionItemView;
ControlSectionItemView = ControlBaseView.extend({
  ui: function ui() {
    var ui = ControlBaseView.prototype.ui.apply(this, arguments);
    ui.heading = '.elementor-panel-heading';
    return ui;
  },
  triggers: {
    click: 'control:section:clicked'
  }
});
module.exports = ControlSectionItemView;

/***/ }),

/***/ "../assets/dev/js/editor/controls/select.js":
/*!**************************************************!*\
  !*** ../assets/dev/js/editor/controls/select.js ***!
  \**************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var ControlBaseDataView = __webpack_require__(/*! elementor-controls/base-data */ "../assets/dev/js/editor/controls/base-data.js"),
  ControlSelectItemView;
ControlSelectItemView = ControlBaseDataView.extend({
  updatePlaceholder: function updatePlaceholder() {
    var select = this.ui.select;
    if (!select) {
      return;
    }
    var selected = select.find('option:selected');

    // When option with an empty value ('') selected, and it's not the placeholder option,
    // set the selected option to the placeholder.
    if ('' === selected.val() && !selected.hasClass('e-option-placeholder')) {
      selected = select.find('.e-option-placeholder');
      selected.prop('selected', true);
    }
    if (selected.hasClass('e-option-placeholder')) {
      select.addClass('e-select-placeholder');
    } else {
      select.removeClass('e-select-placeholder');
    }
  },
  onReady: function onReady() {
    var placeholder = this.getControlPlaceholder();
    if (placeholder) {
      jQuery('<option>').val('').text(this.model.get('options')[placeholder]).addClass('e-option-placeholder').prependTo(this.ui.select);
    }
    this.updatePlaceholder();
  },
  onInputChange: function onInputChange() {
    this.updatePlaceholder();
  }
}, {
  onPasteStyle: function onPasteStyle(control, clipboardValue) {
    if (control.groups) {
      return control.groups.some(function (group) {
        return ControlSelectItemView.onPasteStyle(group, clipboardValue);
      });
    }
    return undefined !== control.options[clipboardValue];
  }
});
module.exports = ControlSelectItemView;

/***/ }),

/***/ "../assets/dev/js/editor/controls/select2.js":
/*!***************************************************!*\
  !*** ../assets/dev/js/editor/controls/select2.js ***!
  \***************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _select = _interopRequireDefault(__webpack_require__(/*! elementor-editor-utils/select2.js */ "../assets/dev/js/editor/utils/select2.js"));
var ControlBaseDataView = __webpack_require__(/*! elementor-controls/base-data */ "../assets/dev/js/editor/controls/base-data.js"),
  ControlSelect2ItemView;
ControlSelect2ItemView = ControlBaseDataView.extend({
  getSelect2Placeholder: function getSelect2Placeholder() {
    return this.ui.select.find("[value=\"".concat(this.getControlPlaceholder(), "\"]")).text() || this.ui.select.children('option:first[value=""]').text();
  },
  getSelect2DefaultOptions: function getSelect2DefaultOptions() {
    var defaultOptions = {
        allowClear: true,
        placeholder: this.getSelect2Placeholder(),
        dir: elementorCommon.config.isRTL ? 'rtl' : 'ltr'
      },
      lockedOptions = this.model.get('lockedOptions');

    // If any non-deletable options are passed, remove the 'x' element from the template for selected items.
    if (lockedOptions) {
      defaultOptions.templateSelection = function (data, container) {
        if (lockedOptions.includes(data.id)) {
          jQuery(container).addClass('e-non-deletable').find('.select2-selection__choice__remove').remove();
        }
        return data.text;
      };
    }
    return defaultOptions;
  },
  getSelect2Options: function getSelect2Options() {
    return jQuery.extend(this.getSelect2DefaultOptions(), this.model.get('select2options'));
  },
  updatePlaceholder: function updatePlaceholder() {
    if (this.getControlPlaceholder()) {
      this.select2Instance.elements.$container.find('.select2-selection__placeholder').addClass('e-select2-placeholder');
    }
  },
  applySavedValue: function applySavedValue() {
    ControlBaseDataView.prototype.applySavedValue.apply(this, arguments);
    var elementSelect2Data = this.ui.select.data('select2');

    // Checking if the element itself was initiated with select2 functionality in case of multiple renders.
    if (!elementSelect2Data) {
      this.select2Instance = new _select.default({
        $element: this.ui.select,
        options: this.getSelect2Options()
      });
      this.updatePlaceholder();
      this.handleLockedOptions();
    } else {
      this.ui.select.trigger('change');
    }
  },
  handleLockedOptions: function handleLockedOptions() {
    var lockedOptions = this.model.get('lockedOptions');
    if (lockedOptions) {
      this.ui.select.on('select2:unselecting', function (event) {
        if (lockedOptions.includes(event.params.args.data.id)) {
          event.preventDefault();
        }
      });
    }
  },
  /**
   * @deprecated since 3.0.0
   */
  onReady: function onReady() {
    elementorDevTools.deprecation.deprecated('onReady()', '3.0.0');
  },
  /**
   * Get Input Value
   *
   * This method is an override of the base method. It is needed because when clearing the Select2 value in single
   * value mode, the library sets that value to `null`, and an empty string is the system's default empty value.
   *
   * @param {*} input current control input
   * @return {*} potentially modified input value
   */
  getInputValue: function getInputValue(input) {
    var _ControlBaseDataView$;
    // eslint-disable-line no-unused-vars
    return (_ControlBaseDataView$ = ControlBaseDataView.prototype.getInputValue.apply(this, arguments)) !== null && _ControlBaseDataView$ !== void 0 ? _ControlBaseDataView$ : '';
  },
  onBaseInputChange: function onBaseInputChange() {
    ControlBaseDataView.prototype.onBaseInputChange.apply(this, arguments);
    this.updatePlaceholder();
  },
  onBeforeDestroy: function onBeforeDestroy() {
    // We always destroy the select2 instance because there are cases where the DOM element's data cache
    // itself has been destroyed but the select2 instance on it still exists
    this.select2Instance.destroy();
    this.$el.remove();
  }
});
module.exports = ControlSelect2ItemView;

/***/ }),

/***/ "../assets/dev/js/editor/controls/slider.js":
/*!**************************************************!*\
  !*** ../assets/dev/js/editor/controls/slider.js ***!
  \**************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var _helpers = __webpack_require__(/*! elementor-editor-utils/helpers */ "../assets/dev/js/editor/utils/helpers.js");
var ControlBaseUnitsItemView = __webpack_require__(/*! elementor-controls/base-units */ "../assets/dev/js/editor/controls/base-units.js"),
  ControlSliderItemView;
ControlSliderItemView = ControlBaseUnitsItemView.extend({
  ui: function ui() {
    var ui = ControlBaseUnitsItemView.prototype.ui.apply(this, arguments);
    ui.slider = '.elementor-slider';
    return ui;
  },
  templateHelpers: function templateHelpers() {
    var templateHelpers = ControlBaseUnitsItemView.prototype.templateHelpers.apply(this, arguments);
    templateHelpers.isMultiple = this.isMultiple();
    return templateHelpers;
  },
  isMultiple: function isMultiple() {
    var sizes = this.getControlValue('sizes');
    return !jQuery.isEmptyObject(sizes);
  },
  initSlider: function initSlider() {
    // Slider does not exist in tests.
    if (!this.ui.slider[0]) {
      return;
    }
    if (this.isCustomUnit()) {
      return;
    }
    this.destroySlider();
    var isMultiple = this.isMultiple(),
      unitRange = elementorCommon.helpers.cloneObject(this.getCurrentRange()),
      step = unitRange.step;
    var sizes = this.getSize();
    if (isMultiple) {
      sizes = Object.values(sizes);
    } else {
      sizes = [sizes];

      // Make sure the value is a number, because the slider can't handle strings.
      sizes[0] = parseFloat(sizes[0]) || 0;
      this.ui.input.attr(unitRange);
    }
    delete unitRange.step;
    var tooltips;
    var self = this;
    if (isMultiple) {
      tooltips = [];
      sizes.forEach(function () {
        return tooltips.push({
          to: function to(value) {
            return value + self.getControlValue('unit');
          }
        });
      });
    }
    var sliderInstance = noUiSlider.create(this.ui.slider[0], {
      start: sizes,
      range: unitRange,
      step: step,
      tooltips: tooltips,
      connect: isMultiple,
      format: {
        to: function to(value) {
          return Math.round(value * 1000) / 1000;
        },
        from: function from(value) {
          return +value;
        }
      }
    });
    sliderInstance.on('slide', this.onSlideChange.bind(this));
  },
  applySavedValue: function applySavedValue() {
    ControlBaseUnitsItemView.prototype.applySavedValue.apply(this, arguments);
    // Slider does not exist in tests.
    if (this.isSliderInitialized()) {
      this.ui.slider[0].noUiSlider.set(this.getSize());
    }
  },
  isSliderInitialized: function isSliderInitialized() {
    return this.ui.slider[0] && this.ui.slider[0].noUiSlider;
  },
  getSize: function getSize() {
    var _this$getControlPlace, _this$model$get;
    var property = this.isMultiple() ? 'sizes' : 'size',
      value = this.getControlValue(property);
    return value || ((_this$getControlPlace = this.getControlPlaceholder()) === null || _this$getControlPlace === void 0 ? void 0 : _this$getControlPlace[property]) || ((_this$model$get = this.model.get('default')) === null || _this$model$get === void 0 ? void 0 : _this$model$get[property]);
  },
  resetSize: function resetSize() {
    if (this.isMultiple()) {
      this.setValue('sizes', {});
    } else {
      this.setValue('size', '');
    }
    this.initSlider();
  },
  destroySlider: function destroySlider() {
    // Slider does not exist in tests.
    if (this.ui.slider[0] && this.ui.slider[0].noUiSlider) {
      this.ui.slider[0].noUiSlider.destroy();
    }
  },
  onReady: function onReady() {
    if (this.isMultiple()) {
      this.$el.addClass('elementor-control-type-slider--multiple elementor-control-type-slider--handles-' + this.model.get('handles'));
    }
    this.initSlider();
  },
  onSlideChange: function onSlideChange(values, index) {
    if (this.isMultiple()) {
      var sizes = elementorCommon.helpers.cloneObject(this.getSize()),
        key = Object.keys(sizes)[index];
      sizes[key] = values[index];
      this.setValue('sizes', sizes);
    } else {
      this.setValue('size', values[0]);
      this.ui.input.val(values[0]);
    }
  },
  onInputChange: function onInputChange(event) {
    var dataChanged = event.currentTarget.dataset.setting;
    if ('size' === dataChanged && this.isSliderInitialized()) {
      this.ui.slider[0].noUiSlider.set(this.getSize());
    } else if ('unit' === dataChanged) {
      this.handleUnitChange();
    }
  },
  handleUnitChange: function handleUnitChange() {
    if (!this.isCustomUnit()) {
      this.resetSize();
    }
    this.maybeDoFractionToCustomConversions();
  },
  updateUnitChoices: function updateUnitChoices() {
    ControlBaseUnitsItemView.prototype.updateUnitChoices.apply(this, arguments);
    var inputType = 'number';
    if (this.isCustomUnit()) {
      inputType = 'text';
      this.destroySlider();
    } else {
      this.initSlider();
    }
    if (!this.isMultiple()) {
      this.ui.input.attr('type', inputType);
    }
  },
  maybeDoFractionToCustomConversions: function maybeDoFractionToCustomConversions() {
    var _this$getControlPlace2, _this$model$get2;
    if (this.isMultiple()) {
      return;
    }

    /*
    We want our code to run only when the user switched from 'fr' to 'custom'.
    But currently we do not have the previous state, so we won't know the user was previously on 'fr'.
    So we make the assumption that if the control only has two units ('fr' and 'custom'), and we
    are switching to custom now, then we can run our conversion logic.
    In future, we might want to investigate a way to build some kind of 'previous state cache' to know
    where we switched from.
    */
    var sizeUnits = this.model.get('size_units'),
      isFrToCustom = 2 === (sizeUnits === null || sizeUnits === void 0 ? void 0 : sizeUnits.length) && sizeUnits.includes('fr') && sizeUnits.includes('custom');
    if (!isFrToCustom) {
      return;
    }
    var currentSize = this.getSize(),
      alreadyConverted = 'string' === typeof currentSize && currentSize.includes('fr');
    if (alreadyConverted) {
      return;
    }
    var sizeValue = this.isCustomUnit() ? (0, _helpers.convertSizeToFrString)(currentSize) : ((_this$getControlPlace2 = this.getControlPlaceholder()) === null || _this$getControlPlace2 === void 0 ? void 0 : _this$getControlPlace2.size) || ((_this$model$get2 = this.model.get('default')) === null || _this$model$get2 === void 0 ? void 0 : _this$model$get2.size);
    this.setValue('size', sizeValue);
    this.render();
  },
  onBeforeDestroy: function onBeforeDestroy() {
    this.destroySlider();
    this.$el.remove();
  },
  onDeviceModeChange: function onDeviceModeChange() {
    var _this = this;
    var currentDeviceMode = elementor.channels.deviceMode.request('currentMode'),
      isMobile = 'mobile' === currentDeviceMode,
      isMobileValue = this.model.get('name').includes('_mobile'),
      hasDefault = this.model.get('default'),
      shouldRunConversion = isMobile && isMobileValue && hasDefault && this.isCustomUnit();
    if (shouldRunConversion) {
      setTimeout(function () {
        _this.maybeDoFractionToCustomConversions();
      });
    }
  }
});
module.exports = ControlSliderItemView;

/***/ }),

/***/ "../assets/dev/js/editor/controls/structure.js":
/*!*****************************************************!*\
  !*** ../assets/dev/js/editor/controls/structure.js ***!
  \*****************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var ControlBaseDataView = __webpack_require__(/*! elementor-controls/base-data */ "../assets/dev/js/editor/controls/base-data.js"),
  ControlStructureItemView;
ControlStructureItemView = ControlBaseDataView.extend({
  ui: function ui() {
    var ui = ControlBaseDataView.prototype.ui.apply(this, arguments);
    ui.resetStructure = '.elementor-control-structure-reset';
    return ui;
  },
  events: function events() {
    return _.extend(ControlBaseDataView.prototype.events.apply(this, arguments), {
      'click @ui.resetStructure': 'onResetStructureClick'
    });
  },
  templateHelpers: function templateHelpers() {
    var helpers = ControlBaseDataView.prototype.templateHelpers.apply(this, arguments);
    helpers.getMorePresets = this.getMorePresets.bind(this);
    return helpers;
  },
  getCurrentEditedSection: function getCurrentEditedSection() {
    var editor = elementor.getPanelView().getCurrentPageView();
    return editor.getOption('editedElementView');
  },
  getMorePresets: function getMorePresets() {
    var parsedStructure = elementor.presetsFactory.getParsedStructure(this.getControlValue());
    return elementor.presetsFactory.getPresets(parsedStructure.columnsCount);
  },
  onResetStructureClick: function onResetStructureClick() {
    this.getCurrentEditedSection().resetColumnsCustomSize();
  }
});
module.exports = ControlStructureItemView;

/***/ }),

/***/ "../assets/dev/js/editor/controls/switcher.js":
/*!****************************************************!*\
  !*** ../assets/dev/js/editor/controls/switcher.js ***!
  \****************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var ControlBaseDataView = __webpack_require__(/*! elementor-controls/base-data */ "../assets/dev/js/editor/controls/base-data.js");
module.exports = ControlBaseDataView.extend({
  setInputValue: function setInputValue(input, value) {
    this.$(input).prop('checked', this.model.get('return_value') === value);
  }
}, {
  onPasteStyle: function onPasteStyle(control, clipboardValue) {
    return !clipboardValue || clipboardValue === control.return_value;
  }
});

/***/ }),

/***/ "../assets/dev/js/editor/controls/tab.js":
/*!***********************************************!*\
  !*** ../assets/dev/js/editor/controls/tab.js ***!
  \***********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var ControlBaseView = __webpack_require__(/*! elementor-controls/base */ "../assets/dev/js/editor/controls/base.js"),
  ControlTabItemView;
ControlTabItemView = ControlBaseView.extend({
  triggers: {
    click: {
      event: 'control:tab:clicked',
      stopPropagation: false
    }
  }
});
module.exports = ControlTabItemView;

/***/ }),

/***/ "../assets/dev/js/editor/controls/url.js":
/*!***********************************************!*\
  !*** ../assets/dev/js/editor/controls/url.js ***!
  \***********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _get2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/get */ "../node_modules/@babel/runtime/helpers/get.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var BaseMultiple = __webpack_require__(/*! elementor-controls/base-multiple */ "../assets/dev/js/editor/controls/base-multiple.js");
var URL = /*#__PURE__*/function (_BaseMultiple) {
  (0, _inherits2.default)(URL, _BaseMultiple);
  var _super = _createSuper(URL);
  function URL() {
    (0, _classCallCheck2.default)(this, URL);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(URL, [{
    key: "ui",
    value: function ui() {
      var ui = (0, _get2.default)((0, _getPrototypeOf2.default)(URL.prototype), "ui", this).call(this);
      ui.mainInput = '.elementor-input';
      ui.moreOptionsToggle = '.elementor-control-url-more';
      ui.moreOptions = '.elementor-control-url-more-options';
      return ui;
    }
  }, {
    key: "events",
    value: function events() {
      var events = (0, _get2.default)((0, _getPrototypeOf2.default)(URL.prototype), "events", this).call(this);
      events['click @ui.moreOptionsToggle'] = 'onMoreOptionsToggleClick';
      return events;
    }
  }, {
    key: "autoComplete",
    value: function autoComplete() {
      var _this = this;
      var $mainInput = this.ui.mainInput,
        positionBase = elementorCommon.config.isRTL ? 'right' : 'left';
      var last, cache;

      // Based on /wp-includes/js/tinymce/plugins/wplink/plugin.js.
      $mainInput.autocomplete({
        source: function source(request, response) {
          if (!_this.options.model.attributes.autocomplete) {
            return;
          }
          if (last === request.term) {
            response(cache);
            return;
          }
          if (/^https?:/.test(request.term) || request.term.indexOf('.') !== -1) {
            return response();
          }

          // Show Spinner.
          $mainInput.prev().show();
          jQuery.post(window.ajaxurl, {
            editor: 'elementor',
            action: 'wp-link-ajax',
            page: 1,
            search: request.term,
            _ajax_linking_nonce: jQuery('#_ajax_linking_nonce').val()
          }, function (data) {
            cache = data;
            response(data);
          }, 'json').always(function () {
            return $mainInput.prev().hide();
          });
          last = request.term;
        },
        focus: function focus(event) {
          /*
           * Don't empty the URL input field, when using the arrow keys to
           * highlight items. See api.jqueryui.com/autocomplete/#event-focus
           */
          event.preventDefault();
        },
        select: function select(event, ui) {
          $mainInput.val(ui.item.permalink);
          _this.setValue('url', ui.item.permalink);
          return false;
        },
        open: function open(event) {
          jQuery(event.target).data('uiAutocomplete').menu.activeMenu.addClass('elementor-autocomplete-menu');
        },
        minLength: 2,
        position: {
          my: positionBase + ' top+2',
          at: positionBase + ' bottom'
        }
      });

      // The `_renderItem` cannot be override via the arguments.
      $mainInput.autocomplete('instance')._renderItem = function (ul, item) {
        var fallbackTitle = window.wpLinkL10n ? window.wpLinkL10n.noTitle : '',
          title = item.title ? item.title : fallbackTitle;
        return jQuery('<li role="option" id="mce-wp-autocomplete-' + item.ID + '">').append('<span>' + title + '</span>&nbsp;<span class="elementor-autocomplete-item-info">' + item.info + '</span>').appendTo(ul);
      };
    }
  }, {
    key: "onReady",
    value: function onReady() {
      this.autoComplete();
    }
  }, {
    key: "onMoreOptionsToggleClick",
    value: function onMoreOptionsToggleClick() {
      this.ui.moreOptions.slideToggle();
    }
  }, {
    key: "onBeforeDestroy",
    value: function onBeforeDestroy() {
      if (this.ui.mainInput.data('autocomplete')) {
        this.ui.mainInput.autocomplete('destroy');
      }
      this.$el.remove();
    }
  }]);
  return URL;
}(BaseMultiple);
module.exports = URL;

/***/ }),

/***/ "../assets/dev/js/editor/controls/wp_widget.js":
/*!*****************************************************!*\
  !*** ../assets/dev/js/editor/controls/wp_widget.js ***!
  \*****************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var ControlBaseDataView = __webpack_require__(/*! elementor-controls/base-data */ "../assets/dev/js/editor/controls/base-data.js"),
  ControlWPWidgetItemView;
ControlWPWidgetItemView = ControlBaseDataView.extend({
  ui: function ui() {
    var ui = ControlBaseDataView.prototype.ui.apply(this, arguments);
    ui.form = 'form';
    ui.loading = '.wp-widget-form-loading';
    return ui;
  },
  events: function events() {
    return {
      'keyup @ui.form :input': 'onFormChanged',
      'change @ui.form :input': 'onFormChanged'
    };
  },
  onFormChanged: function onFormChanged() {
    var idBase = 'widget-' + this.model.get('id_base'),
      settings = this.ui.form.elementorSerializeObject()[idBase].REPLACE_TO_ID;
    this.setValue(settings);
  },
  onReady: function onReady() {
    var self = this;
    elementorCommon.ajax.addRequest('editor_get_wp_widget_form', {
      data: {
        // Fake Widget ID
        id: self.model.cid,
        widget_type: self.model.get('widget'),
        data: self.container.settings.toJSON()
      },
      success: function success(data) {
        self.ui.form.html(data);
        // WP >= 4.8
        if (wp.textWidgets) {
          self.ui.form.addClass('open');
          var event = new jQuery.Event('widget-added');
          wp.textWidgets.handleWidgetAdded(event, self.ui.form);
          wp.mediaWidgets.handleWidgetAdded(event, self.ui.form);

          // WP >= 4.9
          if (wp.customHtmlWidgets) {
            wp.customHtmlWidgets.handleWidgetAdded(event, self.ui.form);
          }
        }
        var widgetType = self.model.get('widget');
        elementor.hooks.doAction("panel/widgets/".concat(widgetType, "/controls/wp_widget/loaded"), self);
      }
    });
  }
});
module.exports = ControlWPWidgetItemView;

/***/ }),

/***/ "../assets/dev/js/editor/controls/wysiwyg.js":
/*!***************************************************!*\
  !*** ../assets/dev/js/editor/controls/wysiwyg.js ***!
  \***************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var ControlBaseDataView = __webpack_require__(/*! elementor-controls/base-data */ "../assets/dev/js/editor/controls/base-data.js"),
  ControlWysiwygItemView;
ControlWysiwygItemView = ControlBaseDataView.extend({
  editor: null,
  ui: function ui() {
    var ui = ControlBaseDataView.prototype.ui.apply(this, arguments);
    jQuery.extend(ui, {
      inputWrapper: '.elementor-control-input-wrapper'
    });
    return ui;
  },
  events: function events() {
    return _.extend(ControlBaseDataView.prototype.events.apply(this, arguments), {
      'keyup textarea.elementor-wp-editor': 'onBaseInputChange'
    });
  },
  // List of buttons to move {buttonToMove: afterButton}
  buttons: {
    addToBasic: {
      underline: 'italic'
    },
    addToAdvanced: {},
    moveToAdvanced: {
      blockquote: 'removeformat',
      alignleft: 'blockquote',
      aligncenter: 'alignleft',
      alignright: 'aligncenter'
    },
    moveToBasic: {},
    removeFromBasic: ['unlink', 'wp_more'],
    removeFromAdvanced: []
  },
  initialize: function initialize() {
    ControlBaseDataView.prototype.initialize.apply(this, arguments);
    var self = this;
    self.editorID = 'elementorwpeditor' + self.cid;

    // Wait a cycle before initializing the editors.
    _.defer(function () {
      if (self.isDestroyed) {
        return;
      }

      // Initialize QuickTags, and set as the default mode.
      quicktags({
        buttons: 'strong,em,del,link,img,close',
        id: self.editorID
      });
      if (elementor.config.rich_editing_enabled) {
        switchEditors.go(self.editorID, 'tmce');
      }
      delete QTags.instances[0];
    });
    if (!elementor.config.rich_editing_enabled) {
      self.$el.addClass('elementor-rich-editing-disabled');
      return;
    }
    var editorConfig = {
      id: self.editorID,
      selector: '#' + self.editorID,
      setup: function setup(editor) {
        self.editor = editor;
      }
    };
    tinyMCEPreInit.mceInit[self.editorID] = _.extend(_.clone(tinyMCEPreInit.mceInit.elementorwpeditor), editorConfig);
    if (!elementor.config.tinymceHasCustomConfig) {
      self.rearrangeButtons();
    }
  },
  applySavedValue: function applySavedValue() {
    if (!this.editor) {
      return;
    }
    var controlValue = this.getControlValue();
    this.editor.setContent(controlValue);

    // Update also the plain textarea
    jQuery('#' + this.editorID).val(controlValue);
  },
  saveEditor: function saveEditor() {
    this.setValue(this.editor.getContent());
  },
  moveButtons: function moveButtons(buttonsToMove, from, to) {
    if (!to) {
      to = from;
      from = null;
    }
    _.each(buttonsToMove, function (afterButton, button) {
      var afterButtonIndex = to.indexOf(afterButton);
      if (from) {
        var buttonIndex = from.indexOf(button);
        if (-1 === buttonIndex) {
          throw new ReferenceError('Trying to move non-existing button `' + button + '`');
        }
        from.splice(buttonIndex, 1);
      }
      if (-1 === afterButtonIndex) {
        throw new ReferenceError('Trying to move button after non-existing button `' + afterButton + '`');
      }
      to.splice(afterButtonIndex + 1, 0, button);
    });
  },
  rearrangeButtons: function rearrangeButtons() {
    var editorProps = tinyMCEPreInit.mceInit[this.editorID],
      editorBasicToolbarButtons = editorProps.toolbar1.split(','),
      editorAdvancedToolbarButtons = editorProps.toolbar2.split(',');
    editorBasicToolbarButtons = _.difference(editorBasicToolbarButtons, this.buttons.removeFromBasic);
    editorAdvancedToolbarButtons = _.difference(editorAdvancedToolbarButtons, this.buttons.removeFromAdvanced);
    this.moveButtons(this.buttons.moveToBasic, editorAdvancedToolbarButtons, editorBasicToolbarButtons);
    this.moveButtons(this.buttons.moveToAdvanced, editorBasicToolbarButtons, editorAdvancedToolbarButtons);
    this.moveButtons(this.buttons.addToBasic, editorBasicToolbarButtons);
    this.moveButtons(this.buttons.addToAdvanced, editorAdvancedToolbarButtons);
    editorProps.toolbar1 = editorBasicToolbarButtons.join(',');
    editorProps.toolbar2 = editorAdvancedToolbarButtons.join(',');
  },
  onReady: function onReady() {
    var _this = this;
    var $editor = jQuery(elementor.config.wp_editor.replace(/elementorwpeditor/g, this.editorID).replace('%%EDITORCONTENT%%', ''));
    $editor.find('.wp-editor-area').text(this.getControlValue());
    $editor.find(".wp-editor-tabs").addClass('elementor-control-dynamic-switcher-wrapper');
    this.ui.inputWrapper.html($editor);
    setTimeout(function () {
      if (!_this.isDestroyed && _this.editor) {
        _this.editor.on('keyup change undo redo', _this.saveEditor.bind(_this));
      }
    }, 100);
  },
  onBeforeDestroy: function onBeforeDestroy() {
    // Remove TinyMCE and QuickTags instances
    delete QTags.instances[this.editorID];
    if (!elementor.config.rich_editing_enabled) {
      return;
    }
    tinymce.EditorManager.execCommand('mceRemoveEditor', true, this.editorID);

    // Cleanup PreInit data
    delete tinyMCEPreInit.mceInit[this.editorID];
    delete tinyMCEPreInit.qtInit[this.editorID];
  }
});
module.exports = ControlWysiwygItemView;

/***/ }),

/***/ "../assets/dev/js/editor/data/globals/base/create-base.js":
/*!****************************************************************!*\
  !*** ../assets/dev/js/editor/data/globals/base/create-base.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var CreateBase = /*#__PURE__*/function (_$e$modules$editor$Co) {
  (0, _inherits2.default)(CreateBase, _$e$modules$editor$Co);
  var _super = _createSuper(CreateBase);
  function CreateBase() {
    (0, _classCallCheck2.default)(this, CreateBase);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(CreateBase, [{
    key: "validateArgs",
    value: function validateArgs() {
      var args = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      this.requireContainer(args);
      this.requireArgumentType('setting', 'string', args);
      this.requireArgumentType('title', 'string', args);
    }
  }]);
  return CreateBase;
}($e.modules.editor.CommandContainerBase);
exports["default"] = CreateBase;

/***/ }),

/***/ "../assets/dev/js/editor/data/globals/colors/commands/create.js":
/*!**********************************************************************!*\
  !*** ../assets/dev/js/editor/data/globals/colors/commands/create.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Create = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _createBase = _interopRequireDefault(__webpack_require__(/*! elementor-editor/data/globals/base/create-base */ "../assets/dev/js/editor/data/globals/base/create-base.js"));
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var Create = /*#__PURE__*/function (_CreateBase) {
  (0, _inherits2.default)(Create, _CreateBase);
  var _super = _createSuper(Create);
  function Create() {
    (0, _classCallCheck2.default)(this, Create);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(Create, [{
    key: "apply",
    value: function apply() {
      var args = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var container = args.container,
        setting = args.setting,
        title = args.title,
        controls = container.controls;
      var result = false;
      if (!controls[setting]) {
        throw new Error("Invalid setting: control '".concat(setting, "', not found."));
      }

      // `args.id` used by tests.
      var id = args.id || elementorCommon.helpers.getUniqueId();
      result = $e.data.create("globals/colors?id=".concat(id), {
        title: title,
        value: container.settings.get(setting)
      });
      return result;
    }
  }]);
  return Create;
}(_createBase.default);
exports.Create = Create;

/***/ }),

/***/ "../assets/dev/js/editor/data/globals/colors/commands/index.js":
/*!*********************************************************************!*\
  !*** ../assets/dev/js/editor/data/globals/colors/commands/index.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
Object.defineProperty(exports, "Create", ({
  enumerable: true,
  get: function get() {
    return _create.Create;
  }
}));
var _create = __webpack_require__(/*! ./create */ "../assets/dev/js/editor/data/globals/colors/commands/create.js");

/***/ }),

/***/ "../assets/dev/js/editor/data/globals/colors/component.js":
/*!****************************************************************!*\
  !*** ../assets/dev/js/editor/data/globals/colors/component.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _componentBase = _interopRequireDefault(__webpack_require__(/*! elementor-api/modules/component-base */ "../modules/web-cli/assets/js/modules/component-base.js"));
var commands = _interopRequireWildcard(__webpack_require__(/*! ./commands/ */ "../assets/dev/js/editor/data/globals/colors/commands/index.js"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var Component = /*#__PURE__*/function (_ComponentBase) {
  (0, _inherits2.default)(Component, _ComponentBase);
  var _super = _createSuper(Component);
  function Component() {
    (0, _classCallCheck2.default)(this, Component);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(Component, [{
    key: "getNamespace",
    value: function getNamespace() {
      return 'globals/colors';
    }
  }, {
    key: "defaultCommands",
    value: function defaultCommands() {
      return this.importCommands(commands);
    }
  }]);
  return Component;
}(_componentBase.default);
exports["default"] = Component;

/***/ }),

/***/ "../assets/dev/js/editor/data/globals/commands/data/colors.js":
/*!********************************************************************!*\
  !*** ../assets/dev/js/editor/data/globals/commands/data/colors.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.Colors = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var Colors = /*#__PURE__*/function (_$e$modules$CommandDa) {
  (0, _inherits2.default)(Colors, _$e$modules$CommandDa);
  var _super = _createSuper(Colors);
  function Colors() {
    (0, _classCallCheck2.default)(this, Colors);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(Colors, null, [{
    key: "getEndpointFormat",
    value: function getEndpointFormat() {
      return 'globals/colors/{id}';
    }
  }]);
  return Colors;
}($e.modules.CommandData);
exports.Colors = Colors;
var _default = Colors;
exports["default"] = _default;

/***/ }),

/***/ "../assets/dev/js/editor/data/globals/commands/data/index.js":
/*!*******************************************************************!*\
  !*** ../assets/dev/js/editor/data/globals/commands/data/index.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
Object.defineProperty(exports, "Colors", ({
  enumerable: true,
  get: function get() {
    return _colors.Colors;
  }
}));
exports.Index = void 0;
Object.defineProperty(exports, "Typography", ({
  enumerable: true,
  get: function get() {
    return _typography.Typography;
  }
}));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _colors = __webpack_require__(/*! ./colors */ "../assets/dev/js/editor/data/globals/commands/data/colors.js");
var _typography = __webpack_require__(/*! ./typography */ "../assets/dev/js/editor/data/globals/commands/data/typography.js");
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } } // Alphabetical order
// TODO: Remove - Move to into base, Possible to handle using ComponentData.
var Index = /*#__PURE__*/function (_$e$modules$CommandDa) {
  (0, _inherits2.default)(Index, _$e$modules$CommandDa);
  var _super = _createSuper(Index);
  function Index() {
    (0, _classCallCheck2.default)(this, Index);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(Index, null, [{
    key: "getEndpointFormat",
    value: function getEndpointFormat() {
      // Format 'globals/index' to 'globals'.
      return 'globals';
    }
  }]);
  return Index;
}($e.modules.CommandData);
exports.Index = Index;

/***/ }),

/***/ "../assets/dev/js/editor/data/globals/commands/data/typography.js":
/*!************************************************************************!*\
  !*** ../assets/dev/js/editor/data/globals/commands/data/typography.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.Typography = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var Typography = /*#__PURE__*/function (_$e$modules$CommandDa) {
  (0, _inherits2.default)(Typography, _$e$modules$CommandDa);
  var _super = _createSuper(Typography);
  function Typography() {
    (0, _classCallCheck2.default)(this, Typography);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(Typography, null, [{
    key: "getEndpointFormat",
    value: function getEndpointFormat() {
      return 'globals/typography/{id}';
    }
  }]);
  return Typography;
}($e.modules.CommandData);
exports.Typography = Typography;
var _default = Typography;
exports["default"] = _default;

/***/ }),

/***/ "../assets/dev/js/editor/data/globals/component.js":
/*!*********************************************************!*\
  !*** ../assets/dev/js/editor/data/globals/component.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _get2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/get */ "../node_modules/@babel/runtime/helpers/get.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _componentBase = _interopRequireDefault(__webpack_require__(/*! elementor-api/modules/component-base */ "../modules/web-cli/assets/js/modules/component-base.js"));
var _component = _interopRequireDefault(__webpack_require__(/*! ./typography/component */ "../assets/dev/js/editor/data/globals/typography/component.js"));
var _component2 = _interopRequireDefault(__webpack_require__(/*! ./colors/component */ "../assets/dev/js/editor/data/globals/colors/component.js"));
var commandsData = _interopRequireWildcard(__webpack_require__(/*! ./commands/data/ */ "../assets/dev/js/editor/data/globals/commands/data/index.js"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var Component = /*#__PURE__*/function (_ComponentBase) {
  (0, _inherits2.default)(Component, _ComponentBase);
  var _super = _createSuper(Component);
  function Component() {
    (0, _classCallCheck2.default)(this, Component);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(Component, [{
    key: "__construct",
    value: function __construct() {
      var _this = this;
      var args = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      (0, _get2.default)((0, _getPrototypeOf2.default)(Component.prototype), "__construct", this).call(this, args);
      elementorCommon.elements.$window.on('elementor:loaded', function () {
        return _this.refreshGlobalData();
      });
    }
  }, {
    key: "getNamespace",
    value: function getNamespace() {
      return 'globals';
    }
  }, {
    key: "registerAPI",
    value: function registerAPI() {
      $e.components.register(new _component.default({
        manager: this
      }));
      $e.components.register(new _component2.default({
        manager: this
      }));
      (0, _get2.default)((0, _getPrototypeOf2.default)(Component.prototype), "registerAPI", this).call(this);
    }
  }, {
    key: "defaultData",
    value: function defaultData() {
      return this.importCommands(commandsData);
    }
  }, {
    key: "refreshGlobalData",
    value: function refreshGlobalData() {
      $e.data.deleteCache($e.components.get('globals'), 'globals/index');
    }
  }]);
  return Component;
}(_componentBase.default);
exports["default"] = Component;

/***/ }),

/***/ "../assets/dev/js/editor/data/globals/typography/commands/create.js":
/*!**************************************************************************!*\
  !*** ../assets/dev/js/editor/data/globals/typography/commands/create.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Create = void 0;
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "../node_modules/@babel/runtime/helpers/slicedToArray.js"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _createBase = _interopRequireDefault(__webpack_require__(/*! elementor-editor/data/globals/base/create-base */ "../assets/dev/js/editor/data/globals/base/create-base.js"));
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var Create = /*#__PURE__*/function (_CreateBase) {
  (0, _inherits2.default)(Create, _CreateBase);
  var _super = _createSuper(Create);
  function Create() {
    (0, _classCallCheck2.default)(this, Create);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(Create, [{
    key: "apply",
    value: function apply() {
      var args = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var container = args.container,
        setting = args.setting,
        title = args.title,
        controls = container.controls,
        availableControls = {};
      var result = false,
        groupPrefix = '';
      if (controls[setting] && controls[setting].groupPrefix) {
        groupPrefix = controls[setting].groupPrefix;
      } else {
        throw new Error("Invalid setting: control '".concat(setting, "', not found."));
      }
      if (groupPrefix) {
        Object.entries(controls).forEach(function (_ref) {
          var _ref2 = (0, _slicedToArray2.default)(_ref, 1),
            key = _ref2[0];
          if (key.includes(groupPrefix)) {
            // Get values but remove defaults.
            var value = container.settings.get(key),
              defaultValue = container.controls[key].default;
            if (!_.isEqual(value, defaultValue)) {
              availableControls[key.replace(groupPrefix, elementor.config.kit_config.typography_prefix)] = container.settings.get(key);
            }
          }
        });
      }
      if (Object.values(availableControls).length) {
        var id = elementorCommon.helpers.getUniqueId();
        result = $e.data.create("globals/typography?id=".concat(id), {
          title: title,
          value: availableControls
        });
      }
      return result;
    }
  }]);
  return Create;
}(_createBase.default);
exports.Create = Create;

/***/ }),

/***/ "../assets/dev/js/editor/data/globals/typography/commands/index.js":
/*!*************************************************************************!*\
  !*** ../assets/dev/js/editor/data/globals/typography/commands/index.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
Object.defineProperty(exports, "Create", ({
  enumerable: true,
  get: function get() {
    return _create.Create;
  }
}));
var _create = __webpack_require__(/*! ./create */ "../assets/dev/js/editor/data/globals/typography/commands/create.js");

/***/ }),

/***/ "../assets/dev/js/editor/data/globals/typography/component.js":
/*!********************************************************************!*\
  !*** ../assets/dev/js/editor/data/globals/typography/component.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _get2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/get */ "../node_modules/@babel/runtime/helpers/get.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _componentBase = _interopRequireDefault(__webpack_require__(/*! elementor-api/modules/component-base */ "../modules/web-cli/assets/js/modules/component-base.js"));
var commands = _interopRequireWildcard(__webpack_require__(/*! ./commands/ */ "../assets/dev/js/editor/data/globals/typography/commands/index.js"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var Component = /*#__PURE__*/function (_ComponentBase) {
  (0, _inherits2.default)(Component, _ComponentBase);
  var _super = _createSuper(Component);
  function Component() {
    (0, _classCallCheck2.default)(this, Component);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(Component, [{
    key: "__construct",
    value: function __construct() {
      var args = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      (0, _get2.default)((0, _getPrototypeOf2.default)(Component.prototype), "__construct", this).call(this, args);
    }
  }, {
    key: "getNamespace",
    value: function getNamespace() {
      return 'globals/typography';
    }
  }, {
    key: "defaultCommands",
    value: function defaultCommands() {
      return this.importCommands(commands);
    }
  }]);
  return Component;
}(_componentBase.default);
exports["default"] = Component;

/***/ }),

/***/ "../assets/dev/js/editor/document/command-bases/command-disable-enable.js":
/*!********************************************************************************!*\
  !*** ../assets/dev/js/editor/document/command-bases/command-disable-enable.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _get2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/get */ "../node_modules/@babel/runtime/helpers/get.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _commandHistoryBase = _interopRequireDefault(__webpack_require__(/*! ./command-history-base */ "../assets/dev/js/editor/document/command-bases/command-history-base.js"));
var _settings = _interopRequireDefault(__webpack_require__(/*! elementor-document/elements/commands/settings */ "../assets/dev/js/editor/document/elements/commands/settings.js"));
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
/**
 * The class serve as base for commands who needs the 'enable/disable' behavior.
 */
var CommandDisableEnable = /*#__PURE__*/function (_CommandHistoryBase) {
  (0, _inherits2.default)(CommandDisableEnable, _CommandHistoryBase);
  var _super = _createSuper(CommandDisableEnable);
  function CommandDisableEnable() {
    (0, _classCallCheck2.default)(this, CommandDisableEnable);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(CommandDisableEnable, [{
    key: "initialize",
    value: function initialize(args) {
      /**
       * Which command is running.
       *
       * @type {string}
       */
      this.type = this.command === this.constructor.getEnableCommand() ? 'enable' : 'disable';

      // Override default logic, since getHistory() depends on `this.type`.
      (0, _get2.default)((0, _getPrototypeOf2.default)(CommandDisableEnable.prototype), "initialize", this).call(this, args);
    }
  }, {
    key: "validateArgs",
    value: function validateArgs(args) {
      this.requireContainer(args);
      this.requireArgumentConstructor('settings', Object, args);
    }
  }, {
    key: "getHistory",
    value: function getHistory(args) {
      var settings = args.settings,
        _args$containers = args.containers,
        containers = _args$containers === void 0 ? [args.container] : _args$containers,
        changes = {};
      containers.forEach(function (container) {
        var id = container.id;
        if (!changes[id]) {
          changes[id] = {};
        }
        changes[id] = settings;
      });
      var subTitle = elementor.translate(this.constructor.getName()) + ' ' + _settings.default.getSubTitle(args),
        type = this.type;
      return {
        containers: containers,
        subTitle: subTitle,
        data: {
          changes: changes,
          command: this.command
        },
        type: type,
        restore: this.constructor.restore
      };
    }
  }], [{
    key: "getName",
    value: function getName() {
      elementorModules.ForceMethodImplementation();
    }

    // eslint-disable-next-line jsdoc/require-returns-check
    /**
     * @return {string} Full enable command.
     */
  }, {
    key: "getEnableCommand",
    value: function getEnableCommand() {
      elementorModules.ForceMethodImplementation();
    }

    // eslint-disable-next-line jsdoc/require-returns-check
    /**
     * @return {string} Full disable command.
     */
  }, {
    key: "getDisableCommand",
    value: function getDisableCommand() {
      elementorModules.ForceMethodImplementation();
    }
  }, {
    key: "restore",
    value: function restore(historyItem, isRedo) {
      var data = historyItem.get('data'),
        CommandClass = $e.commands.getCommandClass(data.command);

      // Upon `disable` command toggle `isRedo`.
      if (CommandClass.getDisableCommand() === data.command) {
        isRedo = !isRedo;
      }
      historyItem.get('containers').forEach(function (container) {
        var settings = data.changes[container.id],
          toggle = isRedo ? CommandClass.getEnableCommand() : CommandClass.getDisableCommand();
        $e.run(toggle, {
          container: container,
          settings: settings
        });
        container.panel.refresh();
      });
    }
  }]);
  return CommandDisableEnable;
}(_commandHistoryBase.default);
exports["default"] = CommandDisableEnable;

/***/ }),

/***/ "../assets/dev/js/editor/document/command-bases/command-history-base.js":
/*!******************************************************************************!*\
  !*** ../assets/dev/js/editor/document/command-bases/command-history-base.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _get2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/get */ "../node_modules/@babel/runtime/helpers/get.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _commandContainerBase = _interopRequireDefault(__webpack_require__(/*! elementor-editor/command-bases/command-container-base */ "../assets/dev/js/editor/command-bases/command-container-base.js"));
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
/**
 * @name $e.modules.editor.document.CommandHistoryBase
 */
var CommandHistoryBase = /*#__PURE__*/function (_CommandContainerBase) {
  (0, _inherits2.default)(CommandHistoryBase, _CommandContainerBase);
  var _super = _createSuper(CommandHistoryBase);
  function CommandHistoryBase() {
    (0, _classCallCheck2.default)(this, CommandHistoryBase);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(CommandHistoryBase, [{
    key: "initialize",
    value: function initialize() {
      var args = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var _args$options = args.options,
        options = _args$options === void 0 ? {} : _args$options,
        _options$useHistory = options.useHistory,
        useHistory = _options$useHistory === void 0 ? true : _options$useHistory;
      if (useHistory) {
        /**
         * Get History from child command.
         *
         * @type {{}|boolean}
         */
        this.history = this.getHistory(args);

        /**
         * @type {number|boolean}
         */
        this.historyId = false;
      }
    }

    // eslint-disable-next-line jsdoc/require-returns-check
    /**
     * Function getHistory().
     *
     * Get history object from child, do nothing if it false.
     *
     * @param {*} [args={}]
     *
     * @return {({}|boolean)} history object
     */
  }, {
    key: "getHistory",
    value: function getHistory() {
      var args = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      // eslint-disable-line no-unused-vars
      elementorModules.ForceMethodImplementation();
    }

    /**
     * Function isHistoryActive().
     *
     * Return `elementor.documents.getCurrent().history.getActive()`.
     *
     * @return {boolean} is history active
     */
  }, {
    key: "isHistoryActive",
    value: function isHistoryActive() {
      return elementor.documents.getCurrent().history.getActive();
    }
  }, {
    key: "onBeforeRun",
    value: function onBeforeRun(args) {
      (0, _get2.default)((0, _getPrototypeOf2.default)(CommandHistoryBase.prototype), "onBeforeRun", this).call(this, args);
      if (this.history && this.isHistoryActive()) {
        this.historyId = $e.internal('document/history/start-log', this.history);
      }
    }
  }, {
    key: "onAfterRun",
    value: function onAfterRun(args, result) {
      (0, _get2.default)((0, _getPrototypeOf2.default)(CommandHistoryBase.prototype), "onAfterRun", this).call(this, args, result);
      if (this.history && this.isHistoryActive()) {
        $e.internal('document/history/end-log', {
          id: this.historyId
        });
      }
    }
  }, {
    key: "onAfterApply",
    value: function onAfterApply() {
      var args = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var result = arguments.length > 1 ? arguments[1] : undefined;
      (0, _get2.default)((0, _getPrototypeOf2.default)(CommandHistoryBase.prototype), "onAfterApply", this).call(this, args, result);
      if (this.isDataChanged()) {
        $e.internal('document/save/set-is-modified', {
          status: true
        });
      }
    }
  }, {
    key: "onCatchApply",
    value: function onCatchApply(e) {
      // Rollback history on failure.
      if (e instanceof $e.modules.HookBreak && this.historyId) {
        $e.internal('document/history/delete-log', {
          id: this.historyId
        });
      }
      (0, _get2.default)((0, _getPrototypeOf2.default)(CommandHistoryBase.prototype), "onCatchApply", this).call(this, e);
    }
  }, {
    key: "isDataChanged",
    value: function isDataChanged() {
      // All the commands who use history are commands that changing the data.
      return true;
    }
  }], [{
    key: "getInstanceType",
    value: function getInstanceType() {
      return 'CommandHistoryBase';
    }
  }]);
  return CommandHistoryBase;
}(_commandContainerBase.default);
exports["default"] = CommandHistoryBase;

/***/ }),

/***/ "../assets/dev/js/editor/document/component.js":
/*!*****************************************************!*\
  !*** ../assets/dev/js/editor/document/component.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _get2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/get */ "../node_modules/@babel/runtime/helpers/get.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _componentBase = _interopRequireDefault(__webpack_require__(/*! elementor-api/modules/component-base */ "../modules/web-cli/assets/js/modules/component-base.js"));
var components = _interopRequireWildcard(__webpack_require__(/*! ./ */ "../assets/dev/js/editor/document/index.js"));
var hooks = _interopRequireWildcard(__webpack_require__(/*! ./hooks/ */ "../assets/dev/js/editor/document/hooks/index.js"));
var uiStates = _interopRequireWildcard(__webpack_require__(/*! ./ui-states */ "../assets/dev/js/editor/document/ui-states/index.js"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var Component = /*#__PURE__*/function (_ComponentBase) {
  (0, _inherits2.default)(Component, _ComponentBase);
  var _super = _createSuper(Component);
  function Component() {
    (0, _classCallCheck2.default)(this, Component);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(Component, [{
    key: "getNamespace",
    value: function getNamespace() {
      return 'document';
    }
  }, {
    key: "registerAPI",
    value: function registerAPI() {
      Object.values(components).forEach(function (ComponentClass) {
        return $e.components.register(new ComponentClass());
      });
      (0, _get2.default)((0, _getPrototypeOf2.default)(Component.prototype), "registerAPI", this).call(this);
    }
  }, {
    key: "defaultCommands",
    value: function defaultCommands() {
      return {
        // Example: ( args ) => ( new Commands.Example( args ).run() ),
      };
    }
  }, {
    key: "defaultHooks",
    value: function defaultHooks() {
      return this.importHooks(hooks);
    }
  }, {
    key: "defaultUiStates",
    value: function defaultUiStates() {
      return this.importUiStates(uiStates);
    }
  }, {
    key: "defaultUtils",
    value: function defaultUtils() {
      var _this = this;
      return {
        findViewRecursive: function findViewRecursive(parent, key, value) {
          var multiple = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : true;
          var found = [];
          for (var x in parent._views) {
            var view = parent._views[x];
            if (value === view.model.get(key)) {
              found.push(view);
              if (!multiple) {
                return found;
              }
            }
            if (view.children) {
              var views = _this.utils.findViewRecursive(view.children, key, value, multiple);
              if (views.length) {
                found = found.concat(views);
                if (!multiple) {
                  return found;
                }
              }
            }
          }
          return found;
        },
        findViewById: function findViewById(id) {
          var elements = _this.utils.findViewRecursive(elementor.getPreviewView().children, 'id', id, false);
          return elements ? elements[0] : false;
        },
        findContainerById: function findContainerById(id) {
          var result = _this.utils.findViewById(id);
          if (result) {
            result = result.getContainer();
          }
          return result;
        }
      };
    }
  }]);
  return Component;
}(_componentBase.default);
exports["default"] = Component;

/***/ }),

/***/ "../assets/dev/js/editor/document/dynamic/commands/base/disable-enable.js":
/*!********************************************************************************!*\
  !*** ../assets/dev/js/editor/document/dynamic/commands/base/disable-enable.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var __ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["__"];


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _commandDisableEnable = _interopRequireDefault(__webpack_require__(/*! elementor-document/command-bases/command-disable-enable */ "../assets/dev/js/editor/document/command-bases/command-disable-enable.js"));
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var DisableEnable = /*#__PURE__*/function (_CommandDisableEnable) {
  (0, _inherits2.default)(DisableEnable, _CommandDisableEnable);
  var _super = _createSuper(DisableEnable);
  function DisableEnable() {
    (0, _classCallCheck2.default)(this, DisableEnable);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(DisableEnable, [{
    key: "getTitle",
    value: function getTitle() {
      return __('Dynamic');
    }
  }], [{
    key: "getName",
    value: function getName() {
      return 'Dynamic';
    }
  }, {
    key: "getEnableCommand",
    value: function getEnableCommand() {
      return 'document/dynamic/enable';
    }
  }, {
    key: "getDisableCommand",
    value: function getDisableCommand() {
      return 'document/dynamic/disable';
    }
  }]);
  return DisableEnable;
}(_commandDisableEnable.default);
exports["default"] = DisableEnable;

/***/ }),

/***/ "../assets/dev/js/editor/document/dynamic/commands/disable.js":
/*!********************************************************************!*\
  !*** ../assets/dev/js/editor/document/dynamic/commands/disable.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.Disable = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _disableEnable = _interopRequireDefault(__webpack_require__(/*! ./base/disable-enable */ "../assets/dev/js/editor/document/dynamic/commands/base/disable-enable.js"));
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var Disable = /*#__PURE__*/function (_DisableEnable) {
  (0, _inherits2.default)(Disable, _DisableEnable);
  var _super = _createSuper(Disable);
  function Disable() {
    (0, _classCallCheck2.default)(this, Disable);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(Disable, [{
    key: "apply",
    value: function apply(args) {
      var settings = args.settings,
        _args$containers = args.containers,
        containers = _args$containers === void 0 ? [args.container] : _args$containers;
      containers.forEach(function (container) {
        container = container.lookup();
        Object.keys(settings).forEach(function (setting) {
          container.dynamic.unset(setting);
        });
        $e.internal('document/elements/set-settings', {
          container: container,
          settings: {
            __dynamic__: container.dynamic.toJSON()
          }
        });
      });
    }
  }]);
  return Disable;
}(_disableEnable.default);
exports.Disable = Disable;
var _default = Disable;
exports["default"] = _default;

/***/ }),

/***/ "../assets/dev/js/editor/document/dynamic/commands/enable.js":
/*!*******************************************************************!*\
  !*** ../assets/dev/js/editor/document/dynamic/commands/enable.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.Enable = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _disableEnable = _interopRequireDefault(__webpack_require__(/*! ./base/disable-enable */ "../assets/dev/js/editor/document/dynamic/commands/base/disable-enable.js"));
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var Enable = /*#__PURE__*/function (_DisableEnable) {
  (0, _inherits2.default)(Enable, _DisableEnable);
  var _super = _createSuper(Enable);
  function Enable() {
    (0, _classCallCheck2.default)(this, Enable);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(Enable, [{
    key: "apply",
    value: function apply(args) {
      var settings = args.settings,
        _args$containers = args.containers,
        containers = _args$containers === void 0 ? [args.container] : _args$containers;
      containers.forEach(function (container) {
        container = container.lookup();
        container.dynamic.set(settings);
        $e.internal('document/elements/set-settings', {
          container: container,
          settings: {
            __dynamic__: container.dynamic.toJSON()
          }
        });
      });
    }
  }]);
  return Enable;
}(_disableEnable.default);
exports.Enable = Enable;
var _default = Enable;
exports["default"] = _default;

/***/ }),

/***/ "../assets/dev/js/editor/document/dynamic/commands/index.js":
/*!******************************************************************!*\
  !*** ../assets/dev/js/editor/document/dynamic/commands/index.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
Object.defineProperty(exports, "Disable", ({
  enumerable: true,
  get: function get() {
    return _disable.Disable;
  }
}));
Object.defineProperty(exports, "Enable", ({
  enumerable: true,
  get: function get() {
    return _enable.Enable;
  }
}));
Object.defineProperty(exports, "Settings", ({
  enumerable: true,
  get: function get() {
    return _settings.Settings;
  }
}));
var _disable = __webpack_require__(/*! ./disable */ "../assets/dev/js/editor/document/dynamic/commands/disable.js");
var _enable = __webpack_require__(/*! ./enable */ "../assets/dev/js/editor/document/dynamic/commands/enable.js");
var _settings = __webpack_require__(/*! ./settings */ "../assets/dev/js/editor/document/dynamic/commands/settings.js");

/***/ }),

/***/ "../assets/dev/js/editor/document/dynamic/commands/settings.js":
/*!*********************************************************************!*\
  !*** ../assets/dev/js/editor/document/dynamic/commands/settings.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.Settings = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _settings = _interopRequireDefault(__webpack_require__(/*! elementor-document/elements/commands/settings */ "../assets/dev/js/editor/document/elements/commands/settings.js"));
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
/**
 * The difference between 'document/elements/settings` and `document/dynamic/settings` is:
 * that `document/elements/settings` apply settings to `container.settings` and `document/dynamic/settings` affect
 * `container.settings.__dynamic__`, also clearing the dynamic if `args.settings` is empty.
 */
var Settings = /*#__PURE__*/function (_$e$modules$editor$do) {
  (0, _inherits2.default)(Settings, _$e$modules$editor$do);
  var _super = _createSuper(Settings);
  function Settings() {
    (0, _classCallCheck2.default)(this, Settings);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(Settings, [{
    key: "validateArgs",
    value: function validateArgs(args) {
      this.requireContainer(args);
      this.requireArgumentConstructor('settings', Object, args);
    }
  }, {
    key: "getHistory",
    value: function getHistory(args) {
      var settings = args.settings,
        _args$containers = args.containers,
        containers = _args$containers === void 0 ? [args.container] : _args$containers,
        changes = {};
      containers.forEach(function (container) {
        var id = container.id;
        if (!changes[id]) {
          changes[id] = {};
        }
        changes[id] = {
          old: container.dynamic.toJSON(),
          new: settings
        };
      });
      var subTitle = _settings.default.getSubTitle(args);
      return {
        containers: containers,
        subTitle: subTitle,
        data: {
          changes: changes
        },
        type: 'change',
        restore: this.constructor.restore
      };
    }
  }, {
    key: "apply",
    value: function apply(args) {
      var settings = args.settings,
        _args$containers2 = args.containers,
        containers = _args$containers2 === void 0 ? [args.container] : _args$containers2;
      containers.forEach(function (container) {
        container = container.lookup();
        if (!Object.keys(settings).length) {
          container.dynamic.clear();
        } else {
          container.dynamic.set(settings);
        }
        $e.internal('document/elements/set-settings', {
          container: container,
          settings: {
            __dynamic__: container.dynamic.toJSON()
          }
        });
      });
    }
  }], [{
    key: "restore",
    value: function restore(historyItem, isRedo) {
      var data = historyItem.get('data');
      historyItem.get('containers').forEach(function (container) {
        var changes = data.changes[container.id];
        $e.run('document/dynamic/settings', {
          container: container,
          settings: isRedo ? changes.new : changes.old
        });
        container.panel.refresh();
      });
    }
  }]);
  return Settings;
}($e.modules.editor.document.CommandHistoryDebounceBase);
exports.Settings = Settings;
var _default = Settings;
exports["default"] = _default;

/***/ }),

/***/ "../assets/dev/js/editor/document/dynamic/component.js":
/*!*************************************************************!*\
  !*** ../assets/dev/js/editor/document/dynamic/component.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _componentBase = _interopRequireDefault(__webpack_require__(/*! elementor-api/modules/component-base */ "../modules/web-cli/assets/js/modules/component-base.js"));
var commands = _interopRequireWildcard(__webpack_require__(/*! ./commands/ */ "../assets/dev/js/editor/document/dynamic/commands/index.js"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var Component = /*#__PURE__*/function (_ComponentBase) {
  (0, _inherits2.default)(Component, _ComponentBase);
  var _super = _createSuper(Component);
  function Component() {
    (0, _classCallCheck2.default)(this, Component);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(Component, [{
    key: "getNamespace",
    value: function getNamespace() {
      return 'document/dynamic';
    }
  }, {
    key: "defaultCommands",
    value: function defaultCommands() {
      return this.importCommands(commands);
    }
  }]);
  return Component;
}(_componentBase.default);
exports["default"] = Component;

/***/ }),

/***/ "../assets/dev/js/editor/document/elements/commands-internal/index.js":
/*!****************************************************************************!*\
  !*** ../assets/dev/js/editor/document/elements/commands-internal/index.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
Object.defineProperty(exports, "SetSettings", ({
  enumerable: true,
  get: function get() {
    return _setSettings.SetSettings;
  }
}));
var _setSettings = __webpack_require__(/*! ./set-settings */ "../assets/dev/js/editor/document/elements/commands-internal/set-settings.js");

/***/ }),

/***/ "../assets/dev/js/editor/document/elements/commands-internal/set-settings.js":
/*!***********************************************************************************!*\
  !*** ../assets/dev/js/editor/document/elements/commands-internal/set-settings.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.SetSettings = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var SetSettings = /*#__PURE__*/function (_$e$modules$editor$Co) {
  (0, _inherits2.default)(SetSettings, _$e$modules$editor$Co);
  var _super = _createSuper(SetSettings);
  function SetSettings() {
    (0, _classCallCheck2.default)(this, SetSettings);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(SetSettings, [{
    key: "validateArgs",
    value: function validateArgs() {
      var args = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      this.requireContainer(args);
      this.requireArgumentType('settings', 'object', args);
      if ('undefined' !== typeof args.render && 'undefined' !== typeof args.renderUI) {
        throw new Error('Args: `render` and `renderUI` cannot be applied together.');
      }
    }
  }, {
    key: "apply",
    value: function apply() {
      var args = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var _args$containers = args.containers,
        containers = _args$containers === void 0 ? [args.container] : _args$containers,
        settings = args.settings,
        _args$options = args.options,
        options = _args$options === void 0 ? {} : _args$options,
        external = options.external,
        _options$render = options.render,
        render = _options$render === void 0 ? true : _options$render,
        _options$renderUI = options.renderUI,
        renderUI = _options$renderUI === void 0 ? false : _options$renderUI;
      containers.forEach(function (container) {
        if (external) {
          container.settings.setExternalChange(settings);
        } else {
          container.settings.set(settings);
        }
        if (renderUI) {
          container.renderUI();
        } else if (render) {
          container.render();
        }
      });
    }
  }]);
  return SetSettings;
}($e.modules.editor.CommandContainerInternalBase);
exports.SetSettings = SetSettings;
var _default = SetSettings;
exports["default"] = _default;

/***/ }),

/***/ "../assets/dev/js/editor/document/elements/commands/copy-all.js":
/*!**********************************************************************!*\
  !*** ../assets/dev/js/editor/document/elements/commands/copy-all.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.CopyAll = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var CopyAll = /*#__PURE__*/function (_$e$modules$CommandBa) {
  (0, _inherits2.default)(CopyAll, _$e$modules$CommandBa);
  var _super = _createSuper(CopyAll);
  function CopyAll() {
    (0, _classCallCheck2.default)(this, CopyAll);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(CopyAll, [{
    key: "apply",
    value: function apply() {
      $e.run('document/elements/copy', {
        containers: Object.values(elementor.getPreviewView().children._views).map(function (view) {
          return view.getContainer();
        })
      });
    }
  }]);
  return CopyAll;
}($e.modules.CommandBase);
exports.CopyAll = CopyAll;
var _default = CopyAll;
exports["default"] = _default;

/***/ }),

/***/ "../assets/dev/js/editor/document/elements/commands/copy.js":
/*!******************************************************************!*\
  !*** ../assets/dev/js/editor/document/elements/commands/copy.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var __ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["__"];


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.Copy = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var Copy = /*#__PURE__*/function (_$e$modules$editor$Co) {
  (0, _inherits2.default)(Copy, _$e$modules$editor$Co);
  var _super = _createSuper(Copy);
  function Copy() {
    (0, _classCallCheck2.default)(this, Copy);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(Copy, [{
    key: "validateArgs",
    value: function validateArgs(args) {
      this.requireContainer(args);
    }
  }, {
    key: "apply",
    value: function apply(args) {
      var _args$storageKey = args.storageKey,
        storageKey = _args$storageKey === void 0 ? 'clipboard' : _args$storageKey,
        _args$containers = args.containers,
        containers = _args$containers === void 0 ? [args.container] : _args$containers;
      if (!elementor.selection.isSameType()) {
        elementor.notifications.showToast({
          message: __('That didn’t work. Try copying one kind of element at a time.', 'elementor'),
          buttons: [{
            name: 'got_it',
            text: __('Got it', 'elementor')
          }]
        });
        return false;
      }
      var elements = elementor.getPreviewView().$el.find('.elementor-element');
      var elementsData = containers.sort(function (first, second) {
        return elements.index(first.view.el) - elements.index(second.view.el);
      }).map(function (container) {
        return container.model.toJSON({
          copyHtmlCache: true
        });
      });
      var storageData = {
        type: 'elementor',
        siteurl: elementorCommon.config.urls.rest,
        elements: elementsData
      };
      elementorCommon.storage.set(storageKey, storageData);

      // TODO: Use package for clipboard saving
      var clipboard = document.createElement('textarea');
      clipboard.value = JSON.stringify(storageData);
      document.body.appendChild(clipboard);
      clipboard.select();
      document.execCommand('copy');
      document.body.removeChild(clipboard);
    }
  }]);
  return Copy;
}($e.modules.editor.CommandContainerBase);
exports.Copy = Copy;
var _default = Copy;
exports["default"] = _default;

/***/ }),

/***/ "../assets/dev/js/editor/document/elements/commands/create.js":
/*!********************************************************************!*\
  !*** ../assets/dev/js/editor/document/elements/commands/create.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.Create = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var Create = /*#__PURE__*/function (_$e$modules$editor$do) {
  (0, _inherits2.default)(Create, _$e$modules$editor$do);
  var _super = _createSuper(Create);
  function Create() {
    (0, _classCallCheck2.default)(this, Create);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(Create, [{
    key: "validateArgs",
    value: function validateArgs(args) {
      this.requireContainer(args);

      // Avoid Backbone model & etc.
      this.requireArgumentConstructor('model', Object, args);
    }
  }, {
    key: "getHistory",
    value: function getHistory(args) {
      var model = args.model,
        _args$containers = args.containers,
        containers = _args$containers === void 0 ? [args.container] : _args$containers;
      return {
        containers: containers,
        model: model,
        type: 'add',
        title: elementor.helpers.getModelLabel(model)
      };
    }
  }, {
    key: "apply",
    value: function apply(args) {
      var _this = this;
      var model = args.model,
        _args$options = args.options,
        options = _args$options === void 0 ? {} : _args$options,
        _args$containers2 = args.containers,
        containers = _args$containers2 === void 0 ? [args.container] : _args$containers2;
      var result = [];
      containers.forEach(function (container) {
        container = container.lookup();
        var createdContainer = container.view.addElement(model, options).getContainer();
        result.push(createdContainer);

        /**
         * Acknowledge history of each created item, because we cannot pass the elements when they do not exist
         * in getHistory().
         */
        if (_this.isHistoryActive()) {
          $e.internal('document/history/log-sub-item', {
            container: container,
            type: 'sub-add',
            restore: _this.constructor.restore,
            options: options,
            data: {
              containerToRestore: createdContainer,
              modelToRestore: createdContainer.model.toJSON()
            }
          });
        }
      });
      if (1 === result.length) {
        result = result[0];
      }
      return result;
    }
  }], [{
    key: "restore",
    value: function restore(historyItem, isRedo) {
      var data = historyItem.get('data'),
        container = historyItem.get('container'),
        options = historyItem.get('options') || {};

      // No clone when restoring. e.g: duplicate will generate unique ids while restoring.
      if (options.clone) {
        options.clone = false;
      }
      if (isRedo) {
        $e.run('document/elements/create', {
          container: container,
          model: data.modelToRestore,
          options: options
        });
      } else {
        $e.run('document/elements/delete', {
          container: data.containerToRestore
        });
      }
    }
  }]);
  return Create;
}($e.modules.editor.document.CommandHistoryBase);
exports.Create = Create;
var _default = Create;
exports["default"] = _default;

/***/ }),

/***/ "../assets/dev/js/editor/document/elements/commands/delete.js":
/*!********************************************************************!*\
  !*** ../assets/dev/js/editor/document/elements/commands/delete.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.Delete = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var Delete = /*#__PURE__*/function (_$e$modules$editor$do) {
  (0, _inherits2.default)(Delete, _$e$modules$editor$do);
  var _super = _createSuper(Delete);
  function Delete() {
    (0, _classCallCheck2.default)(this, Delete);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(Delete, [{
    key: "validateArgs",
    value: function validateArgs(args) {
      this.requireContainer(args);
    }
  }, {
    key: "getHistory",
    value: function getHistory(args) {
      var _args$containers = args.containers,
        containers = _args$containers === void 0 ? [args.container] : _args$containers;
      return {
        containers: containers,
        type: 'remove'
      };
    }
  }, {
    key: "apply",
    value: function apply(args) {
      var _this = this;
      var _args$containers2 = args.containers,
        containers = _args$containers2 === void 0 ? [args.container] : _args$containers2;
      containers.forEach(function (container) {
        container = container.lookup();
        if (_this.isHistoryActive()) {
          $e.internal('document/history/log-sub-item', {
            container: container,
            type: 'sub-remove',
            restore: _this.constructor.restore,
            data: {
              model: container.model.toJSON(),
              parent: container.parent,
              at: container.view._index
            }
          });
        }
        container.model.destroy();
        container.panel.refresh();
      });
      if (1 === containers.length) {
        return containers[0];
      }
      return containers;
    }
  }], [{
    key: "restore",
    value: function restore(historyItem, isRedo) {
      var container = historyItem.get('container'),
        data = historyItem.get('data');
      if (isRedo) {
        $e.run('document/elements/delete', {
          container: container
        });
      } else {
        $e.run('document/elements/create', {
          container: data.parent,
          model: data.model,
          options: {
            at: data.at
          }
        });
      }
    }
  }]);
  return Delete;
}($e.modules.editor.document.CommandHistoryBase);
exports.Delete = Delete;
var _default = Delete;
exports["default"] = _default;

/***/ }),

/***/ "../assets/dev/js/editor/document/elements/commands/deselect-all.js":
/*!**************************************************************************!*\
  !*** ../assets/dev/js/editor/document/elements/commands/deselect-all.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.DeselectAll = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var DeselectAll = /*#__PURE__*/function (_$e$modules$CommandBa) {
  (0, _inherits2.default)(DeselectAll, _$e$modules$CommandBa);
  var _super = _createSuper(DeselectAll);
  function DeselectAll() {
    (0, _classCallCheck2.default)(this, DeselectAll);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(DeselectAll, [{
    key: "apply",
    value: function apply() {
      elementor.selection.remove([], true);
    }
  }]);
  return DeselectAll;
}($e.modules.CommandBase);
exports.DeselectAll = DeselectAll;
var _default = DeselectAll;
exports["default"] = _default;

/***/ }),

/***/ "../assets/dev/js/editor/document/elements/commands/deselect.js":
/*!**********************************************************************!*\
  !*** ../assets/dev/js/editor/document/elements/commands/deselect.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.Deselect = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var Deselect = /*#__PURE__*/function (_$e$modules$editor$Co) {
  (0, _inherits2.default)(Deselect, _$e$modules$editor$Co);
  var _super = _createSuper(Deselect);
  function Deselect() {
    (0, _classCallCheck2.default)(this, Deselect);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(Deselect, [{
    key: "validateArgs",
    value: function validateArgs() {
      var args = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      if (!args.all) {
        this.requireContainer(args);
      }
    }
  }, {
    key: "apply",
    value: function apply(args) {
      var _args$containers = args.containers,
        containers = _args$containers === void 0 ? [args.container] : _args$containers,
        _args$all = args.all,
        all = _args$all === void 0 ? false : _args$all;
      elementor.selection.remove(containers, all);
    }
  }]);
  return Deselect;
}($e.modules.editor.CommandContainerBase);
exports.Deselect = Deselect;
var _default = Deselect;
exports["default"] = _default;

/***/ }),

/***/ "../assets/dev/js/editor/document/elements/commands/duplicate.js":
/*!***********************************************************************!*\
  !*** ../assets/dev/js/editor/document/elements/commands/duplicate.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var __ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["__"];


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.Duplicate = void 0;
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var Duplicate = /*#__PURE__*/function (_$e$modules$editor$do) {
  (0, _inherits2.default)(Duplicate, _$e$modules$editor$do);
  var _super = _createSuper(Duplicate);
  function Duplicate() {
    (0, _classCallCheck2.default)(this, Duplicate);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(Duplicate, [{
    key: "validateArgs",
    value: function validateArgs(args) {
      this.requireContainer(args);
    }
  }, {
    key: "getHistory",
    value: function getHistory(args) {
      var _args$containers = args.containers,
        containers = _args$containers === void 0 ? [args.container] : _args$containers;
      return {
        containers: containers,
        type: 'duplicate'
      };
    }
  }, {
    key: "apply",
    value: function apply(args) {
      var _args$containers2 = args.containers,
        containers = _args$containers2 === void 0 ? [args.container] : _args$containers2,
        _args$options = args.options,
        options = _args$options === void 0 ? {} : _args$options,
        result = [];
      var at = containers[containers.length - 1].view._index;
      if (!elementor.selection.isSameType()) {
        elementor.notifications.showToast({
          message: __('That didn’t work. Try duplicating one kind of element at a time.', 'elementor'),
          buttons: [{
            name: 'got_it',
            text: __('Got it', 'elementor')
          }]
        });
        return false;
      }
      containers.forEach(function (container) {
        var parent = container.parent;
        result.push($e.run('document/elements/create', {
          container: parent,
          model: container.model.toJSON(),
          options: _objectSpread(_objectSpread({}, options), {}, {
            at: ++at,
            clone: true
          })
        }));
      });
      if (1 === result.length) {
        return result[0];
      }
      return result;
    }
  }]);
  return Duplicate;
}($e.modules.editor.document.CommandHistoryBase);
exports.Duplicate = Duplicate;
var _default = Duplicate;
exports["default"] = _default;

/***/ }),

/***/ "../assets/dev/js/editor/document/elements/commands/empty.js":
/*!*******************************************************************!*\
  !*** ../assets/dev/js/editor/document/elements/commands/empty.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var __ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["__"];


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.Empty = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var Empty = /*#__PURE__*/function (_$e$modules$editor$do) {
  (0, _inherits2.default)(Empty, _$e$modules$editor$do);
  var _super = _createSuper(Empty);
  function Empty() {
    (0, _classCallCheck2.default)(this, Empty);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(Empty, [{
    key: "getHistory",
    value: function getHistory(args) {
      if (args.force) {
        return {
          type: 'remove',
          title: __('All Content', 'elementor'),
          data: elementor.elements ? elementor.elements.toJSON() : null,
          restore: this.constructor.restore
        };
      }
      return false;
    }
  }, {
    key: "apply",
    value: function apply(args) {
      if (args.force && elementor.elements) {
        elementor.elements.reset();
        elementor.getPreviewContainer().panel.closeEditor();
        return;
      }
      elementor.getClearPageDialog().show();
    }
  }, {
    key: "isDataChanged",
    value: function isDataChanged() {
      return this.args.force;
    }
  }], [{
    key: "restore",
    value: function restore(historyItem, isRedo) {
      if (isRedo) {
        $e.run('document/elements/empty', {
          force: true
        });
      } else {
        var data = historyItem.get('data');
        if (data) {
          elementor.getPreviewView().addChildModel(data);
        }
        $e.internal('document/save/set-is-modified', {
          status: true
        });
      }
    }
  }]);
  return Empty;
}($e.modules.editor.document.CommandHistoryBase);
exports.Empty = Empty;
var _default = Empty;
exports["default"] = _default;

/***/ }),

/***/ "../assets/dev/js/editor/document/elements/commands/import.js":
/*!********************************************************************!*\
  !*** ../assets/dev/js/editor/document/elements/commands/import.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var __ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["__"];


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.Import = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var Import = /*#__PURE__*/function (_$e$modules$editor$do) {
  (0, _inherits2.default)(Import, _$e$modules$editor$do);
  var _super = _createSuper(Import);
  function Import() {
    (0, _classCallCheck2.default)(this, Import);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(Import, [{
    key: "validateArgs",
    value: function validateArgs(args) {
      this.requireArgumentInstance('model', Backbone.Model, args);
      this.requireArgumentConstructor('data', Object, args);
      if (args.containers) {
        throw new TypeError('Multi containers are not supported');
      }
      if (args.container) {
        this.requireContainer();
      }
    }
  }, {
    key: "getHistory",
    value: function getHistory(args) {
      var model = args.model;
      return {
        type: 'add',
        title: __('Template', 'elementor'),
        subTitle: model.get('title')
      };
    }
  }, {
    key: "apply",
    value: function apply(args) {
      var data = args.data,
        _args$options = args.options,
        options = _args$options === void 0 ? args.options || {} : _args$options,
        _args$container = args.container,
        container = _args$container === void 0 ? args.container || elementor.getPreviewContainer() : _args$container,
        result = [];
      var at = isNaN(options.at) ? container.view.collection.length : options.at;

      // Each `data.content`.
      Object.values(data.content).forEach(function (model) {
        result.push($e.run('document/elements/create', {
          container: container,
          model: model,
          options: Object.assign(options, {
            at: at
          })
        }));
        at++;
      });
      if (options.withPageSettings) {
        $e.run('document/elements/settings', {
          container: elementor.settings.page.getEditedView().getContainer(),
          settings: data.page_settings,
          options: {
            external: true
          }
        });
      }
      return result;
    }
  }]);
  return Import;
}($e.modules.editor.document.CommandHistoryBase);
exports.Import = Import;
var _default = Import;
exports["default"] = _default;

/***/ }),

/***/ "../assets/dev/js/editor/document/elements/commands/index.js":
/*!*******************************************************************!*\
  !*** ../assets/dev/js/editor/document/elements/commands/index.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
Object.defineProperty(exports, "Copy", ({
  enumerable: true,
  get: function get() {
    return _copy.Copy;
  }
}));
Object.defineProperty(exports, "CopyAll", ({
  enumerable: true,
  get: function get() {
    return _copyAll.CopyAll;
  }
}));
Object.defineProperty(exports, "Create", ({
  enumerable: true,
  get: function get() {
    return _create.Create;
  }
}));
Object.defineProperty(exports, "Delete", ({
  enumerable: true,
  get: function get() {
    return _delete.Delete;
  }
}));
Object.defineProperty(exports, "Deselect", ({
  enumerable: true,
  get: function get() {
    return _deselect.Deselect;
  }
}));
Object.defineProperty(exports, "DeselectAll", ({
  enumerable: true,
  get: function get() {
    return _deselectAll.DeselectAll;
  }
}));
Object.defineProperty(exports, "Duplicate", ({
  enumerable: true,
  get: function get() {
    return _duplicate.Duplicate;
  }
}));
Object.defineProperty(exports, "Empty", ({
  enumerable: true,
  get: function get() {
    return _empty.Empty;
  }
}));
Object.defineProperty(exports, "Import", ({
  enumerable: true,
  get: function get() {
    return _import.Import;
  }
}));
Object.defineProperty(exports, "Move", ({
  enumerable: true,
  get: function get() {
    return _move.Move;
  }
}));
Object.defineProperty(exports, "Paste", ({
  enumerable: true,
  get: function get() {
    return _paste.Paste;
  }
}));
Object.defineProperty(exports, "PasteArea", ({
  enumerable: true,
  get: function get() {
    return _pasteArea.PasteArea;
  }
}));
Object.defineProperty(exports, "PasteStyle", ({
  enumerable: true,
  get: function get() {
    return _pasteStyle.PasteStyle;
  }
}));
Object.defineProperty(exports, "ResetSettings", ({
  enumerable: true,
  get: function get() {
    return _resetSettings.ResetSettings;
  }
}));
Object.defineProperty(exports, "ResetStyle", ({
  enumerable: true,
  get: function get() {
    return _resetStyle.ResetStyle;
  }
}));
Object.defineProperty(exports, "Select", ({
  enumerable: true,
  get: function get() {
    return _select.Select;
  }
}));
Object.defineProperty(exports, "SelectAll", ({
  enumerable: true,
  get: function get() {
    return _selectAll.SelectAll;
  }
}));
Object.defineProperty(exports, "Settings", ({
  enumerable: true,
  get: function get() {
    return _settings.Settings;
  }
}));
Object.defineProperty(exports, "ToggleSelection", ({
  enumerable: true,
  get: function get() {
    return _toggleSelection.ToggleSelection;
  }
}));
var _copy = __webpack_require__(/*! ./copy */ "../assets/dev/js/editor/document/elements/commands/copy.js");
var _copyAll = __webpack_require__(/*! ./copy-all */ "../assets/dev/js/editor/document/elements/commands/copy-all.js");
var _create = __webpack_require__(/*! ./create */ "../assets/dev/js/editor/document/elements/commands/create.js");
var _delete = __webpack_require__(/*! ./delete */ "../assets/dev/js/editor/document/elements/commands/delete.js");
var _deselect = __webpack_require__(/*! ./deselect */ "../assets/dev/js/editor/document/elements/commands/deselect.js");
var _deselectAll = __webpack_require__(/*! ./deselect-all */ "../assets/dev/js/editor/document/elements/commands/deselect-all.js");
var _duplicate = __webpack_require__(/*! ./duplicate */ "../assets/dev/js/editor/document/elements/commands/duplicate.js");
var _empty = __webpack_require__(/*! ./empty */ "../assets/dev/js/editor/document/elements/commands/empty.js");
var _import = __webpack_require__(/*! ./import */ "../assets/dev/js/editor/document/elements/commands/import.js");
var _paste = __webpack_require__(/*! ./paste */ "../assets/dev/js/editor/document/elements/commands/paste.js");
var _pasteArea = __webpack_require__(/*! ./paste-area */ "../assets/dev/js/editor/document/elements/commands/paste-area.js");
var _move = __webpack_require__(/*! ./move */ "../assets/dev/js/editor/document/elements/commands/move.js");
var _pasteStyle = __webpack_require__(/*! ./paste-style */ "../assets/dev/js/editor/document/elements/commands/paste-style.js");
var _resetSettings = __webpack_require__(/*! ./reset-settings */ "../assets/dev/js/editor/document/elements/commands/reset-settings.js");
var _resetStyle = __webpack_require__(/*! ./reset-style */ "../assets/dev/js/editor/document/elements/commands/reset-style.js");
var _select = __webpack_require__(/*! ./select */ "../assets/dev/js/editor/document/elements/commands/select.js");
var _selectAll = __webpack_require__(/*! ./select-all */ "../assets/dev/js/editor/document/elements/commands/select-all.js");
var _settings = __webpack_require__(/*! ./settings */ "../assets/dev/js/editor/document/elements/commands/settings.js");
var _toggleSelection = __webpack_require__(/*! ./toggle-selection */ "../assets/dev/js/editor/document/elements/commands/toggle-selection.js");

/***/ }),

/***/ "../assets/dev/js/editor/document/elements/commands/move.js":
/*!******************************************************************!*\
  !*** ../assets/dev/js/editor/document/elements/commands/move.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.Move = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var Move = /*#__PURE__*/function (_$e$modules$editor$do) {
  (0, _inherits2.default)(Move, _$e$modules$editor$do);
  var _super = _createSuper(Move);
  function Move() {
    (0, _classCallCheck2.default)(this, Move);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(Move, [{
    key: "validateArgs",
    value: function validateArgs(args) {
      this.requireContainer(args);
      this.requireArgumentInstance('target', elementorModules.editor.Container, args);
    }
  }, {
    key: "getHistory",
    value: function getHistory(args) {
      var _args$containers = args.containers,
        containers = _args$containers === void 0 ? [args.container] : _args$containers;
      return {
        containers: containers,
        type: 'move'
      };
    }
  }, {
    key: "apply",
    value: function apply(args) {
      var target = args.target,
        _args$options = args.options,
        options = _args$options === void 0 ? {} : _args$options,
        _args$containers2 = args.containers,
        containers = _args$containers2 === void 0 ? [args.container] : _args$containers2,
        reCreate = [];
      containers.forEach(function (container) {
        reCreate.push(container.model.toJSON());
        $e.run('document/elements/delete', {
          container: container
        });
      });
      var count = 0;
      reCreate.forEach(function (model) {
        // If multiple fix position.
        if (Object.prototype.hasOwnProperty.call(options, 'at') && reCreate.length > 1) {
          if (0 !== count) {
            options.at += count;
          }
        }
        $e.run('document/elements/create', {
          container: target,
          model: model,
          options: options
        });
        count++;
      });
    }
  }]);
  return Move;
}($e.modules.editor.document.CommandHistoryBase);
exports.Move = Move;
var _default = Move;
exports["default"] = _default;

/***/ }),

/***/ "../assets/dev/js/editor/document/elements/commands/paste-area.js":
/*!************************************************************************!*\
  !*** ../assets/dev/js/editor/document/elements/commands/paste-area.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var __ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["__"];


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.PasteArea = void 0;
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _environment = _interopRequireDefault(__webpack_require__(/*! elementor-common/utils/environment */ "../core/common/assets/js/utils/environment.js"));
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var PasteArea = /*#__PURE__*/function (_$e$modules$editor$do) {
  (0, _inherits2.default)(PasteArea, _$e$modules$editor$do);
  var _super = _createSuper(PasteArea);
  function PasteArea() {
    (0, _classCallCheck2.default)(this, PasteArea);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(PasteArea, [{
    key: "getHistory",
    value: function getHistory(args) {
      return false;
    }
  }, {
    key: "getDialog",
    value: function getDialog() {
      var _this = this;
      if (this.dialog) {
        return this.dialog;
      }
      var $messageContainer = jQuery('<div>', {
        class: 'e-dialog-description'
      }).html(__('To paste the element from your other site.', 'elementor'));
      var $inputArea = jQuery('<input>', {
        id: 'elementor-paste-area-dialog__input',
        type: 'text'
      }).attr('autocomplete', 'off').on('keypress', function (event) {
        event.preventDefault();
      }).on('blur', function () {
        _.defer(function () {
          return $inputArea.focus();
        });
      }).on('paste', /*#__PURE__*/function () {
        var _ref = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee(event) {
          var $widgetContent, retVal;
          return _regenerator.default.wrap(function _callee$(_context) {
            while (1) switch (_context.prev = _context.next) {
              case 0:
                event.preventDefault();
                $widgetContent = _this.getDialog().getElements('widgetContent');
                $widgetContent.addClass('e-state-loading');
                _context.next = 5;
                return $e.run('document/ui/paste', {
                  container: _this.container,
                  storageType: 'rawdata',
                  data: event.originalEvent.clipboardData.getData('text'),
                  options: _this.options
                });
              case 5:
                retVal = _context.sent;
                $widgetContent.removeClass('e-state-loading');
                if (!retVal) {
                  _context.next = 10;
                  break;
                }
                _this.dialog.hide();
                return _context.abrupt("return");
              case 10:
                $errorArea.show();
              case 11:
              case "end":
                return _context.stop();
            }
          }, _callee);
        }));
        return function (_x) {
          return _ref.apply(this, arguments);
        };
      }());
      var $errorArea = jQuery('<div>', {
        id: 'elementor-paste-area-dialog__error',
        style: "display: none"
      }).html(__('Make sure that both sites are updated to last version of Elementor and have enabled the features relevant to the copied element before trying again.', 'elementor'));
      var $loadingArea = jQuery('<i>', {
        class: 'eicon-loading eicon-animation-spin'
      });
      $messageContainer.append($inputArea).append($errorArea).append($loadingArea);
      var ctrlLabel = _environment.default.mac ? '&#8984;' : 'Ctrl';
      this.dialog = elementorCommon.dialogsManager.createWidget('lightbox', {
        id: 'elementor-paste-area-dialog',
        headerMessage: "".concat(ctrlLabel, " + V"),
        message: $messageContainer,
        position: {
          my: 'center center',
          at: 'center center'
        },
        closeButton: true,
        closeButtonOptions: {
          iconClass: 'eicon-close'
        },
        onShow: function onShow() {
          $inputArea.focus();
          _this.getDialog().getElements('widgetContent').on('click', function () {
            $inputArea.focus();
          });
        }
      });
      return this.dialog;
    }
  }, {
    key: "apply",
    value: function apply(args) {
      this.container = args.container;
      if (args.options) {
        this.options = args.options;
      }
      this.getDialog().show();
    }
  }]);
  return PasteArea;
}($e.modules.editor.document.CommandHistoryBase);
exports.PasteArea = PasteArea;
(0, _defineProperty2.default)(PasteArea, "dialog", null);
(0, _defineProperty2.default)(PasteArea, "container", null);
(0, _defineProperty2.default)(PasteArea, "options", {});
var _default = PasteArea;
exports["default"] = _default;

/***/ }),

/***/ "../assets/dev/js/editor/document/elements/commands/paste-style.js":
/*!*************************************************************************!*\
  !*** ../assets/dev/js/editor/document/elements/commands/paste-style.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.PasteStyle = void 0;
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "../node_modules/@babel/runtime/helpers/slicedToArray.js"));
var _typeof2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
/**
 * @typedef {import('../../../container/container')} Container
 */
var PasteStyle = /*#__PURE__*/function (_$e$modules$editor$do) {
  (0, _inherits2.default)(PasteStyle, _$e$modules$editor$do);
  var _super = _createSuper(PasteStyle);
  function PasteStyle() {
    (0, _classCallCheck2.default)(this, PasteStyle);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(PasteStyle, [{
    key: "validateArgs",
    value: function validateArgs(args) {
      this.requireContainer(args);

      // Validate if storage have data.
      var _args$storageKey = args.storageKey,
        storageKey = _args$storageKey === void 0 ? 'clipboard' : _args$storageKey,
        storageData = elementorCommon.storage.get(storageKey);
      this.requireArgumentType('storageData', 'object', {
        storageData: storageData
      });
    }
  }, {
    key: "validateControls",
    value: function validateControls(source, target) {
      var result = true;

      // Cannot use `_.isEmpty()` does not pass paste style test.
      if (null === source || null === target || undefined === source || undefined === target || 'object' === (0, _typeof2.default)(source) ^ 'object' === (0, _typeof2.default)(target)) {
        result = false;
      }
      return result;
    }
  }, {
    key: "getHistory",
    value: function getHistory(args) {
      var _args$containers = args.containers,
        containers = _args$containers === void 0 ? [args.container] : _args$containers;
      return {
        containers: containers,
        type: 'paste_style'
      };
    }
  }, {
    key: "apply",
    value: function apply(args) {
      var _storageData$elements;
      var _args$containers2 = args.containers,
        containers = _args$containers2 === void 0 ? [args.container] : _args$containers2,
        _args$storageKey2 = args.storageKey,
        storageKey = _args$storageKey2 === void 0 ? 'clipboard' : _args$storageKey2,
        storageData = elementorCommon.storage.get(storageKey);
      if (!storageData || !(storageData !== null && storageData !== void 0 && (_storageData$elements = storageData.elements) !== null && _storageData$elements !== void 0 && _storageData$elements.length) || 'elementor' !== (storageData === null || storageData === void 0 ? void 0 : storageData.type)) {
        return false;
      }
      this.applyPasteStyleData(containers, storageData.elements);
    }
  }, {
    key: "applyPasteStyleData",
    value: function applyPasteStyleData(containers, data) {
      var _this = this;
      containers.forEach(function (targetContainer) {
        var targetSettings = targetContainer.settings,
          targetSettingsAttributes = targetSettings.attributes,
          targetControls = targetSettings.controls,
          diffSettings = {},
          addExtraControls = function addExtraControls(sourceSettings, extraType) {
            if (sourceSettings[extraType]) {
              Object.entries(sourceSettings[extraType]).forEach(function (_ref) {
                var _ref2 = (0, _slicedToArray2.default)(_ref, 2),
                  controlName = _ref2[0],
                  value = _ref2[1];
                var control = targetControls[controlName];
                if (targetContainer.view.isStyleTransferControl(control)) {
                  diffSettings[extraType] = diffSettings[extraType] || {};
                  diffSettings[extraType][controlName] = value;
                }
              });
            }
          };
        data.forEach(function (sourceModel) {
          var sourceSettings = sourceModel.settings;
          addExtraControls(sourceSettings, '__globals__');
          addExtraControls(sourceSettings, '__dynamic__');
          Object.entries(targetControls).forEach(function (_ref3) {
            var _ref4 = (0, _slicedToArray2.default)(_ref3, 2),
              controlName = _ref4[0],
              control = _ref4[1];
            if (!targetContainer.view.isStyleTransferControl(control)) {
              return;
            }
            var controlSourceValue = sourceSettings[controlName],
              controlTargetValue = targetSettingsAttributes[controlName];
            if (!_this.validateControls(controlSourceValue, controlTargetValue)) {
              return;
            }
            if ('object' === (0, _typeof2.default)(controlSourceValue)) {
              // eslint-disable-next-line array-callback-return
              var isEqual = Object.keys(controlSourceValue).some(function (propertyKey) {
                if (controlSourceValue[propertyKey] !== controlTargetValue[propertyKey]) {
                  return false;
                }
              });
              if (isEqual) {
                return;
              }
            }
            if (controlSourceValue === controlTargetValue || !elementor.getControlView(control.type).onPasteStyle(control, controlSourceValue)) {
              return;
            }
            diffSettings[controlName] = controlSourceValue;
          });
          _this.pasteStyle(targetContainer, diffSettings);
        });
      });
    }

    /**
     * @param {Container} targetContainer
     * @param {{}}        settings
     */
  }, {
    key: "pasteStyle",
    value: function pasteStyle(targetContainer, settings) {
      var globals = settings.__globals__;
      if (globals) {
        delete settings.__globals__;
      }
      $e.run('document/elements/settings', {
        container: targetContainer,
        settings: settings,
        options: {
          external: true,
          render: false
        }
      });
      if (globals) {
        $e.run('document/globals/settings', {
          container: targetContainer,
          settings: globals,
          options: {
            external: true,
            render: false
          }
        });
        targetContainer.panel.refresh();
      }
      targetContainer.render();
    }
  }]);
  return PasteStyle;
}($e.modules.editor.document.CommandHistoryBase);
exports.PasteStyle = PasteStyle;
var _default = PasteStyle;
exports["default"] = _default;

/***/ }),

/***/ "../assets/dev/js/editor/document/elements/commands/paste.js":
/*!*******************************************************************!*\
  !*** ../assets/dev/js/editor/document/elements/commands/paste.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var __ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["__"];


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.Paste = void 0;
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var Paste = /*#__PURE__*/function (_$e$modules$editor$do) {
  (0, _inherits2.default)(Paste, _$e$modules$editor$do);
  var _super = _createSuper(Paste);
  function Paste() {
    (0, _classCallCheck2.default)(this, Paste);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(Paste, [{
    key: "validateArgs",
    value: function validateArgs(args) {
      this.requireContainer(args);
    }
  }, {
    key: "getHistory",
    value: function getHistory() {
      return {
        type: 'paste',
        title: __('Elements', 'elementor')
      };
    }
  }, {
    key: "getStorageData",
    value: function getStorageData(args) {
      var _args$storageType = args.storageType,
        storageType = _args$storageType === void 0 ? 'localstorage' : _args$storageType,
        _args$storageKey = args.storageKey,
        storageKey = _args$storageKey === void 0 ? 'clipboard' : _args$storageKey,
        _args$data = args.data,
        data = _args$data === void 0 ? '' : _args$data;
      if ('localstorage' === storageType) {
        return elementorCommon.storage.get(storageKey) || {};
      }
      try {
        return JSON.parse(data) || {};
      } catch (e) {
        return {};
      }
    }
  }, {
    key: "apply",
    value: function () {
      var _apply = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee(args) {
        var _storageData$elements;
        var at, _args$rebuild, rebuild, _args$containers, containers, _args$options, options, storageData, storageDataElements, result;
        return _regenerator.default.wrap(function _callee$(_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              at = args.at, _args$rebuild = args.rebuild, rebuild = _args$rebuild === void 0 ? false : _args$rebuild, _args$containers = args.containers, containers = _args$containers === void 0 ? [args.container] : _args$containers, _args$options = args.options, options = _args$options === void 0 ? {} : _args$options, storageData = this.getStorageData(args);
              if (!(!storageData || !(storageData !== null && storageData !== void 0 && (_storageData$elements = storageData.elements) !== null && _storageData$elements !== void 0 && _storageData$elements.length) || 'elementor' !== (storageData === null || storageData === void 0 ? void 0 : storageData.type))) {
                _context.next = 3;
                break;
              }
              return _context.abrupt("return", false);
            case 3:
              storageDataElements = storageData.elements;
              if (!(storageData.siteurl !== elementorCommon.config.urls.rest)) {
                _context.next = 14;
                break;
              }
              _context.prev = 5;
              _context.next = 8;
              return new Promise(function (resolve, reject) {
                return elementorCommon.ajax.addRequest('import_from_json', {
                  data: {
                    elements: JSON.stringify(storageDataElements)
                  },
                  success: resolve,
                  error: reject
                });
              });
            case 8:
              storageDataElements = _context.sent;
              _context.next = 14;
              break;
            case 11:
              _context.prev = 11;
              _context.t0 = _context["catch"](5);
              return _context.abrupt("return", false);
            case 14:
              result = []; // Paste on "Add Section" area.
              if (rebuild) {
                result = this.rebuild(containers, storageDataElements, at);
              } else {
                if (undefined !== at) {
                  options.at = at;
                }
                result.push(this.pasteTo(containers, storageDataElements, options));
              }
              if (!(1 === result.length)) {
                _context.next = 18;
                break;
              }
              return _context.abrupt("return", result[0]);
            case 18:
              return _context.abrupt("return", result);
            case 19:
            case "end":
              return _context.stop();
          }
        }, _callee, this, [[5, 11]]);
      }));
      function apply(_x) {
        return _apply.apply(this, arguments);
      }
      return apply;
    }()
  }, {
    key: "rebuild",
    value: function rebuild(containers, data, at) {
      var _this = this;
      // Paste at each target.
      var result = [];
      containers.forEach(function (targetContainer) {
        var createNewElementAtTheBottomOfThePage = 'undefined' === typeof at;
        var index = createNewElementAtTheBottomOfThePage ? targetContainer.view.collection.length : at;
        data.forEach(function (model) {
          switch (model.elType) {
            case 'container':
              {
                // Push the cloned container to the 'document'.
                result.push(_this.pasteTo([targetContainer], [model], {
                  at: createNewElementAtTheBottomOfThePage ? ++index : index
                }));
              }
              break;
            case 'section':
              {
                // If is inner create section for `inner-section`.
                if (model.isInner) {
                  var section = $e.run('document/elements/create', {
                    container: targetContainer,
                    model: {
                      elType: 'section'
                    },
                    columns: 1,
                    options: {
                      at: index,
                      edit: false
                    }
                  });

                  // `targetContainer` = first column at `section`.
                  targetContainer = section.view.children.findByIndex(0).getContainer();
                }

                // Will be not affected by hook since it always have `model.elements`.
                result.push(_this.pasteTo([targetContainer], [model], {
                  at: index,
                  edit: false
                }));
                index++;
              }
              break;
            case 'column':
              {
                // Next code changed from original since `_checkIsEmpty()` was removed.
                var _section = $e.run('document/elements/create', {
                  container: targetContainer,
                  model: {
                    elType: 'section'
                  },
                  columns: 0,
                  // Section with no columns.
                  options: {
                    at: ++index,
                    edit: false
                  }
                });
                result.push(_this.pasteTo([_section], [model]));
              }
              break;
            default:
              {
                // The 'default' case is widget.
                var target;
                if ('section' === targetContainer.model.get('elType')) {
                  // On trying to paste widget on section, the paste should be at the first column.
                  target = [targetContainer.view.children.findByIndex(0).getContainer()];
                } else if ('container' === targetContainer.model.get('elType')) {
                  target = [targetContainer];
                } else if (elementorCommon.config.experimentalFeatures.container) {
                  // If the container experiment is active, create a new wrapper container.
                  target = $e.run('document/elements/create', {
                    container: targetContainer,
                    model: {
                      elType: 'container'
                    },
                    options: {
                      at: createNewElementAtTheBottomOfThePage ? ++index : index
                    }
                  });
                  target = [target];
                } else {
                  // Else, create section with one column for the element.
                  var _section2 = $e.run('document/elements/create', {
                    container: targetContainer,
                    model: {
                      elType: 'section'
                    },
                    columns: 1,
                    options: {
                      at: createNewElementAtTheBottomOfThePage ? ++index : index
                    }
                  });

                  // Create the element inside the column that just was created.
                  target = [_section2.view.children.first().getContainer()];
                }
                result.push(_this.pasteTo(target, [model]));
              }
          }
        });
      });
      return result;
    }
  }, {
    key: "pasteTo",
    value: function pasteTo(targetContainers, models) {
      var options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
      options = Object.assign({
        at: null,
        clone: true
      }, options);
      var result = [];
      models.forEach(function (model) {
        result.push($e.run('document/elements/create', {
          containers: targetContainers,
          model: model,
          options: options
        }));

        // On paste sections, increase the `at` for every section.
        if (null !== options.at) {
          options.at++;
        }
      });
      if (1 === result.length) {
        return result[0];
      }
      return result;
    }
  }]);
  return Paste;
}($e.modules.editor.document.CommandHistoryBase);
exports.Paste = Paste;
var _default = Paste;
exports["default"] = _default;

/***/ }),

/***/ "../assets/dev/js/editor/document/elements/commands/reset-settings.js":
/*!****************************************************************************!*\
  !*** ../assets/dev/js/editor/document/elements/commands/reset-settings.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.ResetSettings = void 0;
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "../node_modules/@babel/runtime/helpers/slicedToArray.js"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var ResetSettings = /*#__PURE__*/function (_$e$modules$editor$do) {
  (0, _inherits2.default)(ResetSettings, _$e$modules$editor$do);
  var _super = _createSuper(ResetSettings);
  function ResetSettings() {
    (0, _classCallCheck2.default)(this, ResetSettings);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(ResetSettings, [{
    key: "validateArgs",
    value: function validateArgs(args) {
      this.requireContainer(args);
    }
  }, {
    key: "getHistory",
    value: function getHistory(args) {
      var _args$containers = args.containers,
        containers = _args$containers === void 0 ? [args.container] : _args$containers;
      return {
        containers: containers,
        type: 'reset_settings'
      };
    }
  }, {
    key: "apply",
    value: function apply(args) {
      var _args$containers2 = args.containers,
        containers = _args$containers2 === void 0 ? [args.container] : _args$containers2,
        _args$options = args.options,
        options = _args$options === void 0 ? {} : _args$options,
        _args$settings = args.settings,
        settings = _args$settings === void 0 ? [] : _args$settings;
      containers.forEach(function (container) {
        var controls = Object.entries(container.settings.controls),
          defaultValues = {};
        controls.forEach(function (_ref) {
          var _ref2 = (0, _slicedToArray2.default)(_ref, 2),
            controlName = _ref2[0],
            control = _ref2[1];
          // If settings were specific, restore only them.
          if (settings && settings.length) {
            if (!settings.find(function (key) {
              return key === controlName;
            })) {
              return;
            }
          }
          defaultValues[controlName] = control.default;
        });
        $e.run('document/elements/settings', {
          container: container,
          options: options,
          settings: defaultValues
        });
        container.render();
      });
    }
  }]);
  return ResetSettings;
}($e.modules.editor.document.CommandHistoryBase);
exports.ResetSettings = ResetSettings;
var _default = ResetSettings;
exports["default"] = _default;

/***/ }),

/***/ "../assets/dev/js/editor/document/elements/commands/reset-style.js":
/*!*************************************************************************!*\
  !*** ../assets/dev/js/editor/document/elements/commands/reset-style.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.ResetStyle = void 0;
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "../node_modules/@babel/runtime/helpers/slicedToArray.js"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var ResetStyle = /*#__PURE__*/function (_$e$modules$editor$do) {
  (0, _inherits2.default)(ResetStyle, _$e$modules$editor$do);
  var _super = _createSuper(ResetStyle);
  function ResetStyle() {
    (0, _classCallCheck2.default)(this, ResetStyle);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(ResetStyle, [{
    key: "validateArgs",
    value: function validateArgs(args) {
      this.requireContainer(args);
    }
  }, {
    key: "getHistory",
    value: function getHistory(args) {
      var _args$containers = args.containers,
        containers = _args$containers === void 0 ? [args.container] : _args$containers;
      return {
        containers: containers,
        type: 'reset_style'
      };
    }
  }, {
    key: "apply",
    value: function apply(args) {
      var _args$containers2 = args.containers,
        containers = _args$containers2 === void 0 ? [args.container] : _args$containers2;
      containers.forEach(function (container) {
        var controls = container.settings.controls,
          settingsKeys = [];
        container.view.allowRender = false;
        Object.entries(controls).forEach(function (_ref) {
          var _ref2 = (0, _slicedToArray2.default)(_ref, 2),
            controlName = _ref2[0],
            control = _ref2[1];
          if (!container.view.isStyleTransferControl(control)) {
            return;
          }
          settingsKeys.push(controlName);
        });
        $e.run('document/elements/reset-settings', {
          container: container,
          settings: settingsKeys,
          options: {
            external: true
          }
        });
        container.view.allowRender = true;
        container.render();
      });
    }
  }]);
  return ResetStyle;
}($e.modules.editor.document.CommandHistoryBase);
exports.ResetStyle = ResetStyle;
var _default = ResetStyle;
exports["default"] = _default;

/***/ }),

/***/ "../assets/dev/js/editor/document/elements/commands/select-all.js":
/*!************************************************************************!*\
  !*** ../assets/dev/js/editor/document/elements/commands/select-all.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.SelectAll = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var SelectAll = /*#__PURE__*/function (_$e$modules$CommandBa) {
  (0, _inherits2.default)(SelectAll, _$e$modules$CommandBa);
  var _super = _createSuper(SelectAll);
  function SelectAll() {
    (0, _classCallCheck2.default)(this, SelectAll);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(SelectAll, [{
    key: "apply",
    value: function apply() {
      elementor.selection.add(this.flattenContainersList(
      // The selection mechanism keeps selected elements in a single-dimension object. Therefore, In order to
      // select all document elements, we should convert them into a flatten, single-dimension array.
      elementor.elementsModel.get('elements').map(function (element) {
        return elementor.getContainer(element.id);
      })));
    }

    /**
     * Recursively iterate over all container children and make a flatten array of their instances.
     *
     * @param {*} containers
     * @return {*[]} flattened array of container children
     */
  }, {
    key: "flattenContainersList",
    value: function flattenContainersList() {
      var containers = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
      var flatten = [];
      var _iterator = _createForOfIteratorHelper(containers),
        _step;
      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var container = _step.value;
          flatten.push(container);
          if (container.children.length) {
            flatten = flatten.concat(this.flattenContainersList(container.children));
          }
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }
      return flatten;
    }
  }]);
  return SelectAll;
}($e.modules.CommandBase);
exports.SelectAll = SelectAll;
var _default = SelectAll;
exports["default"] = _default;

/***/ }),

/***/ "../assets/dev/js/editor/document/elements/commands/select.js":
/*!********************************************************************!*\
  !*** ../assets/dev/js/editor/document/elements/commands/select.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.Select = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var Select = /*#__PURE__*/function (_$e$modules$editor$Co) {
  (0, _inherits2.default)(Select, _$e$modules$editor$Co);
  var _super = _createSuper(Select);
  function Select() {
    (0, _classCallCheck2.default)(this, Select);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(Select, [{
    key: "validateArgs",
    value: function validateArgs(args) {
      this.requireContainer(args);
    }
  }, {
    key: "apply",
    value: function apply(args) {
      var _args$containers = args.containers,
        containers = _args$containers === void 0 ? [args.container] : _args$containers,
        _args$append = args.append,
        append = _args$append === void 0 ? false : _args$append;
      elementor.selection.add(containers, append);
    }
  }]);
  return Select;
}($e.modules.editor.CommandContainerBase);
exports.Select = Select;
var _default = Select;
exports["default"] = _default;

/***/ }),

/***/ "../assets/dev/js/editor/document/elements/commands/settings.js":
/*!**********************************************************************!*\
  !*** ../assets/dev/js/editor/document/elements/commands/settings.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.Settings = void 0;
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
/**
 * @typedef {import('../../../container/container')} Container
 */
var Settings = /*#__PURE__*/function (_$e$modules$editor$do) {
  (0, _inherits2.default)(Settings, _$e$modules$editor$do);
  var _super = _createSuper(Settings);
  function Settings() {
    (0, _classCallCheck2.default)(this, Settings);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(Settings, [{
    key: "addToHistory",
    value:
    /**
     * Function addToHistory().
     *
     * @param {Container} container
     * @param {{}}        newSettings
     * @param {{}}        oldSettings
     */
    function addToHistory(container, newSettings, oldSettings) {
      var changes = (0, _defineProperty2.default)({}, container.id, {
          old: oldSettings,
          new: newSettings
        }),
        historyItem = {
          containers: [container],
          data: {
            changes: changes
          },
          type: 'change',
          restore: Settings.restore
        };
      $e.internal('document/history/add-transaction', historyItem);
    }
  }, {
    key: "validateArgs",
    value: function validateArgs(args) {
      this.requireContainer(args);
      this.requireArgumentConstructor('settings', Object, args);
    }
  }, {
    key: "getHistory",
    value: function getHistory(args) {
      var _args$containers = args.containers,
        containers = _args$containers === void 0 ? [args.container] : _args$containers,
        subTitle = this.constructor.getSubTitle(args);
      return {
        containers: containers,
        subTitle: subTitle,
        type: 'change'
      };
    }
  }, {
    key: "apply",
    value: function apply(args) {
      var _this = this;
      var _args$containers2 = args.containers,
        containers = _args$containers2 === void 0 ? [args.container] : _args$containers2,
        _args$settings = args.settings,
        settings = _args$settings === void 0 ? {} : _args$settings,
        _args$isMultiSettings = args.isMultiSettings,
        isMultiSettings = _args$isMultiSettings === void 0 ? false : _args$isMultiSettings,
        _args$options = args.options,
        options = _args$options === void 0 ? {} : _args$options;
      containers.forEach(function (container) {
        container = container.lookup();
        /**
         * Settings support multi settings for each container, eg use:
         * settings: { '{ container-id }': { someSettingKey: someSettingValue } } etc.
         */
        var newSettings = isMultiSettings ? settings[container.id] : settings,
          oldSettings = container.settings.toJSON();

        // Clear old oldValues.
        container.oldValues = {};

        // Set oldValues, For each setting is about to change save setting value.
        Object.keys(newSettings).forEach(function (key) {
          container.oldValues[key] = oldSettings[key];
        });

        // If history active, add history transaction with old and new settings.
        if (_this.isHistoryActive()) {
          _this.addToHistory(container, newSettings, container.oldValues);
        }
        $e.internal('document/elements/set-settings', {
          container: container,
          options: options,
          settings: newSettings
        });
      });
    }
  }], [{
    key: "getSubTitle",
    value:
    /**
     * Function getSubTitle().
     *
     * Get sub title by container.
     *
     * @param {{}} args
     *
     * @return {string} sub title
     */
    function getSubTitle(args) {
      var _args$containers3 = args.containers,
        containers = _args$containers3 === void 0 ? [args.container] : _args$containers3,
        _args$settings2 = args.settings,
        settings = _args$settings2 === void 0 ? {} : _args$settings2,
        isMultiSettings = args.isMultiSettings,
        settingsKeys = Object.keys(settings),
        controls = containers[0].controls,
        firstSettingKey = settingsKeys[0];
      var result = '';
      if (!isMultiSettings && 1 === settingsKeys.length && controls && controls[firstSettingKey]) {
        result = controls[firstSettingKey].label;
      }
      return result;
    }

    /**
     * Function restore().
     *
     * Redo/Restore.
     *
     * @param {{}}      historyItem
     * @param {boolean} isRedo
     */
  }, {
    key: "restore",
    value: function restore(historyItem, isRedo) {
      var data = historyItem.get('data');
      historyItem.get('containers').forEach(function ( /* Container */container) {
        var changes = data.changes[container.id];
        $e.run('document/elements/settings', {
          container: container,
          settings: isRedo ? changes.new : changes.old,
          options: {
            external: true
          }
        });
      });
    }
  }]);
  return Settings;
}($e.modules.editor.document.CommandHistoryDebounceBase);
exports.Settings = Settings;
var _default = Settings;
exports["default"] = _default;

/***/ }),

/***/ "../assets/dev/js/editor/document/elements/commands/toggle-selection.js":
/*!******************************************************************************!*\
  !*** ../assets/dev/js/editor/document/elements/commands/toggle-selection.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.ToggleSelection = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var ToggleSelection = /*#__PURE__*/function (_$e$modules$editor$Co) {
  (0, _inherits2.default)(ToggleSelection, _$e$modules$editor$Co);
  var _super = _createSuper(ToggleSelection);
  function ToggleSelection() {
    (0, _classCallCheck2.default)(this, ToggleSelection);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(ToggleSelection, [{
    key: "validateArgs",
    value: function validateArgs(args) {
      this.requireContainer(args);
    }
  }, {
    key: "apply",
    value: function apply(args) {
      var _args$containers = args.containers,
        containers = _args$containers === void 0 ? [args.container] : _args$containers,
        _args$append = args.append,
        append = _args$append === void 0 ? false : _args$append;
      containers.forEach(function (container) {
        $e.run(elementor.selection.has(container) && append ? 'document/elements/deselect' : 'document/elements/select', args);
      });
    }
  }]);
  return ToggleSelection;
}($e.modules.editor.CommandContainerBase);
exports.ToggleSelection = ToggleSelection;
var _default = ToggleSelection;
exports["default"] = _default;

/***/ }),

/***/ "../assets/dev/js/editor/document/elements/component.js":
/*!**************************************************************!*\
  !*** ../assets/dev/js/editor/document/elements/component.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _componentBase = _interopRequireDefault(__webpack_require__(/*! elementor-api/modules/component-base */ "../modules/web-cli/assets/js/modules/component-base.js"));
var commands = _interopRequireWildcard(__webpack_require__(/*! ./commands/ */ "../assets/dev/js/editor/document/elements/commands/index.js"));
var commandsInternal = _interopRequireWildcard(__webpack_require__(/*! ./commands-internal/ */ "../assets/dev/js/editor/document/elements/commands-internal/index.js"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var Component = /*#__PURE__*/function (_ComponentBase) {
  (0, _inherits2.default)(Component, _ComponentBase);
  var _super = _createSuper(Component);
  function Component() {
    (0, _classCallCheck2.default)(this, Component);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(Component, [{
    key: "getNamespace",
    value: function getNamespace() {
      return 'document/elements';
    }
  }, {
    key: "defaultCommands",
    value: function defaultCommands() {
      return this.importCommands(commands);
    }
  }, {
    key: "defaultCommandsInternal",
    value: function defaultCommandsInternal() {
      return this.importCommands(commandsInternal);
    }
  }, {
    key: "defaultUtils",
    value: function defaultUtils() {
      var _this = this;
      return {
        isValidChild: function isValidChild(childModel, parentModel) {
          return parentModel.isValidChild(childModel);
        },
        isValidGrandChild: function isValidGrandChild(childModel, targetContainer) {
          var result;
          var childElType = childModel.get('elType');
          switch (targetContainer.model.get('elType')) {
            case 'document':
              result = true;
              break;
            case 'section':
              result = 'widget' === childElType;
              break;
            default:
              result = false;
          }
          return result;
        },
        isSameElement: function isSameElement(sourceModel, targetContainer) {
          var targetElType = targetContainer.model.get('elType'),
            sourceElType = sourceModel.get('elType');
          if (targetElType !== sourceElType) {
            return false;
          }
          if ('column' === targetElType && 'column' === sourceElType) {
            return true;
          }
          return targetContainer.model.get('isInner') === sourceModel.get('isInner');
        },
        getPasteOptions: function getPasteOptions(sourceModel, targetContainer) {
          var result = {};
          result.isValidChild = targetContainer.model.isValidChild(sourceModel);
          result.isSameElement = _this.utils.isSameElement(sourceModel, targetContainer);
          result.isValidGrandChild = _this.utils.isValidGrandChild(sourceModel, targetContainer);
          return result;
        },
        isPasteEnabled: function isPasteEnabled(targetContainer) {
          var _storage$elements;
          var storage = elementorCommon.storage.get('clipboard');

          // No storage? no paste.
          if (!storage || !(storage !== null && storage !== void 0 && (_storage$elements = storage.elements) !== null && _storage$elements !== void 0 && _storage$elements.length) || 'elementor' !== (storage === null || storage === void 0 ? void 0 : storage.type)) {
            return false;
          }
          if (!(storage.elements[0] instanceof Backbone.Model)) {
            storage.elements[0] = new Backbone.Model(storage.elements[0]);
          }
          var pasteOptions = _this.utils.getPasteOptions(storage.elements[0], targetContainer);
          return Object.values(pasteOptions).some(function (opt) {
            return !!opt;
          });
        }
      };
    }
  }]);
  return Component;
}(_componentBase.default);
exports["default"] = Component;

/***/ }),

/***/ "../assets/dev/js/editor/document/globals/commands/base/disable-enable.js":
/*!********************************************************************************!*\
  !*** ../assets/dev/js/editor/document/globals/commands/base/disable-enable.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var __ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["__"];


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _commandDisableEnable = _interopRequireDefault(__webpack_require__(/*! elementor-document/command-bases/command-disable-enable */ "../assets/dev/js/editor/document/command-bases/command-disable-enable.js"));
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var DisableEnable = /*#__PURE__*/function (_CommandDisableEnable) {
  (0, _inherits2.default)(DisableEnable, _CommandDisableEnable);
  var _super = _createSuper(DisableEnable);
  function DisableEnable() {
    (0, _classCallCheck2.default)(this, DisableEnable);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(DisableEnable, [{
    key: "getTitle",
    value: function getTitle() {
      return __('Global');
    }
  }], [{
    key: "getName",
    value: function getName() {
      return 'Global';
    }
  }, {
    key: "getEnableCommand",
    value: function getEnableCommand() {
      return 'document/globals/enable';
    }
  }, {
    key: "getDisableCommand",
    value: function getDisableCommand() {
      return 'document/globals/disable';
    }
  }]);
  return DisableEnable;
}(_commandDisableEnable.default);
exports["default"] = DisableEnable;

/***/ }),

/***/ "../assets/dev/js/editor/document/globals/commands/disable.js":
/*!********************************************************************!*\
  !*** ../assets/dev/js/editor/document/globals/commands/disable.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.Disable = void 0;
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "../node_modules/@babel/runtime/helpers/slicedToArray.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _disableEnable = _interopRequireDefault(__webpack_require__(/*! ./base/disable-enable */ "../assets/dev/js/editor/document/globals/commands/base/disable-enable.js"));
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
// TODO: Disable is the only command that extends DisableEnable which is async.
var Disable = /*#__PURE__*/function (_DisableEnable) {
  (0, _inherits2.default)(Disable, _DisableEnable);
  var _super = _createSuper(Disable);
  function Disable() {
    (0, _classCallCheck2.default)(this, Disable);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(Disable, [{
    key: "apply",
    value: function () {
      var _apply = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee3(args) {
        var settings, _args$containers, containers, _args$options, options, all;
        return _regenerator.default.wrap(function _callee3$(_context3) {
          while (1) switch (_context3.prev = _context3.next) {
            case 0:
              settings = args.settings, _args$containers = args.containers, containers = _args$containers === void 0 ? [args.container] : _args$containers, _args$options = args.options, options = _args$options === void 0 ? {} : _args$options;
              all = containers.map( /*#__PURE__*/function () {
                var _ref = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee2( /* Container */container) {
                  var promises;
                  return _regenerator.default.wrap(function _callee2$(_context2) {
                    while (1) switch (_context2.prev = _context2.next) {
                      case 0:
                        container = container.lookup();
                        promises = []; // TODO rename `options.restore` => `options.unlink`.
                        if (!options.restore) {
                          _context2.next = 6;
                          break;
                        }
                        promises = Object.entries(container.globals.attributes).map( /*#__PURE__*/function () {
                          var _ref3 = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee(_ref2) {
                            var _ref4, globalKey, globalValue;
                            return _regenerator.default.wrap(function _callee$(_context) {
                              while (1) switch (_context.prev = _context.next) {
                                case 0:
                                  _ref4 = (0, _slicedToArray2.default)(_ref2, 2), globalKey = _ref4[0], globalValue = _ref4[1];
                                  if (globalValue) {
                                    _context.next = 3;
                                    break;
                                  }
                                  return _context.abrupt("return");
                                case 3:
                                  return _context.abrupt("return", $e.run('document/globals/unlink', {
                                    container: container,
                                    options: {
                                      external: true
                                    },
                                    globalValue: globalValue,
                                    setting: globalKey
                                  }));
                                case 4:
                                case "end":
                                  return _context.stop();
                              }
                            }, _callee);
                          }));
                          return function (_x3) {
                            return _ref3.apply(this, arguments);
                          };
                        }());
                        _context2.next = 6;
                        return Promise.all(promises);
                      case 6:
                        // Clear globals.
                        Object.keys(settings).forEach(function (setting) {
                          return container.globals.set(setting, '');
                        });
                        $e.internal('document/elements/set-settings', {
                          container: container,
                          settings: {
                            __globals__: container.globals.toJSON()
                          },
                          options: {
                            renderUI: true
                          }
                        });
                      case 8:
                      case "end":
                        return _context2.stop();
                    }
                  }, _callee2);
                }));
                return function (_x2) {
                  return _ref.apply(this, arguments);
                };
              }());
              _context3.next = 4;
              return Promise.all(all);
            case 4:
            case "end":
              return _context3.stop();
          }
        }, _callee3);
      }));
      function apply(_x) {
        return _apply.apply(this, arguments);
      }
      return apply;
    }()
  }]);
  return Disable;
}(_disableEnable.default);
exports.Disable = Disable;
var _default = Disable;
exports["default"] = _default;

/***/ }),

/***/ "../assets/dev/js/editor/document/globals/commands/enable.js":
/*!*******************************************************************!*\
  !*** ../assets/dev/js/editor/document/globals/commands/enable.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.Enable = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _disableEnable = _interopRequireDefault(__webpack_require__(/*! ./base/disable-enable */ "../assets/dev/js/editor/document/globals/commands/base/disable-enable.js"));
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
// Run when a global control value is chosen while the active value is custom.
var Enable = /*#__PURE__*/function (_DisableEnable) {
  (0, _inherits2.default)(Enable, _DisableEnable);
  var _super = _createSuper(Enable);
  function Enable() {
    (0, _classCallCheck2.default)(this, Enable);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(Enable, [{
    key: "apply",
    value: function apply(args) {
      var settings = args.settings,
        _args$containers = args.containers,
        containers = _args$containers === void 0 ? [args.container] : _args$containers;
      containers.forEach(function (container) {
        container = container.lookup();
        container.globals.set(settings);
        $e.internal('document/elements/set-settings', {
          container: container,
          settings: {
            __globals__: container.globals.toJSON()
          },
          options: {
            renderUI: true
          }
        });

        // Clear custom local settings.
        Object.values(container.getGroupRelatedControls(settings)).forEach(function (control) {
          container.settings.set(control.name, control.default);
        });
      });
    }
  }]);
  return Enable;
}(_disableEnable.default);
exports.Enable = Enable;
var _default = Enable;
exports["default"] = _default;

/***/ }),

/***/ "../assets/dev/js/editor/document/globals/commands/index.js":
/*!******************************************************************!*\
  !*** ../assets/dev/js/editor/document/globals/commands/index.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
Object.defineProperty(exports, "Disable", ({
  enumerable: true,
  get: function get() {
    return _disable.Disable;
  }
}));
Object.defineProperty(exports, "Enable", ({
  enumerable: true,
  get: function get() {
    return _enable.Enable;
  }
}));
Object.defineProperty(exports, "Settings", ({
  enumerable: true,
  get: function get() {
    return _settings.Settings;
  }
}));
Object.defineProperty(exports, "Unlink", ({
  enumerable: true,
  get: function get() {
    return _unlink.Unlink;
  }
}));
var _disable = __webpack_require__(/*! ./disable */ "../assets/dev/js/editor/document/globals/commands/disable.js");
var _enable = __webpack_require__(/*! ./enable */ "../assets/dev/js/editor/document/globals/commands/enable.js");
var _settings = __webpack_require__(/*! ./settings */ "../assets/dev/js/editor/document/globals/commands/settings.js");
var _unlink = __webpack_require__(/*! ./unlink */ "../assets/dev/js/editor/document/globals/commands/unlink.js");

/***/ }),

/***/ "../assets/dev/js/editor/document/globals/commands/settings.js":
/*!*********************************************************************!*\
  !*** ../assets/dev/js/editor/document/globals/commands/settings.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.Settings = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _settings = _interopRequireDefault(__webpack_require__(/*! elementor-document/elements/commands/settings */ "../assets/dev/js/editor/document/elements/commands/settings.js"));
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var Settings = /*#__PURE__*/function (_$e$modules$editor$do) {
  (0, _inherits2.default)(Settings, _$e$modules$editor$do);
  var _super = _createSuper(Settings);
  function Settings() {
    (0, _classCallCheck2.default)(this, Settings);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(Settings, [{
    key: "validateArgs",
    value: function validateArgs(args) {
      this.requireContainer(args);
      this.requireArgumentConstructor('settings', Object, args);
    }
  }, {
    key: "getHistory",
    value: function getHistory(args) {
      var settings = args.settings,
        _args$containers = args.containers,
        containers = _args$containers === void 0 ? [args.container] : _args$containers,
        changes = {};
      containers.forEach(function (container) {
        var id = container.id;
        if (!changes[id]) {
          changes[id] = {};
        }
        changes[id] = {
          old: container.globals.toJSON(),
          new: settings
        };
      });
      var subTitle = _settings.default.getSubTitle(args);
      return {
        containers: containers,
        subTitle: subTitle,
        data: {
          changes: changes
        },
        type: 'change',
        restore: this.constructor.restore
      };
    }
  }, {
    key: "apply",
    value: function apply(args) {
      var settings = args.settings,
        _args$containers2 = args.containers,
        containers = _args$containers2 === void 0 ? [args.container] : _args$containers2,
        _args$options = args.options,
        options = _args$options === void 0 ? {} : _args$options;
      containers.forEach(function (container) {
        container = container.lookup();
        if (!Object.keys(settings).length) {
          container.globals.clear();
        } else {
          container.globals.set(settings);
        }
        $e.internal('document/elements/set-settings', {
          container: container,
          options: options,
          settings: {
            __globals__: container.globals.toJSON()
          }
        });
      });
    }
  }], [{
    key: "restore",
    value: function restore(historyItem, isRedo) {
      var data = historyItem.get('data');
      historyItem.get('containers').forEach(function (container) {
        var changes = data.changes[container.id];
        $e.run('document/globals/settings', {
          container: container,
          settings: isRedo ? changes.new : changes.old
        });
        container.panel.refresh();
      });
    }
  }]);
  return Settings;
}($e.modules.editor.document.CommandHistoryDebounceBase);
exports.Settings = Settings;
var _default = Settings;
exports["default"] = _default;

/***/ }),

/***/ "../assets/dev/js/editor/document/globals/commands/unlink.js":
/*!*******************************************************************!*\
  !*** ../assets/dev/js/editor/document/globals/commands/unlink.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.Unlink = void 0;
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "../node_modules/@babel/runtime/helpers/slicedToArray.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
// TODO: Add dev-tools CSS to see if widget have globals.
var Unlink = /*#__PURE__*/function (_$e$modules$editor$Co) {
  (0, _inherits2.default)(Unlink, _$e$modules$editor$Co);
  var _super = _createSuper(Unlink);
  function Unlink() {
    (0, _classCallCheck2.default)(this, Unlink);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(Unlink, [{
    key: "validateArgs",
    value: function validateArgs() {
      var args = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      this.requireContainer(args);
      this.requireArgumentType('setting', 'string', args);
      this.requireArgumentType('globalValue', 'string', args);

      // TODO: validate global value is command format.
    }
  }, {
    key: "apply",
    value: function () {
      var _apply = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee2(args) {
        var _args$containers, containers, setting, globalValue, _args$options, options, localSettings;
        return _regenerator.default.wrap(function _callee2$(_context2) {
          while (1) switch (_context2.prev = _context2.next) {
            case 0:
              _args$containers = args.containers, containers = _args$containers === void 0 ? [args.container] : _args$containers, setting = args.setting, globalValue = args.globalValue, _args$options = args.options, options = _args$options === void 0 ? {} : _args$options, localSettings = {};
              _context2.next = 3;
              return Promise.all(containers.map( /*#__PURE__*/function () {
                var _ref = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee( /* Container */container) {
                  var result, _container$controls$s, value, groupPrefix;
                  return _regenerator.default.wrap(function _callee$(_context) {
                    while (1) switch (_context.prev = _context.next) {
                      case 0:
                        _context.next = 2;
                        return $e.data.get(globalValue);
                      case 2:
                        result = _context.sent;
                        if (result) {
                          // Prepare global value to mapping.
                          value = result.data.value, groupPrefix = (_container$controls$s = container.controls[setting]) === null || _container$controls$s === void 0 ? void 0 : _container$controls$s.groupPrefix;
                          if (groupPrefix) {
                            Object.entries(value).forEach(function (_ref2) {
                              var _ref3 = (0, _slicedToArray2.default)(_ref2, 2),
                                dataKey = _ref3[0],
                                dataValue = _ref3[1];
                              dataKey = dataKey.replace(elementor.config.kit_config.typography_prefix, groupPrefix);
                              localSettings[dataKey] = dataValue;
                            });
                          } else {
                            localSettings[setting] = value;
                          }
                        }
                        return _context.abrupt("return", Promise.resolve());
                      case 5:
                      case "end":
                        return _context.stop();
                    }
                  }, _callee);
                }));
                return function (_x2) {
                  return _ref.apply(this, arguments);
                };
              }()));
            case 3:
              // Restore globals settings as custom local settings.
              if (Object.keys(localSettings).length) {
                $e.run('document/elements/settings', {
                  containers: containers,
                  options: options,
                  settings: localSettings
                });
              }
            case 4:
            case "end":
              return _context2.stop();
          }
        }, _callee2);
      }));
      function apply(_x) {
        return _apply.apply(this, arguments);
      }
      return apply;
    }()
  }]);
  return Unlink;
}($e.modules.editor.CommandContainerBase);
exports.Unlink = Unlink;
var _default = Unlink;
exports["default"] = _default;

/***/ }),

/***/ "../assets/dev/js/editor/document/globals/component.js":
/*!*************************************************************!*\
  !*** ../assets/dev/js/editor/document/globals/component.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _componentBase = _interopRequireDefault(__webpack_require__(/*! elementor-api/modules/component-base */ "../modules/web-cli/assets/js/modules/component-base.js"));
var commands = _interopRequireWildcard(__webpack_require__(/*! ./commands/ */ "../assets/dev/js/editor/document/globals/commands/index.js"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var Component = /*#__PURE__*/function (_ComponentBase) {
  (0, _inherits2.default)(Component, _ComponentBase);
  var _super = _createSuper(Component);
  function Component() {
    (0, _classCallCheck2.default)(this, Component);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(Component, [{
    key: "getNamespace",
    value: function getNamespace() {
      return 'document/globals';
    }
  }, {
    key: "defaultCommands",
    value: function defaultCommands() {
      return this.importCommands(commands);
    }
  }]);
  return Component;
}(_componentBase.default);
exports["default"] = Component;

/***/ }),

/***/ "../assets/dev/js/editor/document/helper-bc.js":
/*!*****************************************************!*\
  !*** ../assets/dev/js/editor/document/helper-bc.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var BackwardsCompatibility = /*#__PURE__*/function () {
  function BackwardsCompatibility() {
    (0, _classCallCheck2.default)(this, BackwardsCompatibility);
  }
  (0, _createClass2.default)(BackwardsCompatibility, null, [{
    key: "findViewRecursive",
    value:
    /**
     * @param {*}        parent
     * @param {string}   key
     * @param {string}   value
     * @param {boolean=} multiple
     * @deprecated since 2.9.0, use `$e.components.get( 'document' ).utils.findViewRecursive( parent, key, value, multiple )` instead.
     */
    function findViewRecursive(parent, key, value) {
      var multiple = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : true;
      elementorDevTools.deprecation.deprecated('findViewRecursive()', '2.9.0', "$e.components.get( 'document' ).utils.findViewRecursive( parent, key, value, multiple )");
      return $e.components.get('document').utils.findViewRecursive(parent, key, value, multiple);
    }

    /**
     * @param {string} id - View ID.
     * @deprecated since 2.9.0, use `$e.components.get( 'document' ).utils.findViewById( id )` instead.
     */
  }, {
    key: "findViewById",
    value: function findViewById(id) {
      elementorDevTools.deprecation.deprecated('findViewById( id )', '2.9.0', "$e.components.get( 'document' ).utils.findViewById( id )");
      return $e.components.get('document').utils.findViewById(id);
    }

    /**
     * @param {string} id - Container ID.
     * @deprecated since 2.9.0, use `$e.components.get( 'document' ).utils.findContainerById( id )` instead.
     */
  }, {
    key: "findContainerById",
    value: function findContainerById(id) {
      elementorDevTools.deprecation.deprecated('findContainerById( id )', '2.9.0', "$e.components.get( 'document' ).utils.findContainerById( id )");
      return $e.components.get('document').utils.findContainerById(id);
    }

    /**
     * @param {*} childModel
     * @param {*} parentModel
     * @deprecated since 3.4.0, use `parentModel.isValidChild( childModel )` instead.
     */
  }, {
    key: "isValidChild",
    value: function isValidChild(childModel, parentModel) {
      elementorDevTools.deprecation.deprecated('isValidChild( childModel, parentModel )', '3.4.0', 'parentModel.isValidChild( childModel )');
      return parentModel.isValidChild(childModel);
    }

    /**
     * @param {*} childModel
     * @param {*} targetContainer
     * @deprecated since 3.4.0, use `$e.components.get( 'document/elements' ).utils.isValidGrandChild( childModel, targetContainer )` instead.
     */
  }, {
    key: "isValidGrandChild",
    value: function isValidGrandChild(childModel, targetContainer) {
      elementorDevTools.deprecation.deprecated('isValidGrandChild( childModel, targetContainer )', '3.4.0', "$e.components.get( 'document/elements' ).utils.isValidGrandChild( childModel, targetContainer )");
      return $e.components.get('document/elements').utils.isValidGrandChild(childModel, targetContainer);
    }

    /**
     * @param {*} sourceModel
     * @param {*} targetContainer
     * @deprecated since 3.4.0, use `$e.components.get( 'document/elements' ).utils.isSameElement( sourceModel, targetContainer )` instead.
     */
  }, {
    key: "isSameElement",
    value: function isSameElement(sourceModel, targetContainer) {
      elementorDevTools.deprecation.deprecated('isSameElement( sourceModel, targetContainer )', '3.4.0', "$e.components.get( 'document/elements' ).utils.isSameElement( sourceModel, targetContainer )");
      return $e.components.get('document/elements').utils.isSameElement(sourceModel, targetContainer);
    }

    /**
     * @param {*} sourceModel
     * @param {*} targetContainer
     * @deprecated since 3.4.0, use `$e.components.get( 'document/elements' ).utils.getPasteOptions( sourceModel, targetContainer )` instead.
     */
  }, {
    key: "getPasteOptions",
    value: function getPasteOptions(sourceModel, targetContainer) {
      elementorDevTools.deprecation.deprecated('getPasteOptions( sourceModel, targetContainer )', '3.4.0', "$e.components.get( 'document/elements' ).utils.getPasteOptions( sourceModel, targetContainer )");
      return $e.components.get('document/elements').utils.getPasteOptions(sourceModel, targetContainer);
    }

    /**
     * @param {*} targetContainer
     * @deprecated since 3.4.0, use `$e.components.get( 'document/elements' ).utils.isPasteEnabled( targetContainer )` instead.
     */
  }, {
    key: "isPasteEnabled",
    value: function isPasteEnabled(targetContainer) {
      elementorDevTools.deprecation.deprecated('isPasteEnabled( targetContainer )', '3.4.0', "$e.components.get( 'document/elements' ).utils.isPasteEnabled( targetContainer )");
      return $e.components.get('document/elements').utils.isPasteEnabled(targetContainer);
    }
  }]);
  return BackwardsCompatibility;
}();
exports["default"] = BackwardsCompatibility;

/***/ }),

/***/ "../assets/dev/js/editor/document/history/commands/base/command-history-internal-base.js":
/*!***********************************************************************************************!*\
  !*** ../assets/dev/js/editor/document/history/commands/base/command-history-internal-base.js ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _get2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/get */ "../node_modules/@babel/runtime/helpers/get.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
/**
 * @typedef {import ('elementor/modules/history/assets/js/module')} HistoryManager
 */
var CommandHistoryInternalBase = /*#__PURE__*/function (_$e$modules$editor$Co) {
  (0, _inherits2.default)(CommandHistoryInternalBase, _$e$modules$editor$Co);
  var _super = _createSuper(CommandHistoryInternalBase);
  function CommandHistoryInternalBase() {
    (0, _classCallCheck2.default)(this, CommandHistoryInternalBase);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(CommandHistoryInternalBase, [{
    key: "initialize",
    value: function initialize(args) {
      (0, _get2.default)((0, _getPrototypeOf2.default)(CommandHistoryInternalBase.prototype), "initialize", this).call(this, args);

      /**
       * @type {HistoryManager}
       */
      this.history = elementor.documents.getCurrent().history;
    }
  }]);
  return CommandHistoryInternalBase;
}($e.modules.editor.CommandContainerInternalBase);
exports["default"] = CommandHistoryInternalBase;

/***/ }),

/***/ "../assets/dev/js/editor/document/history/commands/do.js":
/*!***************************************************************!*\
  !*** ../assets/dev/js/editor/document/history/commands/do.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.Do = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var Do = /*#__PURE__*/function (_$e$modules$CommandBa) {
  (0, _inherits2.default)(Do, _$e$modules$CommandBa);
  var _super = _createSuper(Do);
  function Do() {
    (0, _classCallCheck2.default)(this, Do);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(Do, [{
    key: "apply",
    value: function apply(args) {
      var index = args.index;
      return elementor.documents.getCurrent().history.doItem(index);
    }
  }]);
  return Do;
}($e.modules.CommandBase);
exports.Do = Do;
var _default = Do;
exports["default"] = _default;

/***/ }),

/***/ "../assets/dev/js/editor/document/history/commands/index.js":
/*!******************************************************************!*\
  !*** ../assets/dev/js/editor/document/history/commands/index.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
Object.defineProperty(exports, "Do", ({
  enumerable: true,
  get: function get() {
    return _do.Do;
  }
}));
Object.defineProperty(exports, "Redo", ({
  enumerable: true,
  get: function get() {
    return _redo.Redo;
  }
}));
Object.defineProperty(exports, "Undo", ({
  enumerable: true,
  get: function get() {
    return _undo.Undo;
  }
}));
Object.defineProperty(exports, "UndoAll", ({
  enumerable: true,
  get: function get() {
    return _undoAll.UndoAll;
  }
}));
var _do = __webpack_require__(/*! ./do */ "../assets/dev/js/editor/document/history/commands/do.js");
var _redo = __webpack_require__(/*! ./redo */ "../assets/dev/js/editor/document/history/commands/redo.js");
var _undo = __webpack_require__(/*! ./undo */ "../assets/dev/js/editor/document/history/commands/undo.js");
var _undoAll = __webpack_require__(/*! ./undo-all */ "../assets/dev/js/editor/document/history/commands/undo-all.js");

/***/ }),

/***/ "../assets/dev/js/editor/document/history/commands/internal/add-transaction.js":
/*!*************************************************************************************!*\
  !*** ../assets/dev/js/editor/document/history/commands/internal/add-transaction.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.AddTransaction = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _get2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/get */ "../node_modules/@babel/runtime/helpers/get.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _commandHistoryInternalBase = _interopRequireDefault(__webpack_require__(/*! ../base/command-history-internal-base */ "../assets/dev/js/editor/document/history/commands/base/command-history-internal-base.js"));
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var AddTransaction = /*#__PURE__*/function (_CommandHistoryIntern) {
  (0, _inherits2.default)(AddTransaction, _CommandHistoryIntern);
  var _super = _createSuper(AddTransaction);
  function AddTransaction() {
    (0, _classCallCheck2.default)(this, AddTransaction);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(AddTransaction, [{
    key: "initialize",
    value: function initialize(args) {
      (0, _get2.default)((0, _getPrototypeOf2.default)(AddTransaction.prototype), "initialize", this).call(this, args);

      /**
       * Debounce always send 'add-transaction' with title & subTitle, when the transaction
       * already started, there is no need to save those args they are useless.
       */
      if (this.component.isTransactionStarted()) {
        delete args.title;
        delete args.subTitle;
      }
    }
  }, {
    key: "validateArgs",
    value: function validateArgs(args) {
      this.requireContainer();
      this.requireArgumentType('type', 'string', args);
    }
  }, {
    key: "apply",
    value: function apply(args) {
      var currentId = this.history.getCurrentId();
      if (currentId) {
        // If log already started chain his historyId.
        args.id = currentId;
      }
      args = this.component.normalizeLogTitle(args);
      this.component.transactions.push(args);
    }
  }]);
  return AddTransaction;
}(_commandHistoryInternalBase.default);
exports.AddTransaction = AddTransaction;
var _default = AddTransaction;
exports["default"] = _default;

/***/ }),

/***/ "../assets/dev/js/editor/document/history/commands/internal/clear-transaction.js":
/*!***************************************************************************************!*\
  !*** ../assets/dev/js/editor/document/history/commands/internal/clear-transaction.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.ClearTransaction = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var ClearTransaction = /*#__PURE__*/function (_$e$modules$CommandIn) {
  (0, _inherits2.default)(ClearTransaction, _$e$modules$CommandIn);
  var _super = _createSuper(ClearTransaction);
  function ClearTransaction() {
    (0, _classCallCheck2.default)(this, ClearTransaction);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(ClearTransaction, [{
    key: "apply",
    value: function apply() {
      this.component.transactions = [];
    }
  }]);
  return ClearTransaction;
}($e.modules.CommandInternalBase);
exports.ClearTransaction = ClearTransaction;
var _default = ClearTransaction;
exports["default"] = _default;

/***/ }),

/***/ "../assets/dev/js/editor/document/history/commands/internal/delete-log.js":
/*!********************************************************************************!*\
  !*** ../assets/dev/js/editor/document/history/commands/internal/delete-log.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.DeleteLog = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _commandHistoryInternalBase = _interopRequireDefault(__webpack_require__(/*! ../base/command-history-internal-base */ "../assets/dev/js/editor/document/history/commands/base/command-history-internal-base.js"));
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var DeleteLog = /*#__PURE__*/function (_CommandHistoryIntern) {
  (0, _inherits2.default)(DeleteLog, _CommandHistoryIntern);
  var _super = _createSuper(DeleteLog);
  function DeleteLog() {
    (0, _classCallCheck2.default)(this, DeleteLog);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(DeleteLog, [{
    key: "apply",
    value: function apply(args) {
      if (args.id) {
        this.history.deleteItem(args.id);
      }
    }
  }]);
  return DeleteLog;
}(_commandHistoryInternalBase.default);
exports.DeleteLog = DeleteLog;
var _default = DeleteLog;
exports["default"] = _default;

/***/ }),

/***/ "../assets/dev/js/editor/document/history/commands/internal/end-log.js":
/*!*************************************